/*
 * Decompiled with CFR 0.152.
 */
package weblogic.application.compiler.flow;

import java.io.File;
import java.io.IOException;
import weblogic.application.ApplicationConstants;
import weblogic.application.compiler.BuildtimeApplicationContext;
import weblogic.application.compiler.CompilerCtx;
import weblogic.application.compiler.EARModule;
import weblogic.application.compiler.flow.CompilerFlow;
import weblogic.application.utils.IOUtils;
import weblogic.j2ee.J2EELogger;
import weblogic.utils.FileUtils;
import weblogic.utils.StringUtils;
import weblogic.utils.classloaders.ClassFinder;
import weblogic.utils.compiler.ToolFailureException;
import weblogic.utils.jars.VirtualJarFactory;
import weblogic.utils.jars.VirtualJarFile;

public final class CopyLibrariesFlow
extends CompilerFlow {
    private final BuildtimeApplicationContext libCtx;

    public CopyLibrariesFlow(CompilerCtx compilerCtx) {
        super(compilerCtx);
        this.libCtx = (BuildtimeApplicationContext)compilerCtx.getApplicationContext();
    }

    public void compile() throws ToolFailureException {
        this.processLibraries(this.ctx.getModules());
        this.copyAdditionalResources();
    }

    public void cleanup() {
    }

    private void processLibraries(EARModule[] eARModuleArray) throws ToolFailureException {
        for (int i = 0; i < eARModuleArray.length; ++i) {
            if (!eARModuleArray[i].isLibrary()) continue;
            this.copyLibrary(eARModuleArray[i]);
        }
    }

    private void copyLibrary(EARModule eARModule) throws ToolFailureException {
        File file = new File(this.ctx.getOutputDir(), eARModule.getURI());
        File[] fileArray = this.getRoots(eARModule);
        for (int i = 0; i < fileArray.length; ++i) {
            try {
                if (!fileArray[i].equals(file)) {
                    FileUtils.copy((File)fileArray[i], (File)file);
                }
            }
            catch (IOException iOException) {
                throw new ToolFailureException("Failed to copy library " + fileArray[i], (Throwable)iOException);
            }
            IOUtils.forceClose(eARModule.getVirtualJarFile());
            try {
                if (eARModule.getVirtualJarFile() != null) {
                    eARModule.setVirtualJarFile(VirtualJarFactory.createVirtualJar((File)file));
                }
                eARModule.setOutputDir(file);
                continue;
            }
            catch (IOException iOException) {
                throw new ToolFailureException(J2EELogger.logAppcErrorAccessingFileLoggable((String)file.getAbsolutePath(), (String)iOException.toString()).getMessage(), (Throwable)iOException);
            }
        }
    }

    private File[] getRoots(EARModule eARModule) {
        VirtualJarFile virtualJarFile = eARModule.getVirtualJarFile();
        if (virtualJarFile == null) {
            return new File[]{new File(eARModule.getOutputFileName())};
        }
        return virtualJarFile.getRootFiles();
    }

    private void copyAdditionalResources() throws ToolFailureException {
        ClassFinder classFinder = this.ctx.getApplicationContext().getAppClassLoader().getClassFinder();
        String string = classFinder.getClassPath();
        File file = new File(this.ctx.getOutputDir(), ApplicationConstants.APP_INF_LIB);
        File file2 = new File(this.ctx.getOutputDir(), ApplicationConstants.APP_INF_CLASSES);
        file.mkdirs();
        String[] stringArray = StringUtils.splitCompletely((String)string, (String)File.pathSeparator);
        for (int i = 0; i < stringArray.length; ++i) {
            File file3 = new File(stringArray[i]);
            if (!file3.exists()) continue;
            try {
                if (file3.isFile()) {
                    FileUtils.copyNoOverwrite((File)file3, (File)file);
                    continue;
                }
                if (file2.getCanonicalPath().startsWith(file3.getCanonicalPath())) continue;
                FileUtils.copyNoOverwrite((File)file3, (File)file2);
                continue;
            }
            catch (IOException iOException) {
                throw new ToolFailureException("Failed to copy " + file3, (Throwable)iOException);
            }
        }
    }
}

