/*
 * Decompiled with CFR 0.152.
 */
package weblogic.application.compiler.flow;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import weblogic.application.CustomModuleFactory;
import weblogic.application.compiler.CompilerCtx;
import weblogic.application.compiler.EARModule;
import weblogic.application.compiler.flow.CompilerFlow;
import weblogic.j2ee.descriptor.wl.CustomModuleBean;
import weblogic.j2ee.descriptor.wl.WeblogicExtensionBean;
import weblogic.utils.compiler.ToolFailureException;

public class CustomModuleFlow
extends CompilerFlow {
    public CustomModuleFlow(CompilerCtx compilerCtx) {
        super(compilerCtx);
    }

    public void compile() throws ToolFailureException {
        this.ctx.setCustomModules(this.initCustomModules());
    }

    public void cleanup() {
        EARModule[] eARModuleArray = this.ctx.getCustomModules();
        for (int i = 0; i < eARModuleArray.length; ++i) {
            eARModuleArray[i].cleanup();
        }
    }

    private EARModule[] initCustomModules() throws ToolFailureException {
        ArrayList arrayList = new ArrayList();
        WeblogicExtensionBean weblogicExtensionBean = this.ctx.getWLExtensionDD();
        if (weblogicExtensionBean != null) {
            this.initCustomModules(weblogicExtensionBean.getCustomModules(), arrayList, this.ctx.getCustomModuleFactories());
        }
        return arrayList.toArray(new EARModule[0]);
    }

    private void initCustomModules(CustomModuleBean[] customModuleBeanArray, List list, Map map) throws ToolFailureException {
        if (customModuleBeanArray == null || customModuleBeanArray.length == 0) {
            return;
        }
        for (int i = 0; i < customModuleBeanArray.length; ++i) {
            CustomModuleFactory customModuleFactory = (CustomModuleFactory)map.get(customModuleBeanArray[i].getProviderName());
            if (customModuleFactory == null) {
                throw new ToolFailureException("The custom module with the uri " + customModuleBeanArray[i].getUri() + " specified a provider-name of " + customModuleBeanArray[i].getProviderName() + ". However, there was no module-provider " + "with this name in your weblogic-extension.xml.");
            }
            EARModule eARModule = customModuleFactory.createToolsModule(customModuleBeanArray[i]);
            if (eARModule == null) continue;
            eARModule.setOutputDir(this.ctx.getOutputDir());
            eARModule.initModuleClassLoader(this.ctx, this.ctx.getApplicationContext().getAppClassLoader());
            eARModule.merge(this.ctx);
            list.add(eARModule);
        }
    }
}

