/*
 * Decompiled with CFR 0.152.
 */
package weblogic.application.compiler.flow;

import java.io.File;
import weblogic.application.ApplicationDescriptor;
import weblogic.application.compiler.AppcUtils;
import weblogic.application.compiler.CompilerCtx;
import weblogic.application.compiler.flow.CompilerFlow;
import weblogic.j2ee.J2EELogger;
import weblogic.utils.Getopt2;
import weblogic.utils.compiler.ToolFailureException;
import weblogic.utils.jars.VirtualJarFile;

public final class DescriptorParsingFlow
extends CompilerFlow {
    public DescriptorParsingFlow(CompilerCtx compilerCtx) {
        super(compilerCtx);
    }

    public void compile() throws ToolFailureException {
        Getopt2 getopt2 = this.ctx.getOpts();
        VirtualJarFile virtualJarFile = this.ctx.getVSource();
        File file = null;
        if (getopt2.hasOption("altappdd") && !(file = new File(getopt2.getOption("altappdd"))).exists()) {
            throw new ToolFailureException(J2EELogger.logAppcMissingApplicationAltDDFileLoggable((String)file.getPath()).getMessage());
        }
        File file2 = null;
        if (getopt2.hasOption("altwlsappdd") && !(file2 = new File(getopt2.getOption("altwlsappdd"))).exists()) {
            throw new ToolFailureException(J2EELogger.logAppcMissingApplicationAltDDFileLoggable((String)file2.getPath()).getMessage());
        }
        ApplicationDescriptor applicationDescriptor = new ApplicationDescriptor(virtualJarFile, this.ctx.getConfigDir(), this.ctx.getPlanBean(), this.ctx.getSourceName());
        AppcUtils.setDDs(applicationDescriptor, this.ctx);
        if (this.ctx.getApplicationDD() == null) {
            throw new ToolFailureException(J2EELogger.logAppcNoApplicationDDFoundLoggable((String)virtualJarFile.getName()).getMessage());
        }
    }

    public void cleanup() {
    }
}

