/*
 * Decompiled with CFR 0.152.
 */
package weblogic.application.compiler.flow;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import weblogic.application.ApplicationFileManager;
import weblogic.application.SplitDirectoryInfo;
import weblogic.application.compiler.AppcUtils;
import weblogic.application.compiler.CompilerCtx;
import weblogic.application.compiler.flow.CompilerFlow;
import weblogic.application.io.Ear;
import weblogic.application.io.JarCopyFilter;
import weblogic.application.utils.EarUtils;
import weblogic.application.utils.IOUtils;
import weblogic.j2ee.J2EELogger;
import weblogic.utils.FileUtils;
import weblogic.utils.compiler.ToolFailureException;
import weblogic.utils.jars.VirtualJarFactory;
import weblogic.utils.jars.VirtualJarFile;

public final class EarClassLoaderFlow
extends CompilerFlow {
    private Ear ear = null;
    private static final File dummyExtractDir = new File(System.getProperty("java.io.tmpdir"), "_appc_tmp");

    public EarClassLoaderFlow(CompilerCtx compilerCtx) {
        super(compilerCtx);
    }

    public void compile() throws ToolFailureException {
        this.init();
    }

    private void init() throws ToolFailureException {
        File file = this.ctx.getSourceFile();
        File file2 = this.ctx.getOutputDir();
        VirtualJarFile virtualJarFile = null;
        boolean bl = file.equals(file2);
        File file3 = EarUtils.getSplitDirProperties(file);
        boolean bl2 = file3.exists();
        SplitDirectoryInfo splitDirectoryInfo = null;
        try {
            if (bl2) {
                splitDirectoryInfo = new SplitDirectoryInfo(file, file3);
            }
            if (bl2 && !bl) {
                File[] fileArray = splitDirectoryInfo.getRootDirectories();
                for (int i = 0; i < fileArray.length; ++i) {
                    AppcUtils.expandJarFileIntoDirectory(fileArray[i], file2);
                }
                Map map = splitDirectoryInfo.getUriLinks();
                for (String string : map.keySet()) {
                    List list = (List)map.get(string);
                    for (int i = list.size() - 1; i >= 0; --i) {
                        FileUtils.copy((File)((File)list.get(i)), (File)file2);
                    }
                }
                EarUtils.getSplitDirProperties(file2).delete();
                bl2 = false;
                bl = true;
            }
            if (bl2) {
                this.ctx.setSplitDir();
                virtualJarFile = VirtualJarFactory.createVirtualJar((File)splitDirectoryInfo.getSrcDir(), (File)splitDirectoryInfo.getDestDir());
                this.ear = new Ear(file.getName(), dummyExtractDir, splitDirectoryInfo, JarCopyFilter.NOCOPY_FILTER);
                this.ctx.getApplicationContext().setApplicationFileManager(ApplicationFileManager.newInstance(splitDirectoryInfo));
                this.ctx.getApplicationContext().setSplitDirectoryInfo(splitDirectoryInfo);
            } else {
                if (!bl) {
                    AppcUtils.expandJarFileIntoDirectory(file, file2);
                }
                virtualJarFile = VirtualJarFactory.createVirtualJar((File)file2);
                this.ear = new Ear(file.getName(), dummyExtractDir, new File[]{file2}, JarCopyFilter.NOCOPY_FILTER);
                this.ctx.getApplicationContext().setApplicationFileManager(ApplicationFileManager.newInstance(file2));
            }
            this.ctx.setVSource(virtualJarFile);
        }
        catch (IOException iOException) {
            throw new ToolFailureException(J2EELogger.logAppcSourceFileNotAccessibleLoggable((String)file.getAbsolutePath(), (String)iOException.toString()).getMessage(), (Throwable)iOException);
        }
        this.ctx.setEar(this.ear);
    }

    public void cleanup() {
        this.ear.getClassFinder().close();
        IOUtils.forceClose(this.ctx.getVSource());
    }
}

