/*
 * Decompiled with CFR 0.152.
 */
package weblogic.application.compiler.flow;

import java.io.File;
import java.io.IOException;
import weblogic.application.compiler.AppcUtils;
import weblogic.application.compiler.CompilerCtx;
import weblogic.application.compiler.EARModule;
import weblogic.application.compiler.flow.CompilerFlow;
import weblogic.j2ee.J2EELogger;
import weblogic.utils.Debug;
import weblogic.utils.compiler.ToolFailureException;
import weblogic.utils.jars.JarFileUtils;
import weblogic.utils.jars.VirtualJarFile;

public final class ExplodeModulesFlow
extends CompilerFlow {
    private final boolean explodeLibraries;

    public ExplodeModulesFlow(CompilerCtx compilerCtx) {
        this(compilerCtx, false);
    }

    public ExplodeModulesFlow(CompilerCtx compilerCtx, boolean bl) {
        super(compilerCtx);
        this.explodeLibraries = bl;
    }

    public void compile() throws ToolFailureException {
        this.maybeExplodeModules(this.ctx.getModules());
    }

    public void cleanup() throws ToolFailureException {
        EARModule[] eARModuleArray = this.ctx.getModules();
        if (!this.ctx.getOpts().hasOption("nopackage")) {
            this.packageModules(eARModuleArray);
        }
    }

    private void packageModules(EARModule[] eARModuleArray) throws ToolFailureException {
        for (int i = 0; i < eARModuleArray.length; ++i) {
            if (!eARModuleArray[i].needsPackaging()) continue;
            if (debug) {
                Debug.say((String)("Creating output archive: " + eARModuleArray[i].getOutputFileName()));
            }
            AppcUtils.createOutputArchive(eARModuleArray[i].getOutputFileName(), eARModuleArray[i].getOutputDir());
        }
    }

    private void maybeExplodeModules(EARModule[] eARModuleArray) throws ToolFailureException {
        for (int i = 0; i < eARModuleArray.length; ++i) {
            if (!eARModuleArray[i].isArchive() || eARModuleArray[i].isLibrary() && !this.explodeLibraries) continue;
            this.explodeModule(eARModuleArray[i]);
        }
    }

    private void explodeModule(EARModule eARModule) throws ToolFailureException {
        String string = this.ctx.getTempDir().getName() + "_" + eARModule.getURI().replace(File.separatorChar, '_');
        File file = AppcUtils.makeOutputDir(string, this.ctx.getOutputDir(), true);
        if (debug) {
            Debug.say((String)("Expanding " + eARModule.getVirtualJarFile().getName() + " into " + file));
        }
        this.expandJarFileIntoDirectory(eARModule.getVirtualJarFile(), file);
        eARModule.setOutputDir(file);
        eARModule.setNeedsPackaging(true);
    }

    private void expandJarFileIntoDirectory(VirtualJarFile virtualJarFile, File file) throws ToolFailureException {
        try {
            JarFileUtils.extract((VirtualJarFile)virtualJarFile, (File)file);
        }
        catch (IOException iOException) {
            throw new ToolFailureException(J2EELogger.logAppcErrorCopyingFilesLoggable((String)file.getAbsolutePath(), (String)iOException.toString()).getMessage(), (Throwable)iOException);
        }
    }
}

