/*
 * Decompiled with CFR 0.152.
 */
package weblogic.application.compiler.flow;

import weblogic.application.compiler.BuildtimeApplicationContext;
import weblogic.application.compiler.CompilerCtx;
import weblogic.application.compiler.flow.CompilerFlow;
import weblogic.application.library.LibraryManager;
import weblogic.application.library.LibraryReference;
import weblogic.application.library.LoggableLibraryProcessingException;
import weblogic.application.utils.LibraryLoggingUtils;
import weblogic.application.utils.LibraryUtils;
import weblogic.j2ee.descriptor.wl.LibraryRefBean;
import weblogic.utils.compiler.ToolFailureException;

public final class ImportLibrariesFlow
extends CompilerFlow {
    private final BuildtimeApplicationContext libCtx;
    private LibraryManager libraryManager = null;

    public ImportLibrariesFlow(CompilerCtx compilerCtx) {
        super(compilerCtx);
        this.libCtx = (BuildtimeApplicationContext)compilerCtx.getApplicationContext();
    }

    public void compile() throws ToolFailureException {
        this.libraryManager = new LibraryManager(LibraryUtils.initAppReferencer(this.ctx.getSourceName()));
        this.processLibraries();
    }

    private void processLibraries() throws ToolFailureException {
        if (this.ctx.getWLApplicationDD() == null) {
            return;
        }
        LibraryRefBean[] libraryRefBeanArray = this.ctx.getWLApplicationDD().getLibraryRefs();
        if (libraryRefBeanArray == null || libraryRefBeanArray.length == 0) {
            return;
        }
        this.initAppLibManager(libraryRefBeanArray);
        if (this.libraryManager.hasUnresolvedReferences()) {
            return;
        }
        this.importLibraries();
    }

    private void importLibraries() throws ToolFailureException {
        try {
            LibraryUtils.importAppLibraries(this.libraryManager, this.libCtx, this.ctx, this.ctx.isVerbose());
        }
        catch (LoggableLibraryProcessingException loggableLibraryProcessingException) {
            throw new ToolFailureException(loggableLibraryProcessingException.getLoggable().getMessage(), loggableLibraryProcessingException.getCause());
        }
    }

    private void initAppLibManager(LibraryRefBean[] libraryRefBeanArray) throws ToolFailureException {
        LibraryReference[] libraryReferenceArray = null;
        try {
            libraryReferenceArray = LibraryLoggingUtils.initLibRefs(libraryRefBeanArray);
        }
        catch (LoggableLibraryProcessingException loggableLibraryProcessingException) {
            throw new ToolFailureException(loggableLibraryProcessingException.getLoggable().getMessage(), loggableLibraryProcessingException.getCause());
        }
        this.libraryManager.lookup(libraryReferenceArray);
        this.libCtx.getLibraryManagerAggregate().setAppLevelLibraryManager(this.libraryManager);
    }

    public void cleanup() {
    }
}

