/*
 * Decompiled with CFR 0.152.
 */
package weblogic.application.compiler.flow;

import java.io.File;
import weblogic.application.compiler.CompilerCtx;
import weblogic.application.compiler.flow.CompilerFlow;
import weblogic.application.library.LibraryData;
import weblogic.application.library.LibraryInitializer;
import weblogic.application.library.LibraryMetadataCache;
import weblogic.application.library.LoggableLibraryProcessingException;
import weblogic.application.utils.LibraryLoggingUtils;
import weblogic.j2ee.J2EELogger;
import weblogic.logging.Loggable;
import weblogic.utils.Getopt2;
import weblogic.utils.StringUtils;
import weblogic.utils.compiler.ToolFailureException;

public class InitLibrariesFlow
extends CompilerFlow {
    private static final boolean debug = false;
    private LibraryInitializer libraryInitializer = null;

    public InitLibrariesFlow(CompilerCtx compilerCtx, boolean bl) {
        super(compilerCtx);
        if (!bl) {
            LibraryMetadataCache.getInstance().disableCache();
        }
    }

    public void compile() throws ToolFailureException {
        Getopt2 getopt2 = this.ctx.getOpts();
        if (this.initLibraries(getopt2)) {
            File file = new File(System.getProperty("java.io.tmpdir"), "appc_libraries");
            this.libraryInitializer = new LibraryInitializer(file);
            if (this.ctx.isVerbose()) {
                this.libraryInitializer.setVerbose();
            }
            if (getopt2.hasOption("librarydir")) {
                try {
                    this.libraryInitializer.registerLibdir(getopt2.getOption("librarydir"));
                }
                catch (LoggableLibraryProcessingException loggableLibraryProcessingException) {
                    throw new ToolFailureException(loggableLibraryProcessingException.getLoggable().getMessage(), (Throwable)loggableLibraryProcessingException);
                }
                getopt2.removeOption("librarydir");
            }
            if (getopt2.hasOption("library")) {
                this.registerLibraries(getopt2.getOption("library"));
                getopt2.removeOption("library");
            }
            try {
                this.libraryInitializer.initRegisteredLibraries();
            }
            catch (LoggableLibraryProcessingException loggableLibraryProcessingException) {
                throw new ToolFailureException(loggableLibraryProcessingException.getLoggable().getMessage(), (Throwable)loggableLibraryProcessingException);
            }
        }
    }

    private boolean initLibraries(Getopt2 getopt2) {
        return getopt2.hasOption("library") || getopt2.hasOption("librarydir");
    }

    private void registerLibraries(String string) throws ToolFailureException {
        String[] stringArray = StringUtils.splitCompletely((String)string, (String)",");
        boolean bl = true;
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            String string3 = stringArray[i];
            int n = stringArray[i].indexOf("@");
            if (n > -1) {
                string2 = stringArray[i].substring(0, n);
                string3 = stringArray[i].substring(n);
            }
            File file = new File(string2);
            try {
                LibraryData libraryData = this.parseLibraryArg(file, string3);
                this.libraryInitializer.registerLibrary(file, libraryData);
                continue;
            }
            catch (LoggableLibraryProcessingException loggableLibraryProcessingException) {
                loggableLibraryProcessingException.getLoggable().log();
                bl = false;
            }
        }
        if (!bl) {
            Loggable loggable = J2EELogger.logAppcLibraryRegistrationFailedLoggable();
            throw new ToolFailureException(loggable.getMessage());
        }
    }

    private LibraryData parseLibraryArg(File file, String string) throws LoggableLibraryProcessingException {
        if (string.indexOf("@") == -1) {
            return LibraryData.newEmptyInstance(file);
        }
        String[] stringArray = StringUtils.splitCompletely((String)string, (String)"@");
        String string2 = null;
        String string3 = null;
        String string4 = null;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].indexOf("=") == -1) continue;
            String[] stringArray2 = StringUtils.splitCompletely((String)stringArray[i], (String)"=");
            if (stringArray2[0].equalsIgnoreCase("name")) {
                string2 = stringArray2[1];
            }
            if (stringArray2[0].equalsIgnoreCase("libspecver")) {
                string3 = stringArray2[1];
            }
            if (!stringArray2[0].equalsIgnoreCase("libimplver")) continue;
            string4 = stringArray2[1];
        }
        return LibraryLoggingUtils.initLibraryData(string2, string3, string4, file);
    }

    public void cleanup() {
        if (this.ctx.unregisterLibrariesOnExit() && !Boolean.getBoolean("weblogic.application.compiler.flow.InitLibrariesFlow.KeepLibrariesOnExit") && this.libraryInitializer != null) {
            this.libraryInitializer.cleanup();
        }
    }
}

