/*
 * Decompiled with CFR 0.152.
 */
package weblogic.application.compiler.flow;

import java.util.ArrayList;
import weblogic.application.compiler.CompilerCtx;
import weblogic.application.compiler.EARModule;
import weblogic.application.compiler.ToolsFactoryManager;
import weblogic.application.compiler.WLModuleFactory;
import weblogic.application.compiler.flow.CompilerFlow;
import weblogic.j2ee.J2EELogger;
import weblogic.j2ee.descriptor.ModuleBean;
import weblogic.j2ee.descriptor.wl.WeblogicApplicationBean;
import weblogic.j2ee.descriptor.wl.WeblogicModuleBean;
import weblogic.utils.compiler.ToolFailureException;

public final class InitModulesFlow
extends CompilerFlow {
    public InitModulesFlow(CompilerCtx compilerCtx) {
        super(compilerCtx);
    }

    public void compile() throws ToolFailureException {
        this.ctx.setModules(this.initModules());
    }

    private EARModule[] initModules() {
        WeblogicModuleBean[] weblogicModuleBeanArray;
        WeblogicApplicationBean weblogicApplicationBean;
        EARModuleList eARModuleList = new EARModuleList();
        ModuleBean[] moduleBeanArray = this.ctx.getApplicationDD().getModules();
        if (moduleBeanArray != null) {
            for (int i = 0; i < moduleBeanArray.length; ++i) {
                eARModuleList.addEARModule(ToolsFactoryManager.createModule(moduleBeanArray[i]));
            }
        }
        if ((weblogicApplicationBean = this.ctx.getWLApplicationDD()) != null && (weblogicModuleBeanArray = weblogicApplicationBean.getModules()) != null) {
            for (int i = 0; i < weblogicModuleBeanArray.length; ++i) {
                eARModuleList.addEARModule(this.initModule(weblogicModuleBeanArray[i]));
            }
        }
        if (eARModuleList.size() == 0) {
            J2EELogger.logAppcNoModulesFoundLoggable((String)this.ctx.getSourceName()).log();
            return new EARModule[0];
        }
        return eARModuleList.toArray(new EARModule[eARModuleList.size()]);
    }

    private EARModule initModule(WeblogicModuleBean weblogicModuleBean) {
        WLModuleFactory[] wLModuleFactoryArray = ToolsFactoryManager.wlmoduleFactories;
        for (int i = 0; i < wLModuleFactoryArray.length; ++i) {
            EARModule eARModule = wLModuleFactoryArray[i].createModule(weblogicModuleBean);
            if (eARModule == null) continue;
            return eARModule;
        }
        return null;
    }

    public void cleanup() {
    }

    private class EARModuleList
    extends ArrayList {
        private static final long serialVersionUID = 2883469812856650286L;

        private EARModuleList() {
        }

        public void addEARModule(EARModule eARModule) {
            if (eARModule == null) {
                return;
            }
            super.add(eARModule);
        }
    }
}

