/*
 * Decompiled with CFR 0.152.
 */
package weblogic.application.compiler.flow;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.xml.stream.XMLStreamException;
import weblogic.application.compiler.CompilerCtx;
import weblogic.application.compiler.flow.CompilerFlow;
import weblogic.deploy.internal.DeploymentPlanDescriptorLoader;
import weblogic.j2ee.J2EELogger;
import weblogic.utils.compiler.ToolFailureException;

public final class InitPlanFlow
extends CompilerFlow {
    private File pf;

    public InitPlanFlow(CompilerCtx compilerCtx) {
        super(compilerCtx);
    }

    public void compile() throws ToolFailureException {
        this.pf = this.ctx.getPlanFile();
        if (this.pf == null) {
            return;
        }
        try {
            DeploymentPlanDescriptorLoader deploymentPlanDescriptorLoader = new DeploymentPlanDescriptorLoader(this.pf);
            this.ctx.setPlanBean(deploymentPlanDescriptorLoader.getDeploymentPlanBean());
            String string = this.ctx.getPlanBean().getConfigRoot();
            if (this.ctx.getOpts().hasOption("plandir")) {
                string = this.ctx.getOpts().getOption("plandir");
            }
            if (string != null) {
                this.ctx.setConfigDir(new File(string));
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new ToolFailureException(J2EELogger.logAppcPlanFileNotAccessibleLoggable((String)this.pf.getPath(), (String)fileNotFoundException.getMessage()).getMessage(), (Throwable)fileNotFoundException);
        }
        catch (IOException iOException) {
            throw new ToolFailureException(J2EELogger.logAppcPlanParseErrorLoggable((String)this.pf.getPath(), (String)iOException.getMessage()).getMessage(), (Throwable)iOException);
        }
        catch (XMLStreamException xMLStreamException) {
            throw new ToolFailureException(J2EELogger.logAppcPlanParseErrorLoggable((String)this.pf.getPath(), (String)xMLStreamException.getMessage()).getMessage(), (Throwable)xMLStreamException);
        }
    }

    public void cleanup() {
    }
}

