/*
 * Decompiled with CFR 0.152.
 */
package weblogic.application.compiler.flow;

import java.io.File;
import java.io.IOException;
import weblogic.application.compiler.CompilerCtx;
import weblogic.application.compiler.flow.CompilerFlow;
import weblogic.application.utils.PersistenceUtils;
import weblogic.j2ee.descriptor.ApplicationBean;
import weblogic.utils.classloaders.ClassFinder;
import weblogic.utils.classloaders.JarClassFinder;
import weblogic.utils.compiler.ToolFailureException;

public final class LibraryDirectoryFlow
extends CompilerFlow {
    public LibraryDirectoryFlow(CompilerCtx compilerCtx) {
        super(compilerCtx);
    }

    public void compile() throws ToolFailureException {
        ApplicationBean applicationBean = this.ctx.getApplicationDD();
        String string = applicationBean.getLibraryDirectory();
        if (string != null) {
            try {
                File[] fileArray = PersistenceUtils.getApplicationRoots(this.ctx.getApplicationContext().getAppClassLoader(), this.ctx.getApplicationContext().getApplicationId(), false);
                for (int i = fileArray.length - 1; i >= 0; --i) {
                    File file = new File(fileArray[i], string);
                    if (!file.isDirectory()) continue;
                    File[] fileArray2 = file.listFiles();
                    for (int j = fileArray2.length - 1; j >= 0; --j) {
                        if (!fileArray2[j].getName().endsWith(".jar")) continue;
                        this.ctx.getApplicationContext().getAppClassLoader().addClassFinderFirst((ClassFinder)new JarClassFinder(fileArray2[j]));
                    }
                }
            }
            catch (IOException iOException) {
                throw new ToolFailureException("Unable process <library-directory> in application.xml", (Throwable)iOException);
            }
        }
    }

    public void cleanup() {
    }
}

