/*
 * Decompiled with CFR 0.152.
 */
package weblogic.application.compiler.flow;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.jar.JarFile;
import javax.enterprise.deploy.shared.ModuleType;
import javax.xml.stream.XMLStreamException;
import kodo.jdbc.conf.descriptor.PersistenceConfigurationBean;
import weblogic.application.ApplicationAccess;
import weblogic.application.ApplicationContextInternal;
import weblogic.application.Module;
import weblogic.application.SplitDirectoryInfo;
import weblogic.application.compiler.CompilerCtx;
import weblogic.application.compiler.flow.ApplicationViewerFlow;
import weblogic.application.compiler.flow.CompilerFlow;
import weblogic.application.config.DefaultModule;
import weblogic.application.internal.AppClientModule;
import weblogic.application.internal.flow.ModuleListenerInvoker;
import weblogic.application.internal.flow.ScopedModuleDriver;
import weblogic.application.io.ExplodedJar;
import weblogic.application.io.JarCopyFilter;
import weblogic.application.library.LibraryManager;
import weblogic.application.library.LibraryReference;
import weblogic.application.utils.CompositeWebAppFinder;
import weblogic.application.utils.PathUtils;
import weblogic.deploy.api.model.EditableDeployableObject;
import weblogic.deploy.api.model.EditableJ2eeApplicationObject;
import weblogic.deploy.api.model.WebLogicDeployableObjectFactory;
import weblogic.deploy.api.shared.WebLogicModuleType;
import weblogic.descriptor.Descriptor;
import weblogic.descriptor.DescriptorBean;
import weblogic.diagnostics.descriptor.WLDFResourceBean;
import weblogic.ejb.container.deployer.EJBModule;
import weblogic.j2ee.J2EEApplicationService;
import weblogic.j2ee.descriptor.ApplicationClientBean;
import weblogic.j2ee.descriptor.ConnectorBean;
import weblogic.j2ee.descriptor.EjbJarBean;
import weblogic.j2ee.descriptor.PersistenceBean;
import weblogic.j2ee.descriptor.WebAppBean;
import weblogic.j2ee.descriptor.WebservicesBean;
import weblogic.j2ee.descriptor.wl.JDBCDataSourceBean;
import weblogic.j2ee.descriptor.wl.JMSBean;
import weblogic.j2ee.descriptor.wl.WeblogicApplicationClientBean;
import weblogic.j2ee.descriptor.wl.WeblogicConnectorBean;
import weblogic.j2ee.descriptor.wl.WeblogicEjbJarBean;
import weblogic.j2ee.descriptor.wl.WeblogicRdbmsJarBean;
import weblogic.j2ee.descriptor.wl.WeblogicWebAppBean;
import weblogic.j2ee.descriptor.wl.WeblogicWebservicesBean;
import weblogic.j2ee.descriptor.wl.WebservicePolicyRefBean;
import weblogic.servlet.internal.War;
import weblogic.servlet.internal.WebAppModule;
import weblogic.servlet.utils.WebAppLibraryUtils;
import weblogic.utils.FileUtils;
import weblogic.utils.StringUtils;
import weblogic.utils.application.WarDetector;
import weblogic.utils.classloaders.Annotation;
import weblogic.utils.classloaders.ClassFinder;
import weblogic.utils.classloaders.ClasspathClassFinder2;
import weblogic.utils.classloaders.FilteringClassLoader;
import weblogic.utils.classloaders.GenericClassLoader;
import weblogic.utils.classloaders.MultiClassFinder;
import weblogic.utils.compiler.ToolFailureException;
import weblogic.utils.jars.VirtualJarFactory;
import weblogic.utils.jars.VirtualJarFile;

public final class LightWeightDeploymentViewerFlow
extends CompilerFlow {
    private ApplicationContextInternal appCtx = null;
    private VirtualJarFile vjf = null;
    private EditableJ2eeApplicationObject deployableApplication = null;
    private GenericClassLoader appClassLoader = null;
    private File baseDir = null;

    public LightWeightDeploymentViewerFlow(CompilerCtx compilerCtx) {
        super(compilerCtx);
        String string = ".appmergegen_" + System.currentTimeMillis();
        this.baseDir = new File(J2EEApplicationService.getTempDir(), string);
        if (this.baseDir.exists() && !this.baseDir.isDirectory()) {
            this.baseDir.delete();
        }
        this.baseDir.mkdirs();
    }

    private GenericClassLoader createAppClassLoader(String string) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        FilteringClassLoader filteringClassLoader = new FilteringClassLoader(classLoader);
        GenericClassLoader genericClassLoader = new GenericClassLoader((ClassFinder)new MultiClassFinder(), (ClassLoader)filteringClassLoader);
        genericClassLoader.setAnnotation(new Annotation(string));
        return genericClassLoader;
    }

    private void initWebAppLibraryManager(LibraryManager libraryManager, WeblogicWebAppBean weblogicWebAppBean, String string) throws ToolFailureException {
        if (weblogicWebAppBean == null) {
            return;
        }
        if (weblogicWebAppBean.getLibraryRefs() == null) {
            return;
        }
        LibraryReference[] libraryReferenceArray = WebAppLibraryUtils.getWebLibRefs(weblogicWebAppBean, string);
        libraryManager.lookup(libraryReferenceArray);
    }

    public void compile() throws ToolFailureException {
        WebLogicDeployableObjectFactory webLogicDeployableObjectFactory = this.ctx.getObjectFactory();
        if (webLogicDeployableObjectFactory == null) {
            return;
        }
        this.appCtx = ApplicationAccess.getApplicationAccess().getApplicationContext(this.ctx.getLightWeightAppName());
        this.appClassLoader = this.createAppClassLoader(this.ctx.getLightWeightAppName());
        if (this.appCtx.isEar()) {
            try {
                DescriptorBean descriptorBean;
                this.deployableApplication = webLogicDeployableObjectFactory.createApplicationObject();
                this.vjf = this.appCtx.getApplicationFileManager().getVirtualJarFile();
                DescriptorBean descriptorBean2 = (DescriptorBean)this.appCtx.getApplicationDescriptor().getApplicationDescriptor();
                if (descriptorBean2 != null) {
                    descriptorBean = ((Descriptor)descriptorBean2.getDescriptor().clone()).getRootBean();
                    this.deployableApplication.addRootBean("META-INF/application.xml", descriptorBean, null);
                    this.deployableApplication.setRootBean(descriptorBean);
                }
                if ((descriptorBean2 = (DescriptorBean)this.appCtx.getApplicationDescriptor().getWeblogicApplicationDescriptor()) != null) {
                    descriptorBean = ((Descriptor)descriptorBean2.getDescriptor().clone()).getRootBean();
                    this.deployableApplication.addRootBean("META-INF/weblogic-application.xml", descriptorBean, null);
                }
                if ((descriptorBean2 = (DescriptorBean)this.appCtx.getApplicationDescriptor().getWeblogicExtensionDescriptor()) != null) {
                    descriptorBean = ((Descriptor)descriptorBean2.getDescriptor().clone()).getRootBean();
                    this.deployableApplication.addRootBean("META-INF/weblogic-extension.xml", descriptorBean, null);
                }
                descriptorBean = this.appCtx.getApplicationModules();
                for (int i = 0; i < ((DescriptorBean)descriptorBean).length; ++i) {
                    Object object;
                    ModuleType moduleType = WebLogicModuleType.getTypeFromString(descriptorBean[i].getType());
                    if (moduleType.equals((Object)WebLogicModuleType.WLDF)) {
                        object = descriptorBean[i].getDescriptors();
                        DescriptorBean descriptorBean3 = ((Descriptor)object[0].getDescriptor().clone()).getRootBean();
                        this.deployableApplication.addRootBean("META-INF/weblogic-diagnostics.xml", descriptorBean3, moduleType);
                        continue;
                    }
                    object = this.processModules(webLogicDeployableObjectFactory, (Module)descriptorBean[i]);
                    if (object == null) continue;
                    this.deployableApplication.addDeployableObject((EditableDeployableObject)object);
                }
                this.deployableApplication.setClassLoader(this.appClassLoader);
                ApplicationViewerFlow.ApplicationResourceFinder applicationResourceFinder = new ApplicationViewerFlow.ApplicationResourceFinder(this.appCtx.getEar().getURI(), this.appClassLoader.getClassFinder());
                this.deployableApplication.setResourceFinder(applicationResourceFinder);
                this.deployableApplication.setVirtualJarFile(this.vjf);
            }
            catch (XMLStreamException xMLStreamException) {
                this.deployableApplication = null;
            }
            catch (IOException iOException) {
                this.deployableApplication = null;
            }
            catch (ToolFailureException toolFailureException) {
                this.deployableApplication = null;
            }
            this.ctx.setDeployableApplication(this.deployableApplication);
        } else {
            try {
                this.vjf = this.appCtx.getApplicationFileManager().getVirtualJarFile();
            }
            catch (IOException iOException) {
                return;
            }
            EditableDeployableObject editableDeployableObject = null;
            String string = null;
            DescriptorBean[] descriptorBeanArray = null;
            Module[] moduleArray = this.appCtx.getApplicationModules();
            for (int i = 0; i < moduleArray.length; ++i) {
                ModuleType moduleType = WebLogicModuleType.getTypeFromString(moduleArray[i].getType());
                if (moduleType.equals((Object)WebLogicModuleType.WLDF)) {
                    descriptorBeanArray = (DescriptorBean[])moduleArray[i].getDescriptors().clone();
                    continue;
                }
                editableDeployableObject = this.processModules(webLogicDeployableObjectFactory, moduleArray[i]);
                if (editableDeployableObject == null) continue;
                string = moduleArray[i].getId();
                break;
            }
            if (editableDeployableObject != null) {
                this.addModuleDescriptors(editableDeployableObject, null, descriptorBeanArray, WebLogicModuleType.WLDF);
                editableDeployableObject.setVirtualJarFile(this.vjf);
            }
            this.ctx.setDeployableApplication(editableDeployableObject);
        }
    }

    private EditableDeployableObject processModules(WebLogicDeployableObjectFactory webLogicDeployableObjectFactory, Module module) throws ToolFailureException {
        try {
            EditableDeployableObject editableDeployableObject = null;
            ModuleType moduleType = WebLogicModuleType.getTypeFromString(module.getType());
            DescriptorBean[] descriptorBeanArray = module.getDescriptors();
            if (moduleType.equals(ModuleType.EJB)) {
                return this.processEJBModule(webLogicDeployableObjectFactory, module);
            }
            if (moduleType.equals(ModuleType.WAR)) {
                return this.processWARModule(webLogicDeployableObjectFactory, module);
            }
            if (moduleType.equals((Object)WebLogicModuleType.CONFIG)) {
                return this.processCustomModule(webLogicDeployableObjectFactory, module);
            }
            if (moduleType.equals(WebLogicModuleType.CAR)) {
                return this.processCARModule(webLogicDeployableObjectFactory, module);
            }
            if (moduleType.equals((Object)WebLogicModuleType.JDBC)) {
                editableDeployableObject = webLogicDeployableObjectFactory.createDeployableObject(module.getId(), null, moduleType);
            } else if (moduleType.equals((Object)WebLogicModuleType.JMS)) {
                editableDeployableObject = webLogicDeployableObjectFactory.createDeployableObject(module.getId(), null, moduleType);
            } else if (moduleType.equals(WebLogicModuleType.RAR)) {
                editableDeployableObject = webLogicDeployableObjectFactory.createDeployableObject(module.getId(), null, moduleType);
            } else {
                if (moduleType.equals((Object)WebLogicModuleType.WLDF)) {
                    return null;
                }
                return null;
            }
            this.addModuleDescriptors(editableDeployableObject, module, descriptorBeanArray, moduleType);
            editableDeployableObject.setClassLoader(this.appCtx.getAppClassLoader());
            editableDeployableObject.setVirtualJarFile(this.vjf);
            return editableDeployableObject;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private EditableDeployableObject processEJBModule(WebLogicDeployableObjectFactory webLogicDeployableObjectFactory, Module module) throws ToolFailureException {
        ModuleType moduleType = WebLogicModuleType.getTypeFromString(module.getType());
        if (!moduleType.equals(ModuleType.EJB)) {
            return null;
        }
        if (!(module instanceof ModuleListenerInvoker)) {
            throw new ToolFailureException("unknown module");
        }
        Module module2 = ((ModuleListenerInvoker)module).getDelegate();
        if (!(module2 instanceof EJBModule)) {
            throw new ToolFailureException("unknown module");
        }
        EJBModule eJBModule = (EJBModule)module2;
        try {
            EditableDeployableObject editableDeployableObject = webLogicDeployableObjectFactory.createDeployableObject(eJBModule.getURI(), eJBModule.getAltDD(), moduleType);
            DescriptorBean[] descriptorBeanArray = eJBModule.getDescriptors();
            this.addModuleDescriptors(editableDeployableObject, module, descriptorBeanArray, moduleType);
            MultiClassFinder multiClassFinder = new MultiClassFinder();
            String string = this.appCtx.getApplicationFileManager().getSourcePath(eJBModule.getURI()).getParent();
            multiClassFinder.addFinder((ClassFinder)new ClasspathClassFinder2(string));
            if (this.appClassLoader != null) {
                this.appClassLoader.addClassFinder((ClassFinder)multiClassFinder);
                editableDeployableObject.setClassLoader(new GenericClassLoader((ClassLoader)this.appClassLoader));
            } else {
                editableDeployableObject.setClassLoader(new GenericClassLoader((ClassFinder)multiClassFinder));
            }
            File file = this.appCtx.getApplicationFileManager().getSourcePath(eJBModule.getURI());
            VirtualJarFile virtualJarFile = VirtualJarFactory.createVirtualJar((File)file);
            editableDeployableObject.setVirtualJarFile(virtualJarFile);
            return editableDeployableObject;
        }
        catch (IOException iOException) {
            throw new ToolFailureException("unable process EJB module", (Throwable)iOException);
        }
    }

    private EditableDeployableObject processWARModule(WebLogicDeployableObjectFactory webLogicDeployableObjectFactory, Module module) throws ToolFailureException {
        Object object;
        Module module2;
        ModuleType moduleType = WebLogicModuleType.getTypeFromString(module.getType());
        if (!moduleType.equals(ModuleType.WAR)) {
            return null;
        }
        if (!(module instanceof ModuleListenerInvoker)) {
            throw new ToolFailureException("unknown module");
        }
        Module module3 = ((ModuleListenerInvoker)module).getDelegate();
        if (module3 instanceof ScopedModuleDriver) {
            module2 = ((ScopedModuleDriver)module3).getDelegate();
            object = ((ScopedModuleDriver)module3).getDescriptorMappings();
            if (module2 instanceof WebAppModule) {
                WebAppModule webAppModule = (WebAppModule)module2;
                try {
                    GenericClassLoader genericClassLoader;
                    Object object2;
                    Object object3;
                    Object object4;
                    Object object52;
                    EditableDeployableObject editableDeployableObject = webLogicDeployableObjectFactory.createDeployableObject(webAppModule.getModuleURI(), null, moduleType);
                    WeblogicWebAppBean weblogicWebAppBean = null;
                    if (object != null) {
                        for (Object object52 : object.keySet()) {
                            object4 = (DescriptorBean)object.get(object52);
                            object3 = ((Descriptor)object4.getDescriptor().clone()).getRootBean();
                            editableDeployableObject.addRootBean((String)object52, (DescriptorBean)object3, moduleType);
                            if (((String)object52).equals("WEB-INF/web.xml")) {
                                editableDeployableObject.setRootBean((DescriptorBean)object3);
                                continue;
                            }
                            if (!((String)object52).equals("WEB-INF/weblogic.xml")) continue;
                            weblogicWebAppBean = (WeblogicWebAppBean)object3;
                        }
                    } else {
                        object2 = (DescriptorBean)webAppModule.getWebAppBean();
                        object52 = ((Descriptor)object2.getDescriptor().clone()).getRootBean();
                        editableDeployableObject.setRootBean((DescriptorBean)object52);
                        editableDeployableObject.addRootBean("WEB-INF/web.xml", (DescriptorBean)object52, moduleType);
                        object4 = (DescriptorBean)webAppModule.getWlWebAppBean();
                        if (object4 != null) {
                            object3 = ((Descriptor)object4.getDescriptor().clone()).getRootBean();
                            editableDeployableObject.addRootBean("WEB-INF/weblogic.xml", (DescriptorBean)object3, moduleType);
                            weblogicWebAppBean = (WeblogicWebAppBean)object3;
                        }
                    }
                    object2 = new CompositeWebAppFinder();
                    object52 = new MultiClassFinder();
                    object4 = new File(this.baseDir, PathUtils.generateTempPath(null, this.ctx.getLightWeightAppName(), webAppModule.getModuleURI()));
                    object3 = this.appCtx.getApplicationFileManager().getSourcePath(webAppModule.getModuleURI());
                    boolean bl = !((File)object3).isDirectory() && WarDetector.instance.suffixed(((File)object3).getName());
                    VirtualJarFile virtualJarFile = this.appCtx.getApplicationFileManager().getVirtualJarFile(webAppModule.getModuleURI());
                    ExplodedJar explodedJar = null;
                    explodedJar = bl ? new ExplodedJar(webAppModule.getModuleURI(), (File)object4, virtualJarFile.getRootFiles()[0], War.WAR_CLASSPATH_INFO) : new ExplodedJar(webAppModule.getModuleURI(), (File)object4, virtualJarFile.getRootFiles(), War.WAR_CLASSPATH_INFO, JarCopyFilter.NOCOPY_FILTER);
                    ((CompositeWebAppFinder)object2).addFinder(explodedJar.getClassFinder());
                    object52.addFinder((ClassFinder)new ApplicationViewerFlow.ApplicationResourceFinder(webAppModule.getModuleURI(), explodedJar.getClassFinder()));
                    SplitDirectoryInfo splitDirectoryInfo = this.appCtx.getSplitDirectoryInfo();
                    if (splitDirectoryInfo != null && (genericClassLoader = splitDirectoryInfo.getWebAppClasses(webAppModule.getModuleURI())) != null && ((String[])genericClassLoader).length > 0) {
                        ((CompositeWebAppFinder)object2).addFinder((ClassFinder)new ClasspathClassFinder2(StringUtils.join((String[])genericClassLoader, (String)File.pathSeparator)));
                    }
                    if (null != weblogicWebAppBean) {
                        genericClassLoader = new LibraryManager(WebAppLibraryUtils.getLibraryReferencer(webAppModule.getModuleURI()));
                        this.initWebAppLibraryManager((LibraryManager)genericClassLoader, weblogicWebAppBean, webAppModule.getModuleURI());
                        if (genericClassLoader.hasReferencedLibraries()) {
                            War war = new War(webAppModule.getModuleURI());
                            WebAppLibraryUtils.extractWebAppLibraries((LibraryManager)genericClassLoader, war, (File)object4);
                            ((CompositeWebAppFinder)object2).addLibraryFinder(war.getClassFinder());
                            object52.addFinder(war.getResourceFinder("/"));
                        }
                    }
                    if (this.appClassLoader != null) {
                        genericClassLoader = new GenericClassLoader((ClassFinder)object2, (ClassLoader)this.appClassLoader);
                        editableDeployableObject.setClassLoader(genericClassLoader);
                    } else {
                        genericClassLoader = new GenericClassLoader((ClassFinder)object2);
                        editableDeployableObject.setClassLoader(genericClassLoader);
                    }
                    editableDeployableObject.setResourceFinder((ClassFinder)object52);
                    if (bl) {
                        genericClassLoader = VirtualJarFactory.createVirtualJar((JarFile)new JarFile((File)object3));
                        editableDeployableObject.setVirtualJarFile((VirtualJarFile)genericClassLoader);
                    } else {
                        editableDeployableObject.setVirtualJarFile(virtualJarFile);
                    }
                    return editableDeployableObject;
                }
                catch (IOException iOException) {
                    throw new ToolFailureException("unable process WAR module", (Throwable)iOException);
                }
                catch (Exception exception) {
                    throw new ToolFailureException("unable process WAR module", (Throwable)exception);
                }
            }
        }
        if (module3 instanceof WebAppModule) {
            module2 = (WebAppModule)module3;
            try {
                GenericClassLoader genericClassLoader;
                CompositeWebAppFinder compositeWebAppFinder;
                object = webLogicDeployableObjectFactory.createDeployableObject(((WebAppModule)module2).getModuleURI(), null, moduleType);
                DescriptorBean descriptorBean = (DescriptorBean)((WebAppModule)module2).getWebAppBean();
                DescriptorBean descriptorBean2 = ((Descriptor)descriptorBean.getDescriptor().clone()).getRootBean();
                object.setRootBean(descriptorBean2);
                object.addRootBean("WEB-INF/web.xml", descriptorBean2, moduleType);
                DescriptorBean descriptorBean3 = (DescriptorBean)((WebAppModule)module2).getWlWebAppBean();
                if (descriptorBean3 != null) {
                    compositeWebAppFinder = ((Descriptor)descriptorBean3.getDescriptor().clone()).getRootBean();
                    object.addRootBean("WEB-INF/weblogic.xml", (DescriptorBean)compositeWebAppFinder, moduleType);
                }
                compositeWebAppFinder = new CompositeWebAppFinder();
                MultiClassFinder multiClassFinder = new MultiClassFinder();
                File file = new File(this.baseDir, PathUtils.generateTempPath(null, this.ctx.getLightWeightAppName(), ((WebAppModule)module2).getModuleURI()));
                File file2 = this.appCtx.getApplicationFileManager().getSourcePath(((WebAppModule)module2).getModuleURI());
                boolean bl = !file2.isDirectory() && WarDetector.instance.suffixed(file2.getName());
                VirtualJarFile virtualJarFile = this.appCtx.getApplicationFileManager().getVirtualJarFile(((WebAppModule)module2).getModuleURI());
                ExplodedJar explodedJar = null;
                explodedJar = bl ? new ExplodedJar(((WebAppModule)module2).getModuleURI(), file, virtualJarFile.getRootFiles()[0], War.WAR_CLASSPATH_INFO) : new ExplodedJar(((WebAppModule)module2).getModuleURI(), file, virtualJarFile.getRootFiles(), War.WAR_CLASSPATH_INFO, JarCopyFilter.NOCOPY_FILTER);
                compositeWebAppFinder.addFinder(explodedJar.getClassFinder());
                multiClassFinder.addFinder((ClassFinder)new ApplicationViewerFlow.ApplicationResourceFinder(((WebAppModule)module2).getModuleURI(), explodedJar.getClassFinder()));
                SplitDirectoryInfo splitDirectoryInfo = this.appCtx.getSplitDirectoryInfo();
                if (splitDirectoryInfo != null && (genericClassLoader = splitDirectoryInfo.getWebAppClasses(((WebAppModule)module2).getModuleURI())) != null && ((String[])genericClassLoader).length > 0) {
                    compositeWebAppFinder.addFinder((ClassFinder)new ClasspathClassFinder2(StringUtils.join((String[])genericClassLoader, (String)File.pathSeparator)));
                }
                if (null != descriptorBean3) {
                    genericClassLoader = new LibraryManager(WebAppLibraryUtils.getLibraryReferencer(((WebAppModule)module2).getModuleURI()));
                    this.initWebAppLibraryManager((LibraryManager)genericClassLoader, (WeblogicWebAppBean)descriptorBean3, ((WebAppModule)module2).getModuleURI());
                    if (genericClassLoader.hasReferencedLibraries()) {
                        War war = new War(((WebAppModule)module2).getModuleURI());
                        WebAppLibraryUtils.extractWebAppLibraries((LibraryManager)genericClassLoader, war, file);
                        compositeWebAppFinder.addLibraryFinder(war.getClassFinder());
                        multiClassFinder.addFinder(war.getResourceFinder("/"));
                    }
                }
                if (this.appClassLoader != null) {
                    genericClassLoader = new GenericClassLoader((ClassFinder)compositeWebAppFinder, (ClassLoader)this.appClassLoader);
                    object.setClassLoader(genericClassLoader);
                } else {
                    genericClassLoader = new GenericClassLoader((ClassFinder)compositeWebAppFinder);
                    object.setClassLoader(genericClassLoader);
                }
                object.setResourceFinder((ClassFinder)multiClassFinder);
                if (bl) {
                    genericClassLoader = VirtualJarFactory.createVirtualJar((JarFile)new JarFile(file2));
                    object.setVirtualJarFile((VirtualJarFile)genericClassLoader);
                } else {
                    object.setVirtualJarFile(virtualJarFile);
                }
                return object;
            }
            catch (IOException iOException) {
                throw new ToolFailureException("unable process WAR module", (Throwable)iOException);
            }
        }
        throw new ToolFailureException("unable process WAR module");
    }

    private EditableDeployableObject processCustomModule(WebLogicDeployableObjectFactory webLogicDeployableObjectFactory, Module module) throws ToolFailureException {
        ModuleType moduleType = WebLogicModuleType.getTypeFromString(module.getType());
        if (!moduleType.equals((Object)WebLogicModuleType.CONFIG)) {
            return null;
        }
        if (!(module instanceof ModuleListenerInvoker)) {
            throw new ToolFailureException("unknown module");
        }
        Module module2 = ((ModuleListenerInvoker)module).getDelegate();
        if (module2 instanceof DefaultModule) {
            DefaultModule defaultModule = (DefaultModule)module2;
            Map map = defaultModule.getDescriptorMappings();
            if (map != null) {
                for (String string : map.keySet()) {
                    DescriptorBean descriptorBean = (DescriptorBean)map.get(string);
                    DescriptorBean descriptorBean2 = ((Descriptor)descriptorBean.getDescriptor().clone()).getRootBean();
                    this.deployableApplication.addRootBean(string, descriptorBean2, moduleType);
                }
            }
        } else if (module2.getDescriptors() != null && module2.getDescriptors().length > 0) {
            DescriptorBean descriptorBean = ((Descriptor)module2.getDescriptors()[0].getDescriptor().clone()).getRootBean();
            this.deployableApplication.addRootBean(module2.getId(), descriptorBean, moduleType);
        }
        return null;
    }

    private EditableDeployableObject processCARModule(WebLogicDeployableObjectFactory webLogicDeployableObjectFactory, Module module) throws ToolFailureException {
        ModuleType moduleType = WebLogicModuleType.getTypeFromString(module.getType());
        if (!moduleType.equals(WebLogicModuleType.CAR)) {
            return null;
        }
        if (!(module instanceof ModuleListenerInvoker)) {
            throw new ToolFailureException("unknown module");
        }
        Module module2 = ((ModuleListenerInvoker)module).getDelegate();
        if (!(module2 instanceof AppClientModule)) {
            throw new ToolFailureException("unknown module");
        }
        AppClientModule appClientModule = (AppClientModule)module2;
        if (appClientModule.getDescriptors() != null && appClientModule.getDescriptors().length > 0) {
            DescriptorBean descriptorBean = ((Descriptor)appClientModule.getDescriptors()[0].getDescriptor().clone()).getRootBean();
            this.deployableApplication.addRootBean(appClientModule.getId(), descriptorBean, moduleType);
        }
        return null;
    }

    private void addModuleDescriptors(EditableDeployableObject editableDeployableObject, Module module, DescriptorBean[] descriptorBeanArray, ModuleType moduleType) throws ToolFailureException {
        if (descriptorBeanArray == null) {
            return;
        }
        for (int i = 0; i < descriptorBeanArray.length; ++i) {
            if (descriptorBeanArray[i] == null) continue;
            DescriptorBean descriptorBean = ((Descriptor)descriptorBeanArray[i].getDescriptor().clone()).getRootBean();
            if (descriptorBean instanceof WebAppBean) {
                editableDeployableObject.setRootBean(descriptorBean);
                editableDeployableObject.addRootBean("WEB-INF/web.xml", descriptorBean, moduleType);
                continue;
            }
            if (descriptorBean instanceof WeblogicWebAppBean) {
                editableDeployableObject.addRootBean("WEB-INF/weblogic.xml", descriptorBean, moduleType);
                continue;
            }
            if (descriptorBean instanceof EjbJarBean) {
                editableDeployableObject.setRootBean(descriptorBean);
                editableDeployableObject.addRootBean("META-INF/ejb-jar.xml", descriptorBean, moduleType);
                continue;
            }
            if (descriptorBean instanceof WeblogicEjbJarBean) {
                editableDeployableObject.addRootBean("META-INF/weblogic-ejb-jar.xml", descriptorBean, moduleType);
                continue;
            }
            if (descriptorBean instanceof ConnectorBean) {
                editableDeployableObject.setRootBean(descriptorBean);
                editableDeployableObject.addRootBean("META-INF/ra.xml", descriptorBean, moduleType);
                continue;
            }
            if (descriptorBean instanceof WeblogicConnectorBean) {
                editableDeployableObject.addRootBean("META-INF/weblogic-ra.xml", descriptorBean, moduleType);
                continue;
            }
            if (descriptorBean instanceof ApplicationClientBean) {
                editableDeployableObject.setRootBean(descriptorBean);
                editableDeployableObject.addRootBean("META-INF/application-client.xml", descriptorBean, moduleType);
                continue;
            }
            if (descriptorBean instanceof WeblogicApplicationClientBean) {
                editableDeployableObject.addRootBean("META-INF/weblogic-application-client.xml", descriptorBean, moduleType);
                continue;
            }
            if (descriptorBean instanceof WeblogicRdbmsJarBean) {
                editableDeployableObject.addRootBean("META-INF/weblogic-cmp-rdbms-jar.xml", descriptorBean, moduleType);
                continue;
            }
            if (descriptorBean instanceof WLDFResourceBean) {
                editableDeployableObject.addRootBean("META-INF/weblogic-diagnostics.xml", descriptorBean, moduleType);
                continue;
            }
            if (descriptorBean instanceof PersistenceBean) {
                editableDeployableObject.addRootBean("META-INF/persistence.xml", descriptorBean, moduleType);
                continue;
            }
            if (descriptorBean instanceof PersistenceConfigurationBean) {
                editableDeployableObject.addRootBean("META-INF/persistence-configuration.xml", descriptorBean, moduleType);
                continue;
            }
            if (descriptorBean instanceof WebservicesBean) {
                if (moduleType.equals(ModuleType.WAR)) {
                    editableDeployableObject.addRootBean("WEB-INF/webservices.xml", descriptorBean, moduleType);
                }
                if (!moduleType.equals(ModuleType.EJB)) continue;
                editableDeployableObject.addRootBean("META-INF/webservices.xml", descriptorBean, moduleType);
                continue;
            }
            if (descriptorBean instanceof WeblogicWebservicesBean) {
                if (moduleType.equals(ModuleType.WAR)) {
                    editableDeployableObject.addRootBean("WEB-INF/weblogic-webservices.xml", descriptorBean, moduleType);
                }
                if (!moduleType.equals(ModuleType.EJB)) continue;
                editableDeployableObject.addRootBean("META-INF/weblogic-webservices.xml", descriptorBean, moduleType);
                continue;
            }
            if (descriptorBean instanceof WebservicePolicyRefBean) {
                if (moduleType.equals(ModuleType.WAR)) {
                    editableDeployableObject.addRootBean("WEB-INF/weblogic-webservices-policy.xml", descriptorBean, moduleType);
                }
                if (!moduleType.equals(ModuleType.EJB)) continue;
                editableDeployableObject.addRootBean("META-INF/weblogic-webservices-policy.xml", descriptorBean, moduleType);
                continue;
            }
            if (descriptorBean instanceof JMSBean) {
                editableDeployableObject.addRootBean(module.getId(), descriptorBean, moduleType);
                editableDeployableObject.setRootBean(descriptorBean);
                continue;
            }
            if (descriptorBean instanceof JDBCDataSourceBean) {
                editableDeployableObject.addRootBean(module.getId(), descriptorBean, moduleType);
                editableDeployableObject.setRootBean(descriptorBean);
                continue;
            }
            throw new ToolFailureException("unable process unknown descriptors");
        }
    }

    public void cleanup() {
        if (this.appClassLoader != null) {
            this.appClassLoader.close();
        }
        if (this.baseDir.exists()) {
            FileUtils.remove((File)this.baseDir);
        }
    }
}

