/*
 * Decompiled with CFR 0.152.
 */
package weblogic.application.compiler.flow;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.jar.Manifest;
import weblogic.application.compiler.CompilerCtx;
import weblogic.application.compiler.flow.CompilerFlow;
import weblogic.j2ee.J2EELogger;
import weblogic.logging.Loggable;
import weblogic.utils.FileUtils;
import weblogic.utils.compiler.ToolFailureException;

public class ManifestFlow
extends CompilerFlow {
    public ManifestFlow(CompilerCtx compilerCtx) {
        super(compilerCtx);
    }

    public void compile() throws ToolFailureException {
        File file = this.ctx.getManifestFile();
        if (file != null) {
            try {
                if (!file.exists() || !file.isFile()) {
                    throw new FileNotFoundException();
                }
                Manifest manifest = new Manifest();
                manifest.read(new FileInputStream(file));
                File file2 = new File(new File(this.ctx.getOutputDir(), "META-INF"), "MANIFEST.MF");
                FileUtils.copy((File)file, (File)file2);
            }
            catch (Exception exception) {
                Loggable loggable = J2EELogger.logAppcErrorsEncounteredCompilingModuleLoggable((String)this.ctx.getSourceFile().getAbsolutePath(), (String)exception.toString());
                throw new ToolFailureException(loggable.getMessage(), (Throwable)exception);
            }
        }
    }

    public void cleanup() throws ToolFailureException {
    }
}

