/*
 * Decompiled with CFR 0.152.
 */
package weblogic.application.compiler.flow;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import javax.enterprise.deploy.shared.ModuleType;
import weblogic.application.compiler.AppcUtils;
import weblogic.application.compiler.BuildtimeApplicationContext;
import weblogic.application.compiler.CompilerCtx;
import weblogic.application.compiler.EARModule;
import weblogic.application.compiler.flow.AbstractClassEnhanceFlow;
import weblogic.utils.Debug;
import weblogic.utils.FileUtils;
import weblogic.utils.classloaders.ClassFinder;
import weblogic.utils.classloaders.MultiClassFinder;
import weblogic.utils.classloaders.Source;
import weblogic.utils.compiler.ToolFailureException;

public class ModuleClassEnhanceFlow
extends AbstractClassEnhanceFlow {
    private EARModule[] modules = null;
    private final BuildtimeApplicationContext libCtx;
    private ClassLoader cl;
    private MultiClassFinder moduleFinder;
    private MultiClassFinder warFinder;
    private MultiClassFinder appFinder;
    private MultiClassFinder shareLibFinder;
    private Collection finders;

    public ModuleClassEnhanceFlow(CompilerCtx compilerCtx) {
        super(compilerCtx);
        this.libCtx = (BuildtimeApplicationContext)compilerCtx.getApplicationContext();
    }

    private ClassLoader getModuleClassLoader() {
        this.moduleFinder = new MultiClassFinder();
        this.warFinder = new MultiClassFinder();
        this.appFinder = new MultiClassFinder();
        this.shareLibFinder = new MultiClassFinder();
        this.finders = new ArrayList();
        if (this.ctx.getEar() != null) {
            this.moduleFinder.addFinder(this.ctx.getEar().getClassFinder());
            this.appFinder.addFinder(this.ctx.getEar().getClassFinder());
        }
        for (int i = 0; i < this.modules.length; ++i) {
            this.moduleFinder.addFinder(this.modules[i].getClassFinder());
            if (this.modules[i].getModuleType() != ModuleType.WAR) continue;
            this.warFinder.addFinder(this.modules[i].getClassFinder());
        }
        this.moduleFinder.addFinder(this.libCtx.getClassFinder());
        this.shareLibFinder.addFinder(this.libCtx.getClassFinder());
        this.finders.add(this.warFinder);
        this.finders.add(this.appFinder);
        this.finders.add(this.shareLibFinder);
        return AppcUtils.getClassLoaderForApplication((ClassFinder)this.moduleFinder, this.ctx, this.ctx.getApplicationContext().getApplicationId());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void compile() throws ToolFailureException {
        File file;
        block21: {
            block20: {
                block19: {
                    file = null;
                    try {
                        try {
                            this.modules = this.ctx.getModules();
                            Collection collection = new HashSet();
                            HashSet<Object> hashSet = new HashSet<Object>();
                            HashSet<Object> hashSet2 = new HashSet<Object>();
                            URL uRL = null;
                            this.cl = this.getModuleClassLoader();
                            uRL = this.cl.getResource("META-INF/persistence.xml");
                            if (uRL == null) {
                                Object var14_7 = null;
                                if (file == null) return;
                                if (!file.exists()) return;
                                break block19;
                            }
                            file = this.createConfigFile();
                            Enumeration enumeration = this.moduleFinder.getSources("META-INF/persistence.xml");
                            while (enumeration.hasMoreElements()) {
                                Object object = enumeration.nextElement().toString();
                                if (!((String)object).endsWith(".jar")) continue;
                                if (((String)object).indexOf("WEB-INF") > -1) {
                                    object = ((String)object).substring(((String)object).lastIndexOf(File.separatorChar) + 1);
                                    hashSet2.add(object);
                                    continue;
                                }
                                hashSet.add(object);
                            }
                            collection = this.getEntityClasses(this.cl);
                            if (collection.size() == 0) {
                                break block20;
                            }
                            for (Object object : collection) {
                                for (Object object2 : this.finders) {
                                    String string;
                                    Source source = object2.getClassSource((String)object);
                                    if (source == null || !(string = source.toString()).endsWith(".jar")) continue;
                                    if (string.indexOf("WEB-INF") > -1) {
                                        string = string.substring(string.lastIndexOf(File.separatorChar) + 1);
                                        hashSet2.add(string);
                                        continue;
                                    }
                                    hashSet.add(string);
                                }
                            }
                            for (int i = 0; i < this.modules.length; ++i) {
                                if (this.modules[i].getModuleType() == ModuleType.EJB) {
                                    if (debug) {
                                        Debug.say((String)"Enhance EJB persistent classes");
                                    }
                                    this.processDir(this.modules[i].getOutputDir().getPath(), file, collection, this.cl, false);
                                }
                                if (this.modules[i].getModuleType() != ModuleType.WAR) continue;
                                if (debug) {
                                    Debug.say((String)"Enhance WAR persistent classes");
                                }
                                this.processDir(this.modules[i].getOutputDir() + WEBINF_CLASSES, file, collection, this.cl, false);
                                for (Object object : hashSet2) {
                                    Object object2;
                                    object2 = new File(this.modules[i].getOutputDir() + WEBINF_LIB + (String)object);
                                    if (!((File)object2).exists()) continue;
                                    this.processJar((File)object2, file, collection, this.cl, false);
                                }
                            }
                            if (this.ctx.getEar() != null) {
                                if (debug) {
                                    Debug.say((String)"Enhance exploded application persistent classes");
                                }
                                this.processDir(this.ctx.getOutputDir() + APP_CLASSES, file, collection, this.cl, false);
                            }
                            this.processJars(hashSet, file, collection, this.cl, false);
                            break block21;
                        }
                        catch (IOException iOException) {
                            throw new ToolFailureException(iOException.getMessage(), (Throwable)iOException);
                        }
                    }
                    catch (Throwable throwable) {
                        Object var14_10 = null;
                        if (file == null) throw throwable;
                        if (!file.exists()) throw throwable;
                        FileUtils.remove((File)file);
                        throw throwable;
                    }
                }
                FileUtils.remove((File)file);
                return;
            }
            Object var14_8 = null;
            if (file == null) return;
            if (!file.exists()) return;
            FileUtils.remove((File)file);
            return;
        }
        Object var14_9 = null;
        if (file == null) return;
        if (!file.exists()) return;
        FileUtils.remove((File)file);
    }
}

