/*
 * Decompiled with CFR 0.152.
 */
package weblogic.application.compiler.flow;

import java.io.IOException;
import java.io.OutputStream;
import weblogic.application.ApplicationDescriptor;
import weblogic.application.compiler.CompilerCtx;
import weblogic.application.compiler.EARModule;
import weblogic.application.compiler.WARModule;
import weblogic.application.compiler.flow.CompilerFlow;
import weblogic.application.utils.CustomModuleManager;
import weblogic.deploy.api.model.EditableDeployableObject;
import weblogic.deploy.api.model.WebLogicDeployableObjectFactory;
import weblogic.deploy.api.shared.WebLogicModuleType;
import weblogic.descriptor.DescriptorBean;
import weblogic.utils.compiler.ToolFailureException;

public class ModuleViewerFlow
extends CompilerFlow {
    protected static boolean debug = Boolean.getBoolean("weblogic.application.compiler.viewer");

    public ModuleViewerFlow(CompilerCtx compilerCtx) {
        super(compilerCtx);
    }

    public void compile() throws ToolFailureException {
        WebLogicDeployableObjectFactory webLogicDeployableObjectFactory = this.ctx.getObjectFactory();
        if (webLogicDeployableObjectFactory != null) {
            EARModule[] eARModuleArray = this.ctx.getModules();
            if (eARModuleArray.length != 1) {
                throw new AssertionError((Object)"ModuleViewerFlow can be invoked for standalone modules only");
            }
            try {
                this.ctx.setDeployableApplication(this.createDeployableObject(webLogicDeployableObjectFactory, eARModuleArray[0]));
            }
            catch (IOException iOException) {
                throw new ToolFailureException("Unable to create deployable object", (Throwable)iOException);
            }
        }
    }

    protected void dump(ApplicationDescriptor applicationDescriptor) {
        try {
            DescriptorBean descriptorBean = (DescriptorBean)applicationDescriptor.getApplicationDescriptor();
            descriptorBean.getDescriptor().toXML((OutputStream)System.out);
            DescriptorBean descriptorBean2 = (DescriptorBean)applicationDescriptor.getWeblogicApplicationDescriptor();
            descriptorBean2.getDescriptor().toXML((OutputStream)System.out);
            DescriptorBean descriptorBean3 = (DescriptorBean)applicationDescriptor.getWeblogicExtensionDescriptor();
            descriptorBean3.getDescriptor().toXML((OutputStream)System.out);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void cleanup() {
    }

    protected EditableDeployableObject createDeployableObject(WebLogicDeployableObjectFactory webLogicDeployableObjectFactory, EARModule eARModule) throws IOException {
        Object object;
        if (debug) {
            this.say("Adding module type " + eARModule.getModuleType() + " at URI " + eARModule.getURI());
        }
        EditableDeployableObject editableDeployableObject = webLogicDeployableObjectFactory.createDeployableObject(eARModule.getURI(), eARModule.getAltDD(), eARModule.getModuleType());
        editableDeployableObject.setVirtualJarFile(eARModule.getVirtualJarFile());
        if (eARModule.getRootBean() != null) {
            editableDeployableObject.setRootBean(eARModule.getRootBean());
        }
        String[] stringArray = eARModule.getDescriptorUris();
        for (int i = 0; i < stringArray.length; ++i) {
            object = eARModule.getRootBean(stringArray[i]);
            if (object == null) continue;
            if (debug) {
                this.say("Adding URI " + stringArray[i]);
            }
            editableDeployableObject.addRootBean(stringArray[i], (DescriptorBean)object, eARModule.getModuleType());
        }
        editableDeployableObject.setClassLoader(eARModule.getModuleClassLoader());
        if (eARModule.getResourceFinder() != null) {
            editableDeployableObject.setResourceFinder(eARModule.getResourceFinder());
        }
        if (eARModule instanceof WARModule) {
            String string = ((WARModule)eARModule).getContextRoot();
            editableDeployableObject.setContextRoot(string);
            object = ((WARModule)eARModule).getCustomModuleManager();
            if (object != null) {
                stringArray = ((CustomModuleManager)object).getDescriptorUris();
                for (int i = 0; i < stringArray.length; ++i) {
                    DescriptorBean descriptorBean = ((CustomModuleManager)object).getRootBean(stringArray[i]);
                    editableDeployableObject.addRootBean(stringArray[i], descriptorBean, WebLogicModuleType.CONFIG);
                }
            }
        }
        return editableDeployableObject;
    }
}

