/*
 * Decompiled with CFR 0.152.
 */
package weblogic.application.compiler.flow;

import java.io.File;
import java.io.IOException;
import weblogic.application.compiler.AppcUtils;
import weblogic.application.compiler.CompilerCtx;
import weblogic.application.compiler.flow.CompilerFlow;
import weblogic.j2ee.J2EEApplicationService;
import weblogic.j2ee.J2EELogger;
import weblogic.kernel.Kernel;
import weblogic.logging.Loggable;
import weblogic.utils.Getopt2;
import weblogic.utils.application.WarDetector;
import weblogic.utils.compiler.ToolFailureException;

public final class PrepareInputFlow
extends CompilerFlow {
    private File sourceFile;
    private boolean verbose;
    private Getopt2 opts;

    public PrepareInputFlow(CompilerCtx compilerCtx) {
        super(compilerCtx);
    }

    public void compile() throws ToolFailureException {
        this.opts = this.ctx.getOpts();
        this.prepareInput(this.ctx);
    }

    public void cleanup() {
        this.ctx.getApplicationContext().getAppClassLoader().close();
    }

    private void prepareInput(CompilerCtx compilerCtx) throws ToolFailureException {
        String string;
        if (this.opts.args().length > 1) {
            this.opts.usageError("weblogic.appc");
            Loggable loggable = J2EELogger.logTooManyArgsForAppcLoggable();
            throw new ToolFailureException(loggable.getMessage());
        }
        this.verbose = this.opts.hasOption("verbose");
        compilerCtx.setVerbose(this.verbose);
        if (this.opts.hasOption("readonly")) {
            compilerCtx.setReadOnlyInvocation();
        }
        String string2 = this.getSourceFileName(this.opts);
        try {
            this.sourceFile = new File(string2).getCanonicalFile();
        }
        catch (IOException iOException) {
            throw new ToolFailureException("Error processing source " + string2, (Throwable)iOException);
        }
        compilerCtx.setSourceFile(this.sourceFile);
        if (this.opts.hasOption("lightweight")) {
            compilerCtx.setLightWeightAppName(this.opts.getOption("lightweight"));
        }
        compilerCtx.createApplicationContext();
        if (!this.sourceFile.exists()) {
            Loggable loggable = J2EELogger.logAppcSourceArgDoesNotExistLoggable((String)string2);
            throw new ToolFailureException(loggable.getMessage());
        }
        if (this.opts.hasOption("jsps") && this.opts.getBooleanOption("compileAllTagFiles")) {
            throw new ToolFailureException("jsps & compileAllTagFiles flags cannot be used together with Appc");
        }
        if (this.opts.hasOption("jsps") && this.opts.getOption("jsps").indexOf(42) >= 0 && !"*".equals(this.opts.getOption("jsps")) && !"\"*\"".equals(this.opts.getOption("jsps")) && !"'*'".equals(this.opts.getOption("jsps"))) {
            throw new ToolFailureException("Unsupported wildcard pattern was passed to -jsps");
        }
        if (this.opts.hasOption("compiler") && !"javac".equals(this.opts.getOption("compiler")) && !"jdt".equals(this.opts.getOption("compiler")) && !"none".equals(this.opts.getOption("compiler"))) {
            throw new ToolFailureException("-compiler only supports javac, jdt and none");
        }
        this.prepareOutputFiles(this.opts, compilerCtx);
        if (this.opts.hasOption("classpath")) {
            string = this.opts.getOption("classpath");
            compilerCtx.setClasspathArg(string);
        }
        if (this.opts.hasOption("plan")) {
            string = this.opts.getOption("plan");
            compilerCtx.setPlanName(string);
            File file = new File(string);
            compilerCtx.setPlanFile(file);
            if (!file.exists() || !file.isFile()) {
                if (this.opts.hasOption("ignorePlanValidation")) {
                    compilerCtx.setPlanName(null);
                    compilerCtx.setPlanFile(null);
                    System.out.println("Warning: The plan file " + string + " doesn't exist, ignore it");
                } else {
                    Loggable loggable = J2EELogger.logAppcPlanArgDoesNotExistLoggable((String)string);
                    throw new ToolFailureException(loggable.getMessage());
                }
            }
            if (!string.endsWith(".xml") && compilerCtx.getPlanName() != null) {
                Loggable loggable = J2EELogger.logAppcPlanArgWrongTypeLoggable();
                throw new ToolFailureException(loggable.getMessage());
            }
        }
        if (this.opts.hasOption("readonly") && this.opts.hasOption("writeInferredDescriptors")) {
            throw new ToolFailureException("readonly & writeInferredDescriptors flags cannot be used together with AppMerge");
        }
        if (this.opts.hasOption("ignoreMissingLibRefs")) {
            compilerCtx.setVerifyLibraryReferences(false);
        }
        if (this.opts.hasOption("writeInferredDescriptors")) {
            compilerCtx.setWriteInferredDescriptors();
        }
        if (this.opts.hasOption("manifest")) {
            compilerCtx.setManifestFile(new File(this.opts.getOption("manifest")));
        }
    }

    private String getSourceFileName(Getopt2 getopt2) {
        String[] stringArray = getopt2.args();
        return stringArray[0];
    }

    private void prepareOutputFiles(Getopt2 getopt2, CompilerCtx compilerCtx) throws ToolFailureException {
        Object object;
        String string = this.sourceFile.getPath();
        boolean bl = this.sourceFile.isFile();
        boolean bl2 = getopt2.hasOption("output");
        boolean bl3 = getopt2.hasOption("d");
        if (bl2 || bl3) {
            string = bl2 ? getopt2.getOption("output") : getopt2.getOption("d");
            if (new File(string).exists()) {
                J2EELogger.logOutputLocationExists((String)string);
            }
            bl = ((String)(object = string.toLowerCase())).endsWith(".jar") || WarDetector.instance.suffixed((String)object) || ((String)object).endsWith(".rar") || ((String)object).endsWith(".ear");
            if (compilerCtx.getOpts().hasOption("nopackage")) {
                bl = false;
            }
            if ((getopt2.hasOption("jsps") || getopt2.hasOption("moduleUri")) && !bl) {
                compilerCtx.setPartialOutputTarget(string);
            }
        }
        object = null;
        if (bl) {
            File file = null;
            file = Kernel.isServer() ? J2EEApplicationService.getTempDir() : new File(System.getProperty("java.io.tmpdir"));
            object = AppcUtils.makeOutputDir(compilerCtx.getTempDir().getName() + "_" + this.sourceFile.getName(), file, true);
            if (this.verbose) {
                this.say("Created working directory: " + object);
            }
        } else {
            object = compilerCtx.getPartialOutputTarget() != null && this.sourceFile.isDirectory() ? this.sourceFile : (compilerCtx.isReadOnlyInvocation() ? new File(string) : AppcUtils.makeOutputDir(string, null, false));
        }
        compilerCtx.setOutputDir((File)object);
        compilerCtx.setTargetArchive(bl ? string : null);
    }
}

