/*
 * Decompiled with CFR 0.152.
 */
package weblogic.application.compiler.flow;

import java.io.File;
import java.io.IOException;
import weblogic.application.compiler.BuildtimeApplicationContext;
import weblogic.application.compiler.CompilerCtx;
import weblogic.application.compiler.EARModule;
import weblogic.application.compiler.LibraryModule;
import weblogic.application.compiler.flow.CompilerFlow;
import weblogic.j2ee.J2EEApplicationService;
import weblogic.j2ee.J2EELogger;
import weblogic.utils.compiler.ToolFailureException;
import weblogic.utils.jars.VirtualJarFactory;
import weblogic.utils.jars.VirtualJarFile;

public final class PrepareModulesFlow
extends CompilerFlow {
    private final BuildtimeApplicationContext libCtx;

    public PrepareModulesFlow(CompilerCtx compilerCtx) {
        super(compilerCtx);
        this.libCtx = (BuildtimeApplicationContext)compilerCtx.getApplicationContext();
    }

    public void compile() throws ToolFailureException {
        this.prepareModules(this.ctx.getModules());
    }

    private void prepareModules(EARModule[] eARModuleArray) throws ToolFailureException {
        for (int i = 0; i < eARModuleArray.length; ++i) {
            if (this.libCtx.isLibraryURI(eARModuleArray[i].getURI())) {
                eARModuleArray[i] = new LibraryModule(eARModuleArray[i]);
            }
            this.setAltDDFile(eARModuleArray[i]);
            this.prepareModule(eARModuleArray[i]);
        }
    }

    private void setAltDDFile(EARModule eARModule) throws ToolFailureException {
        File file = null;
        String string = eARModule.getAltDD();
        if (string != null && (file = J2EEApplicationService.getAltDDFile(string, this.ctx.getVSource())) == null) {
            throw new ToolFailureException(J2EELogger.logAppcMissingModuleAltDDFileLoggable((String)eARModule.getAltDD(), (String)eARModule.getURI()).getMessage());
        }
        eARModule.setAltDDFile(file);
    }

    private void prepareModule(EARModule eARModule) throws ToolFailureException {
        String string = eARModule.getURI();
        File file = new File(this.ctx.getOutputDir(), string);
        if (!file.exists()) {
            if (eARModule.isSplitDir(this.ctx)) {
                file = this.ctx.getEar().getModuleRoots(string)[0];
            }
            if (!file.exists() && this.libCtx.isLibraryURI(string)) {
                file = this.libCtx.getURILink(string);
            }
        }
        if (!file.exists()) {
            throw new ToolFailureException(J2EELogger.logAppcCantFindDeclaredModuleLoggable((String)string).getMessage());
        }
        VirtualJarFile virtualJarFile = null;
        if (!file.getPath().endsWith(".xml")) {
            try {
                File[] fileArray = this.ctx.getEar().getModuleRoots(string);
                virtualJarFile = fileArray.length > 1 && !fileArray[0].isDirectory() ? VirtualJarFactory.createVirtualJar((File)fileArray[0]) : VirtualJarFactory.createVirtualJar((File[])fileArray);
                if (fileArray.length == 1) {
                    eARModule.setArchive(fileArray[0].isFile());
                } else {
                    eARModule.setArchive(false);
                }
            }
            catch (IOException iOException) {
                throw new ToolFailureException(J2EELogger.logAppcErrorAccessingFileLoggable((String)string, (String)iOException.toString()).getMessage(), (Throwable)iOException);
            }
            eARModule.setVirtualJarFile(virtualJarFile);
        } else {
            eARModule.setArchive(false);
        }
        eARModule.setOutputDir(file);
        eARModule.setOutputFileName(file.getPath());
    }

    public void cleanup() {
    }
}

