/*
 * Decompiled with CFR 0.152.
 */
package weblogic.application.compiler.flow;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.zip.ZipEntry;
import javax.enterprise.deploy.model.DeployableObject;
import javax.enterprise.deploy.model.J2eeApplicationObject;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import weblogic.application.compiler.CompilerCtx;
import weblogic.application.compiler.flow.ModuleViewerFlow;
import weblogic.deploy.api.model.EditableDeployableObject;
import weblogic.deploy.api.model.WebLogicDeployableObjectFactory;
import weblogic.deploy.api.model.sca.EditableScaApplicationObject;
import weblogic.deploy.api.shared.WebLogicModuleType;
import weblogic.descriptor.DescriptorBean;
import weblogic.descriptor.DescriptorManager;
import weblogic.sca.descriptor.ComponentBean;
import weblogic.sca.descriptor.CompositeBean;
import weblogic.sca.descriptor.ScaContributionBean;
import weblogic.utils.compiler.ToolFailureException;
import weblogic.utils.jars.VirtualJarFile;

public class SCACompositeViewerFlow
extends ModuleViewerFlow {
    private static final String SCA_CONTRIBUTION_URI = "META-INF/sca-contribution.xml";

    public SCACompositeViewerFlow(CompilerCtx compilerCtx) {
        super(compilerCtx);
    }

    public void compile() throws ToolFailureException {
        VirtualJarFile virtualJarFile = this.ctx.getVSource();
        ScaContributionBean scaContributionBean = this.parseSCAComposite(virtualJarFile);
        WebLogicDeployableObjectFactory webLogicDeployableObjectFactory = this.ctx.getObjectFactory();
        if (webLogicDeployableObjectFactory != null) {
            EditableScaApplicationObject editableScaApplicationObject;
            ArrayList<EditableDeployableObject> arrayList = new ArrayList<EditableDeployableObject>();
            try {
                editableScaApplicationObject = webLogicDeployableObjectFactory.createScaApplicationObject();
                for (CompositeBean compositeBean : scaContributionBean.getComposites()) {
                    for (ComponentBean componentBean : compositeBean.getComponents()) {
                        String string = compositeBean.getName() + "/" + componentBean.getName();
                        EditableDeployableObject editableDeployableObject = webLogicDeployableObjectFactory.createDeployableObject(string, null, WebLogicModuleType.SCA_JAVA);
                        arrayList.add(editableDeployableObject);
                    }
                }
                J2eeApplicationObject j2eeApplicationObject = (J2eeApplicationObject)this.ctx.getDeployableApplication();
                if (j2eeApplicationObject != null) {
                    for (DeployableObject deployableObject : j2eeApplicationObject.getDeployableObjects()) {
                        arrayList.add((EditableDeployableObject)deployableObject);
                    }
                }
            }
            catch (IOException iOException) {
                throw new ToolFailureException("Unable to create deployable object", (Throwable)iOException);
            }
            try {
                editableScaApplicationObject.setVirtualJarFile(this.ctx.getVSource());
                editableScaApplicationObject.setRootBean((DescriptorBean)scaContributionBean);
                editableScaApplicationObject.addRootBean(SCA_CONTRIBUTION_URI, (DescriptorBean)scaContributionBean, null);
                this.ctx.setDeployableApplication(editableScaApplicationObject);
                for (EditableDeployableObject editableDeployableObject : arrayList) {
                    editableScaApplicationObject.addDeployableObject(editableDeployableObject);
                }
            }
            catch (Exception exception) {
                throw new ToolFailureException("Unable to create Application Object", (Throwable)exception);
            }
        }
    }

    public void cleanup() {
    }

    private ScaContributionBean parseSCAComposite(VirtualJarFile virtualJarFile) throws ToolFailureException {
        try {
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            ZipEntry zipEntry = virtualJarFile.getEntry(SCA_CONTRIBUTION_URI);
            if (zipEntry == null) {
                throw new IllegalArgumentException("no META-INF/sca-contribution.xml");
            }
            ContributionHandler contributionHandler = new ContributionHandler();
            sAXParser.parse(virtualJarFile.getInputStream(zipEntry), (DefaultHandler)contributionHandler);
            ScaContributionBean scaContributionBean = this.createScaContributionBean();
            Object object = virtualJarFile.entries();
            while (object.hasNext()) {
                CompositeBean[] compositeBeanArray = (CompositeBean[])object.next();
                if (!compositeBeanArray.getName().matches("META-INF/.*[.]composite")) continue;
                CompositeHandler compositeHandler = new CompositeHandler(scaContributionBean.createComposite());
                sAXParser.parse(virtualJarFile.getInputStream((ZipEntry)compositeBeanArray), (DefaultHandler)compositeHandler);
            }
            object = contributionHandler.getDeployables();
            for (CompositeBean compositeBean : scaContributionBean.getComposites()) {
                if (object.contains(compositeBean.getName())) continue;
                scaContributionBean.destroyComposite(compositeBean);
            }
            return scaContributionBean;
        }
        catch (IOException iOException) {
            throw new ToolFailureException("Error parsing SCA descriptors", (Throwable)iOException);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new ToolFailureException("Error parsing SCA descriptors", (Throwable)parserConfigurationException);
        }
        catch (SAXException sAXException) {
            throw new ToolFailureException("Error parsing SCA descriptors", (Throwable)sAXException);
        }
    }

    private ScaContributionBean createScaContributionBean() {
        DescriptorManager descriptorManager = new DescriptorManager();
        return (ScaContributionBean)descriptorManager.createDescriptorRoot(ScaContributionBean.class).getRootBean();
    }

    private static class CompositeHandler
    extends DefaultHandler {
        private final CompositeBean composite;
        private ComponentBean current;

        public CompositeHandler(CompositeBean compositeBean) {
            this.composite = compositeBean;
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            if (this.current == null) {
                if (string3.equals("component")) {
                    this.current = this.composite.createComponent();
                    this.current.setName(attributes.getValue("name"));
                } else if (string3.equals("composite")) {
                    this.composite.setName(attributes.getValue("name"));
                }
            } else if (string3.startsWith("implementation.")) {
                this.current.setImplementationType(string3);
            }
        }

        public void endElement(String string, String string2, String string3) throws SAXException {
            if (string3.equals("component")) {
                this.current = null;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ContributionHandler
    extends DefaultHandler {
        HashSet<String> deployables = new HashSet();

        private ContributionHandler() {
        }

        public Set<String> getDeployables() {
            return this.deployables;
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            if (string3.equals("deployable")) {
                this.deployables.add(attributes.getValue("composite"));
            }
        }
    }
}

