/*
 * Decompiled with CFR 0.152.
 */
package weblogic.application.compiler.flow;

import java.io.File;
import weblogic.application.compiler.CompilerCtx;
import weblogic.application.compiler.flow.CompilerFlow;
import weblogic.j2ee.J2EEApplicationService;
import weblogic.kernel.Kernel;
import weblogic.utils.FileUtils;
import weblogic.utils.compiler.ToolFailureException;

public class SetupFlow
extends CompilerFlow {
    private static final boolean KEEP_TEMP_FILES = Boolean.getBoolean("weblogic.application.compiler.KeepTempFilesOnExit");
    private String tempDirName;

    public SetupFlow(CompilerCtx compilerCtx, String string) {
        super(compilerCtx);
        this.tempDirName = string;
    }

    public void cleanup() throws ToolFailureException {
        if (KEEP_TEMP_FILES) {
            return;
        }
        if (this.ctx.getOutputDir() != null && this.ctx.getTempDir() != null && this.ctx.getOutputDir().getName().startsWith(this.ctx.getTempDir().getName() + "_")) {
            FileUtils.remove((File)this.ctx.getOutputDir());
            this.ctx.setOutputDir(null);
        }
        FileUtils.remove((File)this.ctx.getTempDir());
        this.ctx.setTempDir(null);
    }

    public void compile() throws ToolFailureException {
        File file = null;
        file = Kernel.isServer() ? new File(J2EEApplicationService.getTempDir(), this.tempDirName) : new File(System.getProperty("java.io.tmpdir"), this.tempDirName);
        if (file.exists() && !file.isDirectory()) {
            file.delete();
        }
        file.mkdirs();
        this.ctx.setTempDir(file);
    }
}

