/*
 * Decompiled with CFR 0.152.
 */
package weblogic.application.compiler.flow;

import java.io.File;
import java.io.IOException;
import weblogic.application.SingleModuleFileManager;
import weblogic.application.compiler.CompilerCtx;
import weblogic.application.compiler.EARModule;
import weblogic.application.compiler.ToolsFactoryManager;
import weblogic.application.compiler.flow.CompilerFlow;
import weblogic.deploy.api.shared.WebLogicModuleType;
import weblogic.utils.compiler.ToolFailureException;
import weblogic.utils.jars.JarFileUtils;
import weblogic.utils.jars.VirtualJarFactory;
import weblogic.utils.jars.VirtualJarFile;

public abstract class SingleModuleFlow
extends CompilerFlow {
    public SingleModuleFlow(CompilerCtx compilerCtx) {
        super(compilerCtx);
    }

    public void compile() throws ToolFailureException {
        File file = this.ctx.getSourceFile();
        if (this.ctx.getApplicationContext().getApplicationFileManager() == null) {
            this.ctx.getApplicationContext().setApplicationFileManager(new SingleModuleFileManager(file));
        }
        EARModule eARModule = ToolsFactoryManager.createStandaloneModule(this.ctx, file);
        this.prepareModule(eARModule);
        if (file != null) {
            this.ctx.setModules(new EARModule[]{eARModule});
            eARModule.initModuleClassLoader(this.ctx, this.ctx.getApplicationContext().getAppClassLoader());
            this.proecessModule(eARModule);
        }
    }

    private void prepareModule(EARModule eARModule) throws ToolFailureException {
        try {
            if (eARModule != null && (eARModule.getModuleType().equals((Object)WebLogicModuleType.JMS) || eARModule.getModuleType().equals((Object)WebLogicModuleType.JDBC))) {
                eARModule.setArchive(false);
                eARModule.setOutputDir(this.ctx.getOutputDir());
                eARModule.setOutputFileName(this.ctx.getSourceFile().getPath());
                return;
            }
            VirtualJarFile virtualJarFile = VirtualJarFactory.createVirtualJar((File)this.ctx.getSourceFile());
            eARModule.setVirtualJarFile(virtualJarFile);
            eARModule.setArchive(this.ctx.getSourceFile().isFile());
            eARModule.setOutputDir(this.ctx.getOutputDir());
            eARModule.setOutputFileName(this.ctx.getOutputDir().getPath());
            if (!this.ctx.getSourceFile().equals(this.ctx.getOutputDir())) {
                JarFileUtils.extract((VirtualJarFile)virtualJarFile, (File)this.ctx.getOutputDir());
            }
        }
        catch (IOException iOException) {
            throw new ToolFailureException(iOException.getMessage(), (Throwable)iOException);
        }
    }

    public void cleanup() {
        EARModule[] eARModuleArray = this.ctx.getModules();
        if (eARModuleArray.length != 1) {
            throw new AssertionError((Object)"SingleModuleMergerFlow can be invoked for standalone modules only");
        }
        eARModuleArray[0].cleanup();
    }

    protected abstract void proecessModule(EARModule var1) throws ToolFailureException;
}

