/*
 * Decompiled with CFR 0.152.
 */
package weblogic.application.compiler.flow;

import java.io.IOException;
import javax.xml.stream.XMLStreamException;
import weblogic.application.ApplicationDescriptor;
import weblogic.application.compiler.CompilerCtx;
import weblogic.application.compiler.flow.WriteInferredDescriptorFlow;
import weblogic.j2ee.descriptor.wl.LibraryRefBean;
import weblogic.j2ee.descriptor.wl.WeblogicApplicationBean;
import weblogic.utils.compiler.ToolFailureException;

public final class WriteDescriptorsFlow
extends WriteInferredDescriptorFlow {
    public WriteDescriptorsFlow(CompilerCtx compilerCtx) {
        super(compilerCtx);
    }

    public void compile() throws ToolFailureException {
        this.removeLibRefs();
        this.writeDescriptors();
        super.compile();
    }

    public void cleanup() {
    }

    private void removeLibRefs() throws ToolFailureException {
        if (this.ctx.getWLApplicationDD() == null || this.ctx.getWLApplicationDD().getLibraryRefs() == null) {
            return;
        }
        WeblogicApplicationBean weblogicApplicationBean = this.ctx.getWLApplicationDD();
        LibraryRefBean[] libraryRefBeanArray = this.ctx.getWLApplicationDD().getLibraryRefs();
        for (int i = 0; i < libraryRefBeanArray.length; ++i) {
            weblogicApplicationBean.destroyLibraryRef(libraryRefBeanArray[i]);
        }
    }

    private void writeDescriptors() throws ToolFailureException {
        try {
            ApplicationDescriptor applicationDescriptor = this.ctx.getApplicationDescriptor();
            if (applicationDescriptor != null) {
                applicationDescriptor.writeDescriptors(this.ctx.getOutputDir());
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        catch (XMLStreamException xMLStreamException) {
            throw new RuntimeException(xMLStreamException);
        }
    }
}

