/*
 * Decompiled with CFR 0.152.
 */
package weblogic.application.config;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import javax.enterprise.deploy.shared.ModuleType;
import javax.xml.stream.XMLStreamException;
import weblogic.application.ApplicationContextInternal;
import weblogic.application.ModuleException;
import weblogic.application.config.ConfigDescriptorManagerCache;
import weblogic.application.descriptor.AbstractDescriptorLoader2;
import weblogic.application.utils.IOUtils;
import weblogic.application.utils.LibraryUtils;
import weblogic.descriptor.DescriptorBean;
import weblogic.descriptor.DescriptorManager;
import weblogic.j2ee.descriptor.wl.DeploymentPlanBean;
import weblogic.utils.Debug;
import weblogic.utils.classloaders.ClassFinder;
import weblogic.utils.classloaders.ClasspathClassFinder2;
import weblogic.utils.classloaders.GenericClassLoader;
import weblogic.utils.jars.VirtualJarFile;

class ConfigDescriptorManager {
    private ApplicationContextInternal applicationContext;
    private boolean debug;
    private String appModuleName;
    private GenericClassLoader bindingClassLoader;
    private boolean useBindingCache = false;

    public ConfigDescriptorManager(ApplicationContextInternal applicationContextInternal, String string, boolean bl) {
        this.applicationContext = applicationContextInternal;
        this.debug = bl;
        this.appModuleName = string;
    }

    public void initBindingInfo(GenericClassLoader genericClassLoader, String string, boolean bl) throws ModuleException {
        this.bindingClassLoader = genericClassLoader;
        this.useBindingCache = bl;
        if (string != null) {
            URL uRL = this.bindingClassLoader.getResource(string);
            if (uRL == null) {
                throw new ModuleException("Unable to load " + string + " for module");
            }
            this.bindingClassLoader.addClassFinder((ClassFinder)new ClasspathClassFinder2(uRL.getPath()));
        }
    }

    public void destroy() {
        if (this.useBindingCache) {
            ConfigDescriptorManagerCache.SINGLETON.removeEntry(this.bindingClassLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DescriptorBean parseMergedDescriptorBean(File file, DeploymentPlanBean deploymentPlanBean, String string, String string2, ModuleType moduleType, String string3, boolean bl, boolean bl2) throws XMLStreamException, IOException, ModuleException {
        VirtualJarFile[] virtualJarFileArray;
        String string4;
        VirtualJarFile virtualJarFile;
        if (moduleType == ModuleType.EAR) {
            virtualJarFile = this.applicationContext.getApplicationFileManager().getVirtualJarFile();
            string4 = this.applicationContext.getApplicationFileName();
        } else {
            virtualJarFile = this.applicationContext.getApplicationFileManager().getVirtualJarFile(string3);
            string4 = string3;
        }
        AbstractDescriptorLoader2 abstractDescriptorLoader2 = new AbstractDescriptorLoader2(virtualJarFile, file, deploymentPlanBean, string4, string);
        DescriptorManager descriptorManager = this.useBindingCache ? ConfigDescriptorManagerCache.SINGLETON.getEntry(this.bindingClassLoader) : new DescriptorManager((ClassLoader)this.bindingClassLoader);
        abstractDescriptorLoader2.setDescriptorManager(descriptorManager);
        if (bl) {
            block10: {
                DescriptorBean descriptorBean;
                virtualJarFileArray = null;
                try {
                    virtualJarFileArray = LibraryUtils.getLibraryVjarsWithDescriptor(this.applicationContext, string2, string);
                    if (virtualJarFileArray.length <= 0) break block10;
                    DescriptorBean descriptorBean2 = abstractDescriptorLoader2.mergeDescriptors(virtualJarFileArray);
                    if (this.debug) {
                        Debug.say((String)("loaded descriptor and libs to bean: " + descriptorBean2));
                    }
                    if (descriptorBean2 == null && !bl2) {
                        throw new ModuleException("Descriptor not found: " + string + " for app module " + this.appModuleName);
                    }
                    descriptorBean = descriptorBean2;
                    Object var17_16 = null;
                }
                catch (Throwable throwable) {
                    Object var17_18 = null;
                    IOUtils.forceClose(virtualJarFileArray);
                    throw throwable;
                }
                IOUtils.forceClose(virtualJarFileArray);
                return descriptorBean;
            }
            Object var17_17 = null;
            IOUtils.forceClose(virtualJarFileArray);
            {
            }
        }
        virtualJarFileArray = abstractDescriptorLoader2.loadDescriptorBean();
        if (this.debug) {
            Debug.say((String)("loaded descriptor to bean: " + virtualJarFileArray));
        }
        if (virtualJarFileArray == null && !bl2) {
            throw new ModuleException("Descriptor not found: " + string + " for app module " + this.appModuleName);
        }
        return virtualJarFileArray;
    }
}

