/*
 * Decompiled with CFR 0.152.
 */
package weblogic.application.config;

import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.WeakHashMap;
import weblogic.application.ModuleException;
import weblogic.descriptor.DescriptorManager;
import weblogic.utils.Debug;
import weblogic.utils.classloaders.GenericClassLoader;

public final class ConfigDescriptorManagerCache {
    private final boolean debug = Debug.getCategory((String)"weblogic.application.config.ConfigDescriptorManagerCache").isEnabled();
    private volatile Map _cache = new WeakHashMap();
    public static final ConfigDescriptorManagerCache SINGLETON = new ConfigDescriptorManagerCache();

    private ConfigDescriptorManagerCache() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DescriptorManager getEntry(GenericClassLoader genericClassLoader) throws ModuleException {
        Map map = this._cache;
        synchronized (map) {
            WeakReference weakReference = (WeakReference)this._cache.get(genericClassLoader);
            DescriptorManager descriptorManager = null;
            if (weakReference != null) {
                descriptorManager = (DescriptorManager)weakReference.get();
            }
            if (descriptorManager == null) {
                descriptorManager = new DescriptorManager((ClassLoader)genericClassLoader);
                this._cache.put(genericClassLoader, new WeakReference<DescriptorManager>(descriptorManager));
                if (this.debug) {
                    Debug.say((String)("Creating entry using key " + genericClassLoader + ". New size: " + this._cache.size()));
                }
            } else if (this.debug) {
                Debug.say((String)("Got existing entry using key " + genericClassLoader + ". Current size: " + this._cache.size()));
            }
            return descriptorManager;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEntry(GenericClassLoader genericClassLoader) {
        Map map = this._cache;
        synchronized (map) {
            WeakReference weakReference = (WeakReference)this._cache.remove(genericClassLoader);
            if (this.debug) {
                DescriptorManager descriptorManager = null;
                if (weakReference != null) {
                    descriptorManager = (DescriptorManager)weakReference.get();
                }
                if (descriptorManager != null) {
                    Debug.say((String)("Removing entry for key " + genericClassLoader + ". New size: " + this._cache.size()));
                } else {
                    Debug.say((String)("Trying to remove non-existant entry for " + genericClassLoader + ". Current size: " + this._cache.size()));
                }
            }
        }
    }
}

