/*
 * Decompiled with CFR 0.152.
 */
package weblogic.application.config;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import weblogic.application.AdminModeCompletionBarrier;
import weblogic.application.ApplicationContext;
import weblogic.application.ApplicationContextInternal;
import weblogic.application.Module;
import weblogic.application.ModuleException;
import weblogic.application.UpdateListener;
import weblogic.deploy.api.shared.WebLogicModuleType;
import weblogic.descriptor.Descriptor;
import weblogic.descriptor.DescriptorBean;
import weblogic.descriptor.DescriptorManager;
import weblogic.descriptor.DescriptorUpdateFailedException;
import weblogic.descriptor.DescriptorUpdateRejectedException;
import weblogic.descriptor.DescriptorValidateException;
import weblogic.j2ee.descriptor.wl.ConfigurationSupportBean;
import weblogic.j2ee.descriptor.wl.CustomModuleBean;
import weblogic.j2ee.descriptor.wl.ModuleProviderBean;
import weblogic.management.runtime.ComponentRuntimeMBean;
import weblogic.utils.classloaders.GenericClassLoader;
import weblogic.utils.jars.VirtualJarFile;

public abstract class ConfigModule
implements Module,
UpdateListener {
    private static boolean VERBOSE = false;
    private final ModuleProviderBean provider;
    private final String uri;
    private final String descriptorURI;
    private DescriptorManager manager;
    private Descriptor currentDescriptor;
    private ApplicationContextInternal appCtx;

    public ConfigModule(ModuleProviderBean moduleProviderBean, CustomModuleBean customModuleBean) throws ModuleException {
        this.provider = moduleProviderBean;
        this.uri = customModuleBean.getUri();
        if (moduleProviderBean.getBindingJarUri() == null) {
            throw new ModuleException("Your module-provider needs to specify a binding-jar-uri in its weblogic-extension.xml");
        }
        ConfigurationSupportBean configurationSupportBean = customModuleBean.getConfigurationSupport();
        if (configurationSupportBean == null) {
            throw new ModuleException("Your config module must include configuration-support in the weblogic-extension.xml.");
        }
        this.descriptorURI = configurationSupportBean.getBaseUri();
    }

    public String getId() {
        return this.uri;
    }

    public String getType() {
        return WebLogicModuleType.MODULETYPE_CONFIG;
    }

    public boolean acceptURI(String string) {
        return this.descriptorURI.equals(string);
    }

    public DescriptorBean[] getDescriptors() {
        return new DescriptorBean[]{this.currentDescriptor.getRootBean()};
    }

    public ComponentRuntimeMBean[] getComponentRuntimeMBeans() {
        return new ComponentRuntimeMBean[0];
    }

    public GenericClassLoader init(ApplicationContext applicationContext, GenericClassLoader genericClassLoader, UpdateListener.Registration registration) {
        this.appCtx = (ApplicationContextInternal)applicationContext;
        registration.addUpdateListener(this);
        return genericClassLoader;
    }

    public void initUsingLoader(ApplicationContext applicationContext, GenericClassLoader genericClassLoader, UpdateListener.Registration registration) {
        this.init(applicationContext, genericClassLoader, registration);
    }

    private InputStream findResource(VirtualJarFile virtualJarFile, String string) throws IOException {
        ZipEntry zipEntry = virtualJarFile.getEntry(string);
        return zipEntry == null ? null : virtualJarFile.getInputStream(zipEntry);
    }

    protected InputStream findResource(String string) throws IOException {
        VirtualJarFile virtualJarFile = null;
        try {
            virtualJarFile = this.appCtx.getApplicationFileManager().getVirtualJarFile(this.uri);
        }
        catch (IOException iOException) {
            virtualJarFile = null;
        }
        if (virtualJarFile != null) {
            InputStream inputStream = this.findResource(virtualJarFile, string);
            if (inputStream != null) {
                return inputStream;
            }
            virtualJarFile.close();
        }
        virtualJarFile = this.appCtx.getApplicationFileManager().getVirtualJarFile();
        return this.findResource(virtualJarFile, string);
    }

    protected Descriptor parseDescriptor() throws ModuleException {
        InputStream inputStream = null;
        try {
            inputStream = this.findResource(this.descriptorURI);
            if (inputStream == null) {
                throw new ModuleException("Unable to find descriptor at " + this.descriptorURI);
            }
            Descriptor descriptor = this.manager.createDescriptor(inputStream);
            if (VERBOSE) {
                this.manager.writeDescriptorAsXML(descriptor, (OutputStream)System.out);
            }
            Descriptor descriptor2 = descriptor;
            return descriptor2;
        }
        catch (IOException iOException) {
            throw new ModuleException(iOException);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public void prepare() throws ModuleException {
        this.manager = new DescriptorManager(this.provider.getBindingJarUri());
        this.currentDescriptor = this.parseDescriptor();
        this.readDescriptor(this.currentDescriptor.getRootBean());
    }

    public void activate() throws ModuleException {
    }

    public void start() throws ModuleException {
    }

    public void deactivate() throws ModuleException {
    }

    public void unprepare() throws ModuleException {
    }

    public void destroy(UpdateListener.Registration registration) throws ModuleException {
        registration.removeUpdateListener(this);
    }

    public void prepareUpdate(String string) throws ModuleException {
        Descriptor descriptor = this.parseDescriptor();
        try {
            this.currentDescriptor.prepareUpdate(descriptor);
        }
        catch (DescriptorUpdateRejectedException descriptorUpdateRejectedException) {
            throw new ModuleException(descriptorUpdateRejectedException);
        }
        catch (DescriptorValidateException descriptorValidateException) {
            throw new ModuleException(descriptorValidateException);
        }
    }

    public void activateUpdate(String string) throws ModuleException {
        try {
            this.currentDescriptor.activateUpdate();
        }
        catch (DescriptorUpdateFailedException descriptorUpdateFailedException) {
            throw new ModuleException(descriptorUpdateFailedException);
        }
        finally {
            this.updatedDescriptor(this.currentDescriptor.getRootBean());
        }
    }

    public void rollbackUpdate(String string) {
        this.currentDescriptor.rollbackUpdate();
    }

    public void remove() throws ModuleException {
    }

    public void adminToProduction() {
    }

    public void gracefulProductionToAdmin(AdminModeCompletionBarrier adminModeCompletionBarrier) {
    }

    public void forceProductionToAdmin() {
    }

    public abstract void readDescriptor(DescriptorBean var1) throws ModuleException;

    public abstract void updatedDescriptor(DescriptorBean var1) throws ModuleException;
}

