/*
 * Decompiled with CFR 0.152.
 */
package weblogic.application.config;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.enterprise.deploy.shared.ModuleType;
import javax.xml.stream.XMLStreamException;
import weblogic.application.CustomModuleContext;
import weblogic.application.ModuleException;
import weblogic.application.compiler.CompilerCtx;
import weblogic.application.compiler.EARModule;
import weblogic.application.config.ConfigDescriptorManager;
import weblogic.application.utils.IOUtils;
import weblogic.deploy.api.shared.WebLogicModuleType;
import weblogic.descriptor.DescriptorBean;
import weblogic.descriptor.EditableDescriptorManager;
import weblogic.j2ee.descriptor.wl.CustomModuleBean;
import weblogic.utils.Debug;
import weblogic.utils.classloaders.ClassFinder;
import weblogic.utils.classloaders.GenericClassLoader;
import weblogic.utils.classloaders.NullClassFinder;
import weblogic.utils.compiler.ToolFailureException;

public class DefaultEARModule
extends EARModule {
    private ConfigDescriptorManager configDescManager;
    private DescriptorBean moduleDescriptorBean;
    CustomModuleContext customModuleContext;
    String descriptorUri;
    String parentModuleUri;
    String parentModuleId;
    String appModuleName;
    private final ModuleType parentModuleType;
    private GenericClassLoader parentClassLoader;
    private boolean useBindingCache = true;
    private final boolean ignoreMissingDescriptors;
    private static final boolean debug = Debug.getCategory((String)"weblogic.application.config.DefaultModule").isEnabled();

    public DefaultEARModule(CustomModuleContext customModuleContext, CustomModuleBean customModuleBean) throws ToolFailureException {
        this(customModuleContext, customModuleBean, false);
    }

    public DefaultEARModule(CustomModuleContext customModuleContext, CustomModuleBean customModuleBean, boolean bl) throws ToolFailureException {
        super(customModuleBean.getUri(), null);
        this.customModuleContext = customModuleContext;
        this.parentModuleUri = customModuleContext.getParentModuleUri();
        this.parentModuleId = customModuleContext.getParentModuleId();
        if (this.parentModuleUri != null) {
            this.parentModuleType = ModuleType.WAR;
            this.appModuleName = this.parentModuleUri;
        } else {
            this.parentModuleType = ModuleType.EAR;
        }
        if (customModuleBean.getConfigurationSupport() == null || customModuleBean.getConfigurationSupport().getBaseUri() == null) {
            throw new ToolFailureException("Unable to find base descriptor URI for config module " + this.appModuleName);
        }
        this.descriptorUri = customModuleBean.getConfigurationSupport().getBaseUri();
        this.ignoreMissingDescriptors = bl;
    }

    public void compile(GenericClassLoader genericClassLoader, CompilerCtx compilerCtx) throws ToolFailureException {
    }

    public ClassFinder getClassFinder() {
        return NullClassFinder.NULL_FINDER;
    }

    public void initModuleClassLoader(CompilerCtx compilerCtx, GenericClassLoader genericClassLoader) throws ToolFailureException {
        try {
            this.configDescManager = new ConfigDescriptorManager(compilerCtx.getApplicationContext(), this.appModuleName, debug);
            this.configDescManager.initBindingInfo(genericClassLoader, this.customModuleContext.getModuleProviderBean().getBindingJarUri(), this.useBindingCache);
            this.parentClassLoader = genericClassLoader;
        }
        catch (ModuleException moduleException) {
            throw new ToolFailureException("Unable to init module classloader", (Throwable)((Object)moduleException));
        }
    }

    public GenericClassLoader getModuleClassLoader() {
        return this.parentClassLoader;
    }

    public void populateMVI(GenericClassLoader genericClassLoader, CompilerCtx compilerCtx) throws ToolFailureException {
    }

    public void writeDescriptors(CompilerCtx compilerCtx) throws ToolFailureException {
        try {
            if (this.moduleDescriptorBean != null && this.descriptorUri != null && this.parentClassLoader != null) {
                FileOutputStream fileOutputStream = new FileOutputStream(IOUtils.checkCreateParent(new File(this.getOutputDir(), this.descriptorUri)));
                new EditableDescriptorManager((ClassLoader)this.parentClassLoader).writeDescriptorAsXML(this.moduleDescriptorBean.getDescriptor(), (OutputStream)fileOutputStream);
                fileOutputStream.close();
            }
        }
        catch (IOException iOException) {
            throw new ToolFailureException("Unable to write custom module descriptors", (Throwable)iOException);
        }
    }

    public void merge(CompilerCtx compilerCtx) throws ToolFailureException {
        try {
            this.moduleDescriptorBean = this.configDescManager.parseMergedDescriptorBean(compilerCtx.getConfigDir(), compilerCtx.getPlanBean(), this.descriptorUri, this.parentModuleId, this.parentModuleType, this.parentModuleUri, true, this.ignoreMissingDescriptors);
            if (this.descriptorUri != null && this.moduleDescriptorBean != null) {
                this.addRootBean(this.descriptorUri, this.moduleDescriptorBean);
            }
        }
        catch (IOException iOException) {
            throw new ToolFailureException("Error reading descriptor: " + this.descriptorUri + " for app module " + this.appModuleName, (Throwable)iOException);
        }
        catch (XMLStreamException xMLStreamException) {
            throw new ToolFailureException("Error reading descriptor: " + this.descriptorUri + " for app module " + this.appModuleName, (Throwable)xMLStreamException);
        }
        catch (ModuleException moduleException) {
            throw new ToolFailureException("Error reading descriptor: " + this.descriptorUri + " for app module " + this.appModuleName, (Throwable)((Object)moduleException));
        }
    }

    public void cleanup() {
        super.cleanup();
        this.configDescManager.destroy();
    }

    public DescriptorBean getRootBean() {
        return this.getRootBean(this.descriptorUri);
    }

    public ModuleType getModuleType() {
        return WebLogicModuleType.CONFIG;
    }
}

