/*
 * Decompiled with CFR 0.152.
 */
package weblogic.application.config;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.enterprise.deploy.shared.ModuleType;
import javax.xml.stream.XMLStreamException;
import weblogic.application.AdminModeCompletionBarrier;
import weblogic.application.ApplicationAccess;
import weblogic.application.ApplicationContext;
import weblogic.application.ApplicationContextInternal;
import weblogic.application.CustomModuleContext;
import weblogic.application.MergedDescriptorModule;
import weblogic.application.Module;
import weblogic.application.ModuleException;
import weblogic.application.UpdateListener;
import weblogic.application.config.ConfigDescriptorManager;
import weblogic.application.config.ConfigModuleCallbackHandler;
import weblogic.application.config.CustomModuleLogger;
import weblogic.deploy.api.shared.WebLogicModuleType;
import weblogic.descriptor.DescriptorBean;
import weblogic.descriptor.DescriptorUpdateFailedException;
import weblogic.descriptor.DescriptorUpdateRejectedException;
import weblogic.j2ee.descriptor.wl.ConfigurationSupportBean;
import weblogic.j2ee.descriptor.wl.CustomModuleBean;
import weblogic.management.runtime.ComponentRuntimeMBean;
import weblogic.utils.Debug;
import weblogic.utils.classloaders.ClassFinder;
import weblogic.utils.classloaders.GenericClassLoader;

public final class DefaultModule
implements Module,
UpdateListener,
MergedDescriptorModule {
    private static final boolean debug = Debug.getCategory((String)"weblogic.application.config.DefaultModule").isEnabled();
    private final CustomModuleContext customModuleContext;
    private final String descriptorUri;
    private final String parentModuleUri;
    private final ModuleType parentModuleType;
    private ApplicationContextInternal applicationContext;
    private DescriptorBean descriptorBean;
    private String descriptorNamespace;
    private String appModuleName;
    private final ConfigModuleCallbackHandler callbackHandler;
    private final boolean failOnNonDynamicChanges;
    private final boolean mergeLibraryDescriptors;
    private String bindingJarUri;
    private ConfigDescriptorManager configDescManager;
    private boolean descriptorParsed = false;
    private boolean useBindingCache = true;

    public DefaultModule(CustomModuleContext customModuleContext, CustomModuleBean customModuleBean, ConfigModuleCallbackHandler configModuleCallbackHandler, String string, boolean bl, boolean bl2) {
        ConfigurationSupportBean configurationSupportBean;
        this.customModuleContext = customModuleContext;
        this.parentModuleUri = customModuleContext.getParentModuleUri();
        this.descriptorUri = customModuleBean.getUri();
        this.failOnNonDynamicChanges = bl;
        this.mergeLibraryDescriptors = bl2;
        this.callbackHandler = configModuleCallbackHandler;
        this.appModuleName = ApplicationAccess.getApplicationAccess().getCurrentApplicationName();
        if (this.parentModuleUri != null) {
            this.parentModuleType = ModuleType.WAR;
            this.appModuleName = this.appModuleName == null ? this.parentModuleUri : this.appModuleName + "/" + this.parentModuleUri;
        } else {
            this.parentModuleType = ModuleType.EAR;
        }
        if (debug) {
            Debug.say((String)(this.appModuleName + "/" + this.descriptorUri));
        }
        if ((configurationSupportBean = customModuleBean.getConfigurationSupport()) == null) {
            CustomModuleLogger.logNoConfigSupport((String)this.appModuleName, (String)this.descriptorUri);
        } else {
            if (!this.descriptorUri.equals(configurationSupportBean.getBaseUri())) {
                CustomModuleLogger.logConfigSupportUriMismatch((String)this.appModuleName, (String)this.descriptorUri, (String)configurationSupportBean.getBaseUri());
            }
            this.descriptorNamespace = string != null ? string : configurationSupportBean.getBaseNamespace();
        }
        this.bindingJarUri = customModuleContext.getModuleProviderBean().getBindingJarUri();
    }

    public String getId() {
        return this.descriptorUri;
    }

    public String getType() {
        return WebLogicModuleType.MODULETYPE_CONFIG;
    }

    public DescriptorBean[] getDescriptors() {
        DescriptorBean[] descriptorBeanArray;
        if (!this.descriptorParsed) {
            try {
                this.descriptorBean = this.parseDescriptorBean();
            }
            catch (ModuleException moduleException) {
                // empty catch block
            }
        }
        if (this.descriptorBean == null) {
            descriptorBeanArray = new DescriptorBean[]{};
        } else {
            DescriptorBean[] descriptorBeanArray2 = new DescriptorBean[1];
            descriptorBeanArray = descriptorBeanArray2;
            descriptorBeanArray2[0] = this.descriptorBean;
        }
        return descriptorBeanArray;
    }

    public ComponentRuntimeMBean[] getComponentRuntimeMBeans() {
        return new ComponentRuntimeMBean[0];
    }

    public GenericClassLoader init(ApplicationContext applicationContext, GenericClassLoader genericClassLoader, UpdateListener.Registration registration) throws ModuleException {
        this.applicationContext = (ApplicationContextInternal)applicationContext;
        this.appModuleName = this.applicationContext.getApplicationId();
        if (this.parentModuleUri != null) {
            this.appModuleName = this.appModuleName + "/" + this.parentModuleUri;
        }
        if (debug) {
            Debug.say((String)(this.appModuleName + "/" + this.descriptorUri));
        }
        registration.addUpdateListener(this);
        this.configDescManager = new ConfigDescriptorManager(this.applicationContext, this.appModuleName, debug);
        this.configDescManager.initBindingInfo(genericClassLoader, this.bindingJarUri, this.useBindingCache);
        return genericClassLoader;
    }

    public void initUsingLoader(ApplicationContext applicationContext, GenericClassLoader genericClassLoader, UpdateListener.Registration registration) throws ModuleException {
        if (debug) {
            Debug.say((String)(this.appModuleName + "/" + this.descriptorUri));
        }
        this.init(applicationContext, genericClassLoader, registration);
    }

    public void prepare() throws ModuleException {
        if (debug) {
            Debug.say((String)(this.appModuleName + "/" + this.descriptorUri));
        }
        CustomModuleLogger.logPrepareDeploy((String)this.appModuleName, (String)this.descriptorUri);
        this.descriptorBean = this.parseDescriptorBean();
        this.descriptorParsed = true;
        if (this.callbackHandler != null) {
            this.callbackHandler.prepare(this.descriptorUri, this.descriptorNamespace, this.descriptorBean);
        }
    }

    public void activate() throws ModuleException {
        if (debug) {
            Debug.say((String)(this.appModuleName + "/" + this.descriptorUri));
        }
        if (this.callbackHandler != null) {
            this.callbackHandler.activate(this.descriptorUri, this.descriptorNamespace, this.descriptorBean);
        }
    }

    public void start() {
        if (debug) {
            Debug.say((String)(this.appModuleName + "/" + this.descriptorUri));
        }
    }

    public void deactivate() {
        if (debug) {
            Debug.say((String)(this.appModuleName + "/" + this.descriptorUri));
        }
        if (this.callbackHandler != null) {
            this.callbackHandler.deactivate(this.descriptorUri, this.descriptorNamespace, this.descriptorBean);
        }
    }

    public void unprepare() {
        if (debug) {
            Debug.say((String)(this.appModuleName + "/" + this.descriptorUri));
        }
        if (this.callbackHandler != null) {
            this.callbackHandler.unprepare(this.descriptorUri, this.descriptorNamespace, this.descriptorBean);
        }
        this.descriptorBean = null;
    }

    public void destroy(UpdateListener.Registration registration) {
        if (debug) {
            Debug.say((String)(this.appModuleName + "/" + this.descriptorUri));
        }
        registration.removeUpdateListener(this);
        this.applicationContext = null;
        this.descriptorBean = null;
        this.configDescManager.destroy();
    }

    public boolean acceptURI(String string) {
        if (this.parentModuleType == ModuleType.WAR) {
            return string.equals(this.parentModuleUri + "/" + this.descriptorUri);
        }
        return string.equals(this.descriptorUri);
    }

    public void prepareUpdate(String string) throws ModuleException {
        if (debug) {
            Debug.say((String)string);
        }
        CustomModuleLogger.logPrepareUpdate((String)this.appModuleName, (String)string);
        DescriptorBean descriptorBean = this.parseDescriptorBean();
        this.descriptorParsed = true;
        if (debug) {
            Debug.say((String)("prepareUpdate: " + descriptorBean));
        }
        try {
            this.descriptorBean.getDescriptor().prepareUpdate(descriptorBean.getDescriptor(), this.failOnNonDynamicChanges);
        }
        catch (DescriptorUpdateRejectedException descriptorUpdateRejectedException) {
            if (debug) {
                Debug.say((String)descriptorUpdateRejectedException.toString());
            }
            throw new ModuleException("Prepare failed for update to " + this.descriptorUri + " for app module " + this.appModuleName, descriptorUpdateRejectedException);
        }
    }

    public void activateUpdate(String string) throws ModuleException {
        if (debug) {
            Debug.say((String)string);
        }
        try {
            this.descriptorBean.getDescriptor().activateUpdate();
        }
        catch (DescriptorUpdateFailedException descriptorUpdateFailedException) {
            if (debug) {
                Debug.say((String)descriptorUpdateFailedException.toString());
            }
            throw new ModuleException("Activate failed for update to " + this.descriptorUri + " for app module " + this.appModuleName, descriptorUpdateFailedException);
        }
    }

    public void rollbackUpdate(String string) {
        if (debug) {
            Debug.say((String)string);
        }
        this.descriptorBean.getDescriptor().rollbackUpdate();
    }

    public void remove() {
        if (debug) {
            Debug.say((String)(this.appModuleName + "/" + this.descriptorUri));
        }
    }

    public void adminToProduction() {
    }

    public void gracefulProductionToAdmin(AdminModeCompletionBarrier adminModeCompletionBarrier) {
    }

    public void forceProductionToAdmin() {
    }

    public Map getDescriptorMappings() {
        if (!this.mergeLibraryDescriptors) {
            return null;
        }
        DescriptorBean[] descriptorBeanArray = this.getDescriptors();
        if (descriptorBeanArray == null || descriptorBeanArray.length == 0) {
            return null;
        }
        HashMap<String, DescriptorBean> hashMap = new HashMap<String, DescriptorBean>(1);
        hashMap.put(this.descriptorUri, descriptorBeanArray[0]);
        return hashMap;
    }

    public void handleMergedFinder(ClassFinder classFinder) {
    }

    private DescriptorBean parseDescriptorBean() throws ModuleException {
        try {
            File file = null;
            if (this.applicationContext.getAppDeploymentMBean() != null && this.applicationContext.getAppDeploymentMBean().getLocalPlanDir() != null) {
                file = new File(this.applicationContext.getAppDeploymentMBean().getLocalPlanDir());
            }
            return this.configDescManager.parseMergedDescriptorBean(file, this.applicationContext.findDeploymentPlan(), this.descriptorUri, this.customModuleContext.getParentModuleId(), this.parentModuleType, this.customModuleContext.getParentModuleUri(), this.mergeLibraryDescriptors, false);
        }
        catch (IOException iOException) {
            throw new ModuleException("Error reading descriptor: " + this.descriptorUri + " for app module " + this.appModuleName, iOException);
        }
        catch (XMLStreamException xMLStreamException) {
            throw new ModuleException("Error reading descriptor: " + this.descriptorUri + " for app module " + this.appModuleName, xMLStreamException);
        }
    }
}

