/*
 * Decompiled with CFR 0.152.
 */
package weblogic.application.ddconvert;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import weblogic.application.ApplicationFileManager;
import weblogic.descriptor.EditableDescriptorManager;
import weblogic.utils.classloaders.GenericClassLoader;
import weblogic.utils.jars.VirtualJarFile;

final class ConvertCtx {
    private final ApplicationFileManager afm;
    private final File outputDir;
    private final boolean isVerbose;
    private final boolean isQuiet;
    private final EditableDescriptorManager edm = new EditableDescriptorManager();

    ConvertCtx(ApplicationFileManager applicationFileManager, File file, boolean bl, boolean bl2) {
        this.afm = applicationFileManager;
        this.outputDir = file;
        this.isVerbose = bl;
        this.isQuiet = bl2;
    }

    File getOutputDir() {
        return this.outputDir;
    }

    VirtualJarFile getAppVJF() throws IOException {
        return this.afm.getVirtualJarFile();
    }

    VirtualJarFile getModuleVJF(String string) throws IOException {
        return this.afm.getVirtualJarFile(string);
    }

    boolean isVerbose() {
        return this.isVerbose;
    }

    boolean isQuiet() {
        return this.isQuiet;
    }

    EditableDescriptorManager getDescriptorManager() {
        return this.edm;
    }

    GenericClassLoader newClassLoader(VirtualJarFile virtualJarFile) {
        return new VJarResourceLoader(virtualJarFile);
    }

    static void debug(String string) {
        System.err.println("[DDConverter] " + string);
    }

    private static class VJarResourceLoader
    extends GenericClassLoader {
        private final VirtualJarFile vjar;

        VJarResourceLoader(VirtualJarFile virtualJarFile) {
            super((ClassLoader)null);
            this.vjar = virtualJarFile;
        }

        public URL getResource(String string) {
            return this.vjar.getResource(string);
        }

        public Class loadClass(String string) {
            throw new AssertionError((Object)"VJarResourceLoader only loads resources");
        }
    }
}

