/*
 * Decompiled with CFR 0.152.
 */
package weblogic.application.ddconvert;

import java.io.IOException;
import weblogic.application.ddconvert.ConvertCtx;
import weblogic.application.ddconvert.Converter;
import weblogic.application.ddconvert.DDConvertException;
import weblogic.application.ddconvert.EJBConverterFactory;
import weblogic.application.ddconvert.EarConverterFactory;
import weblogic.application.ddconvert.RarConverterFactory;
import weblogic.application.ddconvert.WarConverterFactory;
import weblogic.utils.jars.VirtualJarFile;

abstract class ConverterFactory {
    private static final ConverterFactory[] factories = new ConverterFactory[]{new EJBConverterFactory(), new WarConverterFactory(), new EarConverterFactory(), new RarConverterFactory()};

    ConverterFactory() {
    }

    public static Converter findConverter(ConvertCtx convertCtx, VirtualJarFile virtualJarFile) throws DDConvertException, IOException {
        for (int i = 0; i < factories.length; ++i) {
            if (convertCtx.isVerbose()) {
                ConvertCtx.debug("Trying factory " + factories[i].getClass().getName());
            }
            Converter converter = factories[i].newConverter(virtualJarFile);
            if (convertCtx.isVerbose()) {
                ConvertCtx.debug("Called Factory " + factories[i].getClass().getName() + " recognized application: " + (converter != null));
            }
            if (converter == null) continue;
            return converter;
        }
        return null;
    }

    abstract Converter newConverter(VirtualJarFile var1) throws DDConvertException, IOException;
}

