/*
 * Decompiled with CFR 0.152.
 */
package weblogic.application.ddconvert;

import java.io.File;
import java.io.IOException;
import weblogic.application.ApplicationFileManager;
import weblogic.application.ddconvert.ConvertCtx;
import weblogic.application.ddconvert.Converter;
import weblogic.application.ddconvert.ConverterFactory;
import weblogic.application.ddconvert.DDConvertException;
import weblogic.utils.FileUtils;
import weblogic.utils.compiler.Tool;
import weblogic.utils.compiler.ToolFailureException;
import weblogic.utils.jars.JarFileUtils;
import weblogic.utils.jars.VirtualJarFile;

public final class DDConverter
extends Tool {
    private File inputFile;
    private File workingDir;
    private boolean deleteWorkingDir;

    public DDConverter(String[] stringArray) {
        super(stringArray);
    }

    private static void p(String string) {
        ConvertCtx.debug(string);
    }

    public void prepare() {
        this.setUsageName("weblogic.DDConverter");
        this.opts.setUsageArgs("<EAR, JAR, RAR or WAR file/directory>");
        this.opts.addOption("d", "dir", "Directory where descriptors are written");
        this.opts.addFlag("verbose", "Turns on additional output for debugging");
        this.opts.addFlag("quiet", "Turns off output except for errors");
        this.opts.markPrivate("version");
    }

    private ConvertCtx setupFiles(String string) throws ToolFailureException, IOException {
        String string2;
        boolean bl = this.opts.hasOption("verbose");
        boolean bl2 = this.opts.hasOption("quiet");
        this.inputFile = new File(string);
        if (!this.inputFile.exists()) {
            throw new ToolFailureException("InputDirectory: " + this.inputFile + " does not exist or could not be read.");
        }
        if (bl) {
            DDConverter.p("inputFile " + this.inputFile.getAbsolutePath());
        }
        if ((string2 = this.opts.getOption("d")) == null) {
            throw new ToolFailureException("-d must be specified to indicate where DDConverter should write the descriptors");
        }
        File file = new File(string2);
        if (bl) {
            DDConverter.p("outputDir " + file.getAbsolutePath());
        }
        if (file.exists()) {
            if (!file.isDirectory()) {
                throw new ToolFailureException("-d " + file + " is not a directory.  Please specify a directory for output.");
            }
        } else {
            file.mkdirs();
        }
        if (this.inputFile.isDirectory()) {
            this.workingDir = this.inputFile;
            this.deleteWorkingDir = false;
            if (bl) {
                DDConverter.p("Using exploded dir " + this.workingDir.getAbsolutePath());
            }
        } else {
            this.workingDir = FileUtils.createTempDir((String)this.inputFile.getName());
            this.deleteWorkingDir = true;
            if (bl) {
                DDConverter.p("extracting jar to " + this.workingDir.getAbsolutePath());
            }
            JarFileUtils.extract((File)this.inputFile, (File)this.workingDir);
        }
        return new ConvertCtx(ApplicationFileManager.newInstance(this.workingDir), file, bl, bl2);
    }

    private void example() {
        this.opts.usageError("weblogic.DDConverter");
        System.out.println("");
        System.out.println("Example: java weblogic.DDConverter -d tmpdir my.ear");
        System.out.println("");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runBody() throws ToolFailureException, IOException, DDConvertException {
        String[] stringArray = this.opts.args();
        if (stringArray == null || stringArray.length == 0) {
            this.example();
            return;
        }
        ConvertCtx convertCtx = this.setupFiles(stringArray[0]);
        VirtualJarFile virtualJarFile = null;
        try {
            virtualJarFile = convertCtx.getAppVJF();
            Converter converter = ConverterFactory.findConverter(convertCtx, virtualJarFile);
            if (converter == null) {
                throw new ToolFailureException("The application at " + this.inputFile + " was not recognized as a valid application.\n\n" + "\nFor EAR Files, ensure there is a META-INF/application.xml." + "\nFor EJB-JAR files, ensure there is a META-INF/ejb-jar.xml" + "\nFor WAR files, ensure there is a WEB-INF/web.xml" + "\nFor RAR files, ensure there is a META-INF/ra.xml");
            }
            if (!convertCtx.isQuiet()) {
                converter.printStartMessage(this.inputFile.getName());
            }
            converter.convertDDs(convertCtx, virtualJarFile, convertCtx.getOutputDir());
            if (!convertCtx.isQuiet()) {
                converter.printEndMessage(this.inputFile.getName());
            }
        }
        finally {
            if (virtualJarFile != null) {
                try {
                    virtualJarFile.close();
                }
                catch (IOException iOException) {}
            }
        }
        if (this.deleteWorkingDir) {
            FileUtils.remove((File)this.workingDir);
        }
    }

    public static void main(String[] stringArray) throws Exception {
        new DDConverter(stringArray).run();
    }
}

