/*
 * Decompiled with CFR 0.152.
 */
package weblogic.application.ddconvert;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import weblogic.application.ddconvert.ConvertCtx;
import weblogic.application.ddconvert.Converter;
import weblogic.application.ddconvert.DDConvertException;
import weblogic.descriptor.DescriptorManager;
import weblogic.ejb.spi.EjbDescriptorBean;
import weblogic.ejb.spi.EjbDescriptorFactory;
import weblogic.ejb.spi.EjbDescriptorReader;
import weblogic.ejb.spi.EjbJarDescriptor;
import weblogic.j2ee.descriptor.EjbJarBean;
import weblogic.j2ee.descriptor.wl.WeblogicEjbJarBean;
import weblogic.utils.classloaders.GenericClassLoader;
import weblogic.utils.jars.VirtualJarFile;
import weblogic.xml.process.ProcessorFactory;

public final class EJBConverter
implements Converter {
    private static final String STANDARD_DD = "META-INF" + File.separator + "ejb-jar.xml";
    private static final String WEBLOGIC_DD = "META-INF" + File.separator + "weblogic-ejb-jar.xml";

    public void printStartMessage(String string) {
        ConvertCtx.debug("START Converting EJB-JAR " + string);
    }

    public void printEndMessage(String string) {
        ConvertCtx.debug("END Converting EJB-JAR " + string);
    }

    public void convertDDs(ConvertCtx convertCtx, VirtualJarFile virtualJarFile, File file) throws DDConvertException {
        FileOutputStream fileOutputStream = null;
        FileOutputStream fileOutputStream2 = null;
        GenericClassLoader genericClassLoader = null;
        EjbDescriptorBean ejbDescriptorBean = new EjbDescriptorBean(false);
        try {
            new File(file, "META-INF").mkdirs();
            if (convertCtx.isVerbose()) {
                ConvertCtx.debug("Converting " + STANDARD_DD);
            }
            genericClassLoader = convertCtx.newClassLoader(virtualJarFile);
            fileOutputStream = new FileOutputStream(new File(file, STANDARD_DD));
            EjbJarDescriptor ejbJarDescriptor = new EjbJarDescriptor((DescriptorManager)convertCtx.getDescriptorManager(), genericClassLoader);
            EjbJarBean ejbJarBean = ejbJarDescriptor.getEditableEjbJarBean();
            WeblogicEjbJarBean weblogicEjbJarBean = ejbJarDescriptor.getEditableWeblogicEjbJarBean();
            ejbDescriptorBean.setEjbJarBean(ejbJarBean);
            ejbDescriptorBean.setWeblogicEjbJarBean(weblogicEjbJarBean);
            if (weblogicEjbJarBean != null) {
                if (convertCtx.isVerbose()) {
                    ConvertCtx.debug("Converting " + WEBLOGIC_DD);
                }
                fileOutputStream2 = new FileOutputStream(new File(file, WEBLOGIC_DD));
                EjbDescriptorReader ejbDescriptorReader = EjbDescriptorFactory.getEjbDescriptorReader();
                ejbDescriptorReader.loadWeblogicRDBMSJarMBeans(ejbDescriptorBean, virtualJarFile, new ProcessorFactory(), false);
            }
            ejbDescriptorBean.usePersistenceDestination(file.getAbsolutePath());
            ejbDescriptorBean.persist();
        }
        catch (Exception exception) {
            throw new DDConvertException(exception);
        }
        finally {
            if (genericClassLoader != null) {
                genericClassLoader.close();
            }
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (fileOutputStream2 != null) {
                try {
                    fileOutputStream2.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

