/*
 * Decompiled with CFR 0.152.
 */
package weblogic.application.ddconvert;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import weblogic.application.ApplicationDescriptor;
import weblogic.application.ddconvert.ConvertCtx;
import weblogic.application.ddconvert.Converter;
import weblogic.application.ddconvert.ConverterFactory;
import weblogic.application.ddconvert.DDConvertException;
import weblogic.application.utils.EarUtils;
import weblogic.descriptor.DescriptorBean;
import weblogic.descriptor.DescriptorManager;
import weblogic.j2ee.descriptor.ApplicationBean;
import weblogic.j2ee.descriptor.ModuleBean;
import weblogic.j2ee.descriptor.wl.WeblogicApplicationBean;
import weblogic.utils.classloaders.GenericClassLoader;
import weblogic.utils.jars.VirtualJarFile;

public class EarConverter
implements Converter {
    private static final String STANDARD_DD = "META-INF" + File.separator + "application.xml";
    private static final String WEBLOGIC_DD = "META-INF" + File.separator + "weblogic-application.xml";

    public void printStartMessage(String string) {
        ConvertCtx.debug("START Converting EAR " + string);
    }

    public void printEndMessage(String string) {
        ConvertCtx.debug("END Converting EAR " + string);
    }

    public void convertDDs(ConvertCtx convertCtx, VirtualJarFile virtualJarFile, File file) throws DDConvertException {
        FileOutputStream fileOutputStream = null;
        FileOutputStream fileOutputStream2 = null;
        GenericClassLoader genericClassLoader = null;
        try {
            new File(file, "META-INF").mkdirs();
            fileOutputStream = new FileOutputStream(new File(file, STANDARD_DD));
            if (convertCtx.isVerbose()) {
                ConvertCtx.debug("Converting " + STANDARD_DD);
            }
            genericClassLoader = convertCtx.newClassLoader(virtualJarFile);
            ApplicationDescriptor applicationDescriptor = new ApplicationDescriptor((DescriptorManager)convertCtx.getDescriptorManager(), genericClassLoader);
            ApplicationBean applicationBean = applicationDescriptor.getApplicationDescriptor();
            convertCtx.getDescriptorManager().writeDescriptorBeanAsXML((DescriptorBean)applicationBean, (OutputStream)fileOutputStream);
            WeblogicApplicationBean weblogicApplicationBean = applicationDescriptor.getWeblogicApplicationDescriptor();
            if (weblogicApplicationBean != null) {
                if (convertCtx.isVerbose()) {
                    ConvertCtx.debug("Converting " + WEBLOGIC_DD);
                }
                fileOutputStream2 = new FileOutputStream(new File(file, WEBLOGIC_DD));
                convertCtx.getDescriptorManager().writeDescriptorBeanAsXML((DescriptorBean)weblogicApplicationBean, (OutputStream)fileOutputStream2);
            }
            this.convertModules(applicationBean.getModules(), convertCtx, file);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new DDConvertException(exception);
        }
        finally {
            if (genericClassLoader != null) {
                genericClassLoader.close();
            }
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (fileOutputStream2 != null) {
                try {
                    fileOutputStream2.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void convertModules(ModuleBean[] moduleBeanArray, ConvertCtx convertCtx, File file) throws DDConvertException, IOException {
        if (moduleBeanArray == null || moduleBeanArray.length == 0) {
            return;
        }
        for (int i = 0; i < moduleBeanArray.length; ++i) {
            String string = EarUtils.reallyGetModuleURI(moduleBeanArray[i]);
            VirtualJarFile virtualJarFile = null;
            try {
                Converter converter;
                virtualJarFile = convertCtx.getModuleVJF(string);
                if (convertCtx.isVerbose()) {
                    ConvertCtx.debug("Looking for converter for module-uri " + string);
                }
                if ((converter = ConverterFactory.findConverter(convertCtx, virtualJarFile)) == null) continue;
                File file2 = new File(file, string);
                file2.mkdirs();
                if (!convertCtx.isQuiet()) {
                    converter.printStartMessage(string);
                }
                converter.convertDDs(convertCtx, virtualJarFile, file2);
                if (convertCtx.isQuiet()) continue;
                converter.printEndMessage(string);
                continue;
            }
            finally {
                if (virtualJarFile != null) {
                    try {
                        virtualJarFile.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }
}

