/*
 * Decompiled with CFR 0.152.
 */
package weblogic.application.ddconvert;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import weblogic.application.ddconvert.ConvertCtx;
import weblogic.application.ddconvert.Converter;
import weblogic.application.ddconvert.DDConvertException;
import weblogic.connector.configuration.ConnectorDescriptor;
import weblogic.descriptor.DescriptorBean;
import weblogic.descriptor.DescriptorManager;
import weblogic.j2ee.descriptor.ConnectorBean;
import weblogic.j2ee.descriptor.wl.WeblogicConnectorBean;
import weblogic.utils.classloaders.GenericClassLoader;
import weblogic.utils.jars.VirtualJarFile;

public final class RarConverter
implements Converter {
    private static final String STANDARD_DD = "META-INF" + File.separator + "ra.xml";
    private static final String WEBLOGIC_DD = "META-INF" + File.separator + "weblogic-ra.xml";

    public void printStartMessage(String string) {
        ConvertCtx.debug("START Converting RAR " + string);
    }

    public void printEndMessage(String string) {
        ConvertCtx.debug("END Converting RAR " + string);
    }

    public void convertDDs(ConvertCtx convertCtx, VirtualJarFile virtualJarFile, File file) throws DDConvertException {
        FileOutputStream fileOutputStream = null;
        GenericClassLoader genericClassLoader = null;
        try {
            ConnectorBean connectorBean;
            genericClassLoader = convertCtx.newClassLoader(virtualJarFile);
            new File(file, "META-INF").mkdirs();
            ConnectorDescriptor connectorDescriptor = new ConnectorDescriptor((DescriptorManager)convertCtx.getDescriptorManager(), genericClassLoader, false);
            WeblogicConnectorBean weblogicConnectorBean = connectorDescriptor.getWeblogicConnectorBean();
            if (weblogicConnectorBean != null) {
                if (convertCtx.isVerbose()) {
                    ConvertCtx.debug("Converting " + WEBLOGIC_DD);
                }
                this.convertWLRADD(convertCtx, weblogicConnectorBean, file);
            }
            if ((connectorBean = connectorDescriptor.getConnectorBean()) != null) {
                if (convertCtx.isVerbose()) {
                    ConvertCtx.debug("Converting " + STANDARD_DD);
                }
                fileOutputStream = new FileOutputStream(new File(file, STANDARD_DD));
                convertCtx.getDescriptorManager().writeDescriptorBeanAsXML((DescriptorBean)connectorBean, (OutputStream)fileOutputStream);
            } else {
                ConvertCtx.debug("No ra.xml exists. Adapter may be a link-ref. Note that the adapter may still be deployed successfully as a 1.0 adapter without conversion.");
            }
        }
        catch (Exception exception) {
            throw new DDConvertException(exception);
        }
        finally {
            if (genericClassLoader != null) {
                genericClassLoader.close();
            }
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void convertWLRADD(ConvertCtx convertCtx, WeblogicConnectorBean weblogicConnectorBean, File file) throws DDConvertException {
        FileOutputStream fileOutputStream = null;
        try {
            if (convertCtx.isVerbose()) {
                ConvertCtx.debug("Converting " + WEBLOGIC_DD);
            }
            fileOutputStream = new FileOutputStream(new File(file, WEBLOGIC_DD));
            convertCtx.getDescriptorManager().writeDescriptorBeanAsXML((DescriptorBean)weblogicConnectorBean, (OutputStream)fileOutputStream);
        }
        catch (Exception exception) {
            throw new DDConvertException(exception);
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

