/*
 * Decompiled with CFR 0.152.
 */
package weblogic.application.ddconvert;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import weblogic.application.ddconvert.ConvertCtx;
import weblogic.application.ddconvert.Converter;
import weblogic.application.ddconvert.DDConvertException;
import weblogic.descriptor.DescriptorBean;
import weblogic.descriptor.DescriptorManager;
import weblogic.j2ee.descriptor.WebAppBean;
import weblogic.j2ee.descriptor.wl.WeblogicWebAppBean;
import weblogic.servlet.internal.WebAppDescriptor;
import weblogic.utils.classloaders.GenericClassLoader;
import weblogic.utils.jars.VirtualJarFile;

public class WarConverter
implements Converter {
    private static final String STANDARD_DD = "WEB-INF" + File.separator + "web.xml";
    private static final String WEBLOGIC_DD = "WEB-INF" + File.separator + "weblogic.xml";

    public void printStartMessage(String string) {
        ConvertCtx.debug("START Converting WAR " + string);
    }

    public void printEndMessage(String string) {
        ConvertCtx.debug("END Converting WAR " + string);
    }

    public void convertDDs(ConvertCtx convertCtx, VirtualJarFile virtualJarFile, File file) throws DDConvertException {
        FileOutputStream fileOutputStream = null;
        FileOutputStream fileOutputStream2 = null;
        GenericClassLoader genericClassLoader = null;
        try {
            new File(file, "WEB-INF").mkdirs();
            if (convertCtx.isVerbose()) {
                ConvertCtx.debug("Converting " + STANDARD_DD);
            }
            fileOutputStream = new FileOutputStream(new File(file, STANDARD_DD));
            genericClassLoader = convertCtx.newClassLoader(virtualJarFile);
            WebAppDescriptor webAppDescriptor = new WebAppDescriptor((DescriptorManager)convertCtx.getDescriptorManager(), genericClassLoader);
            WebAppBean webAppBean = webAppDescriptor.getWebAppBean();
            convertCtx.getDescriptorManager().writeDescriptorBeanAsXML((DescriptorBean)webAppBean, (OutputStream)fileOutputStream);
            WeblogicWebAppBean weblogicWebAppBean = webAppDescriptor.getWeblogicWebAppBean();
            if (weblogicWebAppBean != null) {
                if (convertCtx.isVerbose()) {
                    ConvertCtx.debug("Converting " + WEBLOGIC_DD);
                }
                fileOutputStream2 = new FileOutputStream(new File(file, WEBLOGIC_DD));
                convertCtx.getDescriptorManager().writeDescriptorBeanAsXML((DescriptorBean)weblogicWebAppBean, (OutputStream)fileOutputStream2);
            }
        }
        catch (Exception exception) {
            throw new DDConvertException(exception);
        }
        finally {
            if (genericClassLoader != null) {
                genericClassLoader.close();
            }
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (fileOutputStream2 != null) {
                try {
                    fileOutputStream2.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

