/*
 * Decompiled with CFR 0.152.
 */
package weblogic.application.descriptor;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.zip.ZipEntry;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import weblogic.application.descriptor.BasicMunger;
import weblogic.application.descriptor.ReaderEvent;
import weblogic.descriptor.Descriptor;
import weblogic.descriptor.DescriptorBean;
import weblogic.descriptor.DescriptorManager;
import weblogic.j2ee.descriptor.wl.DeploymentPlanBean;
import weblogic.j2ee.descriptor.wl.ModuleDescriptorBean;
import weblogic.utils.Debug;
import weblogic.utils.classloaders.GenericClassLoader;
import weblogic.utils.jars.VirtualJarFile;

public abstract class AbstractDescriptorLoader {
    private boolean dump = Debug.getCategory((String)"weblogic.application.descriptor").isEnabled();
    private DescriptorManager dm = READONLY_SINGLETON.instance;
    private final XMLInputFactory xiFactory = XMLInputFactory.newInstance();
    private Descriptor descriptor;
    private Descriptor planMergedDescriptor;
    private File altDD;
    private VirtualJarFile vjar;
    private GenericClassLoader gcl;
    private DeploymentPlanBean plan;
    private String moduleName;
    private File configDir;
    protected boolean debug = false;
    protected BasicMunger munger;
    private boolean doInit = true;
    DescriptorBean descriptorBean;

    public AbstractDescriptorLoader(VirtualJarFile virtualJarFile, File file, DeploymentPlanBean deploymentPlanBean, String string) {
        this.vjar = virtualJarFile;
        this.configDir = file;
        this.plan = deploymentPlanBean;
        this.moduleName = string;
    }

    public AbstractDescriptorLoader(File file, File file2, DeploymentPlanBean deploymentPlanBean, String string) {
        this.altDD = file;
        this.configDir = file2;
        this.plan = deploymentPlanBean;
        this.moduleName = string;
    }

    public AbstractDescriptorLoader(GenericClassLoader genericClassLoader) {
        this.gcl = genericClassLoader;
    }

    public AbstractDescriptorLoader(GenericClassLoader genericClassLoader, File file, DeploymentPlanBean deploymentPlanBean, String string) {
        this.gcl = genericClassLoader;
        this.configDir = file;
        this.plan = deploymentPlanBean;
        this.moduleName = string;
    }

    public AbstractDescriptorLoader(DescriptorManager descriptorManager, GenericClassLoader genericClassLoader, File file, DeploymentPlanBean deploymentPlanBean, String string) {
        this.gcl = genericClassLoader;
        this.dm = descriptorManager;
        this.plan = deploymentPlanBean;
        this.moduleName = string;
    }

    public AbstractDescriptorLoader(DescriptorManager descriptorManager, GenericClassLoader genericClassLoader) {
        this.gcl = genericClassLoader;
        this.dm = descriptorManager;
    }

    public AbstractDescriptorLoader(VirtualJarFile virtualJarFile) {
        this.vjar = virtualJarFile;
    }

    public AbstractDescriptorLoader(File file) {
        this.altDD = file;
    }

    public DeploymentPlanBean getDeploymentPlan() {
        return this.plan;
    }

    public File getConfigDir() {
        return this.configDir;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public String getAbsolutePath() {
        if (this.altDD == null) {
            if (this.vjar == null && this.gcl == null) {
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                return classLoader.toString() + "/" + this.getDocumentURI();
            }
            if (this.vjar == null) {
                return this.gcl.toString() + "/" + this.getDocumentURI();
            }
            return this.vjar.getName() + "/" + this.getDocumentURI();
        }
        return this.altDD.getAbsolutePath();
    }

    public DescriptorBean getRootDescriptorBean() throws IOException, XMLStreamException {
        if (this.doInit) {
            this.descriptor = this.getDescriptor();
            if (this.descriptor == null) {
                DescriptorBean descriptorBean = this.getDescriptorBeanFromPlan();
                if (descriptorBean != null) {
                    this.descriptor = descriptorBean.getDescriptor();
                }
                return descriptorBean;
            }
        }
        return this.descriptor == null ? null : this.descriptor.getRootBean();
    }

    public Descriptor getDescriptor() throws IOException, XMLStreamException {
        if (this.doInit) {
            this.doInit = false;
            this.descriptor = this.createDescriptor();
        }
        return this.descriptor;
    }

    protected void setDescriptor(Descriptor descriptor) throws IOException, XMLStreamException {
        this.doInit = false;
        this.descriptor = descriptor;
    }

    public abstract String getDocumentURI();

    public String getNamespaceURI() {
        return null;
    }

    public Map getElementNameChanges() {
        return Collections.EMPTY_MAP;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DescriptorBean getDescriptorBeanFromPlan() throws IOException, XMLStreamException {
        File file = this.getPlanFile();
        if (file == null) {
            return null;
        }
        if (file.exists() && file.isFile()) {
            DescriptorBean descriptorBean;
            FileInputStream fileInputStream = new FileInputStream(file);
            try {
                descriptorBean = this.createDescriptor(fileInputStream).getRootBean();
                Object var5_4 = null;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                try {
                    ((InputStream)fileInputStream).close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                ((InputStream)fileInputStream).close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return descriptorBean;
        }
        return null;
    }

    private File getPlanFile() {
        if (this.getDeploymentPlan() == null || this.getConfigDir() == null) {
            return null;
        }
        ModuleDescriptorBean moduleDescriptorBean = this.getDeploymentPlan().findModuleDescriptor(this.getModuleName(), this.getDocumentURI());
        if (moduleDescriptorBean == null) {
            return null;
        }
        File file = this.getDeploymentPlan().rootModule(this.getModuleName()) ? this.getConfigDir() : new File(this.getConfigDir(), this.getModuleName());
        return new File(file, moduleDescriptorBean.getUri());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Descriptor createDescriptor() throws IOException, XMLStreamException {
        Descriptor descriptor;
        InputStream inputStream = this.getInputStream();
        if (inputStream == null) {
            return null;
        }
        try {
            descriptor = this.createDescriptor(inputStream);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            try {
                inputStream.close();
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            inputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return descriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Descriptor createDescriptor(InputStream inputStream) throws IOException, XMLStreamException {
        Descriptor descriptor;
        try {
            XMLStreamReader xMLStreamReader = this.getXMLStreamReader(inputStream);
            descriptor = this.getDescriptorManager().createDescriptor(xMLStreamReader);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            try {
                inputStream.close();
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            inputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return descriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Descriptor createDescriptor(InputStream inputStream, boolean bl) throws IOException, XMLStreamException {
        Descriptor descriptor;
        try {
            XMLStreamReader xMLStreamReader = this.getXMLStreamReader(inputStream);
            descriptor = this.getDescriptorManager().createDescriptor(xMLStreamReader, bl);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            try {
                inputStream.close();
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            inputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return descriptor;
    }

    protected DescriptorManager getDescriptorManager() {
        return this.dm;
    }

    public InputStream getInputStream() throws IOException {
        if (this.altDD == null) {
            if (this.vjar == null && this.gcl == null) {
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                return classLoader.getResourceAsStream(this.getDocumentURI());
            }
            if (this.vjar == null) {
                return this.gcl.getResourceAsStream(this.getDocumentURI());
            }
            ZipEntry zipEntry = this.vjar.getEntry(this.getDocumentURI());
            if (zipEntry == null) {
                return null;
            }
            return this.vjar.getInputStream(zipEntry);
        }
        return new FileInputStream(this.altDD);
    }

    protected XMLStreamReader getXMLStreamReader(InputStream inputStream) throws XMLStreamException {
        if (this.munger == null) {
            this.munger = this.createXMLStreamReader(inputStream);
        }
        return this.munger;
    }

    protected BasicMunger createXMLStreamReader(InputStream inputStream) throws XMLStreamException {
        return new BasicMunger(this.createXMLStreamReaderDelegate(inputStream), this);
    }

    public XMLStreamReader createXMLStreamReaderDelegate(InputStream inputStream) throws XMLStreamException {
        return this.xiFactory.createXMLStreamReader(inputStream);
    }

    public BasicMunger createNullMunger() {
        String string = this.getMunger().getNamespaceURI();
        ArrayList arrayList = new ArrayList();
        this.getMunger().toQueuedEvents(arrayList);
        int n = 0;
        while (n < arrayList.size() && ((ReaderEvent)arrayList.get(n)).getEventType() != 1) {
        }
        String string2 = ((ReaderEvent)arrayList.get(n)).getLocalName();
        String string3 = "<ns:" + string2 + " xmlns:ns=\"" + this.getMunger().getNamespaceURI() + "\">" + "</ns:" + string2 + ">";
        XMLStreamReader xMLStreamReader = null;
        try {
            xMLStreamReader = this.createXMLStreamReaderDelegate(new ByteArrayInputStream(string3.getBytes()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        BasicMunger basicMunger = new BasicMunger(xMLStreamReader, this);
        basicMunger.setDtdNamespaceURI(this.getMunger().getNamespaceURI());
        return basicMunger;
    }

    public void toXML(PrintStream printStream) throws IOException, XMLStreamException {
        if (this.munger == null) {
            this.getRootDescriptorBean();
        }
        this.munger.toXML(printStream);
    }

    protected BasicMunger getMergingMunger() throws IOException, XMLStreamException {
        return this.munger;
    }

    public void merge(AbstractDescriptorLoader abstractDescriptorLoader) throws IOException, XMLStreamException {
        BasicMunger basicMunger = this.getMergingMunger();
        if (basicMunger == null) {
            this.getRootDescriptorBean();
            basicMunger = this.getMergingMunger();
        }
        if (basicMunger == null) {
            return;
        }
        basicMunger.merge(abstractDescriptorLoader.getMergingMunger());
    }

    public void mergeDescriptor(AbstractDescriptorLoader abstractDescriptorLoader) throws IOException, XMLStreamException {
        DescriptorBean descriptorBean = this.getMergedDescriptorBean(abstractDescriptorLoader);
        if (descriptorBean != null) {
            this.setDescriptor(descriptorBean.getDescriptor());
        }
    }

    public DescriptorBean getMergedDescriptorBean(AbstractDescriptorLoader abstractDescriptorLoader) throws IOException, XMLStreamException {
        DescriptorBean descriptorBean = abstractDescriptorLoader.getRootDescriptorBean();
        if (descriptorBean == null) {
            return null;
        }
        this.merge(abstractDescriptorLoader);
        descriptorBean = this.getMergedDescriptorBean();
        if (descriptorBean != null) {
            this.setDescriptor(descriptorBean.getDescriptor());
        }
        return descriptorBean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DescriptorBean getMergedDescriptorBean() throws IOException, XMLStreamException {
        ArrayList arrayList = new ArrayList();
        try {
            BasicMunger basicMunger = this.createNullMunger();
            this.munger.toQueuedEvents(arrayList);
            basicMunger.setQueuedEvents(arrayList);
            basicMunger.setForceNoBaseStreamHasNext(true);
            Descriptor descriptor = this.getDescriptorManager().createDescriptor((XMLStreamReader)basicMunger);
            DescriptorBean descriptorBean = descriptor.getRootBean();
            Object var6_7 = null;
            return descriptorBean;
        }
        catch (Exception exception) {
            try {
                exception.printStackTrace();
                DescriptorBean descriptorBean = null;
                Object var6_8 = null;
                return descriptorBean;
            }
            catch (Throwable throwable) {
                Object var6_9 = null;
                throw throwable;
            }
        }
    }

    public DescriptorBean getPlanMergedDescriptorBean() throws IOException, XMLStreamException {
        if (this.planMergedDescriptor == null) {
            this.planMergedDescriptor = this.getPlanMergedDescriptor();
        }
        if (this.planMergedDescriptor == null) {
            return null;
        }
        if (this.debug || this.dump) {
            this.planMergedDescriptor.toXML((OutputStream)System.out);
        }
        return this.planMergedDescriptor.getRootBean();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Descriptor getPlanMergedDescriptor() throws IOException, XMLStreamException {
        Descriptor descriptor;
        block23: {
            Object object;
            Object object2;
            InputStream inputStream;
            block21: {
                block22: {
                    block15: {
                        Descriptor descriptor2;
                        block20: {
                            block18: {
                                Descriptor descriptor3;
                                block19: {
                                    block16: {
                                        Descriptor descriptor4;
                                        block17: {
                                            inputStream = this.getInputStream();
                                            try {
                                                if (inputStream != null) break block15;
                                                object2 = this.getRootDescriptorBean();
                                                if (object2 != null) break block16;
                                                descriptor4 = null;
                                                Object var6_5 = null;
                                                if (inputStream == null) break block17;
                                            }
                                            catch (Throwable throwable) {
                                                block24: {
                                                    Object var6_10 = null;
                                                    if (inputStream == null) break block24;
                                                    try {
                                                        inputStream.close();
                                                    }
                                                    catch (Exception exception) {}
                                                }
                                                throw throwable;
                                            }
                                            try {
                                                inputStream.close();
                                            }
                                            catch (Exception exception) {
                                                // empty catch block
                                            }
                                        }
                                        return descriptor4;
                                    }
                                    object = this.getPlanFile();
                                    if (object != null) break block18;
                                    descriptor3 = null;
                                    Object var6_6 = null;
                                    if (inputStream == null) break block19;
                                    try {
                                        inputStream.close();
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                }
                                return descriptor3;
                            }
                            if (((File)object).exists() && ((File)object).isFile()) {
                                inputStream = new FileInputStream((File)object);
                                break block15;
                            }
                            descriptor2 = null;
                            Object var6_7 = null;
                            if (inputStream == null) break block20;
                            try {
                                inputStream.close();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        return descriptor2;
                    }
                    object2 = new ArrayList();
                    if (this.munger == null) {
                        this.getRootDescriptorBean();
                    }
                    this.munger.mergePlan((ArrayList)object2);
                    if (((ArrayList)object2).size() != 0) break block21;
                    object = this.getRootDescriptorBean().getDescriptor();
                    Object var6_8 = null;
                    if (inputStream == null) break block22;
                    try {
                        inputStream.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                return object;
            }
            object = this.createXMLStreamReader(inputStream);
            ((BasicMunger)object).setQueuedEvents((ArrayList)object2);
            descriptor = this.getDescriptorManager().createDescriptor((XMLStreamReader)object, false);
            Object var6_9 = null;
            if (inputStream == null) break block23;
            try {
                inputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return descriptor;
    }

    DescriptorBean findOrCreateDescriptorBean(InputStream inputStream) {
        if (this.descriptorBean != null) {
            return this.descriptorBean;
        }
        return null;
    }

    InputStream getInputStreamFromPlan() {
        return null;
    }

    DescriptorBean mergeDescriptorBeanWithPlan() throws IOException {
        if (this.descriptorBean == null) {
            return null;
        }
        this.descriptorBean = this.getMunger().mergeDescriptorBeanWithPlan(this);
        return this.descriptorBean;
    }

    BasicMunger getMunger() {
        return this.munger;
    }

    DescriptorBean getMergedDescriptorBean2(AbstractDescriptorLoader abstractDescriptorLoader) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DescriptorBean getDescriptorBean() throws IOException {
        DescriptorBean descriptorBean;
        block12: {
            InputStream inputStream;
            block10: {
                DescriptorBean descriptorBean2;
                block11: {
                    if (this.descriptorBean != null) {
                        return this.descriptorBean;
                    }
                    inputStream = this.getInputStream();
                    try {
                        if (this.plan != null) break block10;
                        descriptorBean2 = this.findOrCreateDescriptorBean(inputStream);
                        Object var4_4 = null;
                        if (inputStream == null) break block11;
                    }
                    catch (Throwable throwable) {
                        block13: {
                            Object var4_6 = null;
                            if (inputStream == null) break block13;
                            try {
                                inputStream.close();
                            }
                            catch (Exception exception) {}
                        }
                        throw throwable;
                    }
                    try {
                        inputStream.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                return descriptorBean2;
            }
            if (inputStream == null) {
                this.findOrCreateDescriptorBean(this.getInputStreamFromPlan());
            } else {
                this.findOrCreateDescriptorBean(inputStream);
            }
            this.mergeDescriptorBeanWithPlan();
            descriptorBean = this.descriptorBean;
            Object var4_5 = null;
            if (inputStream == null) break block12;
            try {
                inputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return descriptorBean;
    }

    private static class READONLY_SINGLETON {
        static DescriptorManager instance = new DescriptorManager();

        private READONLY_SINGLETON() {
        }
    }
}

