/*
 * Decompiled with CFR 0.152.
 */
package weblogic.application.descriptor;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import weblogic.application.descriptor.BasicMunger2;
import weblogic.application.descriptor.PlaybackReader;
import weblogic.application.descriptor.VersionMunger;
import weblogic.descriptor.DescriptorBean;
import weblogic.descriptor.DescriptorManager;
import weblogic.j2ee.J2EELogger;
import weblogic.j2ee.descriptor.wl.DeploymentPlanBean;
import weblogic.j2ee.descriptor.wl.ModuleDescriptorBean;
import weblogic.utils.Debug;
import weblogic.utils.StackTraceUtils;
import weblogic.utils.classloaders.GenericClassLoader;
import weblogic.utils.classloaders.Source;
import weblogic.utils.jars.VirtualJarFile;

public class AbstractDescriptorLoader2 {
    protected boolean debug = Debug.getCategory((String)"weblogic.descriptor.loader").isEnabled();
    private DescriptorManager dm;
    private DescriptorBean rootBean;
    protected BasicMunger2 munger;
    private File altDD;
    private VirtualJarFile vjar;
    private GenericClassLoader gcl;
    private DeploymentPlanBean plan;
    private File configDir;
    private String moduleName;
    private String documentURI;
    private String namespaceURI;
    private Map elementNameChanges = Collections.EMPTY_MAP;
    private InputStream inputStream;
    protected String versionInfo;
    private static boolean schemaValidationEnabled = AbstractDescriptorLoader2.getBooleanProperty("weblogic.descriptor.schemaValidationEnabled", true);
    private boolean validateSchema = schemaValidationEnabled;
    private List errorHolder = null;

    private static boolean getBooleanProperty(String string, boolean bl) {
        String string2 = System.getProperty(string);
        if (string2 != null) {
            return Boolean.parseBoolean(string2);
        }
        return bl;
    }

    protected AbstractDescriptorLoader2() {
    }

    public AbstractDescriptorLoader2(VirtualJarFile virtualJarFile, File file, DeploymentPlanBean deploymentPlanBean, String string, String string2) {
        this();
        this.vjar = virtualJarFile;
        this.configDir = file;
        this.plan = deploymentPlanBean;
        this.moduleName = string;
        this.documentURI = string2;
    }

    public AbstractDescriptorLoader2(File file, File file2, DeploymentPlanBean deploymentPlanBean, String string, String string2) {
        this();
        this.altDD = file;
        this.configDir = file2;
        this.plan = deploymentPlanBean;
        this.moduleName = string;
        this.documentURI = string2;
    }

    public AbstractDescriptorLoader2(GenericClassLoader genericClassLoader, String string) {
        this();
        this.gcl = genericClassLoader;
        this.documentURI = string;
    }

    public AbstractDescriptorLoader2(GenericClassLoader genericClassLoader, File file, DeploymentPlanBean deploymentPlanBean, String string, String string2) {
        this();
        this.gcl = genericClassLoader;
        this.configDir = file;
        this.plan = deploymentPlanBean;
        this.moduleName = string;
        this.documentURI = string2;
    }

    public AbstractDescriptorLoader2(DescriptorManager descriptorManager, GenericClassLoader genericClassLoader, File file, DeploymentPlanBean deploymentPlanBean, String string, String string2) {
        this();
        this.gcl = genericClassLoader;
        this.dm = descriptorManager;
        this.plan = deploymentPlanBean;
        this.moduleName = string;
        this.documentURI = string2;
    }

    public AbstractDescriptorLoader2(DescriptorManager descriptorManager, GenericClassLoader genericClassLoader, String string) {
        this();
        this.gcl = genericClassLoader;
        this.dm = descriptorManager;
        this.documentURI = string;
    }

    public AbstractDescriptorLoader2(VirtualJarFile virtualJarFile, String string) {
        this();
        this.vjar = virtualJarFile;
        this.documentURI = string;
    }

    public AbstractDescriptorLoader2(File file, String string) {
        this();
        this.altDD = file;
        this.documentURI = string;
    }

    public AbstractDescriptorLoader2(InputStream inputStream) {
        this(inputStream, null, null, true);
    }

    public AbstractDescriptorLoader2(InputStream inputStream, DescriptorManager descriptorManager, List list, boolean bl) {
        this.inputStream = inputStream;
        this.dm = descriptorManager;
        this.errorHolder = list;
        this.validateSchema = bl;
    }

    public DeploymentPlanBean getDeploymentPlan() {
        return this.plan;
    }

    public File getConfigDir() {
        return this.configDir;
    }

    public String getModuleType() {
        return "";
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public String getAbsolutePath() {
        if (this.altDD == null) {
            if (this.vjar == null && this.gcl == null) {
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                return classLoader.toString() + "/" + this.getDocumentURI();
            }
            if (this.vjar == null) {
                return this.gcl.toString() + "/" + this.getDocumentURI();
            }
            return this.vjar.getName() + "/" + this.getDocumentURI();
        }
        return this.altDD.getAbsolutePath();
    }

    public String getDocumentURI() {
        return this.documentURI;
    }

    public String getNamespaceURI() {
        return this.namespaceURI;
    }

    public void setNamespaceURI(String string) {
        this.namespaceURI = string;
    }

    public Map getElementNameChanges() {
        return this.elementNameChanges;
    }

    public void setElementNameChanges(Map map) {
        this.elementNameChanges = map;
    }

    private File getPlanFile() {
        if (this.getDeploymentPlan() == null || this.getConfigDir() == null) {
            return null;
        }
        ModuleDescriptorBean moduleDescriptorBean = this.getDeploymentPlan().findModuleDescriptor(this.getModuleName(), this.getDocumentURI());
        if (moduleDescriptorBean == null) {
            return null;
        }
        File file = this.getDeploymentPlan().rootModule(this.getModuleName()) ? this.getConfigDir() : new File(this.getConfigDir(), this.getModuleName());
        return new File(file, moduleDescriptorBean.getUri());
    }

    protected DescriptorManager getDescriptorManager() {
        if (this.dm == null) {
            this.dm = READONLY_SINGLETON.instance;
        }
        return this.dm;
    }

    public InputStream getInputStream() throws IOException {
        if (this.inputStream != null) {
            return this.inputStream;
        }
        if (this.altDD == null) {
            if (this.vjar == null && this.gcl == null) {
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                return classLoader.getResourceAsStream(this.getDocumentURI());
            }
            if (this.vjar == null) {
                return this.gcl.getResourceAsStream(this.getDocumentURI());
            }
            ZipEntry zipEntry = this.vjar.getEntry(this.getDocumentURI());
            if (zipEntry == null) {
                return null;
            }
            return this.vjar.getInputStream(zipEntry);
        }
        return new FileInputStream(this.altDD);
    }

    public void toXML(PrintStream printStream) throws IOException, XMLStreamException {
        this.getMunger().toXML(printStream);
    }

    protected XMLStreamReader createXMLStreamReader(InputStream inputStream) throws XMLStreamException {
        return new BasicMunger2(inputStream, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DescriptorBean createDescriptorBean(InputStream inputStream) throws IOException, XMLStreamException {
        DescriptorBean descriptorBean;
        block5: {
            block3: {
                DescriptorBean descriptorBean2;
                block4: {
                    try {
                        this.munger = (BasicMunger2)this.createXMLStreamReader(inputStream);
                        this.versionInfo = this.munger.getVersionInfo();
                        if (!this.munger.hasDTD() && !(this.munger instanceof VersionMunger)) break block3;
                        descriptorBean2 = this.getDescriptorBeanFromReader(this.munger.getPlaybackReader());
                        Object var4_4 = null;
                        if (this.getMunger() == null) break block4;
                    }
                    catch (Throwable throwable) {
                        block6: {
                            Object var4_6 = null;
                            if (this.getMunger() == null) break block6;
                            this.getMunger().close();
                        }
                        throw throwable;
                    }
                    this.getMunger().close();
                }
                return descriptorBean2;
            }
            descriptorBean = this.getDescriptorBeanFromReader(this.munger);
            Object var4_5 = null;
            if (this.getMunger() == null) break block5;
            this.getMunger().close();
        }
        return descriptorBean;
    }

    protected void setValidateSchema(boolean bl) {
        this.validateSchema = bl;
    }

    InputStream getInputStreamFromPlan() throws IOException {
        File file = this.getPlanFile();
        if (file == null) {
            return null;
        }
        if (file.exists() && file.isFile()) {
            return new FileInputStream(file);
        }
        return null;
    }

    public DescriptorBean mergeDescriptors(VirtualJarFile[] virtualJarFileArray) throws IOException, XMLStreamException {
        return this._mergeDescriptors(VirtualJarFile.class, virtualJarFileArray, null);
    }

    public DescriptorBean mergeDescriptors(Object[] objectArray) throws IOException, XMLStreamException {
        ArrayList<File> arrayList = new ArrayList<File>();
        for (int i = 0; i < objectArray.length; ++i) {
            Source source = (Source)objectArray[i];
            URL uRL = source.getURL();
            String string = uRL.getProtocol();
            if (!"file".equals(string)) continue;
            arrayList.add(new File(uRL.getPath()));
        }
        File[] fileArray = arrayList.toArray(new File[0]);
        return this.mergeDescriptors(fileArray);
    }

    public DescriptorBean mergeDescriptors(File[] fileArray) throws IOException, XMLStreamException {
        return this._mergeDescriptors(File.class, null, fileArray);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private DescriptorBean _mergeDescriptors(Class clazz, VirtualJarFile[] virtualJarFileArray, File[] fileArray) throws IOException, XMLStreamException {
        if (!$assertionsDisabled) {
            if (clazz == null) throw new AssertionError();
            if (clazz != VirtualJarFile.class && clazz != File.class) {
                throw new AssertionError();
            }
        }
        try {
            try {
                BasicMunger2 basicMunger2 = null;
                PlaybackReader playbackReader = null;
                int n = 0;
                if (clazz == VirtualJarFile.class) {
                    n = virtualJarFileArray.length;
                } else if (clazz == File.class) {
                    n = fileArray.length;
                }
                assert (n != 0);
                for (int i = n - 1; i > -1; --i) {
                    Constructor<?> constructor = this.getClass().getConstructor(clazz, File.class, DeploymentPlanBean.class, String.class, String.class);
                    AbstractDescriptorLoader2 abstractDescriptorLoader2 = null;
                    abstractDescriptorLoader2 = clazz == VirtualJarFile.class ? (AbstractDescriptorLoader2)constructor.newInstance(virtualJarFileArray[i], null, null, null, this.getDocumentURI()) : (AbstractDescriptorLoader2)constructor.newInstance(fileArray[i], null, null, null, this.getDocumentURI());
                    abstractDescriptorLoader2.setDescriptorManager(this.getDescriptorManager());
                    abstractDescriptorLoader2.loadDescriptorBean();
                    if (basicMunger2 == null) {
                        basicMunger2 = abstractDescriptorLoader2.getMunger();
                        playbackReader = basicMunger2.getPlaybackReader();
                        continue;
                    }
                    playbackReader = basicMunger2.merge(abstractDescriptorLoader2.getMunger(), null);
                }
                if (basicMunger2 == null) {
                    return this.loadDescriptorBean();
                }
                this.loadDescriptorBeanWithoutPlan();
                if (this.getMunger() != null) {
                    playbackReader = basicMunger2.merge(this.getMunger(), null);
                }
                this.munger = basicMunger2;
                if (this.plan == null) return this.getDescriptorBeanFromReader(playbackReader);
                return this.mergeDescriptorBeanWithPlan(this.getDeploymentPlan(), this.getModuleName(), this.getDocumentURI());
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new AssertionError((Object)("Descriptor loader subclasses must define a constructor with a \"" + clazz.toString().substring(clazz.toString().lastIndexOf(".") + 1) + ",File,DeploymentPlanBean,String,String\" signature: " + this.getClass().getName() + ": " + noSuchMethodException));
            }
            catch (InstantiationException instantiationException) {
                throw new AssertionError((Object)("Descriptor loader subclasses must define a constructor with a \"" + clazz.toString().substring(clazz.toString().lastIndexOf(".") + 1) + ",File,DeploymentPlanBean,String,String\" signature: " + instantiationException));
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new AssertionError((Object)("Descriptor loader subclasses must define a constructor with a \"" + clazz.toString().substring(clazz.toString().lastIndexOf(".") + 1) + ",File,DeploymentPlanBean,String,String\" signature: " + illegalAccessException));
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new AssertionError((Object)("Descriptor loader subclasses must define a constructor with a \"" + clazz.toString().substring(clazz.toString().lastIndexOf(".") + 1) + ",File,DeploymentPlanBean,String,String\" signature: " + invocationTargetException.getTargetException()));
            }
        }
        catch (Throwable throwable) {
            Object var11_20 = null;
            throw throwable;
        }
    }

    public DescriptorBean mergeDescriptorBean(AbstractDescriptorLoader2 abstractDescriptorLoader2) throws IOException, XMLStreamException {
        return this.mergeDescriptorBean(abstractDescriptorLoader2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DescriptorBean mergeDescriptorBean(AbstractDescriptorLoader2 abstractDescriptorLoader2, DescriptorBean descriptorBean) throws IOException, XMLStreamException {
        DescriptorBean descriptorBean2;
        Object object;
        Object object2;
        Object object3;
        BasicMunger2 basicMunger2 = null;
        if (descriptorBean != null && descriptorBean.getDescriptor().isModified()) {
            object3 = new ByteArrayOutputStream();
            this.dm.writeDescriptorAsXML(descriptorBean.getDescriptor(), (OutputStream)object3);
            object2 = ((ByteArrayOutputStream)object3).toByteArray();
            object = new ByteArrayInputStream((byte[])object2);
            basicMunger2 = (BasicMunger2)this.createXMLStreamReader((InputStream)object);
            descriptorBean2 = null;
            descriptorBean2 = basicMunger2 instanceof VersionMunger ? this.getDescriptorBeanFromReader(basicMunger2.getPlaybackReader()) : this.getDescriptorBeanFromReader(basicMunger2);
        }
        object3 = abstractDescriptorLoader2.getOrCreateMunger();
        object2 = this.getOrCreateMunger();
        if (object2 == null && object3 == null && basicMunger2 == null) {
            return null;
        }
        object3 = this.merge(basicMunger2, (BasicMunger2)object3);
        this.munger = this.merge((BasicMunger2)object2, (BasicMunger2)object3);
        object = this.munger.getPlaybackReader();
        try {
            descriptorBean2 = this.getDescriptorBeanFromReader((XMLStreamReader)object);
            Object var9_8 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            this.getMunger().close();
            throw throwable;
        }
        this.getMunger().close();
        return descriptorBean2;
    }

    private BasicMunger2 merge(BasicMunger2 basicMunger2, BasicMunger2 basicMunger22) throws IOException, XMLStreamException {
        if (basicMunger2 != null && basicMunger22 != null) {
            basicMunger22.merge(basicMunger2, null);
            return basicMunger22;
        }
        if (basicMunger22 != null) {
            return basicMunger22;
        }
        if (basicMunger2 != null) {
            return basicMunger2;
        }
        return null;
    }

    public void updateDescriptorWithBean(DescriptorBean descriptorBean) throws IOException, XMLStreamException {
        BasicMunger2 basicMunger2 = null;
        if (descriptorBean != null) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            this.getDescriptorManager().writeDescriptorAsXML(descriptorBean.getDescriptor(), (OutputStream)byteArrayOutputStream);
            byteArrayOutputStream.flush();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            basicMunger2 = (BasicMunger2)this.createXMLStreamReader(byteArrayInputStream);
            DescriptorBean descriptorBean2 = null;
            descriptorBean2 = basicMunger2 instanceof VersionMunger ? this.getDescriptorBeanFromReader(basicMunger2.getPlaybackReader()) : this.getDescriptorBeanFromReader(basicMunger2);
        }
        if (basicMunger2 != null) {
            this.munger = basicMunger2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DescriptorBean parseBean() throws XMLStreamException, IOException {
        DescriptorBean descriptorBean;
        try {
            descriptorBean = this.getDescriptorBeanFromReader(this.getMunger().getPlaybackReader());
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.getMunger().close();
            throw throwable;
        }
        this.getMunger().close();
        return descriptorBean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DescriptorBean mergeDescriptorBeanWithPlan(DescriptorBean descriptorBean) throws IOException, XMLStreamException {
        DescriptorBean descriptorBean2;
        PlaybackReader playbackReader = this.getMunger().mergeDescriptorBeanWithPlan(descriptorBean);
        try {
            descriptorBean2 = this.getDescriptorBeanFromReader(playbackReader);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.getMunger().close();
            throw throwable;
        }
        this.getMunger().close();
        return descriptorBean2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DescriptorBean mergeDescriptorBeanWithPlan(DeploymentPlanBean deploymentPlanBean, String string, String string2) throws IOException, XMLStreamException {
        DescriptorBean descriptorBean;
        PlaybackReader playbackReader = this.getMunger().mergeDescriptorBeanWithPlan(deploymentPlanBean, string, string2);
        try {
            descriptorBean = this.getDescriptorBeanFromReader(playbackReader);
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.getMunger().close();
            throw throwable;
        }
        this.getMunger().close();
        return descriptorBean;
    }

    protected BasicMunger2 getMunger() {
        return this.munger;
    }

    private BasicMunger2 getOrCreateMunger() throws IOException, XMLStreamException {
        if (this.munger == null) {
            this.loadDescriptorBean();
        }
        return this.munger;
    }

    private DescriptorBean loadDescriptorBeanWithoutPlan() throws IOException, XMLStreamException {
        DescriptorBean descriptorBean = this.rootBean;
        if (descriptorBean != null) {
            return descriptorBean;
        }
        if (this.munger != null) {
            return this.parseBean();
        }
        InputStream inputStream = this.getInputStream();
        if (inputStream == null) {
            inputStream = this.getInputStreamFromPlan();
        }
        if (inputStream != null) {
            descriptorBean = this.createDescriptorBean(inputStream);
        }
        return descriptorBean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DescriptorBean loadDescriptorBean() throws IOException, XMLStreamException {
        DescriptorBean descriptorBean;
        block5: {
            block3: {
                DescriptorBean descriptorBean2;
                block4: {
                    try {
                        DescriptorBean descriptorBean3 = this.loadDescriptorBeanWithoutPlan();
                        if (descriptorBean3 != null && !this.getMunger().hasDTD() && this.plan != null) break block3;
                        descriptorBean2 = descriptorBean3;
                        Object var4_4 = null;
                        if (this.getMunger() == null) break block4;
                    }
                    catch (Throwable throwable) {
                        block6: {
                            Object var4_6 = null;
                            if (this.getMunger() == null) break block6;
                            this.getMunger().close();
                        }
                        throw throwable;
                    }
                    this.getMunger().close();
                }
                return descriptorBean2;
            }
            descriptorBean = this.mergeDescriptorBeanWithPlan(null);
            Object var4_5 = null;
            if (this.getMunger() == null) break block5;
            this.getMunger().close();
        }
        return descriptorBean;
    }

    private DescriptorBean getDescriptorBeanFromReader(XMLStreamReader xMLStreamReader) throws IOException {
        try {
            this.rootBean = this.getDescriptorManager().createDescriptor(xMLStreamReader, this.errorHolder, this.validateSchema).getRootBean();
            if (this.versionInfo != null) {
                this.rootBean.getDescriptor().setOriginalVersionInfo(this.versionInfo);
            }
            return this.rootBean;
        }
        catch (IOException iOException) {
            J2EELogger.logUnableToValidateDescriptor((String)this.moduleName, (String)this.getAbsolutePath(), (String)StackTraceUtils.throwable2StackTrace((Throwable)iOException));
            throw iOException;
        }
    }

    public static void main(String[] stringArray) throws Exception {
        Object object;
        AbstractDescriptorLoader2 abstractDescriptorLoader2;
        String string;
        if (stringArray.length == 0) {
            AbstractDescriptorLoader2.usage();
            System.exit(-1);
        }
        String string2 = stringArray[0];
        String string3 = stringArray.length > 1 && stringArray[1].endsWith("plan.xml") ? stringArray[1] : null;
        File file = new File(string2);
        File file2 = new File(".");
        DeploymentPlanBean deploymentPlanBean = null;
        String string4 = string = stringArray.length > 2 ? stringArray[2] : null;
        if (string3 != null) {
            if (string == null) {
                AbstractDescriptorLoader2.usage();
                System.exit(-1);
            }
            abstractDescriptorLoader2 = new AbstractDescriptorLoader2(new File(string3), string3){};
            deploymentPlanBean = (DeploymentPlanBean)abstractDescriptorLoader2.loadDescriptorBean();
        }
        abstractDescriptorLoader2 = new TestAbstractDescriptorLoader2(file, file2, deploymentPlanBean, string, string2);
        int n = deploymentPlanBean == null ? 1 : 3;
        File[] fileArray = null;
        if (stringArray.length > n && stringArray[n].endsWith(".xml")) {
            System.out.print("\nmerged descriptor, Descriptor.toXML():");
            object = new ArrayList();
            for (int i = n; i < stringArray.length; ++i) {
                ((ArrayList)object).add(new File(stringArray[i]));
            }
            fileArray = ((ArrayList)object).toArray(new File[0]);
        }
        DescriptorBean descriptorBean = fileArray == null ? abstractDescriptorLoader2.loadDescriptorBean() : abstractDescriptorLoader2.mergeDescriptors(fileArray);
        object = descriptorBean.getDescriptor();
        System.out.print("\nDescriptor.toXML():");
        object.toXML((OutputStream)System.out);
    }

    private static void usage() {
        System.out.print("java weblogic.application.descriptor.AbstractDescriptorLoader2  <dd-filename> <plan-filename> <module-name>");
    }

    public void setDescriptorManager(DescriptorManager descriptorManager) {
        this.dm = descriptorManager;
    }

    public static class TestAbstractDescriptorLoader2
    extends AbstractDescriptorLoader2 {
        public TestAbstractDescriptorLoader2(File file, File file2, DeploymentPlanBean deploymentPlanBean, String string, String string2) {
            super(file, file2, deploymentPlanBean, string, string2);
        }
    }

    private static class READONLY_SINGLETON {
        static DescriptorManager instance = new DescriptorManager();

        private READONLY_SINGLETON() {
        }
    }
}

