/*
 * Decompiled with CFR 0.152.
 */
package weblogic.application.descriptor;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Stack;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.util.StreamReaderDelegate;
import weblogic.application.descriptor.AbstractDescriptorLoader;
import weblogic.application.descriptor.Munger;
import weblogic.application.descriptor.ReaderEvent;
import weblogic.descriptor.BeanCreationInterceptor;
import weblogic.descriptor.Descriptor;
import weblogic.descriptor.DescriptorBean;
import weblogic.descriptor.DescriptorException;
import weblogic.descriptor.internal.AbstractDescriptorBean;
import weblogic.descriptor.internal.DescriptorImpl;
import weblogic.descriptor.internal.Munger;
import weblogic.descriptor.internal.SchemaHelper;
import weblogic.j2ee.J2EELogger;
import weblogic.j2ee.descriptor.wl.DeploymentPlanBean;
import weblogic.j2ee.descriptor.wl.ModuleDescriptorBean;
import weblogic.j2ee.descriptor.wl.ModuleOverrideBean;
import weblogic.j2ee.descriptor.wl.VariableAssignmentBean;
import weblogic.j2ee.descriptor.wl.VariableBean;
import weblogic.j2ee.descriptor.wl.VariableDefinitionBean;
import weblogic.utils.Debug;

public class BasicMunger
extends StreamReaderDelegate
implements XMLStreamReader,
Munger,
BeanCreationInterceptor {
    protected boolean debug = Debug.getCategory((String)"weblogic.descriptor").isEnabled();
    protected boolean merge = Debug.getCategory((String)"weblogic.merge").isEnabled();
    private static final XMLInputFactory xiFactory = XMLInputFactory.newInstance();
    private AbstractDescriptorLoader loader;
    private DescriptorImpl descriptor;
    private boolean usingDTD = false;
    private boolean hasDTD = false;
    private String dtdNamespaceURI;
    protected boolean playbackToggle = false;
    protected boolean playback = false;
    protected boolean forceNoBaseStreamHasNext = false;
    ReaderEvent queuedEvent = null;
    protected ArrayList queuedEvents;
    protected ReaderEvent root;
    protected ReaderEvent top = new ReaderEvent(7, null, null, this);
    protected Stack stack = new Stack();
    protected Stack beans = new Stack();
    HashMap valueTable;
    HashMap locationTable;
    HashMap symbolTable;
    Map parentToPath = new HashMap();
    Map pathToParent = new LinkedHashMap();
    public static final String NON_VALIDATING_PARSER = "weblogic.NonValidatingParser";
    private static final String TRUE_STR = "true";
    private static final String FALSE_STR = "false";
    public static final int OP_DEFAULT = -1;
    public static final int OP_ADD = 1;
    public static final int OP_REMOVE = 2;
    public static final int OP_REPLACE = 3;

    public BasicMunger(XMLStreamReader xMLStreamReader, AbstractDescriptorLoader abstractDescriptorLoader) {
        super(xMLStreamReader);
        this.loader = abstractDescriptorLoader;
    }

    public BasicMunger(InputStream inputStream, AbstractDescriptorLoader abstractDescriptorLoader) throws XMLStreamException {
        super(xiFactory.createXMLStreamReader(inputStream));
        this.loader = abstractDescriptorLoader;
    }

    public BasicMunger(XMLStreamReader xMLStreamReader, AbstractDescriptorLoader abstractDescriptorLoader, DeploymentPlanBean deploymentPlanBean, String string, String string2, String string3) {
        this(xMLStreamReader, abstractDescriptorLoader);
        this.initValueTable(deploymentPlanBean, string, string3);
    }

    public BasicMunger(InputStream inputStream, AbstractDescriptorLoader abstractDescriptorLoader, DeploymentPlanBean deploymentPlanBean, String string, String string2, String string3) throws XMLStreamException {
        this(xiFactory.createXMLStreamReader(inputStream), abstractDescriptorLoader);
        this.initValueTable(deploymentPlanBean, string, string3);
    }

    public Map getLocalNameMap() {
        return Collections.EMPTY_MAP;
    }

    public void setDtdNamespaceURI(String string) {
        this.dtdNamespaceURI = string;
    }

    public String getDtdNamespaceURI() {
        return this.dtdNamespaceURI;
    }

    public void initDtdText(String string) {
    }

    public void toXML(PrintStream printStream) {
        this.root.toXML(printStream);
    }

    public void logError(List list) {
        if (list.isEmpty()) {
            return;
        }
        J2EELogger.logDescriptorParseError((String)new DescriptorException("VALIDATION PROBLEMS " + this.loader.getAbsolutePath(), list).getMessage());
    }

    public boolean isValidationEnabled() {
        return !TRUE_STR.equals(System.getProperty(NON_VALIDATING_PARSER));
    }

    public void merge(BasicMunger basicMunger) {
        try {
            this.resetDescriptor(this.loader, this.loader.getDescriptor());
        }
        catch (IOException iOException) {
            throw new AssertionError((Object)iOException);
        }
        catch (XMLStreamException xMLStreamException) {
            throw new AssertionError((Object)xMLStreamException);
        }
        this.merge(basicMunger.root, false);
    }

    public void merge(ReaderEvent readerEvent, boolean bl) {
        this.parentToPath.clear();
        this.pathToParent.clear();
        this.merge(this.root, readerEvent, bl);
    }

    public void merge(ReaderEvent readerEvent, ReaderEvent readerEvent2, boolean bl) {
        this.initKeyedParentToPath(readerEvent);
        this.initPathToParent(readerEvent2);
        if (this.debug || this.merge) {
            this.dumpStartMerge(readerEvent2);
        }
        this.replaceMatchingXpathsByKey(readerEvent, bl);
        if (this.debug || this.merge) {
            System.out.println("--- after replaceMatchingXpathsByKey ----");
            this.dumpStartMerge(readerEvent2);
        }
        for (ReaderEvent readerEvent3 : this.pathToParent.values()) {
            ReaderEvent readerEvent4;
            if (this.debug || this.merge) {
                System.out.println("--- call adoptUnmatchedKeyedReaderEvents with: " + readerEvent3.getPath());
            }
            if (readerEvent.searchSubTree(readerEvent3)) {
                if (!this.merge) continue;
                System.out.println("--- adoptUnmatchedKeyedReaderEvents: source already exists in target.. skipping");
                readerEvent.toXML(System.out);
                continue;
            }
            ReaderEvent readerEvent5 = this.scanForSiblingReaderEvent(readerEvent, readerEvent3);
            if (this.debug || this.merge) {
                System.out.println("--- call adoptUnmatchedKeyedReaderEvents with: " + readerEvent3.getPath());
                System.out.println("--- and: " + readerEvent5.getPath());
            }
            ReaderEvent readerEvent6 = readerEvent5.getParent();
            if (bl && (readerEvent6 == null || readerEvent6.getEventType() == 7)) {
                readerEvent6 = readerEvent5;
            }
            if (!readerEvent3.getLocalName().equals(readerEvent5.getLocalName())) {
                while (readerEvent3.getParent().getLocalName() != null && !readerEvent3.getParent().getLocalName().equals(readerEvent5.getParent().getLocalName()) && (readerEvent4 = readerEvent3.getParent()) != null && readerEvent4.getEventType() != 7 && readerEvent4.getLocalName() != null) {
                    readerEvent3 = readerEvent4;
                }
            }
            readerEvent4 = readerEvent3.getParent();
            readerEvent4.getChildren().remove(readerEvent3);
            if (this.debug || this.merge && readerEvent4 != null && readerEvent4.getChildren() != null) {
                System.out.println(" zap old parent iff size == 0, " + readerEvent4.getChildren().size());
            }
            while (readerEvent4 != null && readerEvent4.getChildren() != null && readerEvent4.getChildren().size() == 0) {
                readerEvent4.setDiscard();
                Stack stack = readerEvent4.getChildren();
                if (stack != null) {
                    stack.remove(readerEvent4);
                }
                readerEvent4 = readerEvent4.getParent();
                if (!this.debug && !this.merge || readerEvent4 == null || readerEvent4.getChildren() == null) continue;
                System.out.println(" zap old parent iff size == 0, " + readerEvent4.getChildren().size());
            }
            readerEvent6.getChildren().add(readerEvent3);
            readerEvent3.fixParents(readerEvent6);
        }
        if (this.debug || this.merge) {
            System.out.println("--- after adoptUnmatchedKeyedReaderEvents ----");
            this.dumpStartMerge(readerEvent2);
        }
        if (readerEvent.searchSubTree(readerEvent2)) {
            if (this.merge) {
                System.out.println("Skipping replaceMatchingXpaths, source already exists in target");
            }
        } else {
            this.parentToPath.clear();
            this.initParentToPath(readerEvent2);
            if (this.debug || this.merge) {
                System.out.println("before replaceMatchingXpaths:");
                System.out.println("target = ");
                readerEvent.toXML(System.out);
                System.out.println("source = ");
                readerEvent2.toXML(System.out);
                this.dumpParent2Path();
                System.out.println("-------------");
            }
            this.replaceMatchingXpaths(readerEvent, bl);
            if (this.debug || this.merge) {
                System.out.print("\n\nafter replaceMatchingXpaths: ");
                System.out.println("target = ");
                readerEvent.toXML(System.out);
                System.out.println("source = ");
                readerEvent2.toXML(System.out);
            }
        }
        if (this.debug || this.merge) {
            System.out.print("\n\n\n... before adoptUnmatchedReaderEvents ");
            this.root.toXML(System.out);
        }
        this.adoptUnmatchedReaderEvents(readerEvent2);
        if (this.debug || this.merge) {
            System.out.print("\n\n\n... after adoptUnmatchedReaderEvents ");
            this.root.toXML(System.out);
        }
    }

    DescriptorBean mergeDescriptorBeanWithPlan(AbstractDescriptorLoader abstractDescriptorLoader) throws IOException {
        ArrayList arrayList = new ArrayList();
        this.mergePlan(arrayList);
        this.setQueuedEvents(arrayList);
        Descriptor descriptor = abstractDescriptorLoader.getDescriptorManager().createDescriptor((XMLStreamReader)this);
        assert (descriptor != null);
        return descriptor.getRootBean();
    }

    public void mergePlan(ArrayList arrayList) throws IOException {
        VariableAssignment variableAssignment;
        String string;
        if (this.valueTable == null) {
            return;
        }
        ArrayList<ReaderEvent> arrayList2 = new ArrayList<ReaderEvent>();
        for (Map.Entry object : this.valueTable.entrySet()) {
            string = (String)object.getKey();
            variableAssignment = (VariableAssignment)object.getValue();
            String string2 = variableAssignment.getName();
            int n = variableAssignment.getOperation();
            if (string2 == null) continue;
            if (this.debug || this.merge) {
                System.out.println("BasicMunger: xpath = " + string + ", val = " + string2);
            }
            arrayList2.add(new ReaderEvent(new StringBuffer(string), new ReaderEvent(7, null, null, this), string2, n, this, (Location)this.getLocationTable().get(string)));
        }
        for (ReaderEvent readerEvent : arrayList2) {
            string = (AbstractDescriptorBean)this.descriptor.getRootBean();
            variableAssignment = string._getSchemaHelper2();
            readerEvent.validate((SchemaHelper)variableAssignment);
            if (this.debug || this.merge) {
                System.out.println("\n\nBasicMunger: ReaderEvent to merge into plan: ");
                readerEvent.toXML(System.out);
                System.out.println("----------- end ReaderEvent --------");
            }
            this.merge(readerEvent, true);
        }
        if (this.debug || this.merge) {
            System.out.println("\n\nBasicMunger: Current descriptor after subtree has been merged: ");
            this.root.toXML(System.out);
        }
        this.root.toQueuedEvents(arrayList);
    }

    public AbstractDescriptorBean getCurrentOrEventBean(ReaderEvent readerEvent) {
        ReaderEvent readerEvent2 = this.getCurrentBeanEvent();
        if (readerEvent2 == null) {
            readerEvent2 = readerEvent.getBeanEvent();
        }
        return readerEvent2 == null ? null : readerEvent2.getBean();
    }

    public ReaderEvent getParentReaderEvent(ReaderEvent readerEvent) {
        AbstractDescriptorBean abstractDescriptorBean = this.getCurrentOrEventBean(readerEvent);
        return abstractDescriptorBean == null ? readerEvent.getParentReaderEvent() : (ReaderEvent)abstractDescriptorBean._getParentReaderEvent((Munger.ReaderEventInfo)readerEvent);
    }

    public DescriptorBean beanCreated(DescriptorBean descriptorBean, DescriptorBean descriptorBean2) {
        if (descriptorBean2 == null) {
            this.descriptor = (DescriptorImpl)descriptorBean.getDescriptor();
        }
        if (this.top != null) {
            this.top.setBean((AbstractDescriptorBean)descriptorBean);
            ((AbstractDescriptorBean)descriptorBean)._setElementName(this.top.getElementName());
            this.beans.push(this.top);
        }
        return descriptorBean;
    }

    public String getLocalName() {
        if (this.playback) {
            if (this.queuedEvent.getEventType() == 4) {
                return new String(this.queuedEvent.getCharacters());
            }
            return this.queuedEvent.getLocalName();
        }
        String string = super.getLocalName();
        if (string == null) {
            return null;
        }
        if (this.usingDTD) {
            String string2 = (String)this.getLocalNameMap().get(string);
            return string2 != null ? string2 : string;
        }
        return string;
    }

    public char[] getTextCharacters() {
        if (this.playback && this.queuedEvent != null) {
            return this.queuedEvent.getCharacters();
        }
        char[] cArray = super.getTextCharacters();
        if (this.top != null) {
            this.top.setCharacters(cArray);
        }
        if (!this.usingDTD) {
            return cArray;
        }
        String string = new String(cArray);
        if (TRUE_STR.equalsIgnoreCase(string.trim())) {
            return string.toLowerCase(Locale.US).toCharArray();
        }
        if (FALSE_STR.equalsIgnoreCase(string.trim())) {
            return string.toLowerCase(Locale.US).toCharArray();
        }
        return cArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void setPlayback(boolean bl) {
        if (bl == this.playback) {
            return;
        }
        if (bl) {
            if (this.queuedEvents.size() <= 0) return;
            if (this.forceNoBaseStreamHasNext) {
                this.queuedEvent = (ReaderEvent)this.queuedEvents.remove(0);
                this.playback = true;
                return;
            }
            this.playbackToggle = true;
            return;
        } else {
            this.playbackToggle = true;
        }
    }

    public int next() throws XMLStreamException {
        if (this.playbackToggle) {
            this.playback = !this.playback;
            this.playbackToggle = false;
        }
        if (this.playback) {
            if (this.queuedEvents.size() > 0) {
                this.queuedEvent = (ReaderEvent)this.queuedEvents.remove(0);
                if (this.debug) {
                    System.out.println("-> next: play = " + this.type2Str(this.queuedEvent.getEventType()) + " event queue size = " + this.queuedEvents.size());
                }
                switch (this.queuedEvent.getEventType()) {
                    case 7: {
                        this.push();
                        break;
                    }
                    case 1: {
                        this.push();
                        break;
                    }
                    case 8: {
                        this.push();
                        break;
                    }
                    case 2: {
                        this.pop();
                        break;
                    }
                    case 4: {
                        new String(this.getTextCharacters());
                        if (this.top == null) break;
                        this.top.setCharacters(this.queuedEvent.getCharacters());
                    }
                }
                int n = this.queuedEvent.getEventType();
                return n;
            }
            if (this.debug) {
                System.out.println("playback played out, delegate to reader...");
            }
        }
        this.playback = false;
        this.queuedEvent = null;
        int n = super.next();
        if (this.debug) {
            System.out.println("->next = " + this.type2Str(n));
        }
        switch (n) {
            case 11: {
                this.hasDTD = true;
                this.usingDTD = true;
                this.initDtdText(this.getText());
                return this.next();
            }
            case 7: {
                this.push();
                break;
            }
            case 1: {
                this.push();
                break;
            }
            case 8: {
                this.push();
                ReaderEvent readerEvent = this.getCurrentBeanEvent();
                if (readerEvent != null && readerEvent.getBean() != null) {
                    this.beans.pop();
                }
                this.pop();
                break;
            }
            case 2: {
                ReaderEvent readerEvent = this.getCurrentBeanEvent();
                if (readerEvent != null && readerEvent.getBean() != null && this.getLocalName().equals(readerEvent.getBean()._getElementName())) {
                    this.beans.pop();
                }
                this.pop();
                break;
            }
            case 4: {
                this.getTextCharacters();
            }
        }
        return n;
    }

    private ReaderEvent getCurrentBeanEvent() {
        return this.beans.empty() ? null : (ReaderEvent)this.beans.peek();
    }

    public void push() {
        this.stack.push(this.top);
        Location location = this.getLocation();
        ReaderEvent readerEvent = new ReaderEvent(this.getEventType() == 8 ? null : this.getLocalName(), this.top, this, location, this.getCurrentBeanEvent());
        if (this.top.getEventType() == 7) {
            this.root = readerEvent;
        }
        this.top = readerEvent;
        ReaderEvent readerEvent2 = this.getCurrentBeanEvent();
        if (readerEvent2 != null) {
            this.top.setBean(readerEvent2.getBean());
        }
        if (this.getEventType() == 1 && this.getAttributeCount() > 0) {
            readerEvent.setAttributeCount(this.getAttributeCount());
            for (int i = 0; i < this.getAttributeCount(); ++i) {
                readerEvent.setAttributeValue(this.getAttributeValue(i), i);
            }
        }
    }

    public void pop() {
        if (this.stack.empty()) {
            if (this.debug) {
                System.out.println("\n\nStack is empty!!!!!");
            }
            return;
        }
        ReaderEvent readerEvent = (ReaderEvent)this.stack.pop();
        if (readerEvent != null) {
            readerEvent.getChildren().push(this.top);
            this.top = readerEvent;
        }
    }

    public void setBean(AbstractDescriptorBean abstractDescriptorBean) {
        if (this.top != null) {
            ReaderEvent readerEvent = (ReaderEvent)this.top.getChildren().lastElement();
            readerEvent.setBean(abstractDescriptorBean);
        }
    }

    public int skip(int n) throws XMLStreamException {
        switch (n) {
            case 1: {
                this.top.setDiscard();
                break;
            }
            case 2: {
                break;
            }
        }
        if (this.debug) {
            System.out.println("skipped...");
        }
        return this.next();
    }

    public String getNamespaceURI() {
        if (this.debug) {
            System.out.println("->getNamespaceURI: usingDTD() =" + this.usingDTD());
        }
        return this.usingDTD() ? this.getDtdNamespaceURI() : super.getNamespaceURI();
    }

    public boolean usingDTD() {
        return this.usingDTD;
    }

    public boolean hasDTD() {
        return this.hasDTD || super.getNamespaceURI() == null;
    }

    public void setParent(XMLStreamReader xMLStreamReader) {
        if (this.debug) {
            System.out.println("->setParent");
        }
        super.setParent(xMLStreamReader);
    }

    public XMLStreamReader getParent() {
        if (this.debug) {
            System.out.println("->getParent");
        }
        return super.getParent();
    }

    public int nextTag() throws XMLStreamException {
        if (this.debug) {
            System.out.println("->nextTag");
        }
        if (this.playback) {
            return this.next();
        }
        return super.nextTag();
    }

    public String getElementText() throws XMLStreamException {
        if (this.debug) {
            System.out.println("->getElementText");
        }
        return super.getElementText();
    }

    public void require(int n, String string, String string2) throws XMLStreamException {
        if (this.debug) {
            System.out.println("->require");
        }
        super.require(n, string, string2);
    }

    public void setForceNoBaseStreamHasNext(boolean bl) {
        this.forceNoBaseStreamHasNext = bl;
    }

    public boolean hasNext() throws XMLStreamException {
        boolean bl;
        boolean bl2 = this.playbackToggle ? !this.playback : (bl = this.playback);
        boolean bl3 = bl && this.queuedEvents.size() > 0 ? true : (this.forceNoBaseStreamHasNext ? false : super.hasNext());
        if (this.debug) {
            System.out.println("->hasNext: = " + bl3 + ", playback = " + this.playback);
        }
        return bl3;
    }

    public void close() throws XMLStreamException {
        if (this.debug) {
            System.out.println("->close");
        }
        super.close();
    }

    public String getNamespaceURI(String string) {
        if (this.debug) {
            System.out.println("->getNamespaceURI(String)");
        }
        return super.getNamespaceURI(string);
    }

    public NamespaceContext getNamespaceContext() {
        if (this.debug) {
            System.out.println("->getNamespaceContext");
        }
        return super.getNamespaceContext();
    }

    public boolean isStartElement() {
        boolean bl;
        boolean bl2 = this.playback ? this.queuedEvent.getEventType() == 1 : (bl = super.isStartElement());
        if (this.debug) {
            System.out.println("->isStartElement: " + bl);
        }
        return bl;
    }

    public boolean isEndElement() {
        if (this.debug) {
            System.out.println("->isEndElement playback=" + this.playback);
        }
        if (this.playback) {
            return this.queuedEvent.getEventType() == 2;
        }
        return super.isEndElement();
    }

    public boolean isCharacters() {
        if (this.debug) {
            System.out.println("->isCharacters");
        }
        if (this.playback) {
            return this.queuedEvent.getEventType() == 4;
        }
        return super.isCharacters();
    }

    private static boolean isSpace(char c) {
        return c == ' ' || c == '\t' || c == '\n' || c == '\r';
    }

    public boolean isWhiteSpace() {
        if (this.debug) {
            System.out.println("->isWhiteSpace");
        }
        if (this.playback) {
            if (this.queuedEvent.getEventType() == 4) {
                char[] cArray = this.queuedEvent.getCharacters();
                for (int i = 0; i < cArray.length; ++i) {
                    if (BasicMunger.isSpace(cArray[i])) continue;
                    return false;
                }
                return true;
            }
            throw new IllegalStateException("isWhiteSpace on type " + this.type2Str(this.queuedEvent.getEventType()));
        }
        return super.isWhiteSpace();
    }

    public String getAttributeValue(String string, String string2) {
        String string3;
        String string4 = string3 = this.playback ? this.queuedEvent.getAttributeValue(string, string2) : super.getAttributeValue(string, string2);
        if (!this.playback && this.top != null) {
            this.top.setAttributeValue(string3, string, string2);
        }
        if (this.debug) {
            System.out.println("->getAttributeValue(" + string + ", " + string2 + ") returns: " + string3);
        }
        return string3;
    }

    public int getAttributeCount() {
        int n;
        int n2 = n = this.playback ? this.queuedEvent.getAttributeCount() : super.getAttributeCount();
        if (this.debug) {
            System.out.println("->getAttributeCount() returns " + n);
        }
        if (!this.playback && this.top != null) {
            this.top.setAttributeCount(n);
        }
        return n;
    }

    public QName getAttributeName(int n) {
        QName qName;
        QName qName2 = qName = this.playback ? this.queuedEvent.getAttributeName(n) : super.getAttributeName(n);
        if (this.debug) {
            System.out.println("->getAttributeName(" + n + ") returns: " + qName);
        }
        return qName;
    }

    public String getAttributePrefix(int n) {
        String string;
        String string2 = string = this.playback ? this.queuedEvent.getAttributePrefix(n) : super.getAttributePrefix(n);
        if (!this.playback && this.top != null) {
            this.top.setAttributePrefix(string, n);
        }
        if (this.debug) {
            System.out.println("->getAttributePrefix(" + n + ") return " + string);
        }
        return string;
    }

    public String getAttributeNamespace(int n) {
        String string;
        String string2 = string = this.playback ? this.queuedEvent.getAttributeNamespace(n) : super.getAttributeNamespace(n);
        if (!this.playback && this.top != null) {
            this.top.setAttributeNamespace(string, n);
        }
        if (this.debug) {
            System.out.println("->getAttributeNamespace(" + n + ") returns " + string);
        }
        return string;
    }

    public String getAttributeLocalName(int n) {
        String string;
        String string2 = string = this.playback ? this.queuedEvent.getAttributeLocalName(n) : super.getAttributeLocalName(n);
        if (!this.playback && this.top != null) {
            this.top.setAttributeLocalName(string, n);
        }
        if (this.debug) {
            System.out.println("->getAttributeLocalName(" + n + ") returns " + string);
        }
        return string;
    }

    public String getAttributeType(int n) {
        if (this.debug) {
            System.out.println("->getAttributeType returns CDATA");
        }
        return "CDATA";
    }

    public String getAttributeValue(int n) {
        String string;
        String string2 = string = this.playback ? this.queuedEvent.getAttributeValue(n) : super.getAttributeValue(n);
        if (!this.playback && this.top != null) {
            this.top.setAttributeValue(string, n);
        }
        if (this.debug) {
            System.out.println("->getAttributeValue(" + n + ") returns: " + string);
        }
        return string;
    }

    public boolean isAttributeSpecified(int n) {
        boolean bl;
        boolean bl2 = bl = this.playback ? this.queuedEvent.isAttributeSpecified(n) : super.isAttributeSpecified(n);
        if (this.debug) {
            System.out.println("->isAttributeSpecified(" + n + ") returns " + bl);
        }
        return bl;
    }

    public int getNamespaceCount() {
        int n;
        int n2 = n = this.playback ? this.queuedEvent.getNamespaceCount() : super.getNamespaceCount();
        if (!this.playback && this.top != null) {
            this.top.setNamespaceCount(n);
        }
        if (this.debug) {
            System.out.println("->getNamespaceCount return " + n);
        }
        return n;
    }

    public String getNamespacePrefix(int n) {
        String string;
        String string2 = string = this.playback ? null : super.getNamespacePrefix(n);
        if (this.debug) {
            System.out.println("->getNamespacePrefix(" + n + ") return " + string);
        }
        return string;
    }

    public String getNamespaceURI(int n) {
        if (this.debug) {
            System.out.println("->getNamespaceURI(int)");
        }
        return super.getNamespaceURI(n);
    }

    public int getEventType() {
        int n;
        int n2 = n = this.playback ? this.queuedEvent.getEventType() : super.getEventType();
        if (this.debug) {
            System.out.println("->getEventType: " + this.type2Str(n));
        }
        return n;
    }

    public String getText() {
        if (this.debug) {
            System.out.println("->getText");
        }
        if (this.playback) {
            return new String(this.getTextCharacters());
        }
        return super.getText();
    }

    public int getTextCharacters(int n, char[] cArray, int n2, int n3) throws XMLStreamException {
        throw new UnsupportedOperationException();
    }

    public int getTextStart() {
        if (this.debug) {
            System.out.println("->getTextStart");
        }
        return super.getTextStart();
    }

    public int getTextLength() {
        if (this.debug) {
            System.out.println("->getTextLength playback=" + this.playback + " queuedEvent=" + this.queuedEvent);
        }
        return this.getTextCharacters().length;
    }

    public String getEncoding() {
        if (this.debug) {
            System.out.println("->getEncoding");
        }
        return super.getEncoding();
    }

    public boolean hasText() {
        if (this.debug) {
            System.out.println("->hasText");
        }
        if (this.playback) {
            return this.queuedEvent.getEventType() == 4 || this.queuedEvent.getEventType() == 6 || this.queuedEvent.getEventType() == 11 || this.queuedEvent.getEventType() == 9 || this.queuedEvent.getEventType() == 5;
        }
        return super.hasText();
    }

    public Location getLocation() {
        Location location;
        Location location2 = this.getEventType() == 8 ? this.top.getLocation() : (location = this.playback ? this.top.getLocation() : new MyLocation(super.getLocation()));
        if (!this.playback && this.top != null) {
            this.top.setLocation(location);
        }
        if (this.debug) {
            System.out.println("->getLocation: " + location);
        }
        return location;
    }

    public QName getName() {
        if (this.debug) {
            System.out.println("->getName");
        }
        if (this.playback) {
            return new QName(this.getNamespaceURI(), this.getLocalName());
        }
        return super.getName();
    }

    public boolean hasName() {
        if (this.debug) {
            System.out.println("->hasName");
        }
        if (this.playback) {
            return this.queuedEvent.getEventType() == 1 || this.queuedEvent.getEventType() == 2;
        }
        return super.hasName();
    }

    public String getPrefix() {
        if (this.debug) {
            System.out.println("->getPrefix");
        }
        return super.getPrefix();
    }

    public String getVersion() {
        if (this.debug) {
            System.out.println("->getVersion");
        }
        return super.getVersion();
    }

    public boolean isStandalone() {
        if (this.debug) {
            System.out.println("->isStandalone");
        }
        return super.isStandalone();
    }

    public boolean standaloneSet() {
        if (this.debug) {
            System.out.println("->standaloneSet");
        }
        return super.standaloneSet();
    }

    public String getCharacterEncodingScheme() {
        if (this.debug) {
            System.out.println("->getCharacterEncodingScheme");
        }
        return super.getCharacterEncodingScheme();
    }

    public String getPITarget() {
        if (this.debug) {
            System.out.println("->getPITarget");
        }
        return super.getPITarget();
    }

    public String getPIData() {
        if (this.debug) {
            System.out.println("->getPIData");
        }
        return super.getPIData();
    }

    public Object getProperty(String string) {
        if (this.debug) {
            System.out.println("->getProperty");
        }
        return super.getProperty(string);
    }

    private void initValueTable(final DeploymentPlanBean deploymentPlanBean, String string, String string2) {
        if (deploymentPlanBean == null || string == null || string2 == null) {
            return;
        }
        boolean bl = false;
        ModuleOverrideBean[] moduleOverrideBeanArray = deploymentPlanBean.getModuleOverrides();
        for (int i = 0; i < moduleOverrideBeanArray.length; ++i) {
            if (this.debug) {
                System.out.println("initValueTable: mos[i].getModuleType() = " + moduleOverrideBeanArray[i].getModuleType() + ",\n mos[i].getModuleName() = " + moduleOverrideBeanArray[i].getModuleName());
            }
            if (!moduleOverrideBeanArray[i].getModuleName().equals(string)) continue;
            ModuleDescriptorBean[] moduleDescriptorBeanArray = moduleOverrideBeanArray[i].getModuleDescriptors();
            for (int j = 0; j < moduleDescriptorBeanArray.length; ++j) {
                if (!moduleDescriptorBeanArray[j].getUri().equals(string2)) continue;
                bl = true;
                VariableAssignmentBean[] variableAssignmentBeanArray = moduleDescriptorBeanArray[j].getVariableAssignments();
                if (this.debug) {
                    System.out.println("initValueTable: vabs.length = " + variableAssignmentBeanArray.length);
                }
                for (int k = 0; k < variableAssignmentBeanArray.length; ++k) {
                    if (this.debug) {
                        System.out.println("initValueTable: " + variableAssignmentBeanArray[k].getXpath() + ", " + variableAssignmentBeanArray[k].getName());
                    }
                    VariableAssignment variableAssignment = new VariableAssignment((String)this.getSymbolTable(deploymentPlanBean).get(variableAssignmentBeanArray[k].getName()), variableAssignmentBeanArray[k].getOperation());
                    this.getValueTable().put(variableAssignmentBeanArray[k].getXpath(), variableAssignment);
                    this.getLocationTable().put(variableAssignmentBeanArray[k].getXpath(), new Location(){

                        public int getLineNumber() {
                            return 0;
                        }

                        public int getColumnNumber() {
                            return 0;
                        }

                        public int getCharacterOffset() {
                            return 0;
                        }

                        public String getPublicId() {
                            return deploymentPlanBean.getConfigRoot() + "plan.xml";
                        }

                        public String getSystemId() {
                            return this.getPublicId();
                        }
                    });
                }
            }
            if (!this.debug) continue;
            System.out.println("\n");
        }
        if (bl) {
            J2EELogger.logValidPlanMerged((String)string, (String)string2);
            if (this.debug) {
                try {
                    ((DescriptorBean)deploymentPlanBean).getDescriptor().toXML((OutputStream)System.out);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
    }

    private HashMap getValueTable() {
        if (this.valueTable == null) {
            this.valueTable = new LinkedHashMap();
        }
        return this.valueTable;
    }

    private HashMap getSymbolTable(DeploymentPlanBean deploymentPlanBean) {
        if (this.symbolTable == null) {
            this.symbolTable = new HashMap();
            VariableDefinitionBean variableDefinitionBean = deploymentPlanBean.getVariableDefinition();
            VariableBean[] variableBeanArray = variableDefinitionBean.getVariables();
            for (int i = 0; i < variableBeanArray.length; ++i) {
                if (this.debug) {
                    System.out.println("getSymbolTable: " + variableBeanArray[i].getName() + ", " + variableBeanArray[i].getValue());
                }
                this.symbolTable.put(variableBeanArray[i].getName(), variableBeanArray[i].getValue());
            }
        }
        return this.symbolTable;
    }

    private HashMap getLocationTable() {
        if (this.locationTable == null) {
            this.locationTable = new HashMap();
        }
        return this.locationTable;
    }

    private void initKeyedParentToPath(ReaderEvent readerEvent) {
        for (ReaderEvent readerEvent2 : readerEvent.getChildren()) {
            if (readerEvent2.isDiscarded()) continue;
            if (readerEvent2.isKey() || readerEvent2.isKeyComponent()) {
                if (readerEvent2.getParent().getParentReaderEvent() == null || readerEvent2.getAttributeCount() == 1) {
                    this.parentToPath.put(readerEvent2, readerEvent2.getPath());
                } else {
                    this.parentToPath.put(readerEvent2.getParent(), readerEvent2.getPath());
                }
            }
            if (readerEvent2.getChildren() == null) continue;
            this.initKeyedParentToPath(readerEvent2);
        }
    }

    private void initParentToPath(ReaderEvent readerEvent) {
        for (ReaderEvent readerEvent2 : readerEvent.getChildren()) {
            if (readerEvent2.isDiscarded()) continue;
            if (readerEvent2.getParent().getParentReaderEvent() == null) {
                this.parentToPath.put(readerEvent2, readerEvent2.getPath());
            } else {
                this.parentToPath.put(readerEvent2.getParent(), readerEvent2.getPath());
            }
            if (readerEvent2.getChildren() == null) continue;
            this.initParentToPath(readerEvent2);
        }
    }

    private void initPathToParent(ReaderEvent readerEvent) {
        for (ReaderEvent readerEvent2 : readerEvent.getChildren()) {
            if (readerEvent2.isDiscarded()) continue;
            if (readerEvent2.isKey() || readerEvent2.isKeyComponent()) {
                if (readerEvent2.isKeyAnAttribute()) {
                    this.pathToParent.put(readerEvent2.getPath(), readerEvent2);
                } else if (readerEvent2.getParent().getParentReaderEvent() == null) {
                    this.pathToParent.put(readerEvent2.getPath(), readerEvent2);
                } else {
                    this.pathToParent.put(readerEvent2.getPath(), readerEvent2.getParent());
                }
            }
            if (readerEvent2.getChildren() == null) continue;
            this.initPathToParent(readerEvent2);
        }
    }

    private void replaceMatchingXpathsByKey(ReaderEvent readerEvent, boolean bl) {
        for (ReaderEvent readerEvent2 : (Collection)readerEvent.getChildren().clone()) {
            if (readerEvent2.isDiscarded()) continue;
            String string = (String)this.parentToPath.get(readerEvent2);
            if (this.debug || this.merge) {
                System.out.println("targetChild = " + readerEvent2 + ", path = " + readerEvent2.getPath() + ", paretnToPath() = " + string);
            }
            if (string != null) {
                ReaderEvent readerEvent3 = (ReaderEvent)this.pathToParent.get(string);
                if (readerEvent3 != null && readerEvent2.hasBeanCompositeKey() && !ReaderEvent.compareKeys(readerEvent2.getBeanCompositeKey(), readerEvent3.getBeanCompositeKey(readerEvent2.getBean()._getSchemaHelper2())) || (readerEvent3 = (ReaderEvent)this.pathToParent.remove(string)) == null || readerEvent3.isDiscarded()) continue;
                if (this.debug || this.merge) {
                    System.out.println("replaceMatchingXpathsByKey.path = " + string);
                    System.out.println("source = " + readerEvent3);
                }
                if (readerEvent3 != null) {
                    Object object;
                    if (this.debug || this.merge) {
                        System.out.println("replaceMatchingXpathsByKey.source = " + readerEvent3);
                        System.out.println("replaceMatchingXpathsByKey.source.getParent() = " + readerEvent3.getParent().getPath());
                    }
                    readerEvent3.getParent().getChildren().remove(readerEvent3);
                    if (readerEvent3.getParent().getChildren().empty()) {
                        for (object = readerEvent3; object != null && ((ReaderEvent)object).getParent() != null && ((ReaderEvent)object).getParent().getChildren() != null && ((ReaderEvent)object).getParent().getChildren().empty(); object = ((ReaderEvent)object).getParent()) {
                            ((ReaderEvent)object).getParent().setDiscard();
                        }
                    }
                    if (this.debug || this.merge) {
                        System.out.println("replaceMatchingXpathsByKey.targetChild.getParent() = " + readerEvent2.getParent().getPath());
                        System.out.println("replaceMatchingXpathsByKey.targetChild() = " + readerEvent2.getPath());
                        System.out.println("before...");
                        object = readerEvent2.getChildren().iterator();
                        while (object.hasNext()) {
                            System.out.println("targetChild.child = " + ((ReaderEvent)object.next()).getPath());
                        }
                    }
                    if (bl) {
                        this.mergeSiblings(readerEvent3, readerEvent2, bl);
                    }
                    readerEvent3.fixParents(readerEvent2.getParent());
                    if (readerEvent3.getBean() == null) {
                        readerEvent3.setBean(readerEvent2.getBean());
                    }
                    readerEvent.getChildren().set(readerEvent.getChildren().indexOf(readerEvent2), readerEvent3);
                    if (bl) continue;
                    readerEvent2.discard();
                    continue;
                }
            }
            if (readerEvent2.getChildren() == null || readerEvent2.getChildren().size() <= 0) continue;
            this.replaceMatchingXpathsByKey(readerEvent2, bl);
        }
    }

    private boolean mergeSiblings(ReaderEvent readerEvent, ReaderEvent readerEvent2, boolean bl) {
        if (this.merge) {
            System.out.println("mergeSiblings(begin)... source");
            readerEvent.toXML(System.out);
            System.out.println("mergeSiblings(begin)... targetChild");
            readerEvent2.toXML(System.out);
        }
        if (readerEvent.getBean() == null) {
            readerEvent.setBean(readerEvent2.getBean());
        }
        SchemaHelper schemaHelper = readerEvent2.getBean() == null ? readerEvent2.getSchemaHelper() : readerEvent2.getBean()._getSchemaHelper2();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        Object object = ((Collection)readerEvent.getChildren().clone()).iterator();
        while (object.hasNext()) {
            Object object2;
            Object object3 = (ReaderEvent)object.next();
            int n = ((ReaderEvent)object3).getOperation();
            if (n == 3 || n == 2) {
                readerEvent2.removeNamedChildren(((ReaderEvent)object3).getLocalName());
            }
            if (n == 2) {
                readerEvent.getChildren().remove(object3);
            }
            if (n == 3 && ((ReaderEvent)object3).isBeanKey(schemaHelper) && !((ReaderEvent)object3).isKey() && hashMap.containsKey(((ReaderEvent)object3).getLocalName())) {
                readerEvent.getChildren().remove(hashMap.get(((ReaderEvent)object3).getLocalName()));
                ((ReaderEvent)object3).setOperation(-1);
            }
            if (((ReaderEvent)object3).isBeanKey(schemaHelper) && (!bl || n != 3)) {
                object2 = readerEvent2.getBeanKey(schemaHelper);
                if (!ReaderEvent.compareKeys(((ReaderEvent)object3).getCharactersAsString(), object2) && !ReaderEvent.compareKeys(this.trimWS(((ReaderEvent)object3).getCharactersAsString()), this.trimWS(object2))) {
                    if (this.merge) {
                        System.out.println("mergeSiblings... Refusal to merge, keys different: " + ((ReaderEvent)object3).getElementName() + " values " + ((ReaderEvent)object3).getCharactersAsString() + ", " + object2);
                    }
                    return false;
                }
            }
            if (hashMap.containsKey(((ReaderEvent)object3).getLocalName())) {
                object2 = ((ReaderEvent)object3).getLocalName();
                hashMap.remove(((ReaderEvent)object3).getLocalName());
                while (object.hasNext() && ((ReaderEvent)(object3 = (ReaderEvent)object.next())).getLocalName().equals(object2)) {
                }
                if (!object.hasNext()) break;
            }
            hashMap.put(((ReaderEvent)object3).getLocalName(), object3);
        }
        object = new ArrayList();
        for (ReaderEvent readerEvent3 : readerEvent2.getChildren()) {
            if (readerEvent3.isDiscarded()) continue;
            if (hashMap.remove(readerEvent3.getLocalName()) != null) {
                if (schemaHelper == null) {
                    System.out.println("no helper... continue");
                    continue;
                }
                int n = schemaHelper.getPropertyIndex(readerEvent3.getElementName());
                if (!schemaHelper.isBean(n) && !schemaHelper.isArray(n)) continue;
            }
            boolean bl2 = false;
            for (ReaderEvent readerEvent4 : readerEvent.getChildren()) {
                if (!readerEvent4.getLocalName().equals(readerEvent3.getLocalName()) || schemaHelper == null) continue;
                int n = schemaHelper.getPropertyIndex(readerEvent4.getElementName());
                if (schemaHelper.isBean(n)) {
                    if (readerEvent4.getChildren().size() > 0) {
                        if (!this.mergeSiblings(readerEvent4, readerEvent3, bl)) continue;
                        bl2 = true;
                        continue;
                    }
                    if (!this.merge) continue;
                    System.out.println("mergeSiblings(end)... source empty, nothing to merge");
                    continue;
                }
                if (!readerEvent4.isSingleton()) continue;
                bl2 = true;
            }
            if (bl2) continue;
            object.add(readerEvent3);
        }
        if (object.size() > 0) {
            readerEvent.getChildren().addAll(object);
        }
        if (this.merge) {
            System.out.println("mergeSiblings(end)... source");
            readerEvent.toXML(System.out);
            System.out.println("mergeSiblings(end)... targetChild");
            readerEvent2.toXML(System.out);
        }
        return true;
    }

    private void replaceMatchingXpaths(ReaderEvent readerEvent, boolean bl) {
        if (readerEvent.isDiscarded() || this.parentToPath.size() <= 0) {
            return;
        }
        String string = readerEvent.getPath();
        for (Map.Entry entry : this.parentToPath.entrySet()) {
            ReaderEvent readerEvent2 = (ReaderEvent)entry.getKey();
            String string2 = readerEvent2.getPath();
            if (string.compareTo(string2) != 0) continue;
            if (this.debug || this.merge) {
                System.out.println(".. matched " + string);
            }
            if (!this.mergeSiblings(readerEvent2, readerEvent, bl)) continue;
            readerEvent.replaceAndMoveChildren(readerEvent2);
            this.pathToParent.remove(readerEvent2);
            return;
        }
        for (int i = 0; i < readerEvent.getChildren().size(); ++i) {
            Map.Entry entry;
            entry = (ReaderEvent)readerEvent.getChildren().elementAt(i);
            this.replaceMatchingXpaths((ReaderEvent)((Object)entry), bl);
        }
    }

    private ReaderEvent scanForSiblingReaderEvent(ReaderEvent readerEvent, ReaderEvent readerEvent2) {
        ReaderEvent readerEvent32 = readerEvent;
        for (ReaderEvent readerEvent32 : readerEvent.getChildren()) {
            if (this.debug || this.merge) {
                System.out.println("compare sibling [" + readerEvent32.getLocalName() + "] to [" + readerEvent2.getLocalName() + "]");
            }
            if (readerEvent32.getLocalName().equals(readerEvent2.getLocalName()) && this.pathsMatch(readerEvent32, readerEvent2)) {
                return readerEvent32;
            }
            if (readerEvent32.getChildren() == null) continue;
            readerEvent32 = this.scanForSiblingReaderEvent(readerEvent32, readerEvent2);
        }
        return readerEvent32;
    }

    private void adoptUnmatchedReaderEvents(ReaderEvent readerEvent) {
        for (ReaderEvent readerEvent2 : readerEvent.getChildren()) {
            if (readerEvent2.isDiscarded()) continue;
            boolean bl = true;
            if (readerEvent2.isSingleton()) {
                for (ReaderEvent readerEvent3 : this.root.getChildren()) {
                    if (readerEvent3.getLocalName() == null || readerEvent2.getLocalName() == null || !readerEvent3.getLocalName().equals(readerEvent2.getLocalName())) continue;
                    readerEvent2.fixParents(this.root);
                    readerEvent2.discard();
                    readerEvent3.getChildren().addAll(readerEvent2.getChildren());
                    bl = false;
                    break;
                }
            }
            if (readerEvent2.isAdditive()) {
                for (ReaderEvent readerEvent3 : this.root.getChildren()) {
                    if (!readerEvent3.getLocalName().equals(readerEvent2.getLocalName())) continue;
                    ReaderEvent readerEvent4 = readerEvent2;
                    readerEvent4.fixParents(readerEvent3.getParentReaderEvent());
                    this.root.getChildren().set(this.root.getChildren().indexOf(readerEvent3), readerEvent4);
                    bl = false;
                    break;
                }
            }
            if (!bl) continue;
            readerEvent2.fixParents(this.root);
            this.root.getChildren().add(readerEvent2);
        }
    }

    private void resetDescriptor(AbstractDescriptorLoader abstractDescriptorLoader, Descriptor descriptor) throws IOException, XMLStreamException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        abstractDescriptorLoader.getDescriptorManager().writeDescriptorAsXML(descriptor, (OutputStream)byteArrayOutputStream);
        byte[] byArray = byteArrayOutputStream.toByteArray();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        BasicMunger basicMunger = abstractDescriptorLoader.createXMLStreamReader(byteArrayInputStream);
        abstractDescriptorLoader.getDescriptorManager().createDescriptor((XMLStreamReader)basicMunger);
        this.root = basicMunger.root;
        this.top = basicMunger.top;
        this.stack = basicMunger.stack;
        this.descriptor = basicMunger.descriptor;
    }

    private boolean pathsMatch(ReaderEvent readerEvent, ReaderEvent readerEvent2) {
        while (readerEvent != null && readerEvent2 != null && readerEvent.getEventType() != 7 && readerEvent2.getEventType() != 7) {
            String string;
            String string2 = readerEvent == null ? "" : readerEvent.getLocalName();
            String string3 = string = readerEvent2 == null ? "" : readerEvent2.getLocalName();
            if (!string2.equals(string)) {
                return false;
            }
            readerEvent = readerEvent.getParent();
            readerEvent2 = readerEvent2.getParent();
        }
        return !(readerEvent == null && readerEvent2 != null || readerEvent != null && readerEvent2 == null) && readerEvent.getEventType() == readerEvent2.getEventType();
    }

    protected String type2Str(int n) {
        switch (n) {
            case 1: {
                return "START_ELEMENT[" + this.getLocalName() + "]";
            }
            case 2: {
                return "END_ELEMENT[" + this.getLocalName() + "]";
            }
            case 3: {
                return "PROCESSING_INSTRUCTION";
            }
            case 4: {
                return "CHARACTERS: [" + new String(this.getTextCharacters()) + "]";
            }
            case 5: {
                return "COMMENT";
            }
            case 6: {
                return "SPACE[6]";
            }
            case 7: {
                return "START_DOCUMENT[7]";
            }
            case 8: {
                return "END_DOCUMENT[8]";
            }
            case 9: {
                return "ENTITY_REFERENCE[9]";
            }
            case 10: {
                return "ATTRIBUTE";
            }
            case 11: {
                return "DTD";
            }
            case 12: {
                return "CDATA[12]";
            }
            case 13: {
                return "NAMESPACE[13]";
            }
            case 14: {
                return "NOTATION_DECLARATION";
            }
            case 15: {
                return "ENTITY_DECLARATION";
            }
        }
        throw new AssertionError((Object)("Unexpected type " + n));
    }

    private void dumpStartMerge(ReaderEvent readerEvent) {
        System.out.println("BasicMunger: start merge...");
        System.out.println("BasicMunger: current ReaderEvent: = ");
        this.root.toXML(System.out);
        this.dumpParent2Path();
        System.out.println("-----------");
        System.out.println("BasicMunger: ReaderEvent to merge into current: = ");
        readerEvent.toXML(System.out);
        this.dumpPath2Parents();
        System.out.println("-----------");
        System.out.println("BasicMunger: ... continue merge...");
    }

    private void dumpParent2Path() {
        System.out.println("\ndump parentToPath:");
        for (Map.Entry entry : this.parentToPath.entrySet()) {
            ReaderEvent readerEvent = (ReaderEvent)entry.getKey();
            String string = (String)entry.getValue();
            System.out.println("instance = (" + readerEvent + ")=" + readerEvent.getPath() + " mapped to key =" + string);
        }
    }

    private void dumpPath2Parents() {
        System.out.println("\ndump pathToParent:");
        for (Map.Entry entry : this.pathToParent.entrySet()) {
            String string = (String)entry.getKey();
            ReaderEvent readerEvent = (ReaderEvent)entry.getValue();
            System.out.println("key =" + string + " mapped to instance = (" + readerEvent + ")=" + readerEvent.getPath());
        }
    }

    public void setQueuedEvents(ArrayList arrayList) {
        this.queuedEvents = arrayList;
        this.setPlayback(true);
        this.usingDTD = true;
    }

    public void toQueuedEvents(ArrayList arrayList) {
        if (this.descriptor == null) {
            this.root.toQueuedEvents(arrayList);
            return;
        }
        this.root.toQueuedEvents(arrayList);
    }

    public ReaderEvent getQueuedEvent(int n, Object object) {
        return new ReaderEvent(n, object, this.getLocation(), this);
    }

    public boolean supportsValidation() {
        return false;
    }

    private Object trimWS(Object object) {
        int n;
        if (!(object instanceof String)) {
            return object;
        }
        String string = (String)object;
        if (string == null) {
            return string;
        }
        int n2 = 0;
        int n3 = string.length();
        for (n = 0; n < string.length() && Character.isWhitespace(string.charAt(n)); ++n) {
            ++n2;
        }
        for (n = n3; n > 0 && n > n2 && Character.isWhitespace(string.charAt(n - 1)); --n) {
            --n3;
        }
        if (n2 == 0 && n3 == string.length()) {
            return string;
        }
        return string.substring(n2, n3);
    }

    public static class VariableAssignment {
        String name;
        int op;

        public VariableAssignment(String string, String string2) {
            this.name = string;
            this.setOperation(string2);
        }

        public void setOperation(String string) {
            this.op = string.equals("add") ? 1 : (string.equals("remove") ? 2 : (string.equals("replace") ? 3 : -1));
        }

        public String getName() {
            return this.name;
        }

        public int getOperation() {
            return this.op;
        }
    }

    private class MyLocation
    implements Location {
        Location l;

        MyLocation(Location location) {
            this.l = location;
        }

        public int getLineNumber() {
            return this.l.getLineNumber();
        }

        public int getColumnNumber() {
            return this.l.getColumnNumber();
        }

        public int getCharacterOffset() {
            return this.l.getCharacterOffset();
        }

        public String getPublicId() {
            return BasicMunger.this.loader.getAbsolutePath() + ":" + this.l.getLineNumber() + ":" + this.l.getColumnNumber();
        }

        public String getSystemId() {
            return this.l.getSystemId();
        }
    }
}

