/*
 * Decompiled with CFR 0.152.
 */
package weblogic.application.descriptor;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Stack;
import javax.xml.stream.Location;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import weblogic.application.descriptor.AbstractDescriptorLoader2;
import weblogic.application.descriptor.DebugStreamReaderDelegate;
import weblogic.application.descriptor.MissingRootElementException;
import weblogic.application.descriptor.MungerLogger;
import weblogic.application.descriptor.PlaybackReader;
import weblogic.application.descriptor.ReaderEvent2;
import weblogic.application.descriptor.ReaderEventInfo;
import weblogic.application.descriptor.Utils;
import weblogic.application.descriptor.VariableAssignment;
import weblogic.descriptor.BeanCreationInterceptor;
import weblogic.descriptor.DescriptorBean;
import weblogic.descriptor.DescriptorException;
import weblogic.descriptor.DescriptorManager;
import weblogic.descriptor.internal.AbstractDescriptorBean;
import weblogic.descriptor.internal.SchemaHelper;
import weblogic.j2ee.J2EELogger;
import weblogic.j2ee.descriptor.wl.DeploymentPlanBean;
import weblogic.j2ee.descriptor.wl.ModuleDescriptorBean;
import weblogic.j2ee.descriptor.wl.ModuleOverrideBean;
import weblogic.j2ee.descriptor.wl.VariableAssignmentBean;
import weblogic.j2ee.descriptor.wl.VariableBean;
import weblogic.j2ee.descriptor.wl.VariableDefinitionBean;
import weblogic.logging.Loggable;
import weblogic.utils.Debug;
import weblogic.utils.StackTraceUtils;
import weblogic.utils.io.UnsyncByteArrayOutputStream;

public class BasicMunger2
extends DebugStreamReaderDelegate
implements BeanCreationInterceptor {
    protected boolean debug = Debug.getCategory((String)"weblogic.descriptor.munger").isEnabled();
    protected boolean merge = Debug.getCategory((String)"weblogic.descriptor.merge").isEnabled();
    protected boolean dbgValue = Debug.getCategory((String)"weblogic.descriptor.valuetable").isEnabled();
    protected static final XMLInputFactory xiFactory = XMLInputFactory.newInstance();
    private boolean hasDTD = false;
    private String dtdNamespaceURI;
    protected ReaderEvent2 root;
    protected ReaderEvent2 currentEvent;
    protected Stack helpers = new Stack();
    protected Stack helperScopedNames = new Stack();
    private InputStream in;
    private String absolutePath;
    protected String versionInfo;
    protected boolean disableReorder;
    private static final String TRUE_STR = "true";
    private static final String FALSE_STR = "false";
    HashMap valueTable;
    HashMap locationTable;
    HashMap symbolTable;

    public BasicMunger2(InputStream inputStream, String string) throws XMLStreamException {
        super(xiFactory.createXMLStreamReader(inputStream));
        this.in = inputStream;
        this.absolutePath = string;
        Location location = super.getLocation();
        this.currentEvent = this.root = new ReaderEvent2(7, new MyLocation(location));
    }

    public BasicMunger2(InputStream inputStream, AbstractDescriptorLoader2 abstractDescriptorLoader2) throws XMLStreamException {
        this(inputStream, abstractDescriptorLoader2.getAbsolutePath());
        this.initValueTable(abstractDescriptorLoader2.getDeploymentPlan(), abstractDescriptorLoader2.getModuleName(), abstractDescriptorLoader2.getDocumentURI());
    }

    String getAbsolutePath() {
        return this.absolutePath;
    }

    public ReaderEvent2 getCurrentEvent() {
        return this.currentEvent;
    }

    public String getDtdNamespaceURI() {
        return null;
    }

    public boolean hasDTD() {
        return this.hasDTD;
    }

    public PlaybackReader getPlaybackReader() throws XMLStreamException {
        PlaybackReader playbackReader = new PlaybackReader(this.root, this.getAbsolutePath());
        if (this.hasDTD()) {
            playbackReader.setDtdNamespaceURI(this.getDtdNamespaceURI());
        }
        return playbackReader;
    }

    public void initDtdText(String string) {
    }

    public void toXML(PrintStream printStream) {
        this.root.toXML(printStream);
    }

    public void logError(List list) {
        if (list.isEmpty()) {
            return;
        }
        J2EELogger.logDescriptorParseError((String)StackTraceUtils.throwable2StackTrace((Throwable)new DescriptorException("VALIDATION PROBLEMS WERE FOUND FOR: " + this.getAbsolutePath(), list)));
    }

    protected void setNamespace(String string, String string2, ReaderEvent2 readerEvent2) {
        ReaderEventInfo readerEventInfo = readerEvent2.getReaderEventInfo();
        if (string != null) {
            readerEventInfo.setPrefix(string);
        }
        readerEventInfo.setNamespaceCount(1);
        readerEventInfo.setNamespaceURI(string, string2);
        for (ReaderEvent2 readerEvent22 : readerEvent2.getChildren()) {
            ReaderEventInfo readerEventInfo2 = readerEvent22.getReaderEventInfo();
            if (string != null) {
                readerEventInfo2.setPrefix(string);
            }
            readerEventInfo2.setNamespaceCount(1);
            readerEventInfo2.setNamespaceURI(string, string2);
        }
    }

    public PlaybackReader merge(BasicMunger2 basicMunger2, DescriptorBean descriptorBean) throws XMLStreamException {
        String string = this.getPrefix();
        String string2 = this.getNamespaceURI();
        this.root.merge(basicMunger2.root, -1, false);
        this.root.orderChildren();
        this.setNamespace(string, string2, this.root);
        return new PlaybackReader(this.root, this.getAbsolutePath());
    }

    private String checkNewBeanCreationPattern(String string) {
        int n = string.lastIndexOf("]");
        if (n == -1) {
            return string;
        }
        int n2 = string.lastIndexOf("[");
        int n3 = string.lastIndexOf("/");
        String string2 = string.substring(n3 + 1, string.length());
        String string3 = string.substring(n2 + 1, n);
        if (string3.indexOf(string2 + "=") != -1) {
            return string.substring(0, n3 + 1);
        }
        return string;
    }

    public PlaybackReader mergeDescriptorBeanWithPlan(DescriptorBean descriptorBean) throws XMLStreamException {
        Object object;
        ArrayList<ReaderEventOperation> arrayList = new ArrayList<ReaderEventOperation>();
        if (this.valueTable == null) {
            return new PlaybackReader(this.root, this.getAbsolutePath());
        }
        for (Map.Entry object2 : this.valueTable.entrySet()) {
            String string = (String)object2.getKey();
            object = (VariableAssignment)object2.getValue();
            String string2 = ((VariableAssignment)object).getName();
            int n = ((VariableAssignment)object).getOperation();
            if (string2 == null) continue;
            String string3 = string;
            String string4 = this.checkNewBeanCreationPattern(string);
            SchemaHelper schemaHelper = this.root.findRootSchemaHelper();
            ReaderEvent2 readerEvent2 = new ReaderEvent2(7, (Location)this.getLocationTable().get(string3));
            ReaderEvent2 readerEvent22 = new ReaderEvent2(new StringBuffer(string4), readerEvent2, schemaHelper, string2, (Location)this.getLocationTable().get(string3));
            readerEvent2.getChildren().add(readerEvent22);
            arrayList.add(new ReaderEventOperation(readerEvent22, n));
        }
        SchemaHelper schemaHelper = this.root.findRootSchemaHelper();
        for (ReaderEventOperation readerEventOperation : arrayList) {
            object = readerEventOperation.getReaderEvent();
            int n = readerEventOperation.getOperation();
            ((ReaderEvent2)object).validate(schemaHelper);
            if (this.merge) {
                System.out.println("\nBasicMunger: ReaderEvent to merge into root from plan: ");
                ((ReaderEvent2)object).toXML(System.out);
                System.out.println("----------- end ReaderEvent --------");
            }
            this.root.merge(((ReaderEvent2)object).getParent(), n, true);
            if (!this.merge) continue;
            System.out.println("\nBasicMunger: root ReaderEvent after merge from plan: ");
            this.root.toXML(System.out);
            System.out.println("----------- end ReaderEvent --------");
        }
        this.root.orderChildren();
        return new PlaybackReader(this.root, this.getAbsolutePath());
    }

    private void dump(ReaderEvent2 readerEvent2) {
        System.out.println("****** root Element name " + readerEvent2.getElementName() + " size of children " + readerEvent2.getChildren().size());
        for (ReaderEvent2 readerEvent22 : readerEvent2.getChildren()) {
            switch (readerEvent22.getEventType()) {
                case 5: 
                case 11: {
                    break;
                }
                case 1: {
                    System.out.println("*** child " + readerEvent22.getElementName() + " child.getXpath() " + readerEvent22.getXpath());
                    this.dump(readerEvent22);
                }
            }
        }
    }

    public PlaybackReader mergeDescriptorBeanWithPlan(DeploymentPlanBean deploymentPlanBean, String string, String string2) throws XMLStreamException {
        this.initValueTable(deploymentPlanBean, string, string2);
        return this.mergeDescriptorBeanWithPlan(null);
    }

    public DescriptorBean beanCreated(DescriptorBean descriptorBean, DescriptorBean descriptorBean2) {
        SchemaHelper schemaHelper = ((AbstractDescriptorBean)descriptorBean)._getSchemaHelper2();
        this.currentEvent.setSchemaHelper(schemaHelper);
        this.helpers.push(schemaHelper);
        this.helperScopedNames.push(this.getLocalName());
        if (this.debug) {
            System.out.println("   set schema helper for: " + this.currentEvent.getSchemaHelper());
        }
        return descriptorBean;
    }

    String getHelperScopedNames() {
        return (String)this.helperScopedNames.peek();
    }

    protected SchemaHelper getTopLevelSchemaHelper() {
        return null;
    }

    public void close() throws XMLStreamException {
        super.close();
        if (this.in != null) {
            try {
                this.in.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.in = null;
    }

    public Location getLocation() {
        MyLocation myLocation = new MyLocation(super.getLocation());
        if (this.debug) {
            System.out.println("->getLocation: " + myLocation);
        }
        return myLocation;
    }

    public int next() throws XMLStreamException {
        int n = super.next();
        if (this.debug) {
            System.out.println("->next = " + Utils.type2Str(n, this));
        }
        switch (n) {
            case 11: {
                this._onDTD();
                n = this.next();
                break;
            }
            case 1: {
                this._onStartElement();
                break;
            }
            case 4: {
                this._onCharacters();
                break;
            }
            case 5: {
                this._onComment();
                break;
            }
            case 2: {
                this._onEndElement();
                break;
            }
            case 8: {
                this._onEndDocument();
                break;
            }
        }
        return n;
    }

    private void _onDTD() {
        this.hasDTD = true;
        this.versionInfo = "DTD";
        this.initDtdText(this.getText());
    }

    private void _onStartElement() {
        int n;
        int n2;
        Object object;
        ReaderEvent2 readerEvent2 = new ReaderEvent2(this.getEventType(), this.getLocalName(), this.currentEvent, super.getLocation());
        String string = this.getCharacterEncodingScheme();
        if (string != null) {
            readerEvent2.getReaderEventInfo().setCharacterEncodingScheme(string.toUpperCase(Locale.US));
        }
        if (this.getTopLevelSchemaHelper() != null) {
            if (readerEvent2.getElementName().equals(this.getTopLevelSchemaHelper().getRootElementName())) {
                readerEvent2.setSchemaHelper(this.getTopLevelSchemaHelper());
                this.currentEvent.addChild(readerEvent2);
            } else {
                object = this.currentEvent;
                SchemaHelper schemaHelper = this.currentEvent.helper;
                if (this.debug) {
                    System.out.println("using parent [" + ((ReaderEvent2)object).getElementName() + "] to set helper for " + readerEvent2.getElementName() + " to " + schemaHelper);
                }
                try {
                    n2 = schemaHelper.getPropertyIndex(readerEvent2.getElementName());
                }
                catch (MissingRootElementException missingRootElementException) {
                    Loggable loggable = MungerLogger.logMissingRootElementLoggable((String)this.getTopLevelSchemaHelper().getRootElementName(), (String)this.getAbsolutePath());
                    throw new MissingRootElementException(loggable.getMessage());
                }
                if (this.debug) {
                    System.out.println("helper.getPropertyIndex = " + n2 + " is bean? " + schemaHelper.isBean(n2));
                }
                if (schemaHelper.isBean(n2)) {
                    readerEvent2.setSchemaHelper(schemaHelper.getSchemaHelper(n2));
                } else {
                    readerEvent2.setSchemaHelper(schemaHelper);
                }
                if (n2 >= 0) {
                    n = 1;
                    if (!this.hasDTD() && this.disableReorder) {
                        n = 0;
                    }
                    ((ReaderEvent2)object).adopt(readerEvent2, schemaHelper, n != 0);
                } else {
                    ((ReaderEvent2)object).addChild(readerEvent2);
                }
                if (schemaHelper.isBean(n2)) {
                    readerEvent2.setSchemaHelper(schemaHelper.getSchemaHelper(n2));
                }
            }
        } else {
            this.currentEvent.addChild(readerEvent2);
        }
        this.currentEvent = readerEvent2;
        object = readerEvent2.getReaderEventInfo();
        if (this.getPrefix() != null) {
            ((ReaderEventInfo)object).setPrefix(this.getPrefix());
        }
        if (this.getNamespaceCount() > 0) {
            ((ReaderEventInfo)object).setNamespaceCount(this.getNamespaceCount());
            for (int i = 0; i < this.getNamespaceCount(); ++i) {
                ((ReaderEventInfo)object).setNamespaceURI(this.getNamespacePrefix(i), this.getNamespaceURI(i));
            }
        }
        if (this.getAttributeCount() > 0) {
            ((ReaderEventInfo)object).setAttributeCount(this.getAttributeCount());
            for (int i = 0; i < this.getAttributeCount(); ++i) {
                ((ReaderEventInfo)object).setAttributeValue(this.getAttributeValue(i), this.getAttributeNamespace(i), this.getAttributeLocalName(i));
            }
        }
        String string2 = ((ReaderEventInfo)object).getElementName();
        if (this.getTopLevelSchemaHelper() != null && this.getTopLevelSchemaHelper().getRootElementName().equals(string2) && !this.hasDTD() && ("application".equals(string2) || "web-app".equals(string2) || "ejb-jar".equals(string2) || "application-client".equals(string2) || "webservices".equals(string2) || "persistence".equals(string2))) {
            n2 = ((ReaderEventInfo)object).getAttributeCount();
            String string3 = null;
            boolean bl = false;
            for (n = 0; n < n2 && !bl; ++n) {
                if (!"version".equals(((ReaderEventInfo)object).getAttributeLocalName(n))) continue;
                bl = true;
                string3 = ((ReaderEventInfo)object).getAttributeValue(n);
                if (!this.debug) continue;
                System.out.println("version:  " + string3);
            }
            if (string3 == null) {
                MungerLogger.logMissingVersionAttribute((String)string2, (String)this.getAbsolutePath());
            }
        }
        if (this.debug) {
            System.out.println("++ onStartElement: " + this.getLocalName());
        }
        if (!this.helpers.empty()) {
            this.currentEvent.setSchemaHelper((SchemaHelper)this.helpers.peek());
        }
    }

    private void _onCharacters() {
        String string = super.getText();
        char[] cArray = null;
        if (string != null) {
            cArray = TRUE_STR.equalsIgnoreCase(string.trim()) ? string.toLowerCase(Locale.US).toCharArray() : (FALSE_STR.equalsIgnoreCase(string.trim()) ? string.toLowerCase(Locale.US).toCharArray() : string.toCharArray());
        }
        this.currentEvent.getReaderEventInfo().appendCharacters(cArray);
    }

    private void _onComment() {
        if (!this.isWhiteSpace()) {
            this.currentEvent.getReaderEventInfo().setComments(super.getText());
        }
    }

    private void _onEndElement() {
        if (this.debug) {
            System.out.println("-- onEndElement: local name = " + this.getLocalName());
            System.out.println("  currentEvent.getElementName : " + this.currentEvent.getReaderEventInfo().getElementName());
            System.out.println("  new scope: " + this.currentEvent.getParent());
        }
        if (!this.helperScopedNames.empty() && this.currentEvent.getReaderEventInfo().getElementName().equals(this.helperScopedNames.peek())) {
            this.helperScopedNames.pop();
            if (!this.helpers.empty()) {
                this.helpers.pop();
            }
        }
        this.currentEvent = this.currentEvent.getParent() == null ? this.currentEvent : this.currentEvent.getParent();
    }

    private void _onEndDocument() {
    }

    protected void orderChildren() {
        this.root.orderChildren();
    }

    private void initValueTable(final DeploymentPlanBean deploymentPlanBean, String string, String string2) {
        if (deploymentPlanBean == null || string == null || string2 == null) {
            return;
        }
        boolean bl = false;
        ModuleOverrideBean[] moduleOverrideBeanArray = deploymentPlanBean.getModuleOverrides();
        for (int i = 0; i < moduleOverrideBeanArray.length; ++i) {
            if (this.dbgValue) {
                System.out.println("initValueTable: mos[i].getModuleType() = " + moduleOverrideBeanArray[i].getModuleType() + ",\n mos[i].getModuleName() = " + moduleOverrideBeanArray[i].getModuleName());
            }
            if (!moduleOverrideBeanArray[i].getModuleName().equals(string)) continue;
            ModuleDescriptorBean[] moduleDescriptorBeanArray = moduleOverrideBeanArray[i].getModuleDescriptors();
            for (int j = 0; j < moduleDescriptorBeanArray.length; ++j) {
                if (!moduleDescriptorBeanArray[j].getUri().equals(string2)) continue;
                bl = true;
                VariableAssignmentBean[] variableAssignmentBeanArray = moduleDescriptorBeanArray[j].getVariableAssignments();
                if (this.dbgValue) {
                    System.out.println("initValueTable: vabs.length = " + variableAssignmentBeanArray.length);
                }
                for (int k = 0; k < variableAssignmentBeanArray.length; ++k) {
                    if (this.dbgValue) {
                        System.out.println("initValueTable: " + variableAssignmentBeanArray[k].getXpath() + ", " + variableAssignmentBeanArray[k].getName());
                    }
                    VariableAssignment variableAssignment = new VariableAssignment((String)this.getSymbolTable(deploymentPlanBean).get(variableAssignmentBeanArray[k].getName()), variableAssignmentBeanArray[k].getOperation());
                    this.getValueTable().put(variableAssignmentBeanArray[k].getXpath(), variableAssignment);
                    this.getLocationTable().put(variableAssignmentBeanArray[k].getXpath(), new Location(){

                        public int getLineNumber() {
                            return 0;
                        }

                        public int getColumnNumber() {
                            return 0;
                        }

                        public int getCharacterOffset() {
                            return 0;
                        }

                        public String getPublicId() {
                            return deploymentPlanBean.getConfigRoot() + "plan.xml";
                        }

                        public String getSystemId() {
                            return this.getPublicId();
                        }
                    });
                }
            }
            if (!this.dbgValue) continue;
            System.out.println("\n");
        }
        if (bl) {
            J2EELogger.logValidPlanMerged((String)string, (String)string2);
            if (this.dbgValue) {
                try {
                    ((DescriptorBean)deploymentPlanBean).getDescriptor().toXML((OutputStream)System.out);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
    }

    private HashMap getValueTable() {
        if (this.valueTable == null) {
            this.valueTable = new LinkedHashMap();
        }
        return this.valueTable;
    }

    private HashMap getSymbolTable(DeploymentPlanBean deploymentPlanBean) {
        if (this.symbolTable == null) {
            this.symbolTable = new HashMap();
            VariableDefinitionBean variableDefinitionBean = deploymentPlanBean.getVariableDefinition();
            VariableBean[] variableBeanArray = variableDefinitionBean.getVariables();
            for (int i = 0; i < variableBeanArray.length; ++i) {
                if (this.dbgValue) {
                    System.out.println("getSymbolTable: " + variableBeanArray[i].getName() + ", " + variableBeanArray[i].getValue());
                }
                this.symbolTable.put(variableBeanArray[i].getName(), variableBeanArray[i].getValue());
            }
        }
        return this.symbolTable;
    }

    private HashMap getLocationTable() {
        if (this.locationTable == null) {
            this.locationTable = new HashMap();
        }
        return this.locationTable;
    }

    String getVersionInfo() {
        return this.versionInfo;
    }

    public static void main(String[] stringArray) throws Exception {
        Object object;
        Location location = new Location(){

            public int getLineNumber() {
                return 0;
            }

            public int getColumnNumber() {
                return 0;
            }

            public int getCharacterOffset() {
                return 0;
            }

            public String getPublicId() {
                return "<no public id>";
            }

            public String getSystemId() {
                return "<no system id>";
            }
        };
        StringBuffer stringBuffer = new StringBuffer("/weblogic-connector xmlns=\"http://www.bea.com/ns/weblogic/90\"/outbound-resource-adapter/connection-definition-group/[connection-factory-interface=\"javax.sql.DataSource\"]/connection-instance/jndi-name");
        System.out.print("\nxpath = " + stringBuffer + "\nresults in:\n");
        UnsyncByteArrayOutputStream unsyncByteArrayOutputStream = new UnsyncByteArrayOutputStream();
        new ReaderEvent2(stringBuffer, new ReaderEvent2(7, location), null, "val1", location).toXML(new PrintStream((OutputStream)unsyncByteArrayOutputStream));
        byte[] byArray = unsyncByteArrayOutputStream.toRawBytes();
        InputStream inputStream = null;
        String string = null;
        if (stringArray.length == 0) {
            inputStream = new ByteArrayInputStream(byArray);
            string = "local buff";
        } else {
            object = new File(stringArray[0]);
            inputStream = new FileInputStream((File)object);
            string = stringArray[0];
        }
        System.out.println("stamp out munger...");
        System.out.flush();
        object = new BasicMunger2(inputStream, string);
        System.out.println("hand munger to descriptor manger...");
        System.out.flush();
        new DescriptorManager().createDescriptor((XMLStreamReader)object).toXML((OutputStream)System.out);
    }

    private static void usage() {
        System.err.println("usage: java weblogic.application.descriptor.BasicMunger2 <descriptor file name>");
        System.exit(0);
    }

    private class MyLocation
    implements Location {
        Location l;

        MyLocation(Location location) {
            this.l = location;
        }

        public int getLineNumber() {
            return this.l.getLineNumber();
        }

        public int getColumnNumber() {
            return this.l.getColumnNumber();
        }

        public int getCharacterOffset() {
            return this.l.getCharacterOffset();
        }

        public String getPublicId() {
            return BasicMunger2.this.getAbsolutePath() + ":" + this.l.getLineNumber() + ":" + this.l.getColumnNumber();
        }

        public String getSystemId() {
            return this.l.getSystemId();
        }
    }

    private static class ReaderEventOperation {
        ReaderEvent2 ev;
        int operation;

        ReaderEventOperation(ReaderEvent2 readerEvent2, int n) {
            this.ev = readerEvent2;
            this.operation = n;
        }

        ReaderEvent2 getReaderEvent() {
            return this.ev;
        }

        int getOperation() {
            return this.operation;
        }
    }
}

