/*
 * Decompiled with CFR 0.152.
 */
package weblogic.application.descriptor;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import javax.xml.stream.XMLStreamException;
import weblogic.application.ApplicationAccess;
import weblogic.application.ApplicationContextInternal;
import weblogic.application.descriptor.AbstractDescriptorLoader;
import weblogic.descriptor.BasicDescriptorManager;
import weblogic.descriptor.Descriptor;
import weblogic.descriptor.DescriptorBean;
import weblogic.descriptor.DescriptorCache;
import weblogic.descriptor.DescriptorManager;
import weblogic.descriptor.internal.DescriptorImpl;
import weblogic.j2ee.descriptor.wl.DeploymentPlanBean;
import weblogic.kernel.Kernel;
import weblogic.utils.classloaders.GenericClassLoader;
import weblogic.utils.jars.VirtualJarFile;

public abstract class CachingDescriptorLoader
extends AbstractDescriptorLoader {
    private static final boolean isServer = Kernel.isServer();
    private static final DescriptorCache cache = DescriptorCache.getInstance();
    private static final boolean DEBUG = false;
    private static final boolean useCaching = Boolean.getBoolean("weblogic.EnableDescriptorCache");
    private final ApplicationAccess access = isServer ? ApplicationAccess.getApplicationAccess() : null;

    public CachingDescriptorLoader(VirtualJarFile virtualJarFile, File file, DeploymentPlanBean deploymentPlanBean, String string) {
        super(virtualJarFile, file, deploymentPlanBean, string);
    }

    public CachingDescriptorLoader(File file, File file2, DeploymentPlanBean deploymentPlanBean, String string) {
        super(file, file2, deploymentPlanBean, string);
    }

    public CachingDescriptorLoader(GenericClassLoader genericClassLoader) {
        super(genericClassLoader);
    }

    public CachingDescriptorLoader(GenericClassLoader genericClassLoader, File file, DeploymentPlanBean deploymentPlanBean, String string) {
        super(genericClassLoader, file, deploymentPlanBean, string);
    }

    public CachingDescriptorLoader(DescriptorManager descriptorManager, GenericClassLoader genericClassLoader, File file, DeploymentPlanBean deploymentPlanBean, String string) {
        super(descriptorManager, genericClassLoader, file, deploymentPlanBean, string);
    }

    public CachingDescriptorLoader(DescriptorManager descriptorManager, GenericClassLoader genericClassLoader) {
        super(descriptorManager, genericClassLoader);
    }

    public CachingDescriptorLoader(VirtualJarFile virtualJarFile) {
        super(virtualJarFile);
    }

    public CachingDescriptorLoader(File file) {
        super(file);
    }

    protected File findCacheDir() {
        ApplicationContextInternal applicationContextInternal = this.access.getCurrentApplicationContext();
        if (applicationContextInternal == null) {
            return null;
        }
        return this.findCacheDir(applicationContextInternal.getDescriptorCacheDir());
    }

    protected File findCacheDir(File file) {
        String string = this.getModuleName();
        if (string == null) {
            string = "";
        }
        return new File(file, string + File.separator + this.getDocumentURI());
    }

    private Descriptor superCreateDescriptor(InputStream inputStream) throws IOException, XMLStreamException {
        return super.createDescriptor(inputStream);
    }

    private Descriptor superCreateDescriptor(InputStream inputStream, boolean bl) throws IOException, XMLStreamException {
        return super.createDescriptor(inputStream, bl);
    }

    protected Descriptor createDescriptor(InputStream inputStream) throws IOException, XMLStreamException {
        DescriptorBean descriptorBean;
        if (!isServer || this.getDeploymentPlan() != null) {
            return super.createDescriptor(inputStream);
        }
        File file = this.findCacheDir();
        if (file == null) {
            return super.createDescriptor(inputStream);
        }
        IOHelperImpl iOHelperImpl = new IOHelperImpl(useCaching);
        iOHelperImpl.setValidate(cache.hasChanged(file, (DescriptorCache.IOHelper)iOHelperImpl));
        try {
            descriptorBean = (DescriptorBean)cache.parseXML(file, (DescriptorCache.IOHelper)iOHelperImpl);
        }
        catch (IOException iOException) {
            cache.removeCRC(file);
            throw iOException;
        }
        catch (XMLStreamException xMLStreamException) {
            cache.removeCRC(file);
            throw xMLStreamException;
        }
        catch (Throwable throwable) {
            cache.removeCRC(file);
            IOException iOException = new IOException(throwable.toString());
            iOException.initCause(throwable);
            throw iOException;
        }
        return descriptorBean == null ? null : descriptorBean.getDescriptor();
    }

    private class IOHelperImpl
    implements DescriptorCache.IOHelper {
        private boolean useCaching = false;
        private boolean validate = true;

        public IOHelperImpl(boolean bl) {
            this.useCaching = bl;
        }

        public InputStream openInputStream() throws IOException {
            return CachingDescriptorLoader.this.getInputStream();
        }

        private DescriptorBean readCachedDescriptor(File file) throws IOException {
            ObjectInputStream objectInputStream = null;
            try {
                objectInputStream = new ObjectInputStream(new FileInputStream(file));
                DescriptorBean descriptorBean = (DescriptorBean)objectInputStream.readObject();
                return descriptorBean;
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw (IOException)new IOException(classNotFoundException.getMessage()).initCause(classNotFoundException);
            }
            finally {
                if (objectInputStream != null) {
                    try {
                        objectInputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object readCachedBean(File file) throws IOException {
            DescriptorImpl descriptorImpl = DescriptorImpl.beginConstruction((boolean)false, (BasicDescriptorManager)READONLY_DESCRIPTOR_MANAGER_SINGLETON.instance, null, null);
            DescriptorBean descriptorBean = null;
            try {
                descriptorBean = this.readCachedDescriptor(file);
            }
            finally {
                DescriptorImpl.endConstruction((DescriptorBean)descriptorBean);
            }
            return descriptorBean;
        }

        public Object parseXML(InputStream inputStream) throws IOException, XMLStreamException {
            Descriptor descriptor = CachingDescriptorLoader.this.superCreateDescriptor(inputStream, this.validate);
            return descriptor.getRootBean();
        }

        public boolean useCaching() {
            return this.useCaching;
        }

        protected void setValidate(boolean bl) {
            this.validate = bl;
        }
    }

    private static class READONLY_DESCRIPTOR_MANAGER_SINGLETON {
        static DescriptorManager instance = new DescriptorManager();

        private READONLY_DESCRIPTOR_MANAGER_SINGLETON() {
        }
    }
}

