/*
 * Decompiled with CFR 0.152.
 */
package weblogic.application.descriptor;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import javax.xml.stream.XMLStreamException;
import weblogic.application.ApplicationAccess;
import weblogic.application.ApplicationContextInternal;
import weblogic.application.descriptor.AbstractDescriptorLoader2;
import weblogic.descriptor.BasicDescriptorManager;
import weblogic.descriptor.Descriptor;
import weblogic.descriptor.DescriptorBean;
import weblogic.descriptor.DescriptorCache;
import weblogic.descriptor.DescriptorManager;
import weblogic.descriptor.internal.DescriptorImpl;
import weblogic.j2ee.descriptor.wl.DeploymentPlanBean;
import weblogic.kernel.Kernel;
import weblogic.utils.classloaders.GenericClassLoader;
import weblogic.utils.jars.VirtualJarFile;

public abstract class CachingDescriptorLoader2
extends AbstractDescriptorLoader2 {
    private static final boolean isServer = Kernel.isServer();
    private static final DescriptorCache cache = DescriptorCache.getInstance();
    private static final boolean DEBUG = false;
    private static final boolean useCaching = Boolean.getBoolean("weblogic.EnableDescriptorCache");
    private final ApplicationAccess access = isServer ? ApplicationAccess.getApplicationAccess() : null;

    public CachingDescriptorLoader2(VirtualJarFile virtualJarFile, File file, DeploymentPlanBean deploymentPlanBean, String string, String string2) {
        super(virtualJarFile, file, deploymentPlanBean, string, string2);
    }

    public CachingDescriptorLoader2(File file, File file2, DeploymentPlanBean deploymentPlanBean, String string, String string2) {
        super(file, file2, deploymentPlanBean, string, string2);
    }

    public CachingDescriptorLoader2(GenericClassLoader genericClassLoader, String string) {
        super(genericClassLoader, string);
    }

    public CachingDescriptorLoader2(GenericClassLoader genericClassLoader, File file, DeploymentPlanBean deploymentPlanBean, String string, String string2) {
        super(genericClassLoader, file, deploymentPlanBean, string, string2);
    }

    public CachingDescriptorLoader2(DescriptorManager descriptorManager, GenericClassLoader genericClassLoader, File file, DeploymentPlanBean deploymentPlanBean, String string, String string2) {
        super(descriptorManager, genericClassLoader, file, deploymentPlanBean, string, string2);
    }

    public CachingDescriptorLoader2(DescriptorManager descriptorManager, GenericClassLoader genericClassLoader, String string) {
        super(descriptorManager, genericClassLoader, string);
    }

    public CachingDescriptorLoader2(VirtualJarFile virtualJarFile, String string) {
        super(virtualJarFile, string);
    }

    public CachingDescriptorLoader2(File file, String string) {
        super(file, string);
    }

    protected File findCacheDir() {
        ApplicationContextInternal applicationContextInternal = this.access.getCurrentApplicationContext();
        if (applicationContextInternal == null) {
            return null;
        }
        return this.findCacheDir(applicationContextInternal.getDescriptorCacheDir());
    }

    protected File findCacheDir(File file) {
        String string = this.getModuleName();
        if (string == null) {
            string = "";
        }
        return new File(file, string + File.separator + this.getDocumentURI());
    }

    protected Descriptor createDescriptor() throws IOException, XMLStreamException {
        DescriptorBean descriptorBean;
        if (!isServer || this.getDeploymentPlan() != null) {
            DescriptorBean descriptorBean2 = this.loadDescriptorBean();
            return descriptorBean2 == null ? null : descriptorBean2.getDescriptor();
        }
        File file = this.findCacheDir();
        if (file == null) {
            DescriptorBean descriptorBean3 = super.loadDescriptorBean();
            return descriptorBean3 == null ? null : descriptorBean3.getDescriptor();
        }
        IOHelperImpl iOHelperImpl = new IOHelperImpl(useCaching);
        iOHelperImpl.setValidate(cache.hasChanged(file, (DescriptorCache.IOHelper)iOHelperImpl));
        try {
            descriptorBean = (DescriptorBean)cache.parseXML(file, (DescriptorCache.IOHelper)iOHelperImpl);
        }
        catch (IOException iOException) {
            cache.removeCRC(file);
            throw iOException;
        }
        catch (XMLStreamException xMLStreamException) {
            cache.removeCRC(file);
            throw xMLStreamException;
        }
        catch (Throwable throwable) {
            cache.removeCRC(file);
            IOException iOException = new IOException(throwable.toString());
            iOException.initCause(throwable);
            throw iOException;
        }
        return descriptorBean == null ? null : descriptorBean.getDescriptor();
    }

    private class IOHelperImpl
    implements DescriptorCache.IOHelper {
        private boolean useCaching = false;
        private boolean validate = true;

        public IOHelperImpl(boolean bl) {
            this.useCaching = bl;
        }

        public InputStream openInputStream() throws IOException {
            return CachingDescriptorLoader2.this.getInputStream();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private DescriptorBean readCachedDescriptor(File file) throws IOException {
            DescriptorBean descriptorBean;
            ObjectInputStream objectInputStream = null;
            try {
                try {
                    objectInputStream = new ObjectInputStream(new FileInputStream(file));
                    descriptorBean = (DescriptorBean)objectInputStream.readObject();
                    Object var5_5 = null;
                    if (objectInputStream == null) return descriptorBean;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw (IOException)new IOException(classNotFoundException.getMessage()).initCause(classNotFoundException);
                }
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                if (objectInputStream == null) throw throwable;
                try {
                    objectInputStream.close();
                    throw throwable;
                }
                catch (IOException iOException) {
                    throw throwable;
                }
            }
            try {}
            catch (IOException iOException) {
                // empty catch block
                return descriptorBean;
            }
            objectInputStream.close();
            return descriptorBean;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object readCachedBean(File file) throws IOException {
            DescriptorImpl descriptorImpl = DescriptorImpl.beginConstruction((boolean)false, (BasicDescriptorManager)READONLY_DESCRIPTOR_MANAGER_SINGLETON.instance, null, null);
            DescriptorBean descriptorBean = null;
            try {
                descriptorBean = this.readCachedDescriptor(file);
                Object var5_4 = null;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                DescriptorImpl.endConstruction((DescriptorBean)descriptorBean);
                throw throwable;
            }
            DescriptorImpl.endConstruction((DescriptorBean)descriptorBean);
            return descriptorBean;
        }

        public Object parseXML(InputStream inputStream) throws IOException, XMLStreamException {
            return CachingDescriptorLoader2.this.loadDescriptorBean();
        }

        public boolean useCaching() {
            return this.useCaching;
        }

        protected void setValidate(boolean bl) {
            this.validate = bl;
        }
    }

    private static class READONLY_DESCRIPTOR_MANAGER_SINGLETON {
        static DescriptorManager instance = new DescriptorManager();

        private READONLY_DESCRIPTOR_MANAGER_SINGLETON() {
        }
    }
}

