/*
 * Decompiled with CFR 0.152.
 */
package weblogic.application.descriptor;

import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.util.StreamReaderDelegate;
import weblogic.application.descriptor.Utils;
import weblogic.utils.Debug;

public abstract class DebugStreamReaderDelegate
extends StreamReaderDelegate
implements XMLStreamReader {
    private boolean debug = Debug.getCategory((String)"weblogic.descriptor.reader").isEnabled();

    public DebugStreamReaderDelegate(XMLStreamReader xMLStreamReader) throws XMLStreamException {
        super(xMLStreamReader);
    }

    public char[] getTextCharacters() {
        char[] cArray = super.getTextCharacters();
        if (this.debug) {
            System.out.println("->getTextCharacters: " + (cArray == null ? "null" : new String(cArray)));
        }
        return cArray;
    }

    public int next() throws XMLStreamException {
        int n = super.next();
        if (this.debug) {
            System.out.println("->next = " + Utils.type2Str(n, this));
        }
        return n;
    }

    public void setParent(XMLStreamReader xMLStreamReader) {
        if (this.debug) {
            System.out.println("->setParent");
        }
        super.setParent(xMLStreamReader);
    }

    public XMLStreamReader getParent() {
        if (this.debug) {
            System.out.println("->getParent");
        }
        return super.getParent();
    }

    public int nextTag() throws XMLStreamException {
        int n = super.nextTag();
        if (this.debug) {
            System.out.println("->nextTag: " + n);
        }
        return n;
    }

    public String getElementText() throws XMLStreamException {
        String string = super.getElementText();
        if (this.debug) {
            System.out.println("->getElementText: " + string);
        }
        return string;
    }

    public void require(int n, String string, String string2) throws XMLStreamException {
        if (this.debug) {
            System.out.println("->require");
        }
        super.require(n, string, string2);
    }

    public boolean hasNext() throws XMLStreamException {
        boolean bl = super.hasNext();
        if (this.debug) {
            System.out.println("->hasNext: = " + bl);
        }
        return bl;
    }

    public void close() throws XMLStreamException {
        if (this.debug) {
            System.out.println("->close");
        }
        super.close();
    }

    public String getNamespaceURI(String string) {
        String string2 = super.getNamespaceURI(string);
        if (this.debug) {
            System.out.println("->getNamespaceURI(String): (" + string + "): " + string2);
        }
        return string2;
    }

    public NamespaceContext getNamespaceContext() {
        NamespaceContext namespaceContext = super.getNamespaceContext();
        if (this.debug) {
            System.out.println("->getNamespaceContext: " + namespaceContext);
        }
        return namespaceContext;
    }

    public boolean isStartElement() {
        boolean bl = super.isStartElement();
        if (this.debug) {
            System.out.println("->isStartElement: " + bl);
            if (!bl) {
                System.out.println("... eventType = " + Utils.type2Str(super.getEventType(), this));
            }
        }
        return bl;
    }

    public boolean isEndElement() {
        if (this.debug) {
            System.out.println("->isEndElement");
        }
        return super.isEndElement();
    }

    public boolean isCharacters() {
        boolean bl = super.isCharacters();
        if (this.debug) {
            System.out.println("->isCharacters: " + bl);
        }
        return bl;
    }

    public boolean isWhiteSpace() {
        if (this.debug) {
            System.out.println("->isWhiteSpace");
        }
        return super.isWhiteSpace();
    }

    public String getAttributeValue(String string, String string2) {
        String string3 = super.getAttributeValue(string, string2);
        if (this.debug) {
            System.out.println("->getAttributeValue(" + string + ", " + string2 + ") returns: " + string3);
        }
        return string3;
    }

    public int getAttributeCount() {
        int n = super.getAttributeCount();
        if (this.debug) {
            System.out.println("->getAttributeCount() returns " + n);
        }
        return n;
    }

    public QName getAttributeName(int n) {
        QName qName = super.getAttributeName(n);
        if (this.debug) {
            System.out.println("->getAttributeName(" + n + ") returns: " + qName);
        }
        return qName;
    }

    public String getAttributePrefix(int n) {
        String string = super.getAttributePrefix(n);
        if (this.debug) {
            System.out.println("->getAttributePrefix(" + n + ") return " + string);
        }
        return string;
    }

    public String getAttributeNamespace(int n) {
        String string = super.getAttributeNamespace(n);
        if (this.debug) {
            System.out.println("->getAttributeNamespace(" + n + ") returns " + string);
        }
        return string;
    }

    public String getAttributeLocalName(int n) {
        String string = super.getAttributeLocalName(n);
        if (this.debug) {
            System.out.println("->getAttributeLocalName(" + n + ") returns " + string);
        }
        return string;
    }

    public String getAttributeType(int n) {
        String string = super.getAttributeType(n);
        if (this.debug) {
            System.out.println("->getAttributeType(" + n + " returns " + string);
        }
        return string;
    }

    public String getAttributeValue(int n) {
        String string = super.getAttributeValue(n);
        if (this.debug) {
            System.out.println("->getAttributeValue(" + n + ") returns: " + string);
        }
        return string;
    }

    public boolean isAttributeSpecified(int n) {
        boolean bl = super.isAttributeSpecified(n);
        if (this.debug) {
            System.out.println("->isAttributeSpecified(" + n + ") returns " + bl);
        }
        return bl;
    }

    public int getNamespaceCount() {
        int n = super.getNamespaceCount();
        if (this.debug) {
            System.out.println("->getNamespaceCount return " + n);
        }
        return n;
    }

    public String getNamespacePrefix(int n) {
        String string = super.getNamespacePrefix(n);
        if (this.debug) {
            System.out.println("->getNamespacePrefix(" + n + ") return " + string);
        }
        return string;
    }

    public String getNamespaceURI(int n) {
        String string = super.getNamespaceURI(n);
        if (this.debug) {
            System.out.println("->getNamespaceURI(" + n + "): " + string);
        }
        return string;
    }

    public int getEventType() {
        int n = super.getEventType();
        if (this.debug) {
            System.out.println("->getEventType: " + Utils.type2Str(n, this));
        }
        return n;
    }

    public String getText() {
        String string = super.getText();
        if (this.debug) {
            System.out.println("->getText: " + string);
        }
        return string;
    }

    public int getTextCharacters(int n, char[] cArray, int n2, int n3) throws XMLStreamException {
        if (this.debug) {
            System.out.println("->getTextCharacters");
        }
        return super.getTextCharacters(n, cArray, n2, n3);
    }

    public int getTextStart() {
        int n = super.getTextStart();
        if (this.debug) {
            System.out.println("->getTextStart");
        }
        return n;
    }

    public int getTextLength() {
        if (this.debug) {
            System.out.println("->getTextLength");
        }
        return super.getTextLength();
    }

    public String getEncoding() {
        if (this.debug) {
            System.out.println("->getEncoding");
        }
        return super.getEncoding();
    }

    public boolean hasText() {
        if (this.debug) {
            System.out.println("->hasText");
        }
        return super.hasText();
    }

    public Location getLocation() {
        Location location = super.getLocation();
        if (this.debug) {
            System.out.println("->getLocation: " + location);
        }
        return location;
    }

    public QName getName() {
        if (this.debug) {
            System.out.println("->getName");
        }
        return super.getName();
    }

    public boolean hasName() {
        if (this.debug) {
            System.out.println("->hasName");
        }
        return super.hasName();
    }

    public String getPrefix() {
        if (this.debug) {
            System.out.println("->getPrefix");
        }
        return super.getPrefix();
    }

    public String getVersion() {
        if (this.debug) {
            System.out.println("->getVersion");
        }
        return super.getVersion();
    }

    public boolean isStandalone() {
        if (this.debug) {
            System.out.println("->isStandalone");
        }
        return super.isStandalone();
    }

    public boolean standaloneSet() {
        if (this.debug) {
            System.out.println("->standaloneSet");
        }
        return super.standaloneSet();
    }

    public String getCharacterEncodingScheme() {
        if (this.debug) {
            System.out.println("->getCharacterEncodingScheme");
        }
        return super.getCharacterEncodingScheme();
    }

    public String getPITarget() {
        if (this.debug) {
            System.out.println("->getPITarget");
        }
        return super.getPITarget();
    }

    public String getPIData() {
        if (this.debug) {
            System.out.println("->getPIData");
        }
        return super.getPIData();
    }

    public Object getProperty(String string) {
        if (this.debug) {
            System.out.println("->getProperty");
        }
        return super.getProperty(string);
    }
}

