/*
 * Decompiled with CFR 0.152.
 */
package weblogic.application.descriptor;

import java.io.InputStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.util.StreamReaderDelegate;

public class NamespaceURIMunger
extends StreamReaderDelegate {
    protected static final XMLInputFactory xiFactory = XMLInputFactory.newInstance();
    private Set<String> oldNamespaceURISet = new HashSet<String>();
    private String newNamespaceURI = null;

    public NamespaceURIMunger(InputStream inputStream, String string, String[] stringArray) throws XMLStreamException {
        super(xiFactory.createXMLStreamReader(inputStream));
        this.newNamespaceURI = string;
        for (String string2 : stringArray) {
            this.oldNamespaceURISet.add(string2);
        }
    }

    public NamespaceContext getNamespaceContext() {
        NamespaceContext namespaceContext = super.getNamespaceContext();
        return namespaceContext == null ? null : new NamespaceContextWrapper(namespaceContext);
    }

    public String getNamespaceURI() {
        return this.mungeNamespaceURI(super.getNamespaceURI());
    }

    public String getNamespaceURI(int n) {
        return this.mungeNamespaceURI(super.getNamespaceURI(n));
    }

    public String getNamespaceURI(String string) {
        return this.mungeNamespaceURI(super.getNamespaceURI(string));
    }

    private String mungeNamespaceURI(String string) {
        return this.oldNamespaceURISet.contains(string) ? this.newNamespaceURI : string;
    }

    private class NamespaceContextWrapper
    implements NamespaceContext {
        private NamespaceContext delegate;

        public NamespaceContextWrapper(NamespaceContext namespaceContext) {
            this.delegate = namespaceContext;
        }

        public String getNamespaceURI(String string) {
            return NamespaceURIMunger.this.mungeNamespaceURI(this.delegate.getNamespaceURI(string));
        }

        public String getPrefix(String string) {
            throw new UnsupportedOperationException();
        }

        public Iterator getPrefixes(String string) {
            throw new UnsupportedOperationException();
        }
    }
}

