/*
 * Decompiled with CFR 0.152.
 */
package weblogic.application.descriptor;

import java.io.File;
import java.io.FileInputStream;
import java.io.OutputStream;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import weblogic.application.descriptor.BasicMunger2;
import weblogic.application.descriptor.ReaderEvent2;
import weblogic.application.descriptor.ReaderEventInfo;
import weblogic.application.descriptor.Utils;
import weblogic.descriptor.DescriptorManager;
import weblogic.utils.Debug;

public class PlaybackReader
implements XMLStreamReader {
    private boolean debug = Debug.getCategory((String)"weblogic.descriptor.playback").isEnabled();
    protected ReaderEvent2 root;
    protected ReaderEvent2 currentEvent;
    protected PlaybackIterator iterator;
    protected int currentState;
    protected ReaderEventInfo.Namespaces namespaces;
    protected ReaderEventInfo.Attributes attributes;
    private String absolutePath;
    String dtdNamespaceURI = null;

    public PlaybackReader(ReaderEvent2 readerEvent2, String string) throws XMLStreamException {
        this.root = readerEvent2;
        this.absolutePath = string;
        this.currentEvent = readerEvent2;
        this.currentState = readerEvent2.getReaderEventInfo().getEventType();
        this.iterator = new PlaybackIterator(readerEvent2);
    }

    String getAbsolutePath() {
        return this.absolutePath;
    }

    public String getLocalName() {
        return this.currentEvent.getReaderEventInfo().getElementName();
    }

    public char[] getTextCharacters() {
        return this.currentEvent.getReaderEventInfo().getCharacters();
    }

    public int next() throws XMLStreamException {
        this.currentState = this.iterator.next();
        this.currentEvent = this.iterator.event();
        if (this.debug) {
            System.out.println("-> next: " + Utils.type2Str(this.currentState, this));
        }
        if (this.currentEvent.isDiscarded()) {
            if (this.debug) {
                System.out.println("-> skiped: " + Utils.type2Str(this.currentState, this));
            }
            return this.next();
        }
        return this.currentState;
    }

    public int nextTag() throws XMLStreamException {
        if (this.debug) {
            System.out.println("->nextTag");
        }
        return this.next();
    }

    public String getElementText() throws XMLStreamException {
        if (this.debug) {
            System.out.println("->getElementText: " + new String(this.getTextCharacters()));
        }
        return new String(this.getTextCharacters());
    }

    public void require(int n, String string, String string2) throws XMLStreamException {
        if (this.debug) {
            System.out.println("->require");
        }
    }

    public boolean hasNext() throws XMLStreamException {
        if (this.debug) {
            System.out.println("->hasNext " + (this.currentState != 8));
        }
        return this.currentState != 8;
    }

    public void close() throws XMLStreamException {
    }

    ReaderEventInfo.Namespaces getNamespaces() {
        if (this.namespaces == null) {
            return this.currentEvent.getReaderEventInfo().getNamespaces();
        }
        return this.namespaces;
    }

    boolean hasDTD() {
        return this.dtdNamespaceURI != null;
    }

    public void setDtdNamespaceURI(String string) {
        this.dtdNamespaceURI = string;
    }

    public String getDtdNamespaceURI() {
        return this.dtdNamespaceURI;
    }

    public String getNamespaceURI() {
        if (this.debug) {
            System.out.println("->getNamespaceURI: usingDTD() =" + this.hasDTD());
        }
        if (this.hasDTD() && this.currentEvent.getReaderEventInfo().getNamespaceCount() == 0) {
            return this.getDtdNamespaceURI();
        }
        String string = this.currentEvent.getReaderEventInfo().getPrefix();
        return this.getNamespaceURI(string);
    }

    public String getNamespaceURI(String string) {
        String string2;
        if (this.debug) {
            System.out.println("->getNamespaceURI(" + string + ") " + this.getNamespaces().getNamespaceURI(string));
        }
        if ((string2 = this.currentEvent.getReaderEventInfo().getNamespaces().getNamespaceURI(string)) == null && ((string2 = this.getNamespaces().getNamespaceURI(string)) == null || string2.trim().length() == 0)) {
            string2 = this.getNamespaces().getNamespaceURI();
        }
        return string2;
    }

    public NamespaceContext getNamespaceContext() {
        if (this.debug) {
            System.out.println("->getNamespaceContext(): " + this.currentEvent.getReaderEventInfo().getNamespaceContext());
        }
        return this.currentEvent.getReaderEventInfo().getNamespaceContext();
    }

    public boolean isStartElement() {
        if (this.debug) {
            System.out.println("->isStartElement " + (this.currentState == 1));
        }
        return this.currentState == 1;
    }

    public boolean isEndElement() {
        if (this.debug) {
            System.out.println("->isEndElement: " + (this.currentState == 2));
        }
        return this.currentState == 2;
    }

    public boolean isCharacters() {
        if (this.debug) {
            System.out.println("->isCharacters");
        }
        return this.currentState == 4;
    }

    private static boolean isSpace(char c) {
        return c == ' ' || c == '\t' || c == '\n' || c == '\r';
    }

    public boolean isWhiteSpace() {
        if (this.currentState == 4) {
            char[] cArray = this.currentEvent.getReaderEventInfo().getCharacters();
            for (int i = 0; i < cArray.length; ++i) {
                if (PlaybackReader.isSpace(cArray[i])) continue;
                if (this.debug) {
                    System.out.println("->isWhiteSpace: false");
                }
                return false;
            }
            if (this.debug) {
                System.out.println("->isWhiteSpace: true");
            }
            return true;
        }
        throw new IllegalStateException("isWhiteSpace on type " + Utils.type2Str(this.currentState, this));
    }

    public String getAttributeValue(String string, String string2) {
        String string3 = this.currentEvent.getReaderEventInfo().getAttributeValue(string, string2);
        if (this.debug) {
            System.out.println("->getAttributeValue(" + string + ", " + string2 + ") returns: " + string3);
        }
        return string3;
    }

    public int getAttributeCount() {
        int n = this.currentEvent.getReaderEventInfo().getAttributeCount();
        if (this.debug) {
            System.out.println("->getAttributeCount() returns " + n);
        }
        return n;
    }

    public QName getAttributeName(int n) {
        QName qName = this.currentEvent.getReaderEventInfo().getAttributeName(n);
        if (this.debug) {
            System.out.println("->getAttributeName(" + n + ") returns: " + qName);
        }
        return qName;
    }

    public String getAttributePrefix(int n) {
        String string = this.currentEvent.getReaderEventInfo().getAttributePrefix(n);
        if (this.debug) {
            System.out.println("->getAttributePrefix(" + n + ") return " + string);
        }
        return string;
    }

    public String getAttributeNamespace(int n) {
        String string = this.currentEvent.getReaderEventInfo().getAttributeNamespace(n);
        if (this.debug) {
            System.out.println("->getAttributeNamespace(" + n + ") returns " + string);
        }
        return string;
    }

    public String getAttributeLocalName(int n) {
        String string = this.currentEvent.getReaderEventInfo().getAttributeLocalName(n);
        if (this.debug) {
            System.out.println("->getAttributeLocalName(" + n + ") returns " + string);
        }
        return string;
    }

    public String getAttributeType(int n) {
        if (this.debug) {
            System.out.println("->getAttributeType returns CDATA");
        }
        return "CDATA";
    }

    public String getAttributeValue(int n) {
        String string = this.currentEvent.getReaderEventInfo().getAttributeValue(n);
        if (this.debug) {
            System.out.println("->getAttributeValue(" + n + ") returns: " + string);
        }
        return string;
    }

    public boolean isAttributeSpecified(int n) {
        boolean bl = this.currentEvent.getReaderEventInfo().isAttributeSpecified(n);
        if (this.debug) {
            System.out.println("->isAttributeSpecified(" + n + ") returns " + bl);
        }
        return bl;
    }

    public int getNamespaceCount() {
        int n = this.currentEvent.getReaderEventInfo().getNamespaceCount();
        if (this.debug) {
            System.out.println("->getNamespaceCount return " + n);
        }
        return n;
    }

    public String getNamespacePrefix(int n) {
        String string = this.currentEvent.getReaderEventInfo().getNamespacePrefix(n);
        if (this.debug) {
            System.out.println("->getNamespacePrefix(" + n + ") return " + string);
        }
        return string;
    }

    public String getNamespaceURI(int n) {
        if (this.debug) {
            System.out.println("->getNamespaceURI(int) " + n);
        }
        return this.currentEvent.getReaderEventInfo().getNamespaceURI(n);
    }

    public int getEventType() {
        int n = this.currentState;
        if (this.debug) {
            System.out.println("->getEventType: " + Utils.type2Str(n, this));
        }
        return n;
    }

    public String getText() {
        if (this.debug) {
            System.out.println("->getText");
        }
        return new String(this.getTextCharacters());
    }

    public int getTextCharacters(int n, char[] cArray, int n2, int n3) throws XMLStreamException {
        throw new UnsupportedOperationException();
    }

    public int getTextStart() {
        if (this.debug) {
            System.out.println("->getTextStart");
        }
        return 0;
    }

    public int getTextLength() {
        return this.getTextCharacters().length;
    }

    public String getEncoding() {
        if (this.debug) {
            System.out.println("->getEncoding");
        }
        return this.currentEvent.getReaderEventInfo().getEncoding();
    }

    public boolean hasText() {
        if (this.debug) {
            System.out.println("->hasText");
        }
        switch (this.currentState) {
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 11: {
                return true;
            }
        }
        return false;
    }

    public Location getLocation() {
        Location location = this.currentEvent.getReaderEventInfo().getLocation();
        if (this.debug) {
            System.out.println("->getLocation: " + location);
        }
        return location;
    }

    public QName getName() {
        ReaderEventInfo readerEventInfo;
        if (this.debug) {
            System.out.println("->getName");
        }
        if ((readerEventInfo = this.currentEvent.getReaderEventInfo()).getNamespacePrefix(0) == null) {
            return new QName(readerEventInfo.getNamespaceURI(0), readerEventInfo.getElementName());
        }
        return new QName(readerEventInfo.getNamespaceURI(0), readerEventInfo.getElementName(), readerEventInfo.getNamespacePrefix(0));
    }

    public boolean hasName() {
        if (this.debug) {
            System.out.println("->hasName");
        }
        return this.currentState == 1 || this.currentState == 2;
    }

    public String getPrefix() {
        if (this.debug) {
            System.out.println("->getPrefix " + this.currentEvent.getReaderEventInfo().getNamespacePrefix(0));
        }
        return this.currentEvent.getReaderEventInfo().getPrefix();
    }

    public String getVersion() {
        if (this.debug) {
            System.out.println("->getVersion");
        }
        return null;
    }

    public boolean isStandalone() {
        if (this.debug) {
            System.out.println("->isStandalone");
        }
        return false;
    }

    public boolean standaloneSet() {
        if (this.debug) {
            System.out.println("->standaloneSet");
        }
        return false;
    }

    public String getCharacterEncodingScheme() {
        if (this.debug) {
            System.out.println("->getCharacterEncodingScheme");
        }
        return this.currentEvent.getReaderEventInfo().getCharacterEncodingScheme();
    }

    public String getPITarget() {
        if (this.debug) {
            System.out.println("->getPITarget");
        }
        throw new IllegalStateException();
    }

    public String getPIData() {
        if (this.debug) {
            System.out.println("->getPIData");
        }
        throw new IllegalStateException();
    }

    public Object getProperty(String string) {
        if (this.debug) {
            System.out.println("->getProperty");
        }
        throw new UnsupportedOperationException("UNIMPLEMENTED");
    }

    public static void main(String[] stringArray) throws Exception {
        Object object;
        FileInputStream fileInputStream = null;
        String string = null;
        if (stringArray.length == 0) {
            PlaybackReader.usage();
        } else {
            object = new File(stringArray[0]);
            fileInputStream = new FileInputStream((File)object);
            string = stringArray[0];
        }
        System.out.println("stamp out munger...");
        System.out.flush();
        object = new BasicMunger2(fileInputStream, string);
        System.out.println("hand munger to descriptor manger...");
        System.out.flush();
        new DescriptorManager().createDescriptor((XMLStreamReader)object).toXML((OutputStream)System.out);
        System.out.print("\n dump the bean from the playback reader:\n");
        System.out.flush();
        new DescriptorManager().createDescriptor((XMLStreamReader)new PlaybackReader(((BasicMunger2)object).root, ((BasicMunger2)object).getAbsolutePath())).toXML((OutputStream)System.out);
    }

    private static void usage() {
        System.err.println("usage: java weblogic.application.descriptor.PlaybackReader <descriptor file name>");
        System.exit(0);
    }

    private class MyLocation
    implements Location {
        Location l;

        MyLocation(Location location) {
            this.l = location;
        }

        public int getLineNumber() {
            return this.l.getLineNumber();
        }

        public int getColumnNumber() {
            return this.l.getColumnNumber();
        }

        public int getCharacterOffset() {
            return this.l.getCharacterOffset();
        }

        public String getPublicId() {
            return PlaybackReader.this.getAbsolutePath() + ":" + this.l.getLineNumber() + ":" + this.l.getColumnNumber();
        }

        public String getSystemId() {
            return this.l.getSystemId();
        }
    }

    class PlaybackIterator {
        int index = 0;
        int state = -1;
        ReaderEvent2 event;
        PlaybackIterator parent;

        PlaybackIterator(ReaderEvent2 readerEvent2) {
            this.event = readerEvent2;
        }

        PlaybackIterator(ReaderEvent2 readerEvent2, PlaybackIterator playbackIterator) {
            this.event = readerEvent2;
            this.parent = playbackIterator;
        }

        int next() throws XMLStreamException {
            int n = this.state();
            if (n == -2 || n == 7) {
                if (this.index < this.event.getChildren().size()) {
                    PlaybackReader.this.iterator = new PlaybackIterator((ReaderEvent2)this.event.getChildren().elementAt(this.index), this);
                    ++this.index;
                    return PlaybackReader.this.iterator.next();
                }
                if (this.index == this.event.getChildren().size()) {
                    if (this.parent == null) {
                        throw new XMLStreamException("unexpected end of xml stream");
                    }
                    PlaybackReader.this.iterator = this.parent;
                    return PlaybackReader.this.iterator.next();
                }
            }
            return n;
        }

        ReaderEvent2 event() {
            return this.event;
        }

        int state() throws XMLStreamException {
            switch (this.state) {
                case -1: {
                    this.state = this.event.getReaderEventInfo().getEventType();
                    if (this.state != 1) break;
                    if (this.event.getReaderEventInfo().getNamespaceCount() > 0) {
                        if (PlaybackReader.this.namespaces == null) {
                            PlaybackReader.this.namespaces = this.event.getReaderEventInfo().getNamespaces();
                        } else {
                            ReaderEventInfo.Namespaces namespaces = this.event.getReaderEventInfo().getNamespaces();
                            for (int i = 0; i < namespaces.getNamespaceCount(); ++i) {
                                PlaybackReader.this.namespaces.setNamespaceURI(namespaces.getNamespacePrefix(i), namespaces.getNamespaceURI(i));
                            }
                        }
                        if (PlaybackReader.this.debug) {
                            for (int i = 0; i < PlaybackReader.this.namespaces.getNamespaceCount(); ++i) {
                                System.out.println("===== namespace prefix = " + PlaybackReader.this.namespaces.getNamespacePrefix(i));
                                System.out.println("===== namespaceURI = " + PlaybackReader.this.namespaces.getNamespaceURI(i));
                            }
                        }
                    }
                    if (this.event.getReaderEventInfo().getAttributeCount() <= 0) break;
                    PlaybackReader.this.attributes = this.event.getReaderEventInfo().getAttributes();
                    break;
                }
                case 2: {
                    this.state = -2;
                    break;
                }
                case 4: {
                    if (this.index < this.event.getChildren().size()) {
                        PlaybackReader.this.iterator = new PlaybackIterator((ReaderEvent2)this.event.getChildren().elementAt(this.index), this);
                        ++this.index;
                        return PlaybackReader.this.iterator.next();
                    }
                    this.state = 2;
                    break;
                }
                case 1: {
                    if (this.event.getReaderEventInfo().getCharacters() != null) {
                        this.state = 4;
                        break;
                    }
                    if (this.index < this.event.getChildren().size()) {
                        PlaybackReader.this.iterator = new PlaybackIterator((ReaderEvent2)this.event.getChildren().elementAt(this.index), this);
                        ++this.index;
                        return PlaybackReader.this.iterator.next();
                    }
                    this.state = 2;
                }
            }
            return this.state;
        }
    }
}

