/*
 * Decompiled with CFR 0.152.
 */
package weblogic.application.descriptor;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Stack;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import weblogic.application.descriptor.BasicMunger;
import weblogic.descriptor.DescriptorException;
import weblogic.descriptor.internal.AbstractDescriptorBean;
import weblogic.descriptor.internal.Munger;
import weblogic.descriptor.internal.SchemaHelper;
import weblogic.utils.Debug;
import weblogic.utils.StringUtils;

public class ReaderEvent
implements Munger.ReaderEventInfo {
    private static boolean debug = Debug.getCategory((String)"weblogic.descriptor").isEnabled();
    private String localName;
    private boolean isKey = false;
    private boolean isKeyComponent = false;
    private char[] characters;
    private ReaderEvent parent;
    private boolean discard = false;
    private Stack children = new Stack();
    private BasicMunger munger;
    private Location location;
    private ReaderEvent beanEvent;
    private AbstractDescriptorBean bean;
    private SchemaHelper helper;
    private int eventType;
    private int attributeCount;
    private String[] attributeNames;
    private String[] attributeValues;
    private String[] attributeUris;
    private String[] attributePrefixes;
    private String charEncodingScheme;
    private String inputEncoding;
    private int namespaceCount;
    private int operation = -1;

    public ReaderEvent(int n, Object object, Location location, BasicMunger basicMunger) {
        this.eventType = n;
        if (object != null) {
            if (object instanceof String) {
                this.localName = (String)object;
            } else {
                this.characters = (char[])object;
            }
        }
        this.munger = basicMunger;
        this.location = location != null ? location : new Location(){

            public int getLineNumber() {
                return 0;
            }

            public int getColumnNumber() {
                return 0;
            }

            public int getCharacterOffset() {
                return 0;
            }

            public String getPublicId() {
                return "Start of document";
            }

            public String getSystemId() {
                return "Start of document";
            }
        };
    }

    private ReaderEvent(String string, ReaderEvent readerEvent, BasicMunger basicMunger, Location location) {
        this.localName = string;
        this.parent = readerEvent;
        this.munger = basicMunger;
        this.location = location;
    }

    public ReaderEvent(String string, ReaderEvent readerEvent, BasicMunger basicMunger, Location location, ReaderEvent readerEvent2) {
        this(string, readerEvent, basicMunger, location);
        this.beanEvent = readerEvent2;
        if (string != null && readerEvent2 != null && readerEvent2.getBean() != null) {
            this.isKey = readerEvent2.getBean()._isPropertyAKey((Munger.ReaderEventInfo)this);
            if (!this.isKey) {
                SchemaHelper schemaHelper = readerEvent2.getBean()._getSchemaHelper2();
                this.isKeyComponent = schemaHelper.isKeyComponent(schemaHelper.getPropertyIndex(this.getElementName()));
            }
        }
    }

    public ReaderEvent(StringBuffer stringBuffer, ReaderEvent readerEvent, String string, int n, BasicMunger basicMunger, Location location) {
        this.parent = readerEvent;
        this.munger = basicMunger;
        this.location = location;
        this.eventType = 1;
        this.consumeElement(stringBuffer);
        if (stringBuffer.length() > 0 && stringBuffer.charAt(0) == '/') {
            this.children.push(new ReaderEvent(stringBuffer, this, string, n, basicMunger, location));
        } else {
            if (debug) {
                System.out.println("Adding " + string + " to " + this.localName);
            }
            this.setOperation(n);
            if (string == null) {
                return;
            }
            if ((string = string.trim()).indexOf("\",\"") > 0) {
                String[] stringArray = StringUtils.splitCompletely((String)string, (String)",", (boolean)false);
                this.characters = stringArray[stringArray.length - 1].substring(1, stringArray[stringArray.length - 1].length() - 1).toCharArray();
                for (int i = 0; i < stringArray.length - 1; ++i) {
                    if (debug) {
                        System.out.println("xpath = " + stringBuffer + ", val = " + stringArray[i]);
                    }
                    StringBuffer stringBuffer2 = new StringBuffer("/" + this.localName);
                    String string2 = stringArray[i].substring(1, stringArray[i].length() - 1);
                    readerEvent.children.push(new ReaderEvent(stringBuffer2, readerEvent, string2, n, basicMunger, location));
                }
            } else {
                if (string.startsWith("\"")) {
                    string = string.substring(1, string.length() - 1);
                }
                this.characters = string.toCharArray();
            }
        }
    }

    public String getLocalName() {
        return this.localName;
    }

    public boolean isKey() {
        return this.isKey;
    }

    public boolean isKeyComponent() {
        return this.isKeyComponent;
    }

    public boolean isKeyAnAttribute() {
        if (this.getAttributeCount() == 0) {
            return false;
        }
        for (int i = 0; i < this.getAttributeCount(); ++i) {
            int n = this.helper.getPropertyIndex(this.getAttributeLocalName(i));
            if (!this.helper.isAttribute(n)) continue;
            return true;
        }
        return false;
    }

    public String getPath() {
        String string;
        String string2 = this.localName;
        if (this.isKey() || this.isKeyComponent()) {
            string = this.attributeValues != null ? this.attributeValues[0] : this.getTrimmedTextCharacters();
            string2 = string2 + "/" + string;
        }
        if (this.parent != null && (string = this.parent.getPath()) != null) {
            string2 = string + "/" + string2;
        }
        return string2;
    }

    public char[] getCharacters() {
        return this.characters;
    }

    public String getCharactersAsString() {
        return this.characters == null ? null : new String(this.characters);
    }

    public void setCharacters(char[] cArray) {
        if (cArray == null) {
            return;
        }
        this.characters = new char[cArray.length];
        System.arraycopy(cArray, 0, this.characters, 0, cArray.length);
    }

    public ReaderEvent getParent() {
        return this.munger.getParentReaderEvent(this);
    }

    public ReaderEvent getParentReaderEvent() {
        return this.parent;
    }

    public boolean isDiscarded() {
        return this.discard;
    }

    public void setDiscard() {
        this.discard = true;
    }

    public Stack getChildren() {
        return this.children;
    }

    public BasicMunger getBasicMunger() {
        return this.munger;
    }

    protected void setBasicMunger(BasicMunger basicMunger) {
        this.munger = basicMunger;
    }

    public Location getLocation() {
        return this.location;
    }

    public void setLocation(Location location) {
        this.location = location;
    }

    public ReaderEvent getBeanEvent() {
        return this.beanEvent;
    }

    AbstractDescriptorBean getBean() {
        return this.bean;
    }

    void setBean(AbstractDescriptorBean abstractDescriptorBean) {
        this.bean = abstractDescriptorBean;
    }

    public int getEventType() {
        return this.eventType;
    }

    public int getAttributeCount() {
        return this.attributeCount;
    }

    public void setAttributeCount(int n) {
        this.attributeCount = n;
        if (n > 0) {
            this.ensureSpaceAvail(n);
        }
    }

    public String getAttributeLocalName(int n) {
        if (n < 0 || n >= this.attributeCount) {
            throw new IndexOutOfBoundsException("attribute position must be 0.." + (this.attributeCount - 1) + " and not " + n);
        }
        return this.attributeNames[n];
    }

    public void setAttributeLocalName(String string, int n) {
        if (string.equals("name")) {
            this.isKey = true;
        }
        this.attributeNames[n] = string;
    }

    public String getAttributeNamespace(int n) {
        if (n < 0 || n >= this.attributeCount) {
            throw new IndexOutOfBoundsException("attribute position must be 0.." + (this.attributeCount - 1) + " and not " + n);
        }
        return this.attributeUris[n];
    }

    public void setAttributeNamespace(String string, int n) {
        this.attributeUris[n] = string;
    }

    public String getAttributePrefix(int n) {
        if (n < 0 || n >= this.attributeCount) {
            throw new IndexOutOfBoundsException("attribute position must be 0.." + (this.attributeCount - 1) + " and not " + n);
        }
        return this.attributePrefixes[n];
    }

    public void setAttributePrefix(String string, int n) {
        this.attributePrefixes[n] = string;
    }

    public String getAttributeType(int n) {
        return "CDATA";
    }

    public boolean isAttributeSpecified(int n) {
        return false;
    }

    public String getAttributeValue(int n) {
        if (n < 0 || n >= this.attributeCount) {
            throw new IndexOutOfBoundsException("attribute position must be 0.." + (this.attributeCount - 1) + " and not " + n);
        }
        return this.attributeValues[n];
    }

    public void setAttributeValue(String string, int n) {
        this.attributeValues[n] = string;
    }

    public String getAttributeValue(String string, String string2) {
        if (string != null) {
            for (int i = 0; i < this.attributeCount; ++i) {
                if (!string.equals(this.attributeUris[i]) || !string2.equals(this.attributeNames[i])) continue;
                return this.attributeValues[i];
            }
        } else {
            for (int i = 0; i < this.attributeCount; ++i) {
                if (!string2.equals(this.attributeNames[i])) continue;
                return this.attributeValues[i];
            }
        }
        return null;
    }

    public void setAttributeValue(String string, String string2, String string3) {
        if (string == null || this.attributeCount == 0) {
            return;
        }
        if (string2 != null) {
            for (int i = 0; i < this.attributeCount; ++i) {
                if (!string2.equals(this.attributeUris[i]) || !string3.equals(this.attributeNames[i]) || !string.equals(this.attributeValues[i])) continue;
                return;
            }
        } else {
            for (int i = 0; i < this.attributeCount; ++i) {
                if (!string3.equals(this.attributeNames[i]) || !string.equals(this.attributeValues[i])) continue;
                return;
            }
        }
        if (string2 != null) {
            this.attributeUris[this.attributeCount - 1] = string2;
        }
        this.attributeNames[this.attributeCount - 1] = string3;
        this.attributeValues[this.attributeCount - 1] = string;
    }

    public QName getAttributeName(int n) {
        return new QName(this.getAttributeNamespace(n), this.getAttributeLocalName(n), this.getAttributePrefix(n));
    }

    public String getCharacterEncodingScheme() {
        return this.charEncodingScheme;
    }

    public void setCharacterEncodingScheme(String string) {
        this.charEncodingScheme = string;
    }

    public int getNamespaceCount() {
        return this.namespaceCount;
    }

    public void setNamespaceCount(int n) {
        this.namespaceCount = n;
    }

    public String getElementText() {
        return null;
    }

    public void setElementText(String string) {
    }

    public String getEncoding() {
        return this.inputEncoding;
    }

    public void setEncoding(String string) {
        this.inputEncoding = string;
    }

    private void ensureSpaceAvail(int n) {
        int n2;
        int n3 = n2 = this.attributeValues == null ? 0 : this.attributeValues.length;
        if (n > n2) {
            int n4;
            int n5 = n4 = n > 10 ? n * 2 : 10;
            if (this.attributeValues == null) {
                this.attributeNames = new String[n4];
                this.attributeValues = new String[n4];
                this.attributeUris = new String[n4];
                this.attributePrefixes = new String[n4];
                return;
            }
            String[] stringArray = null;
            stringArray = new String[n4];
            System.arraycopy(this.attributeNames, 0, stringArray, 0, n2);
            this.attributeNames = stringArray;
            stringArray = new String[n4];
            System.arraycopy(this.attributePrefixes, 0, stringArray, 0, n2);
            this.attributePrefixes = stringArray;
            stringArray = new String[n4];
            System.arraycopy(this.attributeUris, 0, stringArray, 0, n2);
            this.attributeUris = stringArray;
            stringArray = new String[n4];
            System.arraycopy(this.attributeValues, 0, stringArray, 0, n2);
            this.attributeValues = stringArray;
        }
    }

    void consumeElement(StringBuffer stringBuffer) {
        CharSequence charSequence;
        int n;
        int n2 = stringBuffer.indexOf("/");
        if (n2 == -1) {
            throw new AssertionError((Object)("Invalid xpath-- [" + stringBuffer + "] -- does not start with a \"/\""));
        }
        int n3 = stringBuffer.indexOf("/", n2 + 1);
        if (debug) {
            System.out.println("... starting xpath = " + stringBuffer + ", start = " + n2 + ", end = " + n3);
        }
        if (n3 == -1) {
            n3 = stringBuffer.length();
        }
        this.localName = stringBuffer.substring(n2 + 1, n3);
        int n4 = this.localName.indexOf("[");
        if (n4 > -1) {
            n = stringBuffer.indexOf("]");
            if (n3 < n) {
                n3 = stringBuffer.indexOf("/", n);
                this.localName = stringBuffer.substring(n2 + 1, n3);
            }
            charSequence = new StringBuffer(this.localName.substring(n4));
            charSequence = ((StringBuffer)charSequence).deleteCharAt(0).deleteCharAt(((StringBuffer)charSequence).length() - 1);
            this.localName = this.localName.substring(0, n4);
            int n5 = ((StringBuffer)charSequence).indexOf(",");
            if (n5 > -1) {
                String[] stringArray = StringUtils.splitCompletely((String)((StringBuffer)charSequence).toString(), (String)",", (boolean)false);
                for (int i = 0; i < stringArray.length; ++i) {
                    this.parseAttribute(stringArray[i]);
                }
            } else {
                this.parseAttribute(((StringBuffer)charSequence).toString());
                this.isKey = true;
            }
        }
        stringBuffer.delete(n2, n3);
        if (stringBuffer.length() > 0 && Character.isWhitespace(stringBuffer.charAt(0))) {
            throw new AssertionError((Object)("Whitespace not allowed: [" + stringBuffer + "]"));
        }
        if (stringBuffer.length() > 2 && stringBuffer.charAt(0) == '/' && stringBuffer.charAt(1) == '[') {
            n = stringBuffer.indexOf("]");
            if (n == -1) {
                throw new AssertionError((Object)("Invalid key definition-- [" + stringBuffer + "]"));
            }
            charSequence = stringBuffer.substring(2, n);
            if (((String)charSequence).indexOf(",") > -1) {
                String[] stringArray = StringUtils.splitCompletely((String)charSequence, (String)",", (boolean)false);
                for (int i = 0; i < stringArray.length; ++i) {
                    ReaderEvent readerEvent = this.parseChild(stringArray[i]);
                    readerEvent.isKeyComponent = true;
                    this.children.add(readerEvent);
                }
            } else {
                ReaderEvent readerEvent = this.parseChild((String)charSequence);
                readerEvent.isKey = true;
                this.children.add(readerEvent);
            }
            stringBuffer.delete(0, n + 1);
            if (debug) {
                System.out.println(".. resulting xpath = " + stringBuffer);
            }
        }
    }

    private ReaderEvent parseChild(String string) {
        String[] stringArray = StringUtils.splitCompletely((String)string, (String)"=", (boolean)false);
        if (stringArray.length != 2) {
            throw new AssertionError((Object)("Keys must be defined as name value pairs, eg, name=\"value\" -- [" + string + "]"));
        }
        String string2 = stringArray[0];
        String string3 = stringArray[1];
        if (!string3.startsWith("\"") || string3.charAt(string3.length() - 1) != '\"') {
            throw new AssertionError((Object)("Key values must be quoted strings: [" + string3 + "]"));
        }
        string3 = string3.substring(1, string3.length() - 1);
        ReaderEvent readerEvent = new ReaderEvent(string2, this, this.munger, this.location);
        readerEvent.eventType = 1;
        readerEvent.characters = string3.toCharArray();
        return readerEvent;
    }

    private void parseAttribute(String string) {
        String[] stringArray = StringUtils.splitCompletely((String)string, (String)"=", (boolean)false);
        if (stringArray.length != 2) {
            throw new AssertionError((Object)("Attributes must be defined as name value pairs, eg, name=\"value\" -- [" + string + "]"));
        }
        String string2 = stringArray[0];
        String string3 = stringArray[1];
        if (!string3.startsWith("\"") || string3.charAt(string3.length() - 1) != '\"') {
            throw new AssertionError((Object)("Attributes must be defined as name value pairs, eg, name=\"value\" -- [" + string + "]"));
        }
        string3 = string3.substring(1, string3.length() - 1);
        this.setAttributeCount(this.getAttributeCount() + 1);
        this.setAttributeValue(string3, null, string2);
    }

    public void toXML(PrintStream printStream) {
        printStream.print("<");
        printStream.print(this.getLocalName());
        if (this.getAttributeCount() > 0) {
            for (int i = 0; i < this.getAttributeCount(); ++i) {
                printStream.print(" " + this.getAttributeLocalName(i) + " = " + this.getAttributeValue(i));
            }
        }
        SchemaHelper schemaHelper = null;
        schemaHelper = this.helper == null && this.getBean() != null ? this.getBean()._getSchemaHelper2() : this.helper;
        if (schemaHelper == null) {
            printStream.print(", helper is not set!!!");
        }
        printStream.print(">");
        if (this.characters != null) {
            printStream.print(new String(this.characters));
        }
        if (this.children != null) {
            for (ReaderEvent readerEvent : this.children) {
                if (readerEvent.isDiscarded()) continue;
                readerEvent.toXML(printStream);
            }
        }
        printStream.print("</");
        printStream.print(this.getLocalName());
        printStream.print(">\n");
    }

    public void discard() {
        this.discard = true;
        if (this.children != null) {
            for (ReaderEvent readerEvent : this.children) {
                readerEvent.discard();
            }
        }
    }

    public void fixParents(ReaderEvent readerEvent) {
        this.parent = readerEvent;
        if (this.children == null) {
            return;
        }
        for (ReaderEvent readerEvent2 : this.children) {
            readerEvent2.fixParents(this);
        }
    }

    public String getElementName() {
        return this.localName;
    }

    public Munger.ReaderEventInfo getParentReaderInfo() {
        return this.parent;
    }

    public boolean compareXpaths(String string) {
        if (string.length() == this.localName.length()) {
            return string.equals(this.localName);
        }
        int n = string.lastIndexOf("/");
        if (n == -1) {
            return false;
        }
        String string2 = string.substring(n + 1);
        if (string2.length() == this.localName.length()) {
            return string2.equals(this.localName);
        }
        return false;
    }

    public void validate(SchemaHelper schemaHelper) throws DescriptorException {
        this.helper = schemaHelper;
        for (ReaderEvent readerEvent : this.children) {
            int n = schemaHelper.getPropertyIndex(readerEvent.getElementName());
            if (n == -1) {
                throw new DescriptorException("plan xpath defines an element [" + readerEvent.getPath() + "] that is not valid!");
            }
            SchemaHelper schemaHelper2 = schemaHelper.getSchemaHelper(n);
            if (schemaHelper2 != null) {
                readerEvent.validate(schemaHelper2);
                continue;
            }
            readerEvent.helper = schemaHelper;
        }
    }

    public SchemaHelper getSchemaHelper() {
        return this.helper;
    }

    public void toQueuedEvents(ArrayList arrayList) {
        ReaderEvent readerEvent = this.getQueuedEvent(1, this.getLocalName(), this.getLocation());
        readerEvent.beanEvent = this.beanEvent;
        readerEvent.bean = this.bean;
        readerEvent.helper = this.helper;
        arrayList.add(readerEvent);
        if (this.characters != null) {
            arrayList.add(this.getQueuedEvent(4, this.getCharacters(), this.getLocation()));
        }
        if (this.children != null) {
            for (ReaderEvent readerEvent2 : this.children) {
                if (readerEvent2.isDiscarded()) continue;
                readerEvent2.toQueuedEvents(arrayList);
            }
        }
        if (this.attributeCount > 0) {
            readerEvent.attributeCount = this.attributeCount;
            readerEvent.attributeNames = this.attributeNames;
            readerEvent.attributeValues = this.attributeValues;
            readerEvent.attributeUris = this.attributeUris;
            readerEvent.attributePrefixes = this.attributePrefixes;
        }
        arrayList.add(this.getQueuedEvent(2, this.getLocalName(), this.getLocation()));
    }

    protected ReaderEvent getQueuedEvent(int n, Object object, Location location) {
        return new ReaderEvent(n, object, location, this.munger);
    }

    public void setOperation(int n) {
        this.operation = n;
    }

    public int getOperation() {
        return this.operation;
    }

    public void removeNamedChildren(String string) {
        Stack stack = this.getChildren();
        int n = 0;
        while (n < stack.size()) {
            ReaderEvent readerEvent = (ReaderEvent)stack.elementAt(n);
            if (readerEvent.getLocalName().equals(string)) {
                stack.removeElementAt(n);
                continue;
            }
            ++n;
        }
    }

    public Object getBeanKey(SchemaHelper schemaHelper) {
        if (schemaHelper.hasKey()) {
            for (int i = 0; i < this.getChildren().size(); ++i) {
                ReaderEvent readerEvent = (ReaderEvent)this.getChildren().elementAt(i);
                if (!schemaHelper.isKey(schemaHelper.getPropertyIndex(readerEvent.getElementName()))) continue;
                return readerEvent.getTrimmedTextCharacters();
            }
        }
        return null;
    }

    public boolean isBeanKey(SchemaHelper schemaHelper) {
        if (schemaHelper.hasKey()) {
            return schemaHelper.isKey(schemaHelper.getPropertyIndex(this.getElementName()));
        }
        return schemaHelper.isKeyChoice(schemaHelper.getPropertyIndex(this.getElementName()));
    }

    public boolean hasBeanCompositeKey() {
        return this.getBean() == null ? false : this.getBean()._getSchemaHelper2().getKeyElementNames().length > 1;
    }

    public String getBeanCompositeKey(SchemaHelper schemaHelper) {
        String[] stringArray = schemaHelper.getKeyElementNames();
        StringBuffer stringBuffer = new StringBuffer("[");
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            stringBuffer.append("[");
            for (int j = 0; j < this.getChildren().size(); ++j) {
                ReaderEvent readerEvent = (ReaderEvent)this.getChildren().elementAt(j);
                if (!string.equals(readerEvent.getLocalName())) continue;
                stringBuffer.append("\"");
                String string2 = readerEvent.getTrimmedTextCharacters();
                if (string2 != null) {
                    stringBuffer.append(string2);
                }
                stringBuffer.append("\",");
            }
            if (stringBuffer.charAt(stringBuffer.length() - 1) == ',') {
                stringBuffer.deleteCharAt(stringBuffer.length() - 1);
            }
            stringBuffer.append("]");
            if (i >= stringArray.length - 1) continue;
            stringBuffer.append(",");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public String getBeanCompositeKey() {
        return this.getBeanCompositeKey(this.getBean()._getSchemaHelper2());
    }

    public boolean isSingleton() {
        AbstractDescriptorBean abstractDescriptorBean = this.munger.getCurrentOrEventBean(this);
        SchemaHelper schemaHelper = null;
        schemaHelper = abstractDescriptorBean != null ? abstractDescriptorBean._getSchemaHelper2() : this.getSchemaHelper();
        if (schemaHelper != null && !schemaHelper.isArray(schemaHelper.getPropertyIndex(this.getElementName()))) {
            return true;
        }
        return abstractDescriptorBean == null ? false : abstractDescriptorBean._isPropertyASingleton((Munger.ReaderEventInfo)this);
    }

    public boolean isAdditive() {
        AbstractDescriptorBean abstractDescriptorBean = this.munger.getCurrentOrEventBean(this);
        return abstractDescriptorBean == null ? false : abstractDescriptorBean._isPropertyAdditive((Munger.ReaderEventInfo)this);
    }

    public static boolean compareKeys(Object object, Object object2) {
        if (object == object2) {
            return true;
        }
        if (object == null || object2 == null) {
            return false;
        }
        return object.equals(object2);
    }

    public boolean searchSubTree(ReaderEvent readerEvent) {
        Stack stack = this.getChildren();
        for (int i = 0; i < stack.size(); ++i) {
            ReaderEvent readerEvent2 = (ReaderEvent)stack.elementAt(i);
            if (readerEvent2 == readerEvent) {
                return true;
            }
            if (!readerEvent2.searchSubTree(readerEvent)) continue;
            return true;
        }
        return false;
    }

    public void replaceAndMoveChildren(ReaderEvent readerEvent) {
        Stack stack = this.getChildren();
        stack.removeAllElements();
        Stack stack2 = readerEvent.getChildren();
        for (int i = 0; i < stack2.size(); ++i) {
            ReaderEvent readerEvent2 = (ReaderEvent)stack2.elementAt(i);
            readerEvent2.fixParents(this);
            stack.add(readerEvent2);
        }
        stack2.removeAllElements();
    }

    public String getTrimmedTextCharacters() {
        String string = this.getCharactersAsString();
        return string != null ? string.trim() : string;
    }
}

