/*
 * Decompiled with CFR 0.152.
 */
package weblogic.application.descriptor;

import java.io.PrintStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Stack;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamConstants;
import weblogic.application.descriptor.MissingRootElementException;
import weblogic.application.descriptor.ReaderEventInfo;
import weblogic.descriptor.internal.SchemaHelper;
import weblogic.utils.Debug;
import weblogic.utils.StringUtils;

public class ReaderEvent2
implements XMLStreamConstants {
    private static boolean debug = Debug.getCategory((String)"weblogic.descriptor.merge").isEnabled();
    private static boolean test = Debug.getCategory((String)"weblogic.descriptor.merge.test").isEnabled();
    private ReaderEventInfo info;
    private ReaderEvent2 parent;
    private Stack children = new Stack();
    private boolean childrenFromKey = false;
    SchemaHelper helper;
    private boolean discard = false;
    private ReaderEvent2 originalParent;

    public ReaderEvent2(int n, Location location) {
        this.info = new ReaderEventInfo(n, location);
        this.helper = new SchemaHelper(){
            SchemaHelper myHelper;

            public int getPropertyIndex(String string) {
                return this.getRootSchemaHelper().getPropertyIndex(string);
            }

            public SchemaHelper getSchemaHelper(int n) {
                return this.getRootSchemaHelper().getSchemaHelper(n);
            }

            public String getElementName(int n) {
                return this.getRootSchemaHelper().getElementName(n);
            }

            public boolean isArray(int n) {
                return this.getRootSchemaHelper().isArray(n);
            }

            public boolean isAttribute(int n) {
                return this.getRootSchemaHelper().isAttribute(n);
            }

            public String getAttributeName(int n) {
                return this.getRootSchemaHelper().getAttributeName(n);
            }

            public boolean isBean(int n) {
                return this.getRootSchemaHelper().isBean(n);
            }

            public boolean isConfigurable(int n) {
                return this.getRootSchemaHelper().isConfigurable(n);
            }

            public boolean isKey(int n) {
                return this.getRootSchemaHelper().isKey(n);
            }

            public boolean isKeyChoice(int n) {
                return this.getRootSchemaHelper().isKeyChoice(n);
            }

            public boolean isKeyComponent(int n) {
                return this.getRootSchemaHelper().isKeyComponent(n);
            }

            public boolean hasKey() {
                return this.getRootSchemaHelper().hasKey();
            }

            public String[] getKeyElementNames() {
                return this.getRootSchemaHelper().getKeyElementNames();
            }

            public String getRootElementName() {
                return this.getRootSchemaHelper().getRootElementName();
            }

            public boolean isMergeRulePrependDefined(int n) {
                return this.getRootSchemaHelper().isMergeRulePrependDefined(n);
            }

            public boolean isMergeRuleIgnoreSourceDefined(int n) {
                return this.getRootSchemaHelper().isMergeRuleIgnoreSourceDefined(n);
            }

            public boolean isMergeRuleIgnoreTargetDefined(int n) {
                return this.getRootSchemaHelper().isMergeRuleIgnoreTargetDefined(n);
            }

            private SchemaHelper getRootSchemaHelper() {
                if (this.myHelper == null) {
                    for (ReaderEvent2 readerEvent2 : ReaderEvent2.this.children) {
                        if (readerEvent2.helper == null || !readerEvent2.isStartElement()) continue;
                        this.myHelper = readerEvent2.helper;
                        break;
                    }
                }
                if (this.myHelper == null) {
                    throw new MissingRootElementException();
                }
                return this.myHelper;
            }
        };
    }

    public ReaderEvent2(int n, String string, ReaderEvent2 readerEvent2, Location location) {
        this.info = new ReaderEventInfo(n, string, location);
        this.parent = readerEvent2;
        if (readerEvent2.info.namespaces != null) {
            this.info.getNamespaces().copy(readerEvent2.info.namespaces);
        }
    }

    public ReaderEvent2(StringBuffer stringBuffer, ReaderEvent2 readerEvent2, SchemaHelper schemaHelper, String string, Location location) {
        this.parent = readerEvent2;
        this.helper = schemaHelper;
        this.consumeElements(stringBuffer, string, location);
    }

    public ReaderEvent2 getParent() {
        return this.parent;
    }

    public void setParent(ReaderEvent2 readerEvent2) {
        this.parent = readerEvent2;
    }

    public ReaderEvent2 getOriginalParent() {
        return this.originalParent;
    }

    public void setOriginalParent(ReaderEvent2 readerEvent2) {
        this.originalParent = readerEvent2;
    }

    public ReaderEventInfo getReaderEventInfo() {
        return this.info;
    }

    public int getEventType() {
        return this.info.getEventType();
    }

    public String getElementName() {
        return this.info.getElementName();
    }

    public void setElementName(String string) {
        this.info.setElementName(string);
    }

    public char[] getCharacters() {
        return this.info.getCharacters();
    }

    public void setCharacters(char[] cArray) {
        this.info.setCharacters(cArray);
    }

    public String getTextCharacters() {
        return this.info.getCharactersAsString();
    }

    private String getTrimmedTextCharacters() {
        String string = this.getTextCharacters();
        return string != null ? string.trim() : string;
    }

    public Location getLocation() {
        return this.info.getLocation();
    }

    public String toString() {
        if (this.info != null) {
            String string = super.toString();
            string = string.substring(string.lastIndexOf("@"));
            if (this.info.getElementName() != null) {
                return this.info.getElementName() + string;
            }
            return "ReaderEvent2-type = " + this.info.getEventType() + string;
        }
        return super.toString();
    }

    public boolean isDiscarded() {
        return this.discard;
    }

    public void setDiscard() {
        this.discard = true;
    }

    public void setDiscard(boolean bl) {
        this.discard = bl;
    }

    public Stack getChildren() {
        return this.children;
    }

    public void addChild(ReaderEvent2 readerEvent2) {
        this.children.add(readerEvent2);
    }

    public boolean isChildrenFromKey() {
        return this.childrenFromKey;
    }

    public void setChildrenFromKey(boolean bl) {
        this.childrenFromKey = bl;
    }

    public void validate(SchemaHelper schemaHelper) {
        this.helper = schemaHelper;
        for (ReaderEvent2 readerEvent2 : this.children) {
            int n = schemaHelper.getPropertyIndex(readerEvent2.getReaderEventInfo().getElementName());
            if (n == -1) {
                throw new AssertionError((Object)("plan xpath defines an element [" + readerEvent2.getReaderEventInfo().getElementName() + "] that is not valid!"));
            }
            SchemaHelper schemaHelper2 = schemaHelper.getSchemaHelper(n);
            if (schemaHelper2 != null) {
                readerEvent2.validate(schemaHelper2);
                continue;
            }
            readerEvent2.helper = schemaHelper;
        }
    }

    void consumeElements(StringBuffer stringBuffer, String string, Location location) {
        this.consumeElement(stringBuffer, location);
        int n = this.helper.getPropertyIndex(this.getReaderEventInfo().getElementName());
        if (n != -1) {
            this.helper = this.helper.getSchemaHelper(n);
        }
        if (stringBuffer.length() == 1 && stringBuffer.charAt(0) == '/') {
            if (this.childrenFromKey && this.getChildren().size() == 1) {
                ReaderEvent2 readerEvent2 = (ReaderEvent2)this.getChildren().peek();
                ReaderEventInfo readerEventInfo = readerEvent2.info;
                if (readerEventInfo.isKeyCharacters() && string != null && !Arrays.equals(string.toCharArray(), readerEventInfo.getCharacters())) {
                    readerEventInfo.setKeyOverride(true);
                    readerEventInfo.setKeyOverrideCharacters(string.toCharArray());
                }
            }
        } else if (stringBuffer.length() > 0 && stringBuffer.charAt(0) == '/') {
            this.consumeChildren(stringBuffer, string, location);
        } else {
            this.consumeText(stringBuffer, string, location);
        }
    }

    void consumeChildren(StringBuffer stringBuffer, String string, Location location) {
        this.getChildren().push(new ReaderEvent2(stringBuffer, this, this.helper, string, location));
    }

    void consumeText(StringBuffer stringBuffer, String string, Location location) {
        if (debug) {
            System.out.println("Adding " + string + " to " + this.info.getElementName());
        }
        if (string == null) {
            return;
        }
        if ((string = string.trim()).length() == 0 && this.getParent().isArray(this.getPropertyIndex())) {
            return;
        }
        if (string.indexOf("\",\"") > 0) {
            String[] stringArray = StringUtils.splitCompletely((String)string, (String)",", (boolean)false);
            this.info.setCharacters(stringArray[stringArray.length - 1].substring(1, stringArray[stringArray.length - 1].length() - 1).toCharArray());
            for (int i = 0; i < stringArray.length - 1; ++i) {
                if (debug) {
                    System.out.println("xpath = " + stringBuffer + ", val = " + stringArray[i]);
                }
                StringBuffer stringBuffer2 = new StringBuffer("/" + this.info.getElementName());
                this.getParent().getChildren().push(new ReaderEvent2(stringBuffer2, this.parent, this.helper, stringArray[i], location));
            }
        } else {
            if (string.startsWith("\"")) {
                string = string.substring(1, string.length() - 1);
            }
            this.info.setCharacters(string.toCharArray());
        }
    }

    void consumeElement(StringBuffer stringBuffer, Location location) {
        Object object;
        CharSequence charSequence;
        int n;
        String string;
        int n2;
        int n3 = stringBuffer.indexOf("/");
        if (n3 == -1) {
            throw new AssertionError((Object)("Invalid xpath-- [" + stringBuffer + "] -- does not start with a \"/\""));
        }
        int n4 = n3 + 1;
        int n5 = stringBuffer.indexOf("/", n4);
        int n6 = stringBuffer.indexOf("\"", n4);
        if (n6 != -1 && n6 < n5) {
            n4 = n6 + 1;
            n6 = stringBuffer.indexOf("\"", n4);
            n5 = stringBuffer.indexOf("/", n6);
        }
        if (debug) {
            System.out.println("... starting xpath = " + stringBuffer + ", start = " + n3 + ", end = " + n5);
        }
        if (n5 == -1) {
            n5 = stringBuffer.length();
        }
        if ((n2 = (string = stringBuffer.substring(n3 + 1, n5)).indexOf("[")) == -1) {
            n = string.indexOf(" xmlns");
            charSequence = null;
            if (n != -1) {
                charSequence = string.substring(n);
                string = string.substring(0, n);
            }
            this.info = new ReaderEventInfo(1, string, location);
            if (charSequence != null) {
                this.setNamespaces(this.info, (String)charSequence);
            }
        } else {
            n = stringBuffer.indexOf("]");
            if (n5 < n) {
                n5 = stringBuffer.indexOf("/", n);
                string = stringBuffer.substring(n3 + 1, n5);
            }
            charSequence = new StringBuffer(string.substring(n2));
            charSequence = ((StringBuffer)charSequence).deleteCharAt(0).deleteCharAt(((StringBuffer)charSequence).length() - 1);
            string = string.substring(0, n2);
            this.info = new ReaderEventInfo(1, string, location);
            int n7 = ((StringBuffer)charSequence).indexOf(",");
            if (n7 > -1) {
                object = StringUtils.splitCompletely((String)((StringBuffer)charSequence).toString(), (String)",", (boolean)false);
                int n8 = this.info.getAttributeCount();
                for (int i = 0; i < ((String[])object).length; ++i) {
                    this.parseAttribute(object[i]);
                }
            } else {
                this.parseAttribute(((StringBuffer)charSequence).toString());
            }
        }
        stringBuffer.delete(n3, n5);
        if (stringBuffer.length() > 0 && Character.isWhitespace(stringBuffer.charAt(0))) {
            throw new AssertionError((Object)("Whitespace not allowed: [" + stringBuffer + "]"));
        }
        if (stringBuffer.length() > 2 && stringBuffer.charAt(0) == '/' && stringBuffer.charAt(1) == '[') {
            this.childrenFromKey = true;
            n = stringBuffer.indexOf("=");
            if (n < 3) {
                throw new AssertionError((Object)("Key element name not found in [" + stringBuffer + "]"));
            }
            int n9 = stringBuffer.indexOf("]");
            if (n == -1 || n9 == -1) {
                throw new AssertionError((Object)("Invalid key definition-- [" + stringBuffer + "]"));
            }
            if (stringBuffer.indexOf("\",") > -1) {
                String[] stringArray = StringUtils.splitCompletely((String)stringBuffer.toString(), (String)",", (boolean)false);
                for (int i = 0; i < stringArray.length; ++i) {
                    String string2 = null;
                    string2 = stringArray[i].indexOf("\"]") > -1 ? stringArray[i].substring(0, stringArray[i].indexOf("\"]")) : stringArray[i];
                    String[] stringArray2 = StringUtils.splitCompletely((String)string2, (String)"=", (boolean)false);
                    for (int j = 0; j < stringArray2.length; ++j) {
                        int n10;
                        String string3 = stringArray2[j];
                        String string4 = stringArray2[++j];
                        if (string3.startsWith("/")) {
                            string3 = string3.substring(1);
                        }
                        if (string3.startsWith("[")) {
                            string3 = string3.substring(1);
                        }
                        if (string4.startsWith("\"")) {
                            string4 = string4.substring(1);
                        }
                        if ((n10 = string4.indexOf("\"")) > -1) {
                            string4 = string4.substring(0, n10);
                        }
                        ReaderEvent2 readerEvent2 = new ReaderEvent2(1, string3, this, location);
                        readerEvent2.getReaderEventInfo().setCharacters(string4.toCharArray());
                        readerEvent2.getReaderEventInfo().setKeyCharacters(true);
                        this.getChildren().add(readerEvent2);
                    }
                }
            } else {
                String string5 = stringBuffer.substring(n + 1, n9);
                if (!string5.startsWith("\"") || string5.charAt(string5.length() - 1) != '\"') {
                    throw new AssertionError((Object)("Key values must be quoted strings: [" + string5 + "]"));
                }
                string5 = string5.substring(1, string5.length() - 1);
                object = stringBuffer.substring(2, n);
                ReaderEvent2 readerEvent2 = new ReaderEvent2(1, (String)object, this, location);
                readerEvent2.getReaderEventInfo().setCharacters(string5.toCharArray());
                readerEvent2.getReaderEventInfo().setKeyCharacters(true);
                this.getChildren().add(readerEvent2);
            }
            stringBuffer.delete(0, n9 + 1);
        }
        if (debug) {
            System.out.println(".. resulting xpath = " + stringBuffer);
        }
    }

    void setNamespaces(ReaderEventInfo readerEventInfo, String string) {
        String[] stringArray = StringUtils.splitCompletely((String)string, (String)"=", (boolean)false);
        if (stringArray.length != 2) {
            throw new AssertionError((Object)("Namespaces must be defined as name value pairs, eg, name=\"value\" -- [" + string + "]"));
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            String string3 = stringArray[++i];
            int n = string2.indexOf(":");
            string2 = n == -1 ? null : string2.substring(n + 1);
            if (!string3.startsWith("\"") || string3.charAt(string3.length() - 1) != '\"') {
                throw new AssertionError((Object)("Namespaces must be defined as name and quoted value, eg, name=\"value\" -- [" + string + "]"));
            }
            string3 = string3.substring(1, string3.length() - 1);
            readerEventInfo.setNamespaceCount(readerEventInfo.getNamespaceCount() + 1);
            readerEventInfo.setNamespaceURI(string2, string3);
            readerEventInfo.setPrefix(string2);
        }
    }

    void parseAttribute(String string) {
        String[] stringArray = StringUtils.splitCompletely((String)string, (String)"=", (boolean)false);
        if (stringArray.length != 2) {
            throw new AssertionError((Object)("Attributes must be defined as name value pairs, eg, name=\"value\" -- [" + string + "]"));
        }
        String string2 = stringArray[0];
        String string3 = stringArray[1];
        if (!string3.startsWith("\"") || string3.charAt(string3.length() - 1) != '\"') {
            throw new AssertionError((Object)("Attributes must be defined as name value pairs, eg, name=\"value\" -- [" + string + "]"));
        }
        string3 = string3.substring(1, string3.length() - 1);
        this.info.setAttributeCount(this.info.getAttributeCount() + 1);
        this.info.setAttributeValue(string3, null, string2);
    }

    boolean isSimpleKey() {
        int n = this.helper.getPropertyIndex(this.info.getElementName());
        if (this.helper.isKey(n)) {
            return true;
        }
        if (this.helper.isKeyChoice(n)) {
            return true;
        }
        if (this.info.getAttributeCount() > 0) {
            for (int i = 0; i < this.info.getAttributeCount(); ++i) {
                n = this.helper.getPropertyIndex(this.info.getAttributeLocalName(i));
                if (!this.helper.isKey(n)) continue;
                return true;
            }
        }
        return false;
    }

    boolean isKeyComponent() {
        int n = this.helper.getPropertyIndex(this.info.getElementName());
        return this.helper.isKeyComponent(n);
    }

    boolean isKeyChoice() {
        int n = this.helper.getPropertyIndex(this.info.getElementName());
        return this.helper.isKeyChoice(n);
    }

    public void toXML(PrintStream printStream) {
        if (!this.isDiscarded()) {
            int n;
            printStream.print("\n<");
            String string = super.toString();
            printStream.print(this.info.getElementName() + string.substring(string.lastIndexOf("@")));
            printStream.print(" " + (this.helper == null ? "null" : this.helper.toString().substring(this.helper.toString().lastIndexOf(".") + 1)));
            if (this.info.getNamespaceCount() > 0) {
                for (n = 0; n < this.info.getNamespaceCount(); ++n) {
                    printStream.print(" ");
                    String string2 = this.info.getNamespacePrefix(n);
                    string2 = string2 == null ? "xmlns" : "xmlns:" + string2;
                    printStream.print(string2);
                    printStream.print("=\"");
                    printStream.print(this.info.getNamespaceURI(n));
                    printStream.print("\"");
                }
            }
            if (this.info.getAttributeCount() > 0) {
                for (n = 0; n < this.info.getAttributeCount(); ++n) {
                    printStream.print(" " + this.info.getAttributeLocalName(n) + " = " + this.info.getAttributeValue(n));
                }
            }
            printStream.print(">");
            printStream.print(this.info.getCharactersAsString());
        }
        if (this.children != null) {
            for (ReaderEvent2 readerEvent2 : this.children) {
                readerEvent2.toXML(printStream);
            }
        }
        if (!this.isDiscarded()) {
            printStream.print("</");
            printStream.print(this.info.getElementName());
            printStream.print(">\n");
        }
    }

    public void discard() {
        if (debug) {
            System.out.println("discard: " + this.getElementName());
        }
        this.discard = true;
        this.orphanChildren();
        ReaderEvent2 readerEvent2 = this.getParent();
    }

    public void orphanChild(ReaderEvent2 readerEvent2) {
        ReaderEvent2 readerEvent22;
        if (debug) {
            System.out.println("orphan: " + readerEvent2.getElementName());
        }
        if ((readerEvent22 = readerEvent2.getParent()) != null) {
            readerEvent22.getChildren().remove(readerEvent2);
            if (readerEvent22.getChildren().size() == 0) {
                readerEvent22.discard();
            }
        }
    }

    public void orphanChildren() {
        if (debug) {
            System.out.println("orphanChildren: " + this.getElementName());
        }
        this.getChildren().clear();
    }

    public SchemaHelper getSchemaHelper() {
        if (this.helper.getPropertyIndex(this.getElementName()) == -1) {
            if (this.parent.helper != null && this.parent.helper.getPropertyIndex(this.getElementName()) == -1) {
                return this.helper;
            }
            return this.parent.helper;
        }
        return this.helper;
    }

    public void setSchemaHelper(SchemaHelper schemaHelper) {
        this.helper = schemaHelper;
    }

    public boolean isRoot() {
        return this.getElementName() == null;
    }

    public boolean isBean() {
        assert (this.helper != null && this.parent != null);
        return this.helper != this.parent.helper;
    }

    public boolean isBeanKey() {
        if (!this.isBean()) {
            return false;
        }
        SchemaHelper schemaHelper = this.parent.helper;
        int n = schemaHelper.getPropertyIndex(this.getElementName());
        return schemaHelper.isKey(n) || schemaHelper.isKeyChoice(n) || schemaHelper.isKeyComponent(n);
    }

    public boolean hasKey() {
        ReaderEvent2 readerEvent2 = this.getNextChild(-1);
        while (readerEvent2 != null) {
            if (readerEvent2.isSimpleKey() || readerEvent2.isKeyComponent() || readerEvent2.isKeyChoice()) {
                return true;
            }
            readerEvent2 = this.getNextChild(readerEvent2);
        }
        return this.helper.hasKey();
    }

    public String getKey() {
        return this.getKey(false);
    }

    public String getKey(boolean bl) {
        if (this.info.getAttributeCount() > 0) {
            for (int i = 0; i < this.info.getAttributeCount(); ++i) {
                int n = this.helper.getPropertyIndex(this.info.getAttributeLocalName(i));
                if (!this.helper.isKey(n)) continue;
                return this.getXpath();
            }
        }
        ReaderEvent2 readerEvent2 = this.getNextChild(-1);
        while (readerEvent2 != null) {
            if (readerEvent2.isSimpleKey()) {
                return readerEvent2.getXpath();
            }
            if (readerEvent2.isKeyChoice()) {
                return readerEvent2.getXpath();
            }
            if (readerEvent2.isKeyComponent()) {
                return readerEvent2.getXpath(bl);
            }
            if (readerEvent2.isBeanKey()) {
                return readerEvent2.getXpath();
            }
            readerEvent2 = this.getNextChild(readerEvent2);
        }
        return this.getXpath();
    }

    public ReaderEvent2 getMatchingKey(String string) {
        if (debug) {
            System.out.println("getMatchingKey: " + string);
        }
        ReaderEvent2 readerEvent2 = this.getNextChild(-1);
        while (readerEvent2 != null) {
            if (debug) {
                System.out.print("--" + readerEvent2 + ", hasKey ? " + readerEvent2.hasKey() + ", getXpath = " + readerEvent2.getXpath());
            }
            if (debug) {
                System.out.println(readerEvent2.hasKey() ? ", getKey() = " + readerEvent2.getKey() : "");
            }
            if (readerEvent2.hasKey() && readerEvent2.getKey().equals(string)) {
                return readerEvent2;
            }
            readerEvent2 = this.getNextChild(readerEvent2);
        }
        if (this.hasKey()) {
            readerEvent2 = this.getNextChild(-1);
            while (readerEvent2 != null) {
                if (debug) {
                    System.out.println("---" + readerEvent2 + ", getXpath = " + readerEvent2.getXpath());
                }
                if (readerEvent2.getXpath().equals(string)) {
                    return readerEvent2;
                }
                readerEvent2 = this.getNextChild(readerEvent2);
            }
        }
        return null;
    }

    public ReaderEvent2 getMatchingElementName(String string) {
        if (debug) {
            System.out.println("getMatchingElementName");
        }
        ReaderEvent2 readerEvent2 = null;
        ReaderEvent2 readerEvent22 = this.getNextChild(-1);
        while (readerEvent22 != null) {
            if (debug) {
                System.out.println("--" + readerEvent22 + ", getXpath = " + readerEvent22.getElementName());
            }
            if (readerEvent22.getElementName().equals(string)) {
                if (readerEvent22.isDiscarded()) {
                    readerEvent2 = readerEvent22;
                } else {
                    return readerEvent22;
                }
            }
            readerEvent22 = this.getNextChild(readerEvent22);
        }
        return readerEvent2;
    }

    public ReaderEvent2 getMatchingEventFromKey(ReaderEvent2 readerEvent2) {
        if (debug) {
            System.out.println("getMatchingEventFromKey");
        }
        ReaderEvent2 readerEvent22 = this.getNextChild(-1);
        while (readerEvent22 != null) {
            if (debug) {
                System.out.println("--" + readerEvent22 + ", getXpath = " + readerEvent22.getElementName());
            }
            if (readerEvent22.getElementName().equals(readerEvent2.getElementName())) {
                boolean bl = true;
                for (ReaderEvent2 readerEvent23 : readerEvent2.getChildren()) {
                    if (debug) {
                        System.out.println("--" + readerEvent23 + ", getXpath = " + readerEvent23.getXpath());
                    }
                    if (!readerEvent23.getReaderEventInfo().isKeyCharacters()) continue;
                    for (ReaderEvent2 readerEvent24 : readerEvent22.getChildren()) {
                        char[] cArray;
                        char[] cArray2;
                        if (debug) {
                            System.out.println("--" + readerEvent24 + ", getXpath = " + readerEvent24.getXpath());
                        }
                        if (!readerEvent23.getElementName().equals(readerEvent24.getElementName()) || Arrays.equals(cArray2 = readerEvent23.getReaderEventInfo().getCharacters(), cArray = readerEvent24.getReaderEventInfo().getCharacters())) continue;
                        bl = false;
                    }
                }
                if (bl) {
                    return readerEvent22;
                }
            }
            readerEvent22 = this.getNextChild(readerEvent22);
        }
        return null;
    }

    public boolean isStartDoc() {
        return this.getEventType() == 7;
    }

    public boolean isStartElement() {
        return this.getEventType() == 1;
    }

    public SchemaHelper findRootSchemaHelper() {
        for (ReaderEvent2 readerEvent2 : this.children) {
            if (readerEvent2.helper == null) continue;
            this.helper = readerEvent2.helper;
        }
        return this.helper;
    }

    public void merge(ReaderEvent2 readerEvent2, int n, boolean bl) {
        if (debug) {
            System.out.println("merge, this = " + this + ", other = " + readerEvent2);
        }
        if (this.getEventType() != 7) {
            throw new AssertionError((Object)"must start merge form a START_DOCUMENT event");
        }
        block4: for (ReaderEvent2 readerEvent22 : this.getChildren()) {
            switch (readerEvent22.getEventType()) {
                case 5: 
                case 11: {
                    continue block4;
                }
                case 1: {
                    if (debug) {
                        System.out.println("\n target ReaderEvent to merge: ");
                        readerEvent22.toXML(System.out);
                        System.out.println("----------- end ReaderEvent --------");
                    }
                    ReaderEvent2 readerEvent23 = null;
                    for (ReaderEvent2 readerEvent24 : readerEvent2.getChildren()) {
                        if (readerEvent24.getEventType() != 1) continue;
                        readerEvent23 = readerEvent24;
                        break;
                    }
                    if (readerEvent23 == null) {
                        throw new AssertionError((Object)("Could not find start element within event: " + readerEvent2));
                    }
                    if (readerEvent22.getElementName().equals(readerEvent23.getElementName())) {
                        readerEvent22.mergeBean(readerEvent23, n, bl);
                    }
                    return;
                }
            }
            throw new AssertionError((Object)("Unknown event: " + readerEvent22.getEventType()));
        }
    }

    public void mergeBean(ReaderEvent2 readerEvent2, int n, boolean bl) {
        if (debug) {
            System.out.println("mergeBean: target = " + this.getElementName() + ", source = " + readerEvent2.getElementName());
        }
        HashSet hashSet = new HashSet();
        ReaderEvent2 readerEvent22 = readerEvent2.getNextChild(-1);
        while (readerEvent22 != null) {
            if (debug) {
                System.out.println("mergeBean for source child: " + readerEvent22.getElementName() + ", isBean " + readerEvent22.isBean() + ", hasKey " + readerEvent22.hasKey() + " prepend? " + readerEvent22.isMergeRulePrependDefined());
                System.out.println("" + readerEvent22.getTextCharacters());
            }
            if (readerEvent22.isBean()) {
                if (readerEvent22.hasKey()) {
                    this.mergeBeanWithKey(readerEvent22, n, bl);
                } else {
                    this.mergeBeanWithoutKey(readerEvent22, n, bl);
                }
            } else {
                this.mergePropertyImpl(readerEvent22, n, bl, hashSet);
            }
            readerEvent22 = readerEvent2.getNextChild(readerEvent22);
        }
    }

    private void mergeBeanWithKey(ReaderEvent2 readerEvent2, int n, boolean bl) {
        boolean bl2 = n == 3;
        ReaderEvent2 readerEvent22 = this.getMatchingKey(readerEvent2.getKey(bl2));
        if (this.isArray(readerEvent2.getPropertyIndex()) && readerEvent2.isMergeRulePrependDefined()) {
            if (readerEvent22 != null) {
                readerEvent22.mergeBean(readerEvent2, n, bl);
                return;
            }
            if (readerEvent22 == null) {
                readerEvent22 = this.getMatchingElementName(readerEvent2.getElementName());
            }
            if (readerEvent22 == null) {
                this.adopt(readerEvent2, bl);
            } else {
                this.adopt(readerEvent2, bl, true);
            }
        } else {
            if (readerEvent22 == null && bl && bl2) {
                return;
            }
            if (readerEvent22 == null) {
                this.adopt(readerEvent2, bl);
            } else if (!bl && readerEvent2.isMergeRuleIgnoreTargetDefined()) {
                readerEvent22.discard();
                this.adopt(readerEvent2, bl);
            } else {
                if (!bl && readerEvent2.isMergeRuleIgnoreSourceDefined()) {
                    return;
                }
                readerEvent22.mergeBean(readerEvent2, n, bl);
            }
        }
    }

    private void mergeBeanWithoutKey(ReaderEvent2 readerEvent2, int n, boolean bl) {
        ReaderEvent2 readerEvent22 = null;
        readerEvent22 = bl && this.isArray(readerEvent2.getPropertyIndex()) && readerEvent2.isChildrenFromKey() && n == 1 ? this.getMatchingEventFromKey(readerEvent2) : this.getMatchingElementName(readerEvent2.getElementName());
        if (this.isArray(readerEvent2.getPropertyIndex()) && readerEvent2.isMergeRulePrependDefined()) {
            if (readerEvent22 == null) {
                this.adopt(readerEvent2, bl);
            } else {
                this.adopt(readerEvent2, bl, true);
            }
        } else if (readerEvent22 == null) {
            this.adopt(readerEvent2, bl);
        } else if (!bl && readerEvent2.isMergeRuleIgnoreTargetDefined()) {
            readerEvent22.discard();
            this.adopt(readerEvent2, bl);
        } else {
            if (!bl && readerEvent2.isMergeRuleIgnoreSourceDefined()) {
                return;
            }
            if (!this.isArray(readerEvent2.getPropertyIndex()) || bl) {
                readerEvent22.mergeBean(readerEvent2, n, bl);
            } else if (this.isArray(readerEvent2.getPropertyIndex())) {
                if (readerEvent22 == null) {
                    this.adopt(readerEvent2, bl);
                } else {
                    this.adopt(readerEvent2, bl, true);
                }
            } else {
                this.adopt(readerEvent2, bl);
            }
        }
    }

    private void mergePropertyImpl(ReaderEvent2 readerEvent2, int n, boolean bl, HashSet hashSet) {
        ReaderEvent2 readerEvent22 = this.getMatchingElementName(readerEvent2.getElementName());
        int n2 = readerEvent2.getPropertyIndex();
        if (n == 3 && this.isArray(n2)) {
            if (!hashSet.contains(readerEvent2.getElementName())) {
                this.discardAllArrayElements(readerEvent2);
                hashSet.add(readerEvent2.getElementName());
            }
            n = 1;
        }
        if (debug) {
            System.out.println("mergeProperty t is " + readerEvent22);
        }
        if (readerEvent22 == null) {
            this.adopt(readerEvent2, bl);
        } else if (!bl && readerEvent2.isMergeRuleIgnoreTargetDefined()) {
            if (this.isArray(n2)) {
                if (!hashSet.contains(readerEvent2.getElementName())) {
                    this.discardAllArrayElements(readerEvent2);
                    hashSet.add(readerEvent2.getElementName());
                }
            } else {
                readerEvent22.discard();
            }
            this.adopt(readerEvent2, bl);
        } else {
            if (!bl && readerEvent2.isMergeRuleIgnoreSourceDefined()) {
                return;
            }
            switch (n) {
                case -1: 
                case 1: {
                    readerEvent22.mergeProperty(readerEvent2, n, bl);
                    break;
                }
                case 2: {
                    if (readerEvent22.isSimpleKey()) break;
                    readerEvent22.removeProperty(readerEvent2);
                    break;
                }
                case 3: {
                    if (readerEvent2.info.isKeyOverride()) {
                        readerEvent22.replacePropertyWithOverride(readerEvent2);
                        break;
                    }
                    readerEvent22.replaceProperty(readerEvent2);
                }
            }
        }
    }

    private void discardAllArrayElements(ReaderEvent2 readerEvent2) {
        ReaderEvent2 readerEvent22 = this;
        for (ReaderEvent2 readerEvent23 : readerEvent22.getChildren()) {
            if (!readerEvent2.getElementName().equals(readerEvent23.getElementName())) continue;
            readerEvent23.discard();
        }
    }

    public void adopt(ReaderEvent2 readerEvent2, SchemaHelper schemaHelper, boolean bl) {
        if (schemaHelper != null && this.getEventType() == 1) {
            this.adopt(readerEvent2, false, false, bl);
        } else {
            this.addChild(readerEvent2);
        }
    }

    public void adopt(ReaderEvent2 readerEvent2, SchemaHelper schemaHelper) {
        this.adopt(readerEvent2, schemaHelper, true);
    }

    void adopt(ReaderEvent2 readerEvent2, boolean bl) {
        this.adopt(readerEvent2, bl, false);
    }

    void adopt(ReaderEvent2 readerEvent2, boolean bl, boolean bl2) {
        this.adopt(readerEvent2, bl, bl2, true);
    }

    void adopt(ReaderEvent2 readerEvent2, boolean bl, boolean bl2, boolean bl3) {
        int n;
        block16: {
            int n2;
            block15: {
                ReaderEvent2 readerEvent22;
                if (debug) {
                    System.out.println("adopt: " + readerEvent2.getElementName() + " into parent = " + this.getElementName() + " isPlanMerge:" + bl + " prependArrayElements:" + bl2 + " reorderOnAdopt:" + bl3);
                }
                if ((readerEvent22 = this.getNextChild(n2 = this.helper.getPropertyIndex(readerEvent2.getElementName()))) == null) {
                    readerEvent22 = this.getPrevChild(n2);
                }
                if (debug) {
                    System.out.println("source is " + readerEvent2.getElementName() + ", next = " + readerEvent22);
                }
                if (readerEvent22 == null) {
                    this.getChildren().add(readerEvent2);
                    readerEvent2.setOriginalParent(readerEvent2.getParent());
                    readerEvent2.setParent(this);
                    return;
                }
                n = this.getChildren().indexOf(readerEvent22);
                int n3 = this.helper.getPropertyIndex(readerEvent22.getElementName());
                if (debug) {
                    System.out.println("indx = " + n + " propIndex = " + n2 + " nextPropIndex = " + n3 + " size = " + this.getChildren().size());
                }
                boolean bl4 = false;
                boolean bl5 = false;
                if (n2 < n3) break block15;
                if (this.helper.isArray(n2)) {
                    for (int i = 0; i < this.getChildren().size(); ++i) {
                        ReaderEvent2 readerEvent23 = (ReaderEvent2)this.getChildren().elementAt(i);
                        if (!readerEvent2.getElementName().equals(readerEvent23.getElementName())) continue;
                        n = i;
                        bl4 = true;
                        if (debug) {
                            System.out.println("Element name: " + readerEvent2.getElementName() + " indx = " + n + " matching element is true");
                        }
                        bl5 = readerEvent2.getParent() == readerEvent23.getOriginalParent();
                        if (bl2 && readerEvent2.getParent() != readerEvent23.getOriginalParent()) break;
                    }
                }
                if (bl2 && bl4 && !bl5) break block16;
                ++n;
                break block16;
            }
            if (bl2 && this.helper.isArray(n2)) {
                for (int i = 0; i < this.getChildren().size(); ++i) {
                    ReaderEvent2 readerEvent24 = (ReaderEvent2)this.getChildren().elementAt(i);
                    if (!readerEvent2.getElementName().equals(readerEvent24.getElementName()) || readerEvent2.getParent() == readerEvent24.getOriginalParent()) continue;
                    n = i;
                    break;
                }
            }
        }
        if (n < this.getChildren().size() && bl3) {
            this.getChildren().add(n, readerEvent2);
            if (debug) {
                System.out.println("Add element to children at indx " + n);
            }
        } else {
            this.getChildren().add(readerEvent2);
            if (debug) {
                System.out.println("Add element to children at end ");
            }
        }
        readerEvent2.setOriginalParent(readerEvent2.getParent());
        readerEvent2.setParent(this);
        if (this.info.getPrefix() != null) {
            this.setPrefixOnAdopt(readerEvent2, this.info.getPrefix());
        }
    }

    public void orderChildren() {
        int n;
        ReaderEvent2 readerEvent2;
        int n2;
        for (n2 = 0; n2 < this.getChildren().size(); ++n2) {
            readerEvent2 = (ReaderEvent2)this.getChildren().elementAt(n2);
            if (!readerEvent2.isDiscarded() || readerEvent2.getChildren().size() <= 0) continue;
            this.getChildren().addAll(readerEvent2.getChildren());
            for (n = 0; n < readerEvent2.getChildren().size(); ++n) {
                ReaderEvent2 readerEvent22 = (ReaderEvent2)readerEvent2.getChildren().elementAt(n);
                readerEvent22.setParent(readerEvent2);
            }
            readerEvent2.getChildren().clear();
        }
        for (n2 = this.getChildren().size() - 1; n2 > 1; --n2) {
            readerEvent2 = (ReaderEvent2)this.getChildren().elementAt(n2);
            if (!readerEvent2.isDiscarded()) continue;
            this.getChildren().remove(n2);
        }
        SchemaHelper schemaHelper = this.helper;
        int n3 = this.getChildren().size();
        for (n = 0; n < this.getChildren().size(); ++n) {
            for (int i = n + 1; i < n3; ++i) {
                ReaderEvent2 readerEvent23 = (ReaderEvent2)this.getChildren().elementAt(n);
                int n4 = schemaHelper.getPropertyIndex(readerEvent23.getElementName());
                ReaderEvent2 readerEvent24 = (ReaderEvent2)this.getChildren().elementAt(i);
                int n5 = schemaHelper.getPropertyIndex(readerEvent24.getElementName());
                if (n5 == -1 || n5 >= n4) continue;
                this.getChildren().removeElementAt(i);
                this.getChildren().insertElementAt(readerEvent24, n);
            }
        }
        for (n = 0; n < this.getChildren().size(); ++n) {
            ReaderEvent2 readerEvent25 = (ReaderEvent2)this.getChildren().elementAt(n);
            readerEvent25.orderChildren();
        }
    }

    private void removeNullAttribIfValueNotNull(ReaderEvent2 readerEvent2) {
        char[] cArray = readerEvent2.getCharacters();
        if (cArray == null || String.valueOf(cArray).trim().length() == 0) {
            return;
        }
        this.info.removeNillableAttribute();
    }

    void mergeProperty(ReaderEvent2 readerEvent2, int n, boolean bl) {
        int n2;
        if (debug) {
            System.out.println("mergeProperty: " + readerEvent2);
        }
        if (!this.isArray(n2 = readerEvent2.getPropertyIndex())) {
            if (debug) {
                System.out.println("\nsimple property, not an array: " + readerEvent2);
            }
            if (bl) {
                this.removeNullAttribIfValueNotNull(readerEvent2);
            }
            this.setCharacters(readerEvent2.getCharacters());
            if (debug) {
                System.out.println(".. characters =  " + this.getTextCharacters());
            }
            return;
        }
        if (debug) {
            System.out.println("\narray property: " + readerEvent2);
        }
        int n3 = this.getParent().getChildren().indexOf(this);
        if (readerEvent2.getCharacters() == null) {
            return;
        }
        if (n3 == this.getParent().getChildren().size() - 1) {
            this.getParent().getChildren().add(readerEvent2);
            readerEvent2.setOriginalParent(readerEvent2.getParent());
            readerEvent2.setParent(this.getParent());
            return;
        }
        ReaderEvent2 readerEvent22 = this;
        if (debug) {
            System.out.println("evaluate, index = " + n3);
        }
        ReaderEvent2 readerEvent23 = this.getParent().getNextChild(this);
        while (readerEvent23 != null) {
            if (debug) {
                System.out.println("evaluate " + readerEvent23 + ", val = " + readerEvent23.getTextCharacters());
            }
            if (readerEvent23.getPropertyIndex() != this.getPropertyIndex()) break;
            readerEvent22 = readerEvent23;
            readerEvent23 = this.getParent().getNextChild(readerEvent23);
        }
        n3 = this.getParent().getChildren().indexOf(readerEvent22);
        if (debug) {
            System.out.println("evaluate, new index = " + n3);
        }
        if (n3 == this.getParent().getChildren().size() - 1) {
            this.getParent().getChildren().add(readerEvent2);
            readerEvent2.setOriginalParent(readerEvent2.getParent());
            readerEvent2.setParent(this.getParent());
            return;
        }
        if (!this.getParent().isMergeRulePrependDefined()) {
            ++n3;
        } else if (debug) {
            System.out.println("***** prepend is defined");
        }
        this.getParent().getChildren().add(n3, readerEvent2);
        readerEvent2.setOriginalParent(readerEvent2.getParent());
        readerEvent2.setParent(this.getParent());
    }

    void removeProperty(ReaderEvent2 readerEvent2) {
        if (debug) {
            System.out.println("removeProperty: " + this);
        }
        this.discard = true;
    }

    void replaceProperty(ReaderEvent2 readerEvent2) {
        if (debug) {
            System.out.println("replaceProperty: " + this);
        }
        this.getReaderEventInfo().setCharacters(readerEvent2.getReaderEventInfo().getCharacters());
    }

    void replacePropertyWithOverride(ReaderEvent2 readerEvent2) {
        if (debug) {
            System.out.println("replacePropertyWithOverride: " + this);
        }
        this.getReaderEventInfo().setCharacters(readerEvent2.getReaderEventInfo().getKeyOverrideCharacters());
    }

    boolean hasNextChild(int n) {
        for (ReaderEvent2 readerEvent2 : this.getChildren()) {
            if (readerEvent2.getPropertyIndex() <= n) continue;
            return true;
        }
        return false;
    }

    boolean isArray(int n) {
        return this.helper.isArray(n);
    }

    boolean isBean(int n) {
        return this.helper.isBean(n);
    }

    boolean hasKey(int n) {
        return this.helper.isKey(n);
    }

    boolean isAttribute(int n) {
        return this.helper.isAttribute(n);
    }

    String getXpath() {
        return this.getXpath(false);
    }

    String getXpath(boolean bl) {
        if (this.getParent() == null) {
            return "";
        }
        if (this.isSimpleKey()) {
            if (this.info.getAttributeCount() > 0) {
                for (int i = 0; i < this.info.getAttributeCount(); ++i) {
                    int n = this.helper.getPropertyIndex(this.info.getAttributeLocalName(i));
                    if (!this.helper.isKey(n)) continue;
                    StringBuffer stringBuffer = new StringBuffer(this.getParent().getXpath());
                    stringBuffer.append("/").append(this.getElementName()).append("[");
                    stringBuffer.append(this.info.getAttributeLocalName(i)).append("=").append(this.info.getAttributeValue(i));
                    stringBuffer.append("]");
                    return stringBuffer.toString();
                }
            }
            return this.getParent().getXpath() + "/[" + this.getElementName() + "=\"" + this.getTrimmedTextCharacters() + "\"]";
        }
        if (this.isKeyChoice()) {
            return this.getParent().getXpath() + "/[" + this.getElementName() + "=\"" + this.getTrimmedTextCharacters() + "\"]";
        }
        if (this.isKeyComponent()) {
            return this.getParent().getXpath() + "/" + this.getParent().getCompositeXpath(bl);
        }
        if (this.isBeanKey()) {
            ReaderEvent2 readerEvent2 = this.getNextChild(-1);
            while (readerEvent2 != null) {
                if (readerEvent2.isSimpleKey() || readerEvent2.isKeyComponent() || readerEvent2.isKeyChoice()) {
                    return this.getParent().getXpath() + "/" + this.getElementName() + "/[" + readerEvent2.getElementName() + "=\"" + readerEvent2.getTrimmedTextCharacters() + "\"]";
                }
                readerEvent2 = this.getNextChild(readerEvent2);
            }
        }
        return this.getParent().getXpath() + "/" + this.getElementName();
    }

    String getCompositeXpath(boolean bl) {
        String[] stringArray = this.helper.getKeyElementNames();
        StringBuffer stringBuffer = new StringBuffer("[");
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            stringBuffer.append("[");
            for (int j = 0; j < this.getChildren().size(); ++j) {
                boolean bl2;
                ReaderEvent2 readerEvent2 = (ReaderEvent2)this.getChildren().elementAt(j);
                boolean bl3 = bl2 = bl ? readerEvent2.getReaderEventInfo().isKeyCharacters() : true;
                if (!string.equals(readerEvent2.getElementName()) || !bl2) continue;
                stringBuffer.append("\"");
                String string2 = readerEvent2.getTrimmedTextCharacters();
                if (string2 != null) {
                    stringBuffer.append(string2);
                }
                stringBuffer.append("\",");
            }
            if (stringBuffer.charAt(stringBuffer.length() - 1) == ',') {
                stringBuffer.deleteCharAt(stringBuffer.length() - 1);
            }
            stringBuffer.append("]");
            if (i >= stringArray.length - 1) continue;
            stringBuffer.append(",");
        }
        stringBuffer.append("]");
        if (debug) {
            System.out.println("getCompositeXpath return: " + stringBuffer);
        }
        return stringBuffer.toString();
    }

    ReaderEvent2 findEvent(String string) {
        for (ReaderEvent2 readerEvent2 : this.getChildren()) {
            if (!readerEvent2.getXpath().equals(string)) continue;
            return readerEvent2;
        }
        return null;
    }

    ReaderEvent2 getChild(int n) {
        for (ReaderEvent2 readerEvent2 : this.getChildren()) {
            if (readerEvent2.getPropertyIndex() != n) continue;
            return readerEvent2;
        }
        return null;
    }

    ReaderEvent2 getMatchingChild(int n) {
        for (ReaderEvent2 readerEvent2 : this.getChildren()) {
            if (readerEvent2.getPropertyIndex() != n) continue;
            return readerEvent2;
        }
        return null;
    }

    ReaderEvent2 getPrevChild(int n) {
        ReaderEvent2 readerEvent2 = null;
        for (ReaderEvent2 readerEvent22 : this.getChildren()) {
            if (readerEvent22.getPropertyIndex() < n) {
                readerEvent2 = readerEvent22;
            }
            if (readerEvent22.getPropertyIndex() < n) continue;
            return readerEvent2;
        }
        return readerEvent2;
    }

    ReaderEvent2 getPrevChild(ReaderEvent2 readerEvent2) {
        int n = this.getChildren().indexOf(readerEvent2);
        if (--n < 0) {
            return null;
        }
        return (ReaderEvent2)this.getChildren().get(n);
    }

    ReaderEvent2 getNextChild(int n) {
        for (ReaderEvent2 readerEvent2 : this.getChildren()) {
            if (readerEvent2.getPropertyIndex() <= n) continue;
            return readerEvent2;
        }
        return null;
    }

    ReaderEvent2 getNextChild(ReaderEvent2 readerEvent2) {
        int n = this.getChildren().indexOf(readerEvent2);
        if (this.getChildren().size() == ++n) {
            return null;
        }
        return (ReaderEvent2)this.getChildren().get(n);
    }

    int getPropertyIndex() {
        return this.getSchemaHelper().getPropertyIndex(this.getElementName());
    }

    boolean isMergeRuleIgnoreSourceDefined() {
        int n = this.getPropertyIndex();
        return this.getSchemaHelper().isMergeRuleIgnoreSourceDefined(n);
    }

    boolean isMergeRuleIgnoreTargetDefined() {
        int n = this.getPropertyIndex();
        return this.getSchemaHelper().isMergeRuleIgnoreTargetDefined(n);
    }

    boolean isMergeRulePrependDefined() {
        int n = this.getPropertyIndex();
        return this.getSchemaHelper().isMergeRulePrependDefined(n);
    }

    void adoptChildren(ReaderEvent2 readerEvent2) {
        if (debug) {
            System.out.println("\nadoptChildren from source = " + readerEvent2);
        }
        if (readerEvent2.getChildren().size() == 0) {
            return;
        }
        for (ReaderEvent2 readerEvent22 : readerEvent2.getChildren()) {
            readerEvent22.setOriginalParent(readerEvent22.getParent());
            readerEvent22.setParent(this);
        }
        this.getChildren().addAll(readerEvent2.getChildren());
    }

    void adoptChild(ReaderEvent2 readerEvent2, ReaderEvent2 readerEvent22) {
        int n;
        if (debug) {
            System.out.println("\nadoptChild from sourceChild = " + readerEvent2 + ", targetChild = " + readerEvent22);
        }
        int n2 = this.getChildren().indexOf(readerEvent22);
        int n3 = readerEvent2.getPropertyIndex();
        if (n3 < (n = readerEvent22.getPropertyIndex())) {
            this.getChildren().add(n2, readerEvent2);
        }
        assert (n3 != n);
        if (n3 > n) {
            this.getChildren().add(++n2, readerEvent2);
        }
        this.orphanChild(readerEvent2);
        readerEvent2.setOriginalParent(readerEvent2.getParent());
        readerEvent2.setParent(this);
    }

    private void setPrefixOnAdopt(ReaderEvent2 readerEvent2, String string) {
        if (readerEvent2.info.getPrefix() == null) {
            readerEvent2.info.setPrefix(string);
        }
        for (ReaderEvent2 readerEvent22 : readerEvent2.getChildren()) {
            this.setPrefixOnAdopt(readerEvent22, string);
        }
    }

    public static void main(String[] stringArray) throws Exception {
        Location location = new Location(){

            public int getLineNumber() {
                return 0;
            }

            public int getColumnNumber() {
                return 0;
            }

            public int getCharacterOffset() {
                return 0;
            }

            public String getPublicId() {
                return "<no public id>";
            }

            public String getSystemId() {
                return "<no system id>";
            }
        };
        StringBuffer stringBuffer = new StringBuffer("/weblogic-connector xmlns=\"http://www.bea.com/ns/weblogic/90\"/outbound-resource-adapter/connection-definition-group/[connection-factory-interface=\"javax.sql.DataSource\"]/connection-instance/jndi-name");
        System.out.println("\nxpath = " + stringBuffer + "\nresults in:\n");
        new ReaderEvent2(stringBuffer, new ReaderEvent2(7, location), null, "val1", location).toXML(System.out);
    }
}

