/*
 * Decompiled with CFR 0.152.
 */
package weblogic.application.descriptor;

import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;

public class ReaderEventInfo {
    private int eventType;
    private Location location;
    private String elementName;
    private String prefix;
    private char[] characters;
    private Attributes attributes;
    private String charEncodingScheme;
    private String inputEncoding;
    Namespaces namespaces;
    private StringBuffer comments;
    private boolean keyCharacters;
    private boolean keyOverride;
    private char[] keyOverrideCharacters;

    public ReaderEventInfo(int n, Location location) {
        this.eventType = n;
        this.location = location;
    }

    public ReaderEventInfo(int n, String string, Location location) {
        this(n, location);
        this.elementName = string;
    }

    public String getElementName() {
        return this.elementName;
    }

    public void setElementName(String string) {
        this.elementName = string;
    }

    public char[] getCharacters() {
        return this.characters;
    }

    public void setCharacters(char[] cArray) {
        if (cArray == null) {
            return;
        }
        this.characters = new char[cArray.length];
        System.arraycopy(cArray, 0, this.characters, 0, cArray.length);
    }

    void appendCharacters(char[] cArray) {
        if (cArray == null || cArray.length == 0 && this.characters != null) {
            return;
        }
        if (this.characters != null) {
            char[] cArray2 = new char[this.characters.length + cArray.length];
            System.arraycopy(this.characters, 0, cArray2, 0, this.characters.length);
            System.arraycopy(cArray, 0, cArray2, this.characters.length, cArray.length);
            this.characters = cArray2;
        } else if (cArray.length == 0) {
            this.characters = new char[0];
        } else {
            this.setCharacters(cArray);
        }
    }

    public boolean hasComment() {
        return this.comments != null;
    }

    public String getComments() {
        if (this.hasComment()) {
            return this.comments.toString();
        }
        return null;
    }

    public void setComments(String string) {
        if (this.comments == null) {
            this.comments = new StringBuffer();
        }
        this.comments.append(string);
    }

    public String getCharactersAsString() {
        if (this.characters != null) {
            return new String(this.getCharacters());
        }
        return "";
    }

    public Location getLocation() {
        return this.location;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String string) {
        this.prefix = string;
    }

    public int getEventType() {
        return this.eventType;
    }

    public int getAttributeCount() {
        return this.getAttributes().getAttributeCount();
    }

    Attributes getAttributes() {
        if (this.attributes == null) {
            this.attributes = new Attributes();
        }
        return this.attributes;
    }

    public void removeNillableAttribute() {
        if (this.attributes != null) {
            this.attributes.removeNillable();
        }
    }

    public void setAttributeCount(int n) {
        this.getAttributes().setAttributeCount(n);
    }

    public String getAttributeLocalName(int n) {
        return this.getAttributes().getAttributeLocalName(n);
    }

    public void setAttributeLocalName(String string, int n) {
        this.getAttributes().setAttributeLocalName(string, n);
    }

    public String getAttributeNamespace(int n) {
        return this.getAttributes().getAttributeNamespace(n);
    }

    public void setAttributeNamespace(String string, int n) {
        this.getAttributes().setAttributeNamespace(string, n);
    }

    public String getAttributePrefix(int n) {
        return this.getAttributes().getAttributePrefix(n);
    }

    public void setAttributePrefix(String string, int n) {
        this.getAttributes().setAttributePrefix(string, n);
    }

    public String getAttributeType(int n) {
        return this.getAttributes().getAttributeType(n);
    }

    public boolean isAttributeSpecified(int n) {
        return this.getAttributes().isAttributeSpecified(n);
    }

    public String getAttributeValue(int n) {
        return this.getAttributes().getAttributeValue(n);
    }

    public void setAttributeValue(String string, int n) {
        this.getAttributes().setAttributeValue(string, n);
    }

    public String getAttributeValue(String string, String string2) {
        return this.getAttributes().getAttributeValue(string, string2);
    }

    public void setAttributeValue(String string, String string2, String string3) {
        this.getAttributes().setAttributeValue(string, string2, string3);
    }

    public QName getAttributeName(int n) {
        return this.getAttributes().getAttributeName(n);
    }

    public String getCharacterEncodingScheme() {
        return this.charEncodingScheme;
    }

    public void setCharacterEncodingScheme(String string) {
        this.charEncodingScheme = string;
    }

    public int getNamespaceCount() {
        return this.getNamespaces().getNamespaceCount();
    }

    public String getNamespacePrefix(int n) {
        return this.getNamespaces().getNamespacePrefix(n);
    }

    public String getNamespaceURI(int n) {
        return this.getNamespaces().getNamespaceURI(n);
    }

    public boolean hasNamespaceURI(String string) {
        return this.getNamespaces().hasNamespaceURI(string);
    }

    public void setNamespaceCount(int n) {
        this.getNamespaces().setNamespaceCount(n);
    }

    Namespaces getNamespaces() {
        if (this.namespaces == null) {
            this.namespaces = new Namespaces();
        }
        return this.namespaces;
    }

    public void clearNamespaces() {
        this.namespaces = new Namespaces();
    }

    public void setNamespaceURI(String string, String string2) {
        if (string2 == null) {
            return;
        }
        this.getNamespaces().setNamespaceURI(string, string2);
    }

    public javax.xml.namespace.NamespaceContext getNamespaceContext() {
        return new NamespaceContext(this.getNamespaces());
    }

    public String getEncoding() {
        return this.inputEncoding;
    }

    public void setEncoding(String string) {
        this.inputEncoding = string;
    }

    public boolean isKeyCharacters() {
        return this.keyCharacters;
    }

    public void setKeyCharacters(boolean bl) {
        this.keyCharacters = bl;
    }

    public boolean isKeyOverride() {
        return this.keyOverride;
    }

    public void setKeyOverride(boolean bl) {
        this.keyOverride = bl;
    }

    public char[] getKeyOverrideCharacters() {
        return this.keyOverrideCharacters;
    }

    public void setKeyOverrideCharacters(char[] cArray) {
        if (cArray == null) {
            return;
        }
        this.keyOverrideCharacters = new char[cArray.length];
        System.arraycopy(cArray, 0, this.keyOverrideCharacters, 0, cArray.length);
    }

    class NamespaceContext
    implements javax.xml.namespace.NamespaceContext {
        Namespaces namespaces;

        NamespaceContext(Namespaces namespaces) {
            this.namespaces = namespaces;
        }

        public String getNamespaceURI(String string) {
            if (string == null) {
                throw new IllegalArgumentException("The prefix may not be null");
            }
            return this.namespaces.getNamespaceURI(string);
        }

        public String getPrefix(String string) {
            if (string == null) {
                throw new IllegalArgumentException("The uri may not be null.");
            }
            for (int i = 0; i < this.namespaces.getNamespaceCount(); ++i) {
                if (!string.equals(this.namespaces.getNamespaceURI(i))) continue;
                return this.namespaces.getNamespacePrefix(i);
            }
            return null;
        }

        public Iterator getPrefixes(String string) {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (int i = 0; i < this.namespaces.getNamespaceCount(); ++i) {
                if (!string.equals(this.namespaces.getNamespaceURI(i))) continue;
                arrayList.add(this.namespaces.getNamespacePrefix(i));
            }
            return arrayList.iterator();
        }
    }

    class Namespaces {
        private int namespaceCount;
        private String[] namespacePrefixes;
        private String[] namespaceValues;

        Namespaces() {
        }

        public void ensureSpaceAvail(int n) {
            int n2;
            int n3 = n2 = this.namespaceValues == null ? 0 : this.namespaceValues.length;
            if (n > n2) {
                int n4;
                int n5 = n4 = n > 10 ? n * 2 : 10;
                if (this.namespaceValues == null) {
                    this.namespaceValues = new String[n4];
                    this.namespacePrefixes = new String[n4];
                    return;
                }
                String[] stringArray = new String[n4];
                System.arraycopy(this.namespaceValues, 0, stringArray, 0, n2);
                this.namespaceValues = stringArray;
                stringArray = new String[n4];
                System.arraycopy(this.namespacePrefixes, 0, stringArray, 0, n2);
                this.namespacePrefixes = stringArray;
            }
        }

        public int getNamespaceCount() {
            return this.namespaceCount;
        }

        public String getNamespacePrefix(int n) {
            return this.namespaceCount == 0 ? null : this.namespacePrefixes[n];
        }

        public String getNamespaceURI(int n) {
            return this.namespaceCount == 0 ? null : this.namespaceValues[n];
        }

        public String getNamespaceURI() {
            return this.getNamespaceURI(0);
        }

        public String getNamespaceURI(String string) {
            for (int i = 0; i < this.namespaceCount; ++i) {
                if (this.namespacePrefixes[i] == string && this.namespaceValues[i] != null) {
                    return this.namespaceValues[i];
                }
                if (this.namespacePrefixes[i] == null || string == null || !string.equals(this.namespacePrefixes[i])) continue;
                return this.namespaceValues[i];
            }
            return null;
        }

        public boolean hasNamespaceURI(String string) {
            for (int i = 0; i < this.namespaceCount; ++i) {
                if (this.namespaceValues[i] == null || !this.namespaceValues[i].equals(string)) continue;
                return true;
            }
            return false;
        }

        public void setNamespaceCount(int n) {
            if (n > 0) {
                this.ensureSpaceAvail(n);
            }
            if (this.namespaceCount < n) {
                this.namespaceCount = n;
            }
        }

        public void setNamespaceURI(String string, String string2) {
            int n;
            if (string2 == null || this.namespaceCount == 0) {
                return;
            }
            if (string != null) {
                for (n = 0; n < this.namespaceCount; ++n) {
                    if (!string.equals(this.namespacePrefixes[n]) || !string2.equals(this.namespaceValues[n])) continue;
                    return;
                }
            } else {
                for (n = 0; n < this.namespaceCount; ++n) {
                    if (!string2.equals(this.namespaceValues[n])) continue;
                    return;
                }
            }
            for (n = 0; n < this.namespaceCount; ++n) {
                if (this.namespaceValues[n] != null) continue;
                this.namespaceValues[n] = string2;
                this.namespacePrefixes[n] = string;
                return;
            }
            this.setNamespaceCount(this.getNamespaceCount() + 1);
            this.namespaceValues[this.getNamespaceCount() - 1] = string2;
            this.namespacePrefixes[this.getNamespaceCount() - 1] = string;
        }

        void copy(Namespaces namespaces) {
            if (namespaces.namespaceCount > 0) {
                this.setNamespaceCount(namespaces.namespaceCount);
                for (int i = 0; i < this.namespaceCount; ++i) {
                    this.namespacePrefixes[i] = namespaces.namespacePrefixes[i];
                    this.namespaceValues[i] = namespaces.namespaceValues[i];
                }
            }
        }
    }

    class Attributes {
        private int attributeCount;
        private String[] attributeNames;
        private String[] attributeValues;
        private String[] attributeUris;
        private String[] attributePrefixes;

        Attributes() {
        }

        public void ensureSpaceAvail(int n) {
            int n2;
            int n3 = n2 = this.attributeValues == null ? 0 : this.attributeValues.length;
            if (n > n2) {
                int n4;
                int n5 = n4 = n > 10 ? n * 2 : 10;
                if (this.attributeValues == null) {
                    this.attributeNames = new String[n4];
                    this.attributeValues = new String[n4];
                    this.attributeUris = new String[n4];
                    this.attributePrefixes = new String[n4];
                    return;
                }
                String[] stringArray = null;
                stringArray = new String[n4];
                System.arraycopy(this.attributeNames, 0, stringArray, 0, n2);
                this.attributeNames = stringArray;
                stringArray = new String[n4];
                System.arraycopy(this.attributePrefixes, 0, stringArray, 0, n2);
                this.attributePrefixes = stringArray;
                stringArray = new String[n4];
                System.arraycopy(this.attributeUris, 0, stringArray, 0, n2);
                this.attributeUris = stringArray;
                stringArray = new String[n4];
                System.arraycopy(this.attributeValues, 0, stringArray, 0, n2);
                this.attributeValues = stringArray;
            }
        }

        public int getAttributeCount() {
            return this.attributeCount;
        }

        public void setAttributeCount(int n) {
            this.attributeCount = n;
            if (n > 0) {
                this.ensureSpaceAvail(n);
            }
        }

        public String getAttributeLocalName(int n) {
            if (n < 0 || n >= this.attributeCount) {
                throw new IndexOutOfBoundsException("attribute position must be 0.." + (this.attributeCount - 1) + " and not " + n);
            }
            return this.attributeNames[n];
        }

        public void setAttributeLocalName(String string, int n) {
            this.attributeNames[n] = string;
        }

        public String getAttributeNamespace(int n) {
            if (n < 0 || n >= this.attributeCount) {
                throw new IndexOutOfBoundsException("attribute position must be 0.." + (this.attributeCount - 1) + " and not " + n);
            }
            return this.attributeUris[n];
        }

        public void setAttributeNamespace(String string, int n) {
            this.attributeUris[n] = string;
        }

        public String getAttributePrefix(int n) {
            if (n < 0 || n >= this.attributeCount) {
                throw new IndexOutOfBoundsException("attribute position must be 0.." + (this.attributeCount - 1) + " and not " + n);
            }
            return this.attributePrefixes[n];
        }

        public void setAttributePrefix(String string, int n) {
            this.attributePrefixes[n] = string;
        }

        public String getAttributeType(int n) {
            return "CDATA";
        }

        public boolean isAttributeSpecified(int n) {
            return false;
        }

        public String getAttributeValue(int n) {
            if (n < 0 || n >= this.attributeCount) {
                throw new IndexOutOfBoundsException("attribute position must be 0.." + (this.attributeCount - 1) + " and not " + n);
            }
            return this.attributeValues[n];
        }

        public void setAttributeValue(String string, int n) {
            this.attributeValues[n] = string;
        }

        public String getAttributeValue(String string, String string2) {
            if (string != null) {
                for (int i = 0; i < this.attributeCount; ++i) {
                    if (!string.equals(this.attributeUris[i]) || !string2.equals(this.attributeNames[i])) continue;
                    return this.attributeValues[i];
                }
            } else {
                for (int i = 0; i < this.attributeCount; ++i) {
                    if (!string2.equals(this.attributeNames[i])) continue;
                    return this.attributeValues[i];
                }
            }
            return null;
        }

        public void setAttributeValue(String string, String string2, String string3) {
            int n;
            if (string == null || this.attributeCount == 0) {
                return;
            }
            if (string2 != null) {
                for (n = 0; n < this.attributeCount; ++n) {
                    if (!string2.equals(this.attributeUris[n]) || !string3.equals(this.attributeNames[n]) || !string.equals(this.attributeValues[n])) continue;
                    return;
                }
            } else {
                for (n = 0; n < this.attributeCount; ++n) {
                    if (!string3.equals(this.attributeNames[n]) || !string.equals(this.attributeValues[n])) continue;
                    return;
                }
            }
            for (n = 0; n < this.attributeCount; ++n) {
                if (this.attributeValues[n] != null) continue;
                if (string2 != null) {
                    this.attributeUris[n] = string2;
                }
                this.attributeNames[n] = string3;
                this.attributeValues[n] = string;
                return;
            }
            this.ensureSpaceAvail(this.attributeCount++);
            if (string2 != null) {
                this.attributeUris[this.attributeCount - 1] = string2;
            }
            this.attributeNames[this.attributeCount - 1] = string3;
            this.attributeValues[this.attributeCount - 1] = string;
        }

        public QName getAttributeName(int n) {
            return new QName(this.getAttributeNamespace(n), this.getAttributeLocalName(n), this.getAttributePrefix(n));
        }

        public void removeNillable() {
            if (this.attributeNames == null || this.attributeValues == null || this.attributeUris == null || this.attributePrefixes == null) {
                return;
            }
            for (int i = 0; i < this.attributeNames.length; ++i) {
                String string = this.attributeNames[i];
                if (!"nil".equals(string) || !"true".equals(this.attributeValues[i]) || !"http://www.w3.org/2001/XMLSchema-instance".equals(this.attributeUris[i])) continue;
                --this.attributeCount;
                String[] stringArray = new String[this.attributeNames.length];
                System.arraycopy(this.attributeNames, 0, stringArray, 0, i);
                System.arraycopy(this.attributeNames, i + 1, stringArray, i + 1, this.attributeNames.length - (i + 1));
                this.attributeNames = stringArray;
                stringArray = new String[this.attributeValues.length];
                System.arraycopy(this.attributeValues, 0, stringArray, 0, i);
                System.arraycopy(this.attributeValues, i + 1, stringArray, i + 1, this.attributeValues.length - (i + 1));
                this.attributeValues = stringArray;
                stringArray = new String[this.attributeUris.length];
                System.arraycopy(this.attributeUris, 0, stringArray, 0, i);
                System.arraycopy(this.attributeUris, i + 1, stringArray, i + 1, this.attributeUris.length - (i + 1));
                this.attributeUris = stringArray;
                stringArray = new String[this.attributePrefixes.length];
                System.arraycopy(this.attributePrefixes, 0, stringArray, 0, i);
                System.arraycopy(this.attributePrefixes, i + 1, stringArray, i + 1, this.attributePrefixes.length - (i + 1));
                this.attributePrefixes = stringArray;
            }
        }
    }
}

