/*
 * Decompiled with CFR 0.152.
 */
package weblogic.application.event;

import java.util.ArrayList;
import java.util.List;
import weblogic.application.ApplicationContext;
import weblogic.application.ApplicationLifecycleListener;
import weblogic.application.event.ApplicationLifecycleListenerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ApplicationEventManager {
    private List<ApplicationLifecycleListenerFactory> factories = new ArrayList<ApplicationLifecycleListenerFactory>();
    private static ApplicationEventManager instance = new ApplicationEventManager();

    private ApplicationEventManager() {
    }

    public static ApplicationEventManager getInstance() {
        return instance;
    }

    public void registerListenerFactory(ApplicationLifecycleListenerFactory applicationLifecycleListenerFactory) {
        this.factories.add(applicationLifecycleListenerFactory);
    }

    public List<ApplicationLifecycleListener> createListeners(ApplicationContext applicationContext) {
        ArrayList<ApplicationLifecycleListener> arrayList = new ArrayList<ApplicationLifecycleListener>();
        for (ApplicationLifecycleListenerFactory applicationLifecycleListenerFactory : this.factories) {
            ApplicationLifecycleListener applicationLifecycleListener = applicationLifecycleListenerFactory.createListener(applicationContext);
            if (applicationLifecycleListener == null) continue;
            arrayList.add(applicationLifecycleListener);
        }
        return arrayList;
    }
}

