/*
 * Decompiled with CFR 0.152.
 */
package weblogic.application.internal;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import weblogic.application.AppClassLoaderManager;
import weblogic.application.CannotRedeployException;
import weblogic.application.internal.FlowContext;
import weblogic.deploy.container.NonFatalDeploymentException;
import weblogic.utils.classloaders.Annotation;
import weblogic.utils.classloaders.GenericClassLoader;
import weblogic.utils.classloaders.Source;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AppClassLoaderManagerImpl
extends AppClassLoaderManager {
    private static final boolean DEBUG = false;
    private static final String NULL_KEY = new String();
    private final Map<GenericClassLoader, Map<ClassLoader, GenericClassLoader>> interAppCLMap = new ConcurrentHashMap<GenericClassLoader, Map<ClassLoader, GenericClassLoader>>();
    private final CLInfo rootInfo = new CLInfo(null);

    @Override
    public void addModuleLoader(GenericClassLoader genericClassLoader, String string) {
        this.rootInfo.findOrCreateInfo(genericClassLoader, string);
    }

    public void removeApplicationLoader(String string) {
        CLInfo cLInfo = this.rootInfo.findInfo(string);
        if (cLInfo != null) {
            GenericClassLoader genericClassLoader = cLInfo.getClassLoader();
            this.removeClassLoaderFromCLMap(genericClassLoader);
            Iterator iterator = cLInfo.children.values().iterator();
            while (iterator.hasNext()) {
                genericClassLoader = ((CLInfo)iterator.next()).getClassLoader();
                this.removeClassLoaderFromCLMap(genericClassLoader);
            }
        }
        this.rootInfo.removeAppInfo(string);
    }

    private void removeClassLoaderFromCLMap(GenericClassLoader genericClassLoader) {
        if (genericClassLoader != null) {
            this.interAppCLMap.remove(genericClassLoader);
            for (GenericClassLoader object : this.interAppCLMap.keySet()) {
                if (this.sameAnnotation(object.getAnnotation(), genericClassLoader.getAnnotation())) {
                    this.interAppCLMap.remove(object);
                    continue;
                }
                if (object.getParent() == null || !(object.getParent() instanceof GenericClassLoader) || !this.sameAnnotation(((GenericClassLoader)object.getParent()).getAnnotation(), genericClassLoader.getAnnotation())) continue;
                this.interAppCLMap.remove(object);
            }
            for (Map map : this.interAppCLMap.values()) {
                map.remove(genericClassLoader);
                for (ClassLoader classLoader : map.keySet()) {
                    if (!(classLoader instanceof GenericClassLoader)) continue;
                    if (this.sameAnnotation(((GenericClassLoader)classLoader).getAnnotation(), genericClassLoader.getAnnotation())) {
                        map.remove(classLoader);
                        continue;
                    }
                    if (classLoader.getParent() == null || !(classLoader.getParent() instanceof GenericClassLoader) || !this.sameAnnotation(((GenericClassLoader)classLoader.getParent()).getAnnotation(), genericClassLoader.getAnnotation())) continue;
                    map.remove(classLoader);
                }
            }
        }
    }

    private boolean sameAnnotation(Annotation annotation, Annotation annotation2) {
        return annotation.getAnnotationString().length() != 0 && annotation2.getAnnotationString().length() != 0 && annotation.equals((Object)annotation2);
    }

    @Override
    public GenericClassLoader findLoader(Annotation annotation) {
        CLInfo cLInfo = this.rootInfo.findInfo(annotation);
        return cLInfo == null ? null : cLInfo.getClassLoader();
    }

    private CLInfo findModuleInfo(String string, String string2) {
        CLInfo cLInfo = this.rootInfo.findInfo(string, string2);
        if (cLInfo == null) {
            cLInfo = this.rootInfo.findInfo(string);
        }
        return cLInfo;
    }

    @Override
    public GenericClassLoader findModuleLoader(String string, String string2) {
        CLInfo cLInfo = this.findModuleInfo(string, string2);
        return cLInfo == null ? null : cLInfo.getClassLoader();
    }

    @Override
    public Class loadApplicationClass(Annotation annotation, String string) throws ClassNotFoundException {
        GenericClassLoader genericClassLoader = this.findLoader(annotation);
        if (genericClassLoader == null) {
            throw new ClassNotFoundException(string);
        }
        return Class.forName(string, false, (ClassLoader)genericClassLoader);
    }

    @Override
    public Source findApplicationSource(Annotation annotation, String string) {
        GenericClassLoader genericClassLoader = this.findLoader(annotation);
        return genericClassLoader == null ? null : genericClassLoader.getClassFinder().getSource(string);
    }

    @Override
    public GenericClassLoader findOrCreateIntraAppLoader(Annotation annotation, ClassLoader classLoader) {
        return this.findLoader(annotation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GenericClassLoader findOrCreateInterAppLoader(Annotation annotation, ClassLoader classLoader) {
        GenericClassLoader genericClassLoader;
        GenericClassLoader genericClassLoader2 = this.findLoader(annotation);
        if (genericClassLoader2 == null) {
            return null;
        }
        Map<ClassLoader, GenericClassLoader> map = this.interAppCLMap.get(genericClassLoader2);
        if (map == null) {
            genericClassLoader = genericClassLoader2;
            synchronized (genericClassLoader) {
                map = this.interAppCLMap.get(genericClassLoader2);
                if (map == null) {
                    map = new ConcurrentHashMap<ClassLoader, GenericClassLoader>();
                    this.interAppCLMap.put(genericClassLoader2, map);
                }
            }
        }
        if ((genericClassLoader = map.get(classLoader)) == null) {
            ClassLoader classLoader2 = classLoader;
            synchronized (classLoader2) {
                genericClassLoader = map.get(classLoader);
                if (genericClassLoader == null) {
                    genericClassLoader = new GenericClassLoader(genericClassLoader2.getClassFinder(), classLoader);
                    if (!(classLoader instanceof GenericClassLoader)) {
                        genericClassLoader.setAnnotation(genericClassLoader2.getAnnotation());
                    }
                    map.put(classLoader, genericClassLoader);
                }
            }
        }
        return genericClassLoader;
    }

    public void checkPartialRedeploy(FlowContext flowContext, String[] stringArray) throws NonFatalDeploymentException {
        String string = flowContext.getApplicationId();
        for (int i = 0; i < stringArray.length; ++i) {
            GenericClassLoader genericClassLoader;
            CLInfo cLInfo = this.findModuleInfo(string, stringArray[i]);
            CLInfo cLInfo2 = this.rootInfo.findInfo(string);
            GenericClassLoader genericClassLoader2 = genericClassLoader = cLInfo2 != null ? cLInfo2.cl : null;
            if (cLInfo == null) continue;
            if (genericClassLoader != null && cLInfo.cl == genericClassLoader) {
                if (flowContext.isStopOperation()) {
                    throw new NonFatalDeploymentException("Module '" + stringArray[i] + "' has the same ClassLoader as the Application '" + string + "'. Consider stopping the entire application.");
                }
                throw new CannotRedeployException("Module '" + stringArray[i] + "' has the same ClassLoader as the Application '" + string + "'. Consider redeploying the entire application.");
            }
            Set<String> set = cLInfo.findMissingURIs(new HashSet<String>(Arrays.asList(stringArray)));
            if (set.isEmpty()) continue;
            if (flowContext.isStopOperation()) {
                throw new NonFatalDeploymentException("Module " + stringArray[i] + " in application '" + string + "' cannot be stopped because the following modules" + " which depend on " + stringArray[i] + " were not included in the list: " + AppClassLoaderManagerImpl.prettyPrint(set));
            }
            throw new CannotRedeployException("Module " + stringArray[i] + " in application '" + string + "' cannot be redeployed because the following modules" + " which depend on " + stringArray[i] + " were not included in the redeploy list: " + AppClassLoaderManagerImpl.prettyPrint(set));
        }
    }

    public Set<String> updatePartialDeploySet(FlowContext flowContext, String[] stringArray) throws NonFatalDeploymentException {
        String string = flowContext.getApplicationId();
        HashSet<String> hashSet = new HashSet<String>(Arrays.asList(stringArray));
        CLInfo cLInfo = this.rootInfo.findInfo(string);
        GenericClassLoader genericClassLoader = cLInfo != null ? cLInfo.cl : null;
        for (int i = 0; i < stringArray.length; ++i) {
            CLInfo cLInfo2 = this.findModuleInfo(string, stringArray[i]);
            if (cLInfo2 == null) continue;
            if (genericClassLoader != null && cLInfo2.cl == genericClassLoader) {
                if (flowContext.isStopOperation()) {
                    throw new NonFatalDeploymentException("Module '" + stringArray[i] + "' has the same ClassLoader as the Application '" + string + "'. Consider stopping the entire application.");
                }
                throw new CannotRedeployException("Module '" + stringArray[i] + "' has the same ClassLoader as the Application '" + string + "'. Consider redeploying the entire application.");
            }
            Set<String> set = cLInfo2.findMissingURIs(hashSet);
            if (set.isEmpty()) continue;
            hashSet.addAll(set);
        }
        return hashSet;
    }

    private static String prettyPrint(Set<String> set) {
        String string = "";
        StringBuffer stringBuffer = new StringBuffer();
        Iterator<String> iterator = set.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(string);
            stringBuffer.append(iterator.next());
            string = ", ";
        }
        return stringBuffer.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CLInfo {
        private GenericClassLoader cl;
        private Map<String, CLInfo> children = Collections.emptyMap();
        private final Set<String> uriSet = Collections.synchronizedSet(new HashSet());

        CLInfo(GenericClassLoader genericClassLoader) {
            this.cl = genericClassLoader;
        }

        void setClassLoader(GenericClassLoader genericClassLoader) {
            this.cl = genericClassLoader;
        }

        GenericClassLoader getClassLoader() {
            return this.cl;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer = this.toStringBuffer(stringBuffer, 0);
            return stringBuffer.toString();
        }

        StringBuffer toStringBuffer(StringBuffer stringBuffer, int n) {
            for (int i = 0; i < n; ++i) {
                stringBuffer.append(" ");
            }
            stringBuffer.append("[Annotation]: " + (this.cl == null ? "Null CL" : this.cl.getAnnotation().toString()));
            stringBuffer.append(" [uris:] " + AppClassLoaderManagerImpl.prettyPrint(this.uriSet));
            stringBuffer.append("\n");
            for (CLInfo cLInfo : this.children.values()) {
                cLInfo.toStringBuffer(stringBuffer, n + 2);
            }
            return stringBuffer;
        }

        private void addChild(String string, CLInfo cLInfo) {
            if (this.children.size() == 0) {
                this.children = new ConcurrentHashMap<String, CLInfo>();
            }
            this.children.put(string == null ? NULL_KEY : string, cLInfo);
        }

        CLInfo findInfo(final String string) {
            return this.findInfo(new Finder(){

                CLInfo findInfo(CLInfo cLInfo) {
                    return (CLInfo)cLInfo.children.get(string == null ? NULL_KEY : string);
                }
            });
        }

        CLInfo findInfo(String string, String string2) {
            if (string2 == null) {
                return this.findInfo(string);
            }
            return this.findInfo(new ModuleFinder(string, string2));
        }

        CLInfo findInfo(Annotation annotation) {
            return this.findInfo(new AnnotationFinder(annotation));
        }

        private CLInfo findInfo(Finder finder) {
            return finder.findInfo(this);
        }

        CLInfo findOrCreateInfo(GenericClassLoader genericClassLoader, String string) {
            LinkedList<GenericClassLoader> linkedList = new LinkedList<GenericClassLoader>();
            Object object = genericClassLoader;
            while (object instanceof GenericClassLoader) {
                linkedList.add(0, (GenericClassLoader)object);
                Annotation annotation = object.getAnnotation();
                if (annotation.getModuleName() == null) break;
                object = object.getParent();
            }
            return this.findOrCreateInfo(linkedList.iterator(), string);
        }

        private CLInfo findOrCreateInfo(Iterator<ClassLoader> iterator, String string) {
            if (!iterator.hasNext()) {
                this.uriSet.add(string);
                return this;
            }
            GenericClassLoader genericClassLoader = (GenericClassLoader)iterator.next();
            Annotation annotation = genericClassLoader.getAnnotation();
            String string2 = annotation.getModuleName() == null ? annotation.getApplicationName() : annotation.getModuleName();
            CLInfo cLInfo = null;
            cLInfo = this.children.get(string2 == null ? NULL_KEY : string2);
            if (cLInfo == null) {
                cLInfo = new CLInfo(genericClassLoader);
                this.addChild(string2, cLInfo);
            } else if (cLInfo.getClassLoader() != genericClassLoader) {
                cLInfo.children.clear();
                cLInfo.setClassLoader(genericClassLoader);
            }
            return cLInfo.findOrCreateInfo(iterator, string);
        }

        void removeAppInfo(String string) {
            this.children.remove(string == null ? NULL_KEY : string);
        }

        Set<String> findMissingURIs(Set<String> set) {
            HashSet<String> hashSet = new HashSet<String>();
            this.findMissingURIs(hashSet, set);
            return hashSet;
        }

        private void findMissingURIs(Set<String> set, Set<String> set2) {
            for (String object : this.uriSet) {
                if (set2.contains(object)) continue;
                set.add(object);
            }
            for (CLInfo cLInfo : this.children.values()) {
                cLInfo.findMissingURIs(set, set2);
            }
        }

        private static class ModuleFinder
        extends Finder {
            private final String appName;
            private final String moduleName;

            ModuleFinder(String string, String string2) {
                this.appName = string;
                this.moduleName = string2;
            }

            CLInfo findInfo(CLInfo cLInfo) {
                CLInfo cLInfo2 = (CLInfo)cLInfo.children.get(this.appName == null ? NULL_KEY : this.appName);
                if (cLInfo2 == null) {
                    return null;
                }
                return this.findModuleInfo(cLInfo2);
            }

            private CLInfo findModuleInfo(CLInfo cLInfo) {
                if (cLInfo.uriSet.contains(this.moduleName)) {
                    return cLInfo;
                }
                for (CLInfo cLInfo2 : cLInfo.children.values()) {
                    CLInfo cLInfo3 = this.findModuleInfo(cLInfo2);
                    if (cLInfo3 == null) continue;
                    return cLInfo3;
                }
                return null;
            }
        }

        private static class AnnotationFinder
        extends Finder {
            private final Annotation annotation;

            AnnotationFinder(Annotation annotation) {
                this.annotation = annotation;
            }

            CLInfo findInfo(CLInfo cLInfo) {
                if (cLInfo.cl != null && this.annotation.equals((Object)cLInfo.cl.getAnnotation())) {
                    return cLInfo;
                }
                for (CLInfo cLInfo2 : cLInfo.children.values()) {
                    CLInfo cLInfo3 = this.findInfo(cLInfo2);
                    if (cLInfo3 == null) continue;
                    return cLInfo3;
                }
                return null;
            }
        }

        private static abstract class Finder {
            private Finder() {
            }

            abstract CLInfo findInfo(CLInfo var1);
        }
    }
}

