/*
 * Decompiled with CFR 0.152.
 */
package weblogic.application.internal;

import java.security.AccessController;
import weblogic.application.AdminModeCompletionBarrier;
import weblogic.application.ApplicationContext;
import weblogic.application.ApplicationContextInternal;
import weblogic.application.ConcurrentModule;
import weblogic.application.Module;
import weblogic.application.ModuleException;
import weblogic.application.UpdateListener;
import weblogic.application.internal.AppClientComponentRuntimeMBeanImpl;
import weblogic.deploy.api.shared.WebLogicModuleType;
import weblogic.descriptor.DescriptorBean;
import weblogic.management.ManagementException;
import weblogic.management.provider.ManagementService;
import weblogic.management.runtime.ComponentRuntimeMBean;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.utils.classloaders.GenericClassLoader;

public final class AppClientModule
implements Module,
ConcurrentModule {
    private final String uri;
    private AppClientComponentRuntimeMBeanImpl rtmb;
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());

    AppClientModule(String string) {
        this.uri = string;
    }

    public String getId() {
        return this.uri;
    }

    public String getType() {
        return WebLogicModuleType.MODULETYPE_CAR;
    }

    public DescriptorBean[] getDescriptors() {
        return new DescriptorBean[0];
    }

    public ComponentRuntimeMBean[] getComponentRuntimeMBeans() {
        return new ComponentRuntimeMBean[]{this.rtmb};
    }

    public void initUsingLoader(ApplicationContext applicationContext, GenericClassLoader genericClassLoader, UpdateListener.Registration registration) throws ModuleException {
        ApplicationContextInternal applicationContextInternal = (ApplicationContextInternal)applicationContext;
        String string = ManagementService.getRuntimeAccess(kernelId).getServerName() + "_" + applicationContextInternal.getApplicationId() + "_" + this.uri;
        try {
            this.rtmb = new AppClientComponentRuntimeMBeanImpl(string, this.uri, applicationContextInternal.getRuntime());
        }
        catch (ManagementException managementException) {
            throw new ModuleException(managementException);
        }
    }

    public GenericClassLoader init(ApplicationContext applicationContext, GenericClassLoader genericClassLoader, UpdateListener.Registration registration) throws ModuleException {
        this.initUsingLoader(applicationContext, genericClassLoader, registration);
        return genericClassLoader;
    }

    public void destroy(UpdateListener.Registration registration) throws ModuleException {
        try {
            if (this.rtmb != null) {
                this.rtmb.unregister();
            }
        }
        catch (ManagementException managementException) {
            throw new ModuleException(managementException);
        }
    }

    public void prepare() {
    }

    public void activate() {
    }

    public void start() {
    }

    public void deactivate() {
    }

    public void unprepare() {
    }

    public void remove() {
    }

    public void adminToProduction() {
    }

    public void gracefulProductionToAdmin(AdminModeCompletionBarrier adminModeCompletionBarrier) {
    }

    public void forceProductionToAdmin() {
    }

    public boolean isParallelEnabled() {
        return true;
    }
}

