/*
 * Decompiled with CFR 0.152.
 */
package weblogic.application.internal;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.zip.ZipEntry;
import javax.naming.Context;
import javax.security.jacc.PolicyConfiguration;
import javax.xml.stream.XMLStreamException;
import weblogic.application.AppDeploymentExtension;
import weblogic.application.ApplicationContextInternal;
import weblogic.application.ApplicationDescriptor;
import weblogic.application.ApplicationFileManager;
import weblogic.application.ApplicationLifecycleListener;
import weblogic.application.DescriptorUpdater;
import weblogic.application.Module;
import weblogic.application.ModuleManager;
import weblogic.application.SecurityRole;
import weblogic.application.SplitDirectoryInfo;
import weblogic.application.UpdateListener;
import weblogic.application.internal.AppDDHolder;
import weblogic.application.internal.FlowContext;
import weblogic.application.internal.library.LibraryManagerAggregate;
import weblogic.application.io.Ear;
import weblogic.application.library.LibraryContext;
import weblogic.application.library.LibraryManager;
import weblogic.application.library.LibraryProvider;
import weblogic.application.library.LoggableLibraryProcessingException;
import weblogic.application.utils.ApplicationVersionUtils;
import weblogic.application.utils.EarUtils;
import weblogic.application.utils.LibraryUtils;
import weblogic.application.utils.XMLWriter;
import weblogic.deploy.event.ApplicationVersionLifecycleListenerAdapter;
import weblogic.deployment.PersistenceUnitRegistry;
import weblogic.descriptor.DescriptorBean;
import weblogic.j2ee.J2EEApplicationRuntimeMBeanImpl;
import weblogic.j2ee.descriptor.ApplicationBean;
import weblogic.j2ee.descriptor.wl.DeploymentPlanBean;
import weblogic.j2ee.descriptor.wl.WeblogicApplicationBean;
import weblogic.j2ee.descriptor.wl.WeblogicExtensionBean;
import weblogic.management.WebLogicMBean;
import weblogic.management.configuration.AppDeploymentMBean;
import weblogic.management.configuration.ApplicationMBean;
import weblogic.management.configuration.BasicDeploymentMBean;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.configuration.LibraryMBean;
import weblogic.management.configuration.SubDeploymentMBean;
import weblogic.management.configuration.SystemResourceMBean;
import weblogic.management.runtime.LibraryRuntimeMBean;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.SecurityServiceManager;
import weblogic.utils.classloaders.Annotation;
import weblogic.utils.classloaders.AugmentableClassLoaderManager;
import weblogic.utils.classloaders.ClassFinder;
import weblogic.utils.classloaders.FilteringClassLoader;
import weblogic.utils.classloaders.GenericClassLoader;
import weblogic.utils.classloaders.MultiClassFinder;
import weblogic.utils.jars.VirtualJarFile;
import weblogic.work.WorkManagerCollection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplicationContextImpl
implements ApplicationContextInternal,
DescriptorUpdater,
LibraryContext,
FlowContext,
UpdateListener.Registration {
    private AppDeploymentMBean duMBean;
    private final SystemResourceMBean srMBean;
    private final String appId;
    private final File applicationRootFile;
    private Context rootContext;
    private Context envContext;
    private GenericClassLoader appClassLoader;
    private ApplicationLifecycleListener[] listeners = new ApplicationLifecycleListener[0];
    private ApplicationVersionLifecycleListenerAdapter versionListenerAdapter;
    private ApplicationBean appDD;
    private WeblogicApplicationBean wlappDD;
    private WeblogicExtensionBean extDD;
    private final ModuleManager moduleManager = new ModuleManager();
    private Module[] startingModules = new Module[0];
    private Module[] stoppingModules = new Module[0];
    private String[] stoppedModuleIds = null;
    private File[] paths = new File[0];
    private File descriptorCacheDir;
    private String securityRealmName;
    private J2EEApplicationRuntimeMBeanImpl appRuntimeMBean;
    private ApplicationFileManager afm;
    private Map ejbCacheMap = Collections.EMPTY_MAP;
    private Map ejbQueryCacheMap = Collections.EMPTY_MAP;
    private Map applicationParameters = Collections.EMPTY_MAP;
    private Map factoryMap = Collections.EMPTY_MAP;
    private WorkManagerCollection workManagerCollection;
    private Ear ear;
    private final LibraryManagerAggregate libAggr = new LibraryManagerAggregate();
    private final List updateListeners = new ArrayList();
    private ApplicationDescriptor appDesc = null;
    private final Collection policyConfigurations = new ArrayList();
    private SplitDirectoryInfo splitInfo;
    private final boolean isInternalApp;
    private DomainMBean proposedDomain;
    private AuthenticatedSubject deploymentInitiator;
    private Map appRoleMappings = null;
    private Map appListenerIdentityMappings = null;
    private boolean isStaticDeployment = false;
    private boolean isAdminState = false;
    private boolean requiresRestart = false;
    private boolean isSplitDir = false;
    private int deploymentOperation;
    private AppDDHolder appDDHolder = null;
    private Map clToSchemaTypeLoader = new ConcurrentHashMap();
    private Map contextRootOverrideMap;
    private Map userObjects = Collections.EMPTY_MAP;
    private String[] partialRedeployURIs;
    private final Map<String, AppDeploymentExtension> appExtensions;
    private final Set<AppDeploymentExtension> appPreProcessorExtensions;
    private final Set<AppDeploymentExtension> appPostProcessorExtensions;
    private PersistenceUnitRegistry proposedPersistenceUnitRegistry;
    private Map<String, String> moduleURItoIdMap;

    ApplicationContextImpl(String string) {
        this(null, null, string, null, false);
    }

    ApplicationContextImpl(AppDeploymentMBean appDeploymentMBean, File file) {
        this(appDeploymentMBean, null, appDeploymentMBean.getApplicationIdentifier(), file, appDeploymentMBean.isInternalApp());
    }

    ApplicationContextImpl(SystemResourceMBean systemResourceMBean, File file) {
        this(null, systemResourceMBean, systemResourceMBean.getName(), file, false);
    }

    public ApplicationContextImpl(String string, File file, ClassLoader classLoader) {
        this(null, null, string, file, false, false, classLoader);
    }

    private ApplicationContextImpl(AppDeploymentMBean appDeploymentMBean, SystemResourceMBean systemResourceMBean, String string, File file, boolean bl) {
        this(appDeploymentMBean, systemResourceMBean, string, file, bl, true, (ClassLoader)AugmentableClassLoaderManager.getAugmentableSystemClassLoader());
    }

    private ApplicationContextImpl(AppDeploymentMBean appDeploymentMBean, SystemResourceMBean systemResourceMBean, String string, File file, boolean bl, boolean bl2, ClassLoader classLoader) {
        this.duMBean = appDeploymentMBean;
        this.srMBean = systemResourceMBean;
        this.appId = string;
        this.applicationRootFile = file;
        this.isInternalApp = bl;
        if (bl2) {
            this.workManagerCollection = new WorkManagerCollection(string, bl);
        }
        FilteringClassLoader filteringClassLoader = new FilteringClassLoader(classLoader);
        this.appClassLoader = new GenericClassLoader((ClassFinder)new MultiClassFinder(), (ClassLoader)filteringClassLoader);
        this.appClassLoader.setAnnotation(new Annotation(string));
        this.proposedPersistenceUnitRegistry = null;
        this.appExtensions = new HashMap<String, AppDeploymentExtension>();
        this.appPreProcessorExtensions = new HashSet<AppDeploymentExtension>();
        this.appPostProcessorExtensions = new HashSet<AppDeploymentExtension>();
    }

    @Override
    public ApplicationMBean getApplicationMBean() {
        return this.duMBean == null ? null : this.duMBean.getAppMBean();
    }

    @Override
    public BasicDeploymentMBean getBasicDeploymentMBean() {
        return this.duMBean != null ? this.duMBean : this.srMBean;
    }

    @Override
    public AppDeploymentMBean getAppDeploymentMBean() {
        return this.duMBean;
    }

    public void setUpdatedAppDeploymentMBean(AppDeploymentMBean appDeploymentMBean) {
        if (this.duMBean != null && appDeploymentMBean != null) {
            this.duMBean = appDeploymentMBean;
        }
    }

    @Override
    public SystemResourceMBean getSystemResourceMBean() {
        return this.srMBean;
    }

    @Override
    public DomainMBean getProposedDomain() {
        return this.proposedDomain;
    }

    public void setProposedDomain(DomainMBean domainMBean) {
        this.proposedDomain = domainMBean;
    }

    @Override
    public AuthenticatedSubject getDeploymentInitiator() {
        return this.deploymentInitiator;
    }

    public void setDeploymentInitiator(AuthenticatedSubject authenticatedSubject) {
        this.deploymentInitiator = authenticatedSubject;
    }

    @Override
    public boolean requiresRestart() {
        return this.requiresRestart;
    }

    public void setRequiresRestart(boolean bl) {
        this.requiresRestart = bl;
    }

    @Override
    public Context getEnvContext() {
        return this.envContext;
    }

    @Override
    public void setEnvContext(Context context) {
        this.envContext = context;
    }

    @Override
    public Context getRootContext() {
        return this.rootContext;
    }

    @Override
    public void setRootContext(Context context) {
        this.rootContext = context;
    }

    @Override
    public GenericClassLoader getAppClassLoader() {
        return this.appClassLoader;
    }

    public void resetAppClassLoader(GenericClassLoader genericClassLoader) {
        this.appClassLoader = genericClassLoader;
        Thread.currentThread().setContextClassLoader((ClassLoader)this.appClassLoader);
    }

    @Override
    public ApplicationLifecycleListener[] getApplicationListeners() {
        return this.listeners;
    }

    @Override
    public void setApplicationListeners(ApplicationLifecycleListener[] applicationLifecycleListenerArray) {
        if (applicationLifecycleListenerArray == null || applicationLifecycleListenerArray.length == 0) {
            return;
        }
        if (this.listeners.length == 0) {
            this.listeners = applicationLifecycleListenerArray;
        } else {
            this.addListeners(applicationLifecycleListenerArray);
        }
    }

    @Override
    public void addApplicationListener(ApplicationLifecycleListener applicationLifecycleListener) {
        this.setApplicationListeners(new ApplicationLifecycleListener[]{applicationLifecycleListener});
    }

    private void addListeners(ApplicationLifecycleListener[] applicationLifecycleListenerArray) {
        ArrayList<ApplicationLifecycleListener> arrayList = new ArrayList<ApplicationLifecycleListener>(this.listeners.length + applicationLifecycleListenerArray.length);
        arrayList.addAll(Arrays.asList(this.listeners));
        arrayList.addAll(Arrays.asList(applicationLifecycleListenerArray));
        this.listeners = arrayList.toArray(new ApplicationLifecycleListener[arrayList.size()]);
    }

    @Override
    public void setApplicationVersionListenerAdapter(ApplicationVersionLifecycleListenerAdapter applicationVersionLifecycleListenerAdapter) {
        if (applicationVersionLifecycleListenerAdapter == null && this.versionListenerAdapter != null) {
            this.versionListenerAdapter.cleanup();
        }
        this.versionListenerAdapter = applicationVersionLifecycleListenerAdapter;
    }

    @Override
    public void setApplicationDescriptor(ApplicationDescriptor applicationDescriptor) throws IOException, XMLStreamException {
        this.appDesc = applicationDescriptor;
        this.appDD = applicationDescriptor.getApplicationDescriptor();
        this.wlappDD = applicationDescriptor.getWeblogicApplicationDescriptor();
        this.extDD = applicationDescriptor.getWeblogicExtensionDescriptor();
    }

    @Override
    public ApplicationDescriptor getApplicationDescriptor() {
        return this.appDesc;
    }

    @Override
    public WorkManagerCollection getWorkManagerCollection() {
        return this.workManagerCollection;
    }

    @Override
    public ApplicationBean getApplicationDD() {
        return this.appDD;
    }

    @Override
    public WeblogicApplicationBean getWLApplicationDD() {
        return this.wlappDD;
    }

    @Override
    public WeblogicExtensionBean getWLExtensionDD() {
        return this.extDD;
    }

    @Override
    public void setEar(Ear ear) {
        this.ear = ear;
    }

    @Override
    public Ear getEar() {
        return this.ear;
    }

    @Override
    public boolean isEar() {
        return this.ear != null;
    }

    @Override
    public File[] getApplicationPaths() {
        return this.paths;
    }

    @Override
    public void setApplicationPaths(File[] fileArray) {
        this.paths = fileArray;
    }

    @Override
    public String getApplicationFileName() {
        return this.applicationRootFile == null ? null : this.applicationRootFile.getName();
    }

    @Override
    public String getStagingPath() {
        return this.applicationRootFile.getPath();
    }

    @Override
    public String getOutputPath() {
        if (this.afm == null) {
            throw new AssertionError((Object)"getOutputPath called too early!");
        }
        return this.afm.getOutputPath().getPath();
    }

    @Override
    public String getApplicationSecurityRealmName() {
        return this.securityRealmName;
    }

    @Override
    public void setApplicationSecurityRealmName(String string) {
        this.securityRealmName = string;
    }

    @Override
    public String getApplicationName() {
        return ApplicationVersionUtils.getApplicationName(this.appId);
    }

    @Override
    public String getApplicationId() {
        return this.appId;
    }

    @Override
    public J2EEApplicationRuntimeMBeanImpl getRuntime() {
        return this.appRuntimeMBean;
    }

    @Override
    public void setRuntime(J2EEApplicationRuntimeMBeanImpl j2EEApplicationRuntimeMBeanImpl) {
        this.appRuntimeMBean = j2EEApplicationRuntimeMBeanImpl;
    }

    @Override
    public ApplicationFileManager getApplicationFileManager() {
        return this.afm;
    }

    @Override
    public void setApplicationFileManager(ApplicationFileManager applicationFileManager) {
        this.afm = applicationFileManager;
    }

    @Override
    public SplitDirectoryInfo getSplitDirectoryInfo() {
        return this.splitInfo;
    }

    @Override
    public void setSplitDirectoryInfo(SplitDirectoryInfo splitDirectoryInfo) {
        this.splitInfo = splitDirectoryInfo;
    }

    @Override
    public Map getEJBCacheMap() {
        return this.ejbCacheMap;
    }

    @Override
    public void setEJBCacheMap(Map map) {
        this.ejbCacheMap = map == null ? Collections.EMPTY_MAP : map;
    }

    @Override
    public Map getEJBQueryCacheMap() {
        return this.ejbQueryCacheMap;
    }

    @Override
    public void setEJBQueryCacheMap(Map map) {
        this.ejbQueryCacheMap = map == null ? Collections.EMPTY_MAP : map;
    }

    @Override
    public Map getApplicationParameters() {
        return this.applicationParameters;
    }

    @Override
    public void setApplicationParameters(Map map) {
        this.applicationParameters = map == null ? Collections.EMPTY_MAP : map;
    }

    @Override
    public String getApplicationParameter(String string) {
        return (String)this.applicationParameters.get(string);
    }

    @Override
    public InputStream getElement(String string) throws IOException {
        VirtualJarFile virtualJarFile = this.afm.getVirtualJarFile();
        ZipEntry zipEntry = virtualJarFile.getEntry(string);
        return zipEntry == null ? null : virtualJarFile.getInputStream(zipEntry);
    }

    @Override
    public ModuleManager getModuleManager() {
        return this.moduleManager;
    }

    @Override
    public Module[] getApplicationModules() {
        return this.moduleManager.getModules();
    }

    @Override
    public void setApplicationModules(Module[] moduleArray) {
        this.moduleManager.setModules(moduleArray);
    }

    @Override
    public Module[] getStartingModules() {
        return this.startingModules;
    }

    @Override
    public void setStartingModules(Module[] moduleArray) {
        this.startingModules = moduleArray;
    }

    @Override
    public Module[] getStoppingModules() {
        return this.stoppingModules;
    }

    @Override
    public void setStoppingModules(Module[] moduleArray) {
        this.stoppingModules = moduleArray;
    }

    @Override
    public Map getCustomModuleFactories() {
        return this.factoryMap;
    }

    @Override
    public void setCustomModuleFactories(Map map) {
        this.factoryMap = map;
    }

    @Override
    public void addUpdateListener(UpdateListener updateListener) {
        this.updateListeners.add(updateListener);
    }

    @Override
    public void removeUpdateListener(UpdateListener updateListener) {
        this.updateListeners.remove(updateListener);
    }

    @Override
    public List getUpdateListeners() {
        return this.updateListeners;
    }

    @Override
    public void addLibraryManager(String string, LibraryManager libraryManager) {
        this.libAggr.addLibraryManager(string, libraryManager);
    }

    @Override
    public void removeLibraryManager(String string, LibraryManager libraryManager) {
        this.libAggr.removeLibraryManager(string, libraryManager);
    }

    @Override
    public LibraryManagerAggregate getLibraryManagerAggregate() {
        return this.libAggr;
    }

    @Override
    public LibraryProvider getLibraryProvider(String string) {
        return this.libAggr.getLibraryProvider(string);
    }

    @Override
    public void addJACCPolicyConfiguration(PolicyConfiguration policyConfiguration) {
        this.policyConfigurations.add(policyConfiguration);
    }

    @Override
    public PolicyConfiguration[] getJACCPolicyConfigurations() {
        return this.policyConfigurations.toArray(new PolicyConfiguration[this.policyConfigurations.size()]);
    }

    @Override
    public boolean useJACC() {
        return SecurityServiceManager.isJACCEnabled() && !this.isInternalApp;
    }

    @Override
    public void addClassFinder(ClassFinder classFinder) {
        this.getAppClassLoader().addClassFinder(classFinder);
    }

    @Override
    public void registerLink(File file) throws IOException {
        this.registerLink(file.getName(), file);
    }

    @Override
    public void registerLink(String string, File file) throws IOException {
        EarUtils.linkURI(this.getEar(), this.getApplicationFileManager(), string, file);
    }

    @Override
    public void notifyDescriptorUpdate() throws LoggableLibraryProcessingException {
        LibraryUtils.resetAppDDs(this.appDesc, this);
    }

    @Override
    public String getRefappName() {
        return this.getApplicationName();
    }

    @Override
    public DeploymentPlanBean findDeploymentPlan() {
        if (this.srMBean != null) {
            return null;
        }
        AppDeploymentMBean appDeploymentMBean = this.proposedDomain == null ? this.duMBean : this.proposedDomain.lookupAppDeployment(this.getApplicationId());
        return appDeploymentMBean != null ? appDeploymentMBean.getDeploymentPlanDescriptor() : null;
    }

    @Override
    public void writeDiagnosticImage(XMLWriter xMLWriter) {
        xMLWriter.addElement("name", this.getApplicationId());
        xMLWriter.addElement("internal", String.valueOf(this.isInternalApp));
        xMLWriter.addElement("paths");
        File[] fileArray = this.getApplicationPaths();
        for (int i = 0; i < fileArray.length; ++i) {
            xMLWriter.addElement("path", fileArray[i].getAbsolutePath());
        }
        xMLWriter.closeElement();
        xMLWriter.addElement("classpath", this.getAppClassLoader().getClassPath());
        xMLWriter.addElement("modules");
        Module[] moduleArray = this.getModuleManager().getModules();
        for (int i = 0; i < moduleArray.length; ++i) {
            xMLWriter.addElement("module");
            xMLWriter.addElement("name", moduleArray[i].getId());
            xMLWriter.addElement("type", moduleArray[i].getType());
            xMLWriter.closeElement();
        }
        xMLWriter.closeElement();
        xMLWriter.addElement("libraries");
        this.libAggr.writeDiagnosticImage(xMLWriter);
        xMLWriter.closeElement();
    }

    @Override
    public void setAppLevelRoleMappings(Map map) {
        if (this.appRoleMappings != null) {
            throw new AssertionError((Object)"Application Role mappings cannot be reset");
        }
        this.appRoleMappings = map;
    }

    @Override
    public void setAppListenerIdentityMappings(Map map) {
        if (this.appListenerIdentityMappings != null) {
            throw new AssertionError((Object)"ApplicationLifecycleListener to run-as principal mappings cannot be reset");
        }
        this.appListenerIdentityMappings = map;
    }

    @Override
    public AuthenticatedSubject getAppListenerIdentity(ApplicationLifecycleListener applicationLifecycleListener) {
        if (this.appListenerIdentityMappings == null) {
            return null;
        }
        return (AuthenticatedSubject)this.appListenerIdentityMappings.get(applicationLifecycleListener);
    }

    @Override
    public SecurityRole getSecurityRole(String string) {
        if (this.appRoleMappings == null) {
            return null;
        }
        return (SecurityRole)this.appRoleMappings.get(string);
    }

    @Override
    public File getDescriptorCacheDir() {
        return this.descriptorCacheDir;
    }

    @Override
    public void setDescriptorCacheDir(File file) {
        this.descriptorCacheDir = file;
    }

    @Override
    public boolean isStaticDeploymentOperation() {
        return this.isStaticDeployment;
    }

    public void setStaticDeploymentOperation(boolean bl) {
        this.isStaticDeployment = bl;
    }

    @Override
    public void setAdminState(boolean bl) {
        this.isAdminState = bl;
    }

    @Override
    public boolean isAdminState() {
        return this.isAdminState;
    }

    @Override
    public boolean isInternalApp() {
        return this.isInternalApp;
    }

    @Override
    public void setSplitDir() {
        this.isSplitDir = true;
    }

    @Override
    public boolean isSplitDir() {
        return this.isSplitDir;
    }

    @Override
    public boolean isRedeployOperation() {
        return this.deploymentOperation == 9;
    }

    @Override
    public boolean isStopOperation() {
        return this.deploymentOperation == 8;
    }

    @Override
    public int getDeploymentOperation() {
        return this.deploymentOperation;
    }

    public void setDeploymentOperation(int n) {
        this.deploymentOperation = n;
    }

    @Override
    public void setAdditionalModuleUris(Map map) {
        this.moduleManager.setAdditionalModuleUris(map);
    }

    @Override
    public void setPartialRedeployURIs(String[] stringArray) {
        this.partialRedeployURIs = stringArray;
    }

    @Override
    public String[] getPartialRedeployURIs() {
        return this.partialRedeployURIs;
    }

    @Override
    public AppDDHolder getProposedPartialRedeployDDs() {
        return this.appDDHolder;
    }

    @Override
    public void setProposedPartialRedeployDDs(AppDDHolder appDDHolder) {
        this.appDDHolder = appDDHolder;
    }

    @Override
    public Object getSchemaTypeLoader(ClassLoader classLoader) {
        return this.clToSchemaTypeLoader.get(classLoader);
    }

    @Override
    public void setSchemaTypeLoader(ClassLoader classLoader, Object object) {
        this.clToSchemaTypeLoader.put(classLoader, object);
    }

    @Override
    public void clear() {
        this.clToSchemaTypeLoader.clear();
    }

    @Override
    public String getRefappUri() {
        return this.getEar().getURI();
    }

    @Override
    public Map getContextRootOverrideMap() {
        return this.contextRootOverrideMap;
    }

    @Override
    public void setContextRootOverrideMap(Map map) {
        this.contextRootOverrideMap = map;
    }

    @Override
    public SubDeploymentMBean[] getLibrarySubDeployments() {
        return new LibrarySubDeploymentFetcher().getSubDeploymentMBeans();
    }

    @Override
    public Object putUserObject(Object object, Object object2) {
        if (this.userObjects == Collections.EMPTY_MAP) {
            this.userObjects = new HashMap();
        }
        return this.userObjects.put(object, object2);
    }

    @Override
    public Object getUserObject(Object object) {
        return this.userObjects.get(object);
    }

    @Override
    public Object removeUserObject(Object object) {
        return this.userObjects.remove(object);
    }

    @Override
    public void setProposedPersistenceUnitRegistry(PersistenceUnitRegistry persistenceUnitRegistry) {
        this.proposedPersistenceUnitRegistry = persistenceUnitRegistry;
    }

    @Override
    public PersistenceUnitRegistry getProposedPersistenceUnitRegistry() {
        return this.proposedPersistenceUnitRegistry;
    }

    @Override
    public void addAppDeploymentExtension(AppDeploymentExtension appDeploymentExtension, FlowContext.ExtensionType extensionType) {
        this.appExtensions.put(appDeploymentExtension.getName(), appDeploymentExtension);
        if (extensionType == FlowContext.ExtensionType.PRE) {
            this.appPreProcessorExtensions.add(appDeploymentExtension);
        } else {
            this.appPostProcessorExtensions.add(appDeploymentExtension);
        }
    }

    @Override
    public Set<AppDeploymentExtension> getAppDeploymentExtensions(FlowContext.ExtensionType extensionType) {
        if (extensionType == FlowContext.ExtensionType.PRE) {
            return this.appPreProcessorExtensions;
        }
        return this.appPostProcessorExtensions;
    }

    public String toString() {
        return this.appId;
    }

    @Override
    public AppDeploymentExtension getAppDeploymentExtension(String string) {
        return this.appExtensions.get(string);
    }

    @Override
    public void clearAppDeploymentExtensions() {
        this.appExtensions.clear();
        this.appPreProcessorExtensions.clear();
        this.appPostProcessorExtensions.clear();
    }

    @Override
    public Map<String, String> getModuleURItoIdMap() {
        return this.moduleURItoIdMap;
    }

    @Override
    public void setModuleURItoIdMap(Map<String, String> map) {
        this.moduleURItoIdMap = map;
    }

    @Override
    public String[] getStoppedModules() {
        return this.stoppedModuleIds;
    }

    @Override
    public void setStoppedModules(String[] stringArray) {
        this.stoppedModuleIds = stringArray;
    }

    private class LibrarySubDeploymentFetcher {
        private LibrarySubDeploymentFetcher() {
        }

        SubDeploymentMBean[] getSubDeploymentMBeans() {
            LibraryRuntimeMBean[] libraryRuntimeMBeanArray = ApplicationContextImpl.this.getRuntime().getLibraryRuntimes();
            if (libraryRuntimeMBeanArray == null || libraryRuntimeMBeanArray.length == 0) {
                return null;
            }
            WebLogicMBean webLogicMBean = ApplicationContextImpl.this.getBasicDeploymentMBean().getParent();
            DescriptorBean descriptorBean = (DescriptorBean)webLogicMBean;
            DomainMBean domainMBean = (DomainMBean)descriptorBean.getDescriptor().getRootBean();
            ArrayList<SubDeploymentMBean> arrayList = new ArrayList<SubDeploymentMBean>();
            for (int i = 0; i < libraryRuntimeMBeanArray.length; ++i) {
                SubDeploymentMBean[] subDeploymentMBeanArray;
                String string = libraryRuntimeMBeanArray[i].getLibraryIdentifier();
                LibraryMBean libraryMBean = domainMBean.lookupLibrary(string);
                if (libraryMBean == null || (subDeploymentMBeanArray = libraryMBean.getSubDeployments()) == null || subDeploymentMBeanArray.length <= 0) continue;
                arrayList.addAll(Arrays.asList(subDeploymentMBeanArray));
            }
            return arrayList.toArray(new SubDeploymentMBean[arrayList.size()]);
        }
    }
}

