/*
 * Decompiled with CFR 0.152.
 */
package weblogic.application.internal;

import weblogic.application.ApplicationContext;
import weblogic.application.Deployment;
import weblogic.application.internal.BackgroundDeploymentService;
import weblogic.deploy.container.DeploymentContext;
import weblogic.management.DeploymentException;

public class BackgroundDeployment
implements Deployment {
    private final Deployment delegate;
    private boolean completedDeployment;
    private boolean startedDeployment;

    BackgroundDeployment(Deployment deployment) {
        this.delegate = deployment;
    }

    Deployment getDelegate() {
        return this.delegate;
    }

    void setCompletedDeployment(boolean bl) {
        this.completedDeployment = bl;
    }

    boolean getCompletedDeployment() {
        return this.completedDeployment;
    }

    void setStartedDeployment(boolean bl) {
        this.startedDeployment = bl;
    }

    boolean getStartedDeployment() {
        return this.startedDeployment;
    }

    public void prepare(DeploymentContext deploymentContext) {
        this.completedDeployment = false;
        BackgroundDeploymentService.addBackgroundDeployment(this, deploymentContext);
    }

    public void activate(DeploymentContext deploymentContext) {
    }

    public void adminToProduction(DeploymentContext deploymentContext) {
    }

    public void gracefulProductionToAdmin(DeploymentContext deploymentContext) throws DeploymentException {
        if (this.completedDeployment) {
            this.delegate.gracefulProductionToAdmin(deploymentContext);
        } else {
            Deployment.AdminModeCallback adminModeCallback = null;
            if (deploymentContext != null) {
                adminModeCallback = deploymentContext.getAdminModeCallback();
            }
            if (adminModeCallback != null) {
                adminModeCallback.completed();
            }
        }
    }

    public void forceProductionToAdmin(DeploymentContext deploymentContext) throws DeploymentException {
        if (this.completedDeployment) {
            this.delegate.forceProductionToAdmin(deploymentContext);
        }
    }

    public void deactivate(DeploymentContext deploymentContext) throws DeploymentException {
        if (this.completedDeployment) {
            this.delegate.deactivate(deploymentContext);
        }
    }

    public void unprepare(DeploymentContext deploymentContext) throws DeploymentException {
        if (this.completedDeployment) {
            this.delegate.unprepare(deploymentContext);
        }
    }

    public void remove(DeploymentContext deploymentContext) throws DeploymentException {
        if (this.completedDeployment) {
            this.delegate.remove(deploymentContext);
        }
    }

    public void prepareUpdate(DeploymentContext deploymentContext) throws DeploymentException {
        if (this.completedDeployment) {
            this.delegate.prepareUpdate(deploymentContext);
        }
    }

    public void activateUpdate(DeploymentContext deploymentContext) throws DeploymentException {
        if (this.completedDeployment) {
            this.delegate.activateUpdate(deploymentContext);
        }
    }

    public void rollbackUpdate(DeploymentContext deploymentContext) {
        if (this.completedDeployment) {
            this.delegate.rollbackUpdate(deploymentContext);
        }
    }

    public void start(DeploymentContext deploymentContext) throws DeploymentException {
        if (this.completedDeployment) {
            this.delegate.start(deploymentContext);
        }
    }

    public void stop(DeploymentContext deploymentContext) throws DeploymentException {
        if (this.completedDeployment) {
            this.delegate.stop(deploymentContext);
        }
    }

    public ApplicationContext getApplicationContext() {
        return this.delegate.getApplicationContext();
    }
}

