/*
 * Decompiled with CFR 0.152.
 */
package weblogic.application.internal;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import weblogic.application.ApplicationContext;
import weblogic.application.internal.BackgroundDeployment;
import weblogic.application.utils.StateChange;
import weblogic.application.utils.StateChangeException;
import weblogic.application.utils.StateMachineDriver;
import weblogic.deploy.common.Debug;
import weblogic.deploy.container.DeploymentContext;
import weblogic.j2ee.J2EELogger;
import weblogic.management.DeploymentException;
import weblogic.management.configuration.AppDeploymentMBean;
import weblogic.server.AbstractServerService;
import weblogic.server.RunningStateListener;
import weblogic.server.ServiceFailureException;
import weblogic.servlet.internal.OnDemandListener;
import weblogic.servlet.internal.WebService;
import weblogic.t3.srvr.ServerServicesManager;
import weblogic.timers.Timer;
import weblogic.timers.TimerListener;
import weblogic.timers.TimerManagerFactory;
import weblogic.work.WorkManagerFactory;

public final class BackgroundDeploymentService
extends AbstractServerService
implements OnDemandListener,
TimerListener,
RunningStateListener {
    private static BackgroundDeploymentService THE_ONE = null;
    private static final List<BackgroundApplication> backgroundApps = new ArrayList<BackgroundApplication>();
    private static final List<BackgroundApplication> backgroundOnDemandApps = new ArrayList<BackgroundApplication>();
    private volatile boolean stillRunning;
    private volatile boolean backgroundActionScheduled = false;
    private BackgroundDeployAction backgroundAction = null;
    private static final long BACKGROUND_DELAY = 3000L;
    private static final StateChange prepareStateChange = new StateChange(){

        public void next(Object object) throws Exception {
            BackgroundApplication backgroundApplication = (BackgroundApplication)object;
            backgroundApplication.deployment.getDelegate().prepare(backgroundApplication.ctx);
        }

        public void previous(Object object) throws Exception {
            BackgroundApplication backgroundApplication = (BackgroundApplication)object;
            backgroundApplication.deployment.getDelegate().unprepare(backgroundApplication.ctx);
        }

        public void logRollbackError(StateChangeException stateChangeException) {
            J2EELogger.logIgnoringUndeploymentError((Throwable)stateChangeException.getCause());
        }
    };
    private static final StateChange activateStateChange = new StateChange(){

        public void next(Object object) throws Exception {
            BackgroundApplication backgroundApplication = (BackgroundApplication)object;
            backgroundApplication.deployment.getDelegate().activate(backgroundApplication.ctx);
        }

        public void previous(Object object) throws Exception {
            BackgroundApplication backgroundApplication = (BackgroundApplication)object;
            backgroundApplication.deployment.getDelegate().deactivate(backgroundApplication.ctx);
        }

        public void logRollbackError(StateChangeException stateChangeException) {
            J2EELogger.logIgnoringUndeploymentError((Throwable)stateChangeException.getCause());
        }
    };
    private static final StateChange adminStateChange = new StateChange(){

        public void next(Object object) throws Exception {
            BackgroundApplication backgroundApplication = (BackgroundApplication)object;
            backgroundApplication.deployment.getDelegate().adminToProduction(backgroundApplication.ctx);
        }

        public void previous(Object object) throws Exception {
            BackgroundApplication backgroundApplication = (BackgroundApplication)object;
            backgroundApplication.deployment.getDelegate().forceProductionToAdmin(backgroundApplication.ctx);
        }

        public void logRollbackError(StateChangeException stateChangeException) {
            J2EELogger.logIgnoringAdminModeErrro((Throwable)stateChangeException.getCause());
        }
    };

    public BackgroundDeploymentService() {
        assert (THE_ONE == null);
        THE_ONE = this;
    }

    public static BackgroundDeploymentService getInstance() {
        return THE_ONE;
    }

    static void addBackgroundDeployment(BackgroundDeployment backgroundDeployment, DeploymentContext deploymentContext) {
        AppDeploymentMBean appDeploymentMBean;
        ApplicationContext applicationContext = backgroundDeployment.getApplicationContext();
        AppDeploymentMBean appDeploymentMBean2 = appDeploymentMBean = applicationContext != null ? applicationContext.getAppDeploymentMBean() : null;
        if (appDeploymentMBean != null && appDeploymentMBean.getOnDemandContextPaths() != null && appDeploymentMBean.getOnDemandContextPaths().length > 0) {
            if (Debug.isDeploymentDebugEnabled()) {
                Debug.deploymentDebug("Add background deployment: " + appDeploymentMBean.getName());
            }
            backgroundOnDemandApps.add(new BackgroundApplication(backgroundDeployment, deploymentContext));
        } else {
            backgroundApps.add(new BackgroundApplication(backgroundDeployment, deploymentContext));
        }
    }

    private synchronized void waitForCompletion() {
        while (this.stillRunning) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private synchronized void complete() {
        this.stillRunning = false;
        this.notifyAll();
    }

    public void start() throws ServiceFailureException {
        if (!backgroundOnDemandApps.isEmpty()) {
            for (BackgroundApplication backgroundApplication : backgroundOnDemandApps) {
                ApplicationContext applicationContext = backgroundApplication.deployment.getApplicationContext();
                AppDeploymentMBean appDeploymentMBean = applicationContext.getAppDeploymentMBean();
                if (Debug.isDeploymentDebugEnabled()) {
                    Debug.deploymentDebug("Registering on demand context paths for : " + appDeploymentMBean.getName());
                }
                WebService.defaultHttpServer().getOnDemandManager().registerOnDemandContextPaths(appDeploymentMBean.getOnDemandContextPaths(), this, appDeploymentMBean.getName(), appDeploymentMBean.isOnDemandDisplayRefresh());
            }
        }
        if (backgroundApps.isEmpty()) {
            return;
        }
        this.stillRunning = true;
        BackgroundApplication[] backgroundApplicationArray = backgroundApps.toArray(new BackgroundApplication[backgroundApps.size()]);
        this.backgroundAction = new BackgroundDeployAction(backgroundApplicationArray);
        TimerManagerFactory.getTimerManagerFactory().getDefaultTimerManager().schedule((TimerListener)this, 3000L);
        ServerServicesManager.addRunningStateListener(this);
    }

    public void OnDemandURIAccessed(String string, String string2, boolean bl) throws DeploymentException {
        Object object;
        if (Debug.isDeploymentDebugEnabled()) {
            Debug.deploymentDebug("OnDemand URI accessed : " + string + " for app: " + string2 + " load async: " + bl);
        }
        BackgroundApplication backgroundApplication = null;
        Iterator<BackgroundApplication> iterator = backgroundOnDemandApps.iterator();
        boolean bl2 = false;
        while (iterator.hasNext() && !bl2) {
            backgroundApplication = iterator.next();
            object = backgroundApplication.deployment.getApplicationContext();
            AppDeploymentMBean appDeploymentMBean = object.getAppDeploymentMBean();
            if (!string2.equals(appDeploymentMBean.getName())) continue;
            if (backgroundApplication.deployment.getCompletedDeployment()) {
                return;
            }
            if (backgroundApplication.failureException != null) {
                if (Debug.isDeploymentDebugEnabled()) {
                    Debug.deploymentDebug("Background deployment error: ", backgroundApplication.failureException);
                }
                if (backgroundApplication.failureException instanceof DeploymentException) {
                    throw (DeploymentException)((Object)backgroundApplication.failureException);
                }
                throw new DeploymentException(backgroundApplication.failureException);
            }
            bl2 = true;
        }
        if (!bl2) {
            throw new IllegalArgumentException("appName " + string2 + " is not found");
        }
        this.waitForCompletion();
        if (bl && backgroundApplication.deployment.getStartedDeployment()) {
            return;
        }
        object = new OnDemandBackgroundDeployAction(backgroundApplication);
        if (bl) {
            WorkManagerFactory.getInstance().getSystem().schedule((Runnable)object);
        } else {
            ((OnDemandBackgroundDeployAction)object).run();
            if (backgroundApplication.failureException != null) {
                if (Debug.isDeploymentDebugEnabled()) {
                    Debug.deploymentDebug("Background deployment error: ", backgroundApplication.failureException);
                }
                if (backgroundApplication.failureException instanceof DeploymentException) {
                    throw (DeploymentException)((Object)backgroundApplication.failureException);
                }
                throw new DeploymentException(backgroundApplication.failureException);
            }
        }
    }

    public void timerExpired(Timer timer) {
        this.scheduleBackgroundDeployAction();
    }

    public void onRunning() {
        this.scheduleBackgroundDeployAction();
    }

    private synchronized void scheduleBackgroundDeployAction() {
        if (this.backgroundActionScheduled) {
            return;
        }
        this.backgroundActionScheduled = true;
        WorkManagerFactory.getInstance().getSystem().schedule((Runnable)this.backgroundAction);
        this.backgroundAction = null;
    }

    private static class OnDemandBackgroundDeployAction
    extends BackgroundDeployAction {
        private final BackgroundApplication app;

        OnDemandBackgroundDeployAction(BackgroundApplication backgroundApplication) {
            super(new BackgroundApplication[]{backgroundApplication});
            this.app = backgroundApplication;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            if (Debug.isDeploymentDebugEnabled()) {
                Debug.deploymentDebug("Performing on demand background deploy action: ");
            }
            Class<OnDemandBackgroundDeployAction> clazz = OnDemandBackgroundDeployAction.class;
            synchronized (OnDemandBackgroundDeployAction.class) {
                this.app.deployment.setStartedDeployment(true);
                if (this.app.deployment.getCompletedDeployment() || this.app.failureException != null) {
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
                super.run();
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }
    }

    private static class BackgroundDeployAction
    implements Runnable {
        private final BackgroundApplication[] backgroundApps;
        private StateMachineDriver driver = new StateMachineDriver();

        BackgroundDeployAction(BackgroundApplication[] backgroundApplicationArray) {
            this.backgroundApps = backgroundApplicationArray;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            if (Debug.isDeploymentDebugEnabled()) {
                Debug.deploymentDebug("Starting background deploy action");
            }
            try {
                this.driver.nextState(prepareStateChange, this.backgroundApps);
                try {
                    this.driver.nextState(activateStateChange, this.backgroundApps);
                    try {
                        this.driver.nextState(adminStateChange, this.backgroundApps);
                        for (int i = 0; i < this.backgroundApps.length; ++i) {
                            this.backgroundApps[i].deployment.setCompletedDeployment(true);
                        }
                    }
                    catch (Exception exception) {
                        this.driver.previousState(activateStateChange, this.backgroundApps);
                        throw exception;
                    }
                }
                catch (Exception exception) {
                    this.driver.previousState(prepareStateChange, this.backgroundApps);
                    throw exception;
                }
            }
            catch (Exception exception) {
                J2EELogger.logErrorDeployingApplication((String)"Internal Application", (String)exception.getMessage(), (Throwable)exception);
                for (int i = 0; i < this.backgroundApps.length; ++i) {
                    this.backgroundApps[i].failureException = exception;
                }
            }
            finally {
                BackgroundDeploymentService.getInstance().complete();
            }
        }
    }

    private static class BackgroundApplication {
        private final BackgroundDeployment deployment;
        private final DeploymentContext ctx;
        private Exception failureException;

        BackgroundApplication(BackgroundDeployment backgroundDeployment, DeploymentContext deploymentContext) {
            this.deployment = backgroundDeployment;
            this.ctx = deploymentContext;
        }
    }

    public static class WaitForBackgroundCompletion
    extends AbstractServerService {
        public void stop() throws ServiceFailureException {
            BackgroundDeploymentService.getInstance().waitForCompletion();
        }

        public void halt() throws ServiceFailureException {
            BackgroundDeploymentService.getInstance().waitForCompletion();
        }
    }
}

